define( [
    "inform.agent.web.forms.Dropdown",
    "inform.agent.web.forms.WebForm",
    "inform.agent.web.forms.Datamodel"
    , "static.jquery.jquery"
], function( Dropdown, WebForm, DM, $ ) {
    var Menu;
    return Menu = CLASS( {
        constructor: function( descriptor ) {
            this._descriptor = descriptor;
        },
        _action: function( id ) {
            if ( id !== 1 )//only execute action supported
                return null;
            var self = this;
            return function( args ) {
                var e = args.event, menu = self._menu;
                var d = self._descriptor;
                function removeSubs( menu ) {
                    for ( var j = 0; j < menu.rows.length; j++ ) {
                        var m = menu.rows[j]._menu;
                        if ( m && m.parentNode ) {
                            removeSubs( m );
                            m.parentNode.removeChild( m );
                        }
                    }
                }
                function abstopleft( e ) {
                    var t = 0, l = 0;
                    while ( e ) {
                        t += e.offsetTop;
                        l += e.offsetLeft;
                        e = e.offsetParent;
                    }
                    return {top:t, left:l};
                }
                function mkmenu( items, coms ) {
                    var menu = document.createElement( "table" );
                    menu.className = "menu";
                    function mkitem( it ) {
                        var action = !it.items && it.event && new (WebForm.ActionList)( it.event, coms );
                        var inidx = menu.rows.length;
                        function mkrow( it, vc, vi ) {
                            var tr = menu.insertRow( inidx );
                            var ci = tr.insertCell( -1 );
                            ci.className = "img";
                            if ( vi )
                                ci.innerHTML = "<img data-icon='" + vi + "'>";
                            var cc = tr.insertCell( -1 );
                            cc.className = "capt";
                            cc.innerHTML = vc;
                            cc.title = it.hint || "";
                            var ca = tr.insertCell( -1 );
                            ca.className = "arr";
                            if ( it.items ) {
                                ca.innerHTML = "&#9658;";
                                tr.onmouseover = tr.onclick = (function( ca ) {
                                    return function() {
                                        var mn = this._menu;
                                        if ( mn && (mn.parentNode === ca) )
                                            return;//already visible
                                        this._preclick && this._preclick.call( this );
                                        if (!mn) {
                                            this._menu = mn = mkmenu( it.items, d.coms );
                                            WebForm.updateIcons(mn);
                                        }
                                        removeSubs( menu );
                                        var left = this.offsetWidth-2, top = this.offsetTop;
                                        $( mn ).css( {top: top+"px", left: left+"px"} );
                                        ca.appendChild( mn );
                                        var ap = abstopleft( mn );
                                        var dx = (ap.left + mn.offsetWidth) - (document.body.clientWidth - 4);
                                        if ( dx > 0 ) {
                                            left -= dx;
                                            ap.left -= dx;
                                        }
                                        var dx = ap.left - (window.pageXOffset + 4);
                                        if ( dx < 0 )
                                            left -= dx;
                                        var dy = (ap.top + mn.offsetHeight) - (document.body.clientHeight - 4);
                                        if ( dy > 0 )
                                            top -= dy;
                                        $( mn ).css( {
                                            top: top + "px",
                                            left: left + "px"
                                        } );
                                    };
                                })( ca );
                            }
                            return tr;
                        }
                        var tr = mkrow( it, it.caption, it.image );
                        function updateAction() {
                            var disabled = !!this._executing || !action, onclick = null, self = this;
                            if ( !disabled ) {
                                var act = action._action();
                                if ( !(disabled = !act) )
                                    onclick = function( e ) {
                                        function always() {
                                            self._executing = false;
                                            updateAction.call( self );
                                        }
                                        self._executing = true;
                                        self._preclick && self._preclick.call( self );
                                        act( {event: e || window.event} ).then( always, always );
                                        updateAction.call( self );
                                        menu.parentNode && menu.parentNode.removeChild( menu );
                                    };
                            }
                            $( this ).attr( "disabled", disabled && !it.items ? "" : null );
                            this.onclick = onclick;
                        }
                        if ( !it.ds ) {
                            if ( action )
                                action._listen( function() {
                                    updateAction.call( tr );
                                } );
                            updateAction.call( tr );
                            return menu;
                        }
                        var datasources = coms.datamodel._datasources;
                        var fc = it.fc && DM.mkFieldPath( it.fc, it.ds, datasources );
                        var fi = it.fi && DM.mkFieldPath( it.fi, it.ds, datasources );
                        var tmoWait, items = [], thisCursor, thisCursorChNo;
                        tr.style.backgroundImage = "url(" + asmo.root + "/static/images/progress.gif)";
                        function empty( arr ) {
                            for ( var i = 0; i < arr.length; i++ ) {
                                var e = arr[i];
                                e.parentNode.removeChild( e );
                            }
                            return [];
                        }
                        function dsupdate() {
                            var ok = true;
                            if ( !it.ds._scan( function( cursor ) {
                                var rcount = cursor._rowsCount();
                                if ( rcount === DM.fetchFPathValue.WAIT ) {
                                    ok = false;
                                    return;
                                }
                                clearTimeout( tmoWait );
                                tmoWait = null;
                                var rebuild = !!tmoWait || (thisCursor !== cursor) || (thisCursorChNo !== cursor._changeno);
                                if ( rebuild ) {
                                thisCursor = cursor;
                                items = empty( items );
                                tr.style.display = "none";
                                for ( cursor._ridx = 0; cursor._ridx < rcount; cursor._ridx++ ) {
                                    var vc = it.caption;
                                    if ( fc ) {
                                        vc = DM.fetchFPathValue( fc );
                                        if ( vc === DM.fetchFPathValue.WAIT ) {
                                            ok = false;
                                            break;
                                        }
                                        if ( vc === DM.fetchFPathValue.NVAL )
                                            continue;
                                    }
                                    var vi = it.image;
                                    if ( fi ) {
                                        vi = DM.fetchFPathValue( fi );
                                        if ( vi === DM.fetchFPathValue.WAIT ) {
                                            ok = false;
                                            break;
                                        }
                                    }
                                    var r = mkrow( it, vc, vi );
                                    r.onclick = r._preclick = (function( ridx ) {
                                        return function() {
                                            cursor._ridx = ridx;
                                            it.ds._touch();
                                        };
                                    })( cursor._ridx );
                                    updateAction.call( r );
                                    items.push( r );
                                }
                                    if ( !ok )
                                        return;
                                    thisCursorChNo = cursor._changeno;
                                }
                            } ) || !ok ) {
                                if ( !!tmoWait )
                                    tmoWait = setTimeout( function() {
                                        if ( !tmoWait )//IE8 bug
                                            return;
                                        items = empty( items );
                                        tr.style.display = "";
                                    }, 250 );
                            } else
                                WebForm.updateIcons( menu );
                        }
                        it.ds._listen( dsupdate );
                        action && action._listen( dsupdate );
                        dsupdate();
                    }
                    for ( var i in items )
                        mkitem( items[i] );
                    return menu;
                }
                if ( !menu )
                    self._menu = menu = mkmenu( d.items, d.coms );
                removeSubs( menu );
                WebForm.updateIcons( menu );
                Dropdown.popover( menu, e.currentTarget || e.srcElement );
            };
        }
    } );
} );