﻿define(["require", "exports", './Strings'], function (require, exports, S) {
    "use strict";
    describe('Strings', function () {
        it('can convert base64 to binary string', function () {
            for (var _i = 0, _a = [
                ["ZAQAAAAAPgA/AA==", "\x64\x04\x00\x00\x00\x00\x3e\x00\x3f\x00"],
                ["ZAQCAAAAPgA/AA==", "\x64\x04\x02\x00\x00\x00\x3e\x00\x3f\x00"],
                ["ZAQFAAAAPgA/AA==", "\x64\x04\x05\x00\x00\x00\x3e\x00\x3f\x00"],
                ["ZAQFAAAAPgA/AGEA", "\x64\x04\x05\x00\x00\x00\x3e\x00\x3f\x00\x61\x00"],
                ["ZAT/////PgA/AGAA", "\x64\x04\xff\xff\xff\xff\x3e\x00\x3f\x00\x60\x00"],
                ["MgBkBP////8+AD8A", "\x32\x00\x64\x04\xff\xff\xff\xff\x3e\x00\x3f\x00"],
                ["NQBkBP////8+AD8A", "\x35\x00\x64\x04\xff\xff\xff\xff\x3e\x00\x3f\x00"],
                ["ZAT/////PgA/AFsEAQAAAA==", "\x64\x04\xff\xff\xff\xff\x3e\x00\x3f\x00\x5b\x04\x01\x00\x00\x00"],
                ["ZAT/////PgA/AGAA", "\x64\x04\xff\xff\xff\xff\x3e\x00\x3f\x00\x60\x00"],
                ["ZAQAAAAAPgA/AGAA", "\x64\x04\x00\x00\x00\x00\x3e\x00\x3f\x00\x60\x00"],
                ["ZAQBAAAAPgA/AGAA", "\x64\x04\x01\x00\x00\x00\x3e\x00\x3f\x00\x60\x00"],
                ["ZAT/////PgA/AGAAWwQBAAAA", "\x64\x04\xff\xff\xff\xff\x3e\x00\x3f\x00\x60\x00\x5b\x04\x01\x00\x00\x00"],
                ["PQA=", "\x3d\x00"],
                ["OwA9ADwEAQAAAA==", "\x3b\x00\x3d\x00\x3c\x04\x01\x00\x00\x00"],
                ["PQA8BAIAAAA=", "\x3d\x00\x3c\x04\x02\x00\x00\x00"],
                ["PQA8BAMAAAA=", "\x3d\x00\x3c\x04\x03\x00\x00\x00"],
                ["PQA8BAQAAAA=", "\x3d\x00\x3c\x04\x04\x00\x00\x00"],
                ["MgA2AD0A", "\x32\x00\x36\x00\x3d\x00"],
                ["MgA3AD0A", "\x32\x00\x37\x00\x3d\x00"],
                ['', '']
            ]; _i < _a.length; _i++) {
                var t = _a[_i];
                //            console.log(JSON.stringify([t[0], a2b(<string>t[0]).replace(/./g, c => {
                //                let cc = c.charCodeAt(0).toString(16);
                //                if (cc.length !== 2)
                //                    cc = '0' + cc;
                //                return '\\x' + cc;
                //            })]));
                var q = S._atob_fallback(t[0]), e = t[1];
                expect(q).toBe(e);
            }
        });
        it('can trim strings', function () {
            expect(S.trimAll('')).toBe('');
            expect(S.trimAll(' a b')).toBe('a b');
            expect(S.trimAll('a b ')).toBe('a b');
            expect(S.trimAll('  a c b  ')).toBe('a c b');
        });
    });
});
