/*
 * Decompiled with CFR 0.152.
 */
package inform.adt;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class Cache<K, V> {
    private final Map<K, SoftReference<V>> refs = new HashMap<K, SoftReference<V>>();
    private static final int PACK_TRESHOLD = 10240;
    private static final int MISS_TRESHOLD = 8;
    private int missCount;

    public V get(K key) {
        assert (key != null);
        Reference ref = this.refs.get(key);
        if (ref == null) {
            return null;
        }
        Object object = ref.get();
        if (object == null) {
            this.refs.remove(key);
            if (++this.missCount >= 8 && this.refs.size() >= 10240) {
                this.refs.clear();
                this.missCount = 0;
            }
            return null;
        }
        return (V)object;
    }

    public void put(K key, V value) {
        assert (key != null && value != null);
        this.refs.put(key, new SoftReference<V>(value));
    }

    public V putAndGet(K key, V value) {
        assert (key != null && value != null);
        Reference ref = this.refs.put(key, new SoftReference<V>(value));
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    public void remove(K key) {
        assert (key != null);
        this.refs.remove(key);
    }
}

