/*
 * Decompiled with CFR 0.152.
 */
package inform.adt;

import inform.adt.collections.Cursor;
import java.util.Iterator;

public class LittleEndian {
    public static byte getByte(byte[] buf, int offset) {
        return (byte)(buf[offset] & 0xFF);
    }

    public static short getShort(byte[] buf, int offset) {
        return (short)(buf[offset + 1] << 8 | buf[offset] & 0xFF);
    }

    public static int getInt(byte[] buf, int offset) {
        byte a = buf[offset];
        byte b = buf[offset + 1];
        byte c = buf[offset + 2];
        byte d = buf[offset + 3];
        return d << 24 | (c & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public static long getUInt(byte[] buf, int offset) {
        byte a = buf[offset];
        byte b = buf[offset + 1];
        byte c = buf[offset + 2];
        long d = buf[offset + 3];
        return (d & 0xFFL) << 24 | (long)((c & 0xFF) << 16) | (long)((b & 0xFF) << 8) | (long)(a & 0xFF);
    }

    public static long getLong(byte[] buf, int offset) {
        byte a = buf[offset];
        byte b = buf[offset + 1];
        byte c = buf[offset + 2];
        byte d = buf[offset + 3];
        byte e = buf[offset + 4];
        byte f = buf[offset + 5];
        byte g = buf[offset + 6];
        byte h = buf[offset + 7];
        return (long)(h & 0xFF) << 56 | (long)(g & 0xFF) << 48 | (long)(f & 0xFF) << 40 | (long)(e & 0xFF) << 32 | (long)(d & 0xFF) << 24 | (long)(c & 0xFF) << 16 | (long)(b & 0xFF) << 8 | (long)(a & 0xFF);
    }

    public static float getFloat(byte[] buf, int offset) {
        return Float.intBitsToFloat(LittleEndian.getInt(buf, offset));
    }

    public static double getDouble(byte[] buf, int offset) {
        return Double.longBitsToDouble(LittleEndian.getLong(buf, offset));
    }

    public static int[] toIntArray(byte[] buf) {
        int[] result = new int[buf.length / 4];
        int offset = 0;
        for (int i = 0; i < result.length && offset < buf.length; offset += 4, ++i) {
            result[i] = LittleEndian.getInt(buf, offset);
        }
        return result;
    }

    public static double[] toDoubleArray(byte[] buf) {
        double[] result = new double[buf.length / 8];
        int offset = 0;
        for (int i = 0; i < result.length && offset < buf.length; offset += 8, ++i) {
            result[i] = LittleEndian.getDouble(buf, offset);
        }
        return result;
    }

    public static byte[] intArrayToBinary(int[] array, int size) {
        byte[] result = new byte[size * 32 / 8];
        int count = 0;
        for (int index = 0; index < size; ++index) {
            int i = array[index];
            result[count++] = (byte)(i & 0xFF);
            result[count++] = (byte)((i & 0xFF00) >> 8);
            result[count++] = (byte)((i & 0xFF0000) >> 16);
            result[count++] = (byte)((i & 0xFF000000) >> 24);
        }
        return result;
    }

    public static byte[] doubleArrayToBinary(double[] array, int size) {
        byte[] result = new byte[size * 64 / 8];
        int count = 0;
        for (int index = 0; index < size; ++index) {
            long l = Double.doubleToLongBits(array[index]);
            int i = (int)l;
            result[count++] = (byte)(i & 0xFF);
            result[count++] = (byte)((i & 0xFF00) >> 8);
            result[count++] = (byte)((i & 0xFF0000) >> 16);
            result[count++] = (byte)((i & 0xFF000000) >> 24);
            i = (int)(l >> 32);
            result[count++] = (byte)(i & 0xFF);
            result[count++] = (byte)((i & 0xFF00) >> 8);
            result[count++] = (byte)((i & 0xFF0000) >> 16);
            result[count++] = (byte)((i & 0xFF000000) >> 24);
        }
        return result;
    }

    public static byte[] doubleArrayToBinary(double[] array) {
        return LittleEndian.doubleArrayToBinary(array, array.length);
    }

    public static byte[] doubleIteratorToBinary(Iterator<Double> it, int size) {
        byte[] result = new byte[size * 64 / 8];
        int count = 0;
        for (int index = 0; index < size && it.hasNext(); ++index) {
            long l = Double.doubleToLongBits(it.next());
            int i = (int)l;
            result[count++] = (byte)(i & 0xFF);
            result[count++] = (byte)((i & 0xFF00) >> 8);
            result[count++] = (byte)((i & 0xFF0000) >> 16);
            result[count++] = (byte)((i & 0xFF000000) >> 24);
            i = (int)(l >> 32);
            result[count++] = (byte)(i & 0xFF);
            result[count++] = (byte)((i & 0xFF00) >> 8);
            result[count++] = (byte)((i & 0xFF0000) >> 16);
            result[count++] = (byte)((i & 0xFF000000) >> 24);
        }
        return result;
    }

    public static byte[] doubleCursorToBinary(Iterator<? extends Cursor.Double> it, int size) {
        byte[] result = new byte[size * 64 / 8];
        int count = 0;
        for (int index = 0; index < size && it.hasNext(); ++index) {
            long l = Double.doubleToLongBits(it.next().value);
            int i = (int)l;
            result[count++] = (byte)(i & 0xFF);
            result[count++] = (byte)((i & 0xFF00) >> 8);
            result[count++] = (byte)((i & 0xFF0000) >> 16);
            result[count++] = (byte)((i & 0xFF000000) >> 24);
            i = (int)(l >> 32);
            result[count++] = (byte)(i & 0xFF);
            result[count++] = (byte)((i & 0xFF00) >> 8);
            result[count++] = (byte)((i & 0xFF0000) >> 16);
            result[count++] = (byte)((i & 0xFF000000) >> 24);
        }
        return result;
    }

    public static byte[] doubleToBinary(double val) {
        return LittleEndian.longToBinary(Double.doubleToLongBits(val));
    }

    public static byte[] intToBinary(int val) {
        return new byte[]{(byte)(val & 0xFF), (byte)((val & 0xFF00) >> 8), (byte)((val & 0xFF0000) >> 16), (byte)((val & 0xFF000000) >> 24)};
    }

    public static byte[] longToBinary(long val) {
        return new byte[]{(byte)(val & 0xFFL), (byte)((val & 0xFF00L) >>> 8), (byte)((val & 0xFF0000L) >>> 16), (byte)((val & 0xFF000000L) >>> 24), (byte)((val & 0xFF00000000L) >>> 32), (byte)((val & 0xFF0000000000L) >>> 40), (byte)((val & 0xFF000000000000L) >>> 48), (byte)((val & 0xFF00000000000000L) >>> 56)};
    }

    public static void setDouble(double val, byte[] buf, int offset) {
        long bytes = Double.doubleToLongBits(val);
        buf[offset++] = (byte)(bytes & 0xFFL);
        buf[offset++] = (byte)((bytes & 0xFF00L) >>> 8);
        buf[offset++] = (byte)((bytes & 0xFF0000L) >>> 16);
        buf[offset++] = (byte)((bytes & 0xFF000000L) >>> 24);
        buf[offset++] = (byte)((bytes & 0xFF00000000L) >>> 32);
        buf[offset++] = (byte)((bytes & 0xFF0000000000L) >>> 40);
        buf[offset++] = (byte)((bytes & 0xFF000000000000L) >>> 48);
        buf[offset++] = (byte)((bytes & 0xFF00000000000000L) >>> 56);
    }

    public static void setByte(byte val, byte[] buf, int offset) {
        buf[offset++] = (byte)((long)val & 0xFFL);
    }

    public static void setShort(short val, byte[] buf, int offset) {
        buf[offset++] = (byte)((long)val & 0xFFL);
        buf[offset++] = (byte)(((long)val & 0xFF00L) >>> 8);
    }

    public static void setInteger(int val, byte[] buf, int offset) {
        buf[offset++] = (byte)((long)val & 0xFFL);
        buf[offset++] = (byte)(((long)val & 0xFF00L) >>> 8);
        buf[offset++] = (byte)(((long)val & 0xFF0000L) >>> 16);
        buf[offset++] = (byte)(((long)val & 0xFF000000L) >>> 24);
    }

    public static void setLong(long val, byte[] buf, int offset) {
        buf[offset++] = (byte)(val & 0xFFL);
        buf[offset++] = (byte)((val & 0xFF00L) >>> 8);
        buf[offset++] = (byte)((val & 0xFF0000L) >>> 16);
        buf[offset++] = (byte)((val & 0xFF000000L) >>> 24);
        buf[offset++] = (byte)((val & 0xFF00000000L) >>> 32);
        buf[offset++] = (byte)((val & 0xFF0000000000L) >>> 40);
        buf[offset++] = (byte)((val & 0xFF000000000000L) >>> 48);
        buf[offset++] = (byte)((val & 0xFF00000000000000L) >>> 56);
    }
}

