/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.collections;

import inform.adt.collections.AbstractSet;
import inform.adt.collections.Cursor;
import inform.adt.collections.Hashing;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectSet
extends AbstractSet
implements Iterable<Cursor.Object> {
    public static final ObjectSet EMPTY = new ObjectSet();
    private static final Object ZERO = Hashing.zero_Object;
    private Object[] keys;

    public ObjectSet() {
        this.keys = new Object[this.capacity << 1];
    }

    public boolean add(Object v) {
        if (v == ZERO) {
            return this.addZero();
        }
        this.rehashIfNeed();
        boolean r = this.place(v);
        if (r) {
            ++this.size;
        }
        return r;
    }

    public boolean contains(Object k) {
        Object e;
        if (k == ZERO) {
            return this.zero;
        }
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while ((e = this.keys[i]) != ZERO) {
            if (this.equals(e, k)) {
                return true;
            }
            i = i + 1 & m;
        }
        return false;
    }

    public boolean remove(Object k) {
        Object e;
        if (k == ZERO) {
            return this.remZero();
        }
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while ((e = this.keys[i]) != ZERO) {
            if (this.equals(e, k)) {
                this.deleteAt(i);
                return true;
            }
            i = i + 1 & m;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        int len = this.keys.length;
        for (int i = 0; i < len; ++i) {
            this.keys[i] = ZERO;
        }
    }

    @Override
    public Iterator<Cursor.Object> iterator() {
        return new Iterator<Cursor.Object>(){
            final Cursor.Object cursor = new Cursor.Object();
            final int keysLen;
            boolean has;
            int idx;
            {
                this.keysLen = ObjectSet.this.keys.length;
                this.has = ObjectSet.this.zero;
            }

            @Override
            public boolean hasNext() {
                while (!this.has && this.idx < this.keysLen) {
                    this.has = (this.cursor.value = ObjectSet.this.keys[this.idx++]) != ZERO;
                }
                return this.has;
            }

            @Override
            public Cursor.Object next() {
                if (this.idx > this.keysLen) {
                    throw new NoSuchElementException();
                }
                this.has = false;
                return this.cursor;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object[] toArray() {
        Object[] r = new Object[this.size];
        int i = 0;
        if (this.zero) {
            r[i++] = ZERO;
        }
        for (Object v : this.keys) {
            if (v == ZERO) continue;
            r[i++] = v;
        }
        return r;
    }

    private boolean place(Object k) {
        Object e;
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while ((e = this.keys[i]) != ZERO) {
            if (this.equals(e, k)) {
                return false;
            }
            i = i + 1 & m;
        }
        this.keys[i] = k;
        return true;
    }

    @Override
    protected void rehash() {
        Object[] old = this.keys;
        this.keys = new Object[this.capacity << 1];
        for (Object v : old) {
            if (v == ZERO) continue;
            this.place(v);
        }
    }

    protected final void deleteAt(int index) {
        Object v;
        assert (this.keys[index] != ZERO);
        this.keys[index] = ZERO;
        --this.size;
        int m = this.keys.length - 1;
        int i = index + 1 & m;
        while ((v = this.keys[i]) != ZERO) {
            this.keys[i] = ZERO;
            this.place(v);
            i = i + 1 & m;
        }
    }

    protected int hash(Object v) {
        return Hashing.hash(v);
    }

    protected boolean equals(Object a, Object b) {
        return Hashing.equals(a, b);
    }

    @Override
    protected final boolean toString_appendZero(StringBuilder out) {
        if (!this.zero) {
            return false;
        }
        out.append(ZERO);
        return true;
    }

    @Override
    protected final boolean toString_appendItem(int index, StringBuilder out) {
        Object e = this.keys[index];
        if (e == ZERO) {
            return false;
        }
        out.append(e);
        return true;
    }

    public int fillFactor() {
        int f = 0;
        int m = 0;
        for (Object v : this.keys) {
            if (v != ZERO) {
                ++f;
                continue;
            }
            if (m < f) {
                m = f;
            }
            f = 0;
        }
        if (m < f) {
            m = f;
        }
        return m;
    }
}

