/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.taggedio;

import inform.adt.InformException;
import inform.adt.taggedio.TagHeader;
import inform.adt.taggedio.TagReader;
import java.util.Arrays;

public abstract class InOutMemory {
    private static final int FOLLY_TAG_LIMIT = 0x8000000;
    protected byte[][] fragments = new byte[][]{null, null};
    protected int fragmentCount = 0;
    protected int currentPosition = 0;

    public boolean peekBytes(int skip, byte[] buffer) throws InformException {
        int i;
        if (buffer == null || buffer.length == 0) {
            return true;
        }
        MemoryIterator in = new MemoryIterator();
        for (i = 0; i < skip; ++i) {
            in.next();
        }
        for (i = 0; in.hasNext() && i < buffer.length; ++i) {
            buffer[i] = in.next();
        }
        return i == buffer.length;
    }

    public TagHeader peekTagHeader() throws InformException {
        MemoryIterator in = new MemoryIterator();
        if (!in.hasNext()) {
            return null;
        }
        int tag = in.next() & 0xFF;
        if (tag == 255) {
            if (!this.isAvailable(246)) {
                return null;
            }
            TagHeader header = new TagHeader();
            header.tag = in.next() & 0xFF;
            header.dataSize = this.peekIntLE(in);
            header.headerSize = 6;
            return header;
        }
        if (!in.hasNext()) {
            return null;
        }
        TagHeader header = new TagHeader();
        header.tag = tag;
        header.dataSize = in.next() & 0xFF;
        header.headerSize = 2;
        return header;
    }

    public TagReader poolTagReader() throws InformException {
        TagHeader header = this.peekTagHeader();
        if (header == null) {
            return null;
        }
        int needSize = header.headerSize + header.dataSize;
        if (!this.isAvailable(needSize)) {
            if (needSize >= 0x8000000) {
                this.warn("Tag too big ({} bytes)", needSize);
            }
            return null;
        }
        byte[] tagData = new byte[header.dataSize];
        this.peekBytes(header.headerSize, tagData);
        this.skip(needSize);
        return new TagReader(header.tag, tagData, header.dataSize);
    }

    public void skip(int size) throws InformException {
        if (size <= 0) {
            throw new InformException("MemoryBlockReader.skip: invalid size");
        }
        while (size > 0 && this.fragmentCount > 0) {
            int available;
            byte[] block = this.fragments[0];
            if (block == null) {
                this.throwUnexpextedEnd();
            }
            if ((available = block.length - this.currentPosition) == 0) {
                this.popFragment();
                continue;
            }
            if (available <= size) {
                this.popFragment();
                size -= available;
                continue;
            }
            this.currentPosition += size;
            size = 0;
        }
        if (size == 0) {
            return;
        }
        this.throwUnexpextedEnd();
    }

    public void getBytes(byte[] buffer, int size) throws InformException {
        if (buffer == null || size == 0) {
            return;
        }
        assert (size <= buffer.length);
        int bufPos = 0;
        int i = 0;
        while (bufPos < size && i < this.fragmentCount) {
            byte[] block = this.fragments[i];
            if (block == null) {
                this.throwUnexpextedEnd();
            }
            while (bufPos < size && this.currentPosition < block.length) {
                buffer[bufPos++] = block[this.currentPosition++];
            }
            if (this.currentPosition == block.length) {
                this.popFragment();
                continue;
            }
            ++i;
        }
        if (bufPos != size) {
            this.throwUnexpextedEnd();
        }
    }

    int peekIntLE(MemoryIterator in) throws InformException {
        if (!in.hasNext()) {
            this.throwUnexpextedEnd();
        }
        byte a = in.next();
        if (!in.hasNext()) {
            this.throwUnexpextedEnd();
        }
        byte b = in.next();
        if (!in.hasNext()) {
            this.throwUnexpextedEnd();
        }
        byte c = in.next();
        if (!in.hasNext()) {
            this.throwUnexpextedEnd();
        }
        byte d = in.next();
        return d << 24 | (c & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public boolean isAvailable(int size) {
        int available = 0;
        int position = this.currentPosition;
        for (byte[] block : this.fragments) {
            if (block == null) break;
            if (size <= (available += block.length - position)) {
                return true;
            }
            position = 0;
        }
        return false;
    }

    public void add(byte[] block) {
        if (this.fragmentCount == this.fragments.length) {
            this.fragments = (byte[][])Arrays.copyOf(this.fragments, this.fragments.length + 2);
        }
        this.fragments[this.fragmentCount++] = block;
    }

    private void popFragment() {
        int newCount = this.fragmentCount - 1;
        for (int i = 0; i < newCount; ++i) {
            this.fragments[i] = this.fragments[i + 1];
        }
        this.fragments[newCount] = null;
        this.fragmentCount = newCount;
        this.currentPosition = 0;
    }

    public void throwUnexpextedEnd() throws InformException {
        throw new InformException("\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u043d\u0435\u0446 \u0434\u0430\u043d\u043d\u044b\u0445");
    }

    protected abstract void warn(String var1, Object var2);

    public byte[][] getFragments() {
        return this.fragments;
    }

    public int getFragmentCount() {
        return this.fragmentCount;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    class MemoryIterator {
        int fragmentIndex = 0;
        int position;
        int absolutePosition;

        MemoryIterator() {
            this.position = InOutMemory.this.currentPosition;
            this.absolutePosition = 0;
        }

        boolean hasNext() {
            return this.fragmentIndex < InOutMemory.this.fragments.length && InOutMemory.this.fragments[this.fragmentIndex] != null && this.position < InOutMemory.this.fragments[this.fragmentIndex].length;
        }

        byte next() throws InformException {
            byte[] block = InOutMemory.this.fragments[this.fragmentIndex];
            if (block == null) {
                InOutMemory.this.throwUnexpextedEnd();
                return 0;
            }
            byte result = block[this.position++];
            ++this.absolutePosition;
            if (this.position == block.length) {
                this.position = 0;
                ++this.fragmentIndex;
            }
            return result;
        }
    }
}

