/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.taggedio;

import inform.adt.taggedio.TaggedWriter;
import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class LittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    private final InputStream inputStream;

    public LittleEndianDataInputStream(InputStream dataStream) {
        super(dataStream);
        this.inputStream = dataStream;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            return this.in.read(b, off, len);
        }
        return 0;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        if (this.inputStream.read(b) < b.length) {
            throw new EOFException();
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (off < 0) {
            throw new IndexOutOfBoundsException("off");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len");
        }
        if (off + len > b.length) {
            throw new IndexOutOfBoundsException("off+len");
        }
        if (this.inputStream.read(b, off, len) < b.length - off + len) {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.inputStream.skip(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        int val = this.inputStream.read();
        if (val == -1) {
            throw new EOFException();
        }
        return val != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int val = this.inputStream.read();
        if (val == -1) {
            throw new EOFException();
        }
        return (byte)(val & 0xFF);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int result = this.inputStream.read();
        if (result == -1) {
            throw new EOFException();
        }
        return result & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        int a = this.inputStream.read();
        int b = this.inputStream.read();
        if (a == -1 || b == -1) {
            throw new EOFException();
        }
        return (short)(b << 8 | a & 0xFF);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int a = this.inputStream.read();
        int b = this.inputStream.read();
        if (a == -1 || b == -1) {
            throw new EOFException();
        }
        return (b & 0xFF) << 8 | a & 0xFF;
    }

    @Override
    public char readChar() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int readInt() throws IOException {
        int a = this.inputStream.read();
        int b = this.inputStream.read();
        int c = this.inputStream.read();
        int d = this.inputStream.read();
        if (a == -1 || b == -1 || c == -1 || d == -1) {
            throw new EOFException();
        }
        return d << 24 | (c & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public long readUnsignedInt() throws IOException {
        int a = this.inputStream.read();
        int b = this.inputStream.read();
        int c = this.inputStream.read();
        int d = this.inputStream.read();
        if (a == -1 || b == -1 || c == -1 || d == -1) {
            throw new EOFException();
        }
        return (long)(d & 0xFF) << 24 | (long)(c & 0xFF) << 16 | (long)(b & 0xFF) << 8 | (long)(a & 0xFF);
    }

    @Override
    public long readLong() throws IOException {
        int a = this.inputStream.read();
        int b = this.inputStream.read();
        int c = this.inputStream.read();
        int d = this.inputStream.read();
        int e = this.inputStream.read();
        int f = this.inputStream.read();
        int g = this.inputStream.read();
        int h = this.inputStream.read();
        if (a == -1 || b == -1 || c == -1 || d == -1 || e == -1 || f == -1 || g == -1 || h == -1) {
            throw new EOFException();
        }
        return (long)(h & 0xFF) << 56 | (long)(g & 0xFF) << 48 | (long)(f & 0xFF) << 40 | (long)(e & 0xFF) << 32 | (long)(d & 0xFF) << 24 | (long)(c & 0xFF) << 16 | (long)(b & 0xFF) << 8 | (long)(a & 0xFF);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] readNTB() throws IOException {
        byte b;
        byte[] bytes = new byte[16];
        int length = 0;
        while ((b = this.readByte()) != 0) {
            if (length == bytes.length) {
                bytes = Arrays.copyOf(bytes, 2 * length);
            }
            bytes[length++] = b;
        }
        if (length == bytes.length) {
            return bytes;
        }
        return Arrays.copyOf(bytes, length);
    }

    public String readAnsi() throws IOException {
        byte b;
        byte[] bytes = new byte[16];
        int length = 0;
        while ((b = this.readByte()) != 0) {
            if (length == bytes.length) {
                bytes = Arrays.copyOf(bytes, 2 * length);
            }
            bytes[length++] = b;
        }
        return new String(bytes, 0, length, TaggedWriter.ANSI);
    }

    public String readUnicode() throws IOException {
        byte[] bytes = new byte[16];
        int length = 0;
        while (true) {
            byte b1 = this.readByte();
            byte b2 = this.readByte();
            if (b1 == 0 && b2 == 0) break;
            if (length == bytes.length) {
                bytes = Arrays.copyOf(bytes, 2 * length);
            }
            bytes[length++] = b1;
            bytes[length++] = b2;
        }
        return new String(bytes, 0, length, TaggedWriter.UTF16LE);
    }
}

