/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.taggedio;

import inform.adt.taggedio.SendReadyResponse;
import inform.adt.taggedio.TaggedWriter;
import java.io.IOException;
import java.io.OutputStream;

public class SendReadyTaggedWriter
extends TaggedWriter {
    private final SendReadyResponse host;
    private long inputSize = 0L;
    private long notifySize = 0L;

    public SendReadyTaggedWriter(OutputStream dataStream, SendReadyResponse host) {
        super(dataStream);
        this.host = host;
    }

    public final long getInputSize() {
        return this.inputSize;
    }

    public long getNotifySize() {
        return this.notifySize;
    }

    public final void setNotifySize(long notifySize) {
        this.notifySize = notifySize;
    }

    @Override
    protected void writeTagHeader(int tag, int dataSize) throws IOException {
        super.writeTagHeader(tag, dataSize);
        this.inputSize = dataSize <= 240 ? (this.inputSize += 2L) : (this.inputSize += 6L);
        this.inputSize += (long)dataSize;
    }

    @Override
    public void reset(OutputStream dataStream) throws IOException {
        super.reset(dataStream);
        this.inputSize = 0L;
    }

    @Override
    public void notifyReady() throws Exception {
        if (this.host != null && this.notifySize > 0L && this.notifySize <= this.inputSize) {
            this.host.notifyReadyToSend();
        }
    }
}

