/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.Memory;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.TimeInfo;
import inform.adt.TimeZoneHost;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TagVersionInfo;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ActionHooks;
import inform.agent.AsmoTemplateIDGenerator;
import inform.agent.CancelRequestException;
import inform.agent.DBConf;
import inform.agent.EdDsa;
import inform.agent.HeapDumper;
import inform.agent.Ini;
import inform.agent.PhaThread;
import inform.agent.RequestStatistics;
import inform.agent.SmartNumberConverter;
import inform.agent.Statistics;
import inform.agent.VersionInfo;
import inform.agent.Vfs;
import inform.agent.am.Telemeter;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.DatabaseType;
import inform.agent.files.BFS;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.net.AlertingEngine;
import inform.agent.net.Client;
import inform.agent.net.ClientSession;
import inform.agent.net.MultiProtocolServerHandler;
import inform.agent.net.RequestExecutor;
import inform.agent.sched.Sched;
import inform.agent.scripts.AsmoJsContextFactory;
import inform.agent.scripts.License;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.metadata.MetadataLibrary;
import inform.agent.web.AsyncExecutor;
import inform.agent.web.JWT;
import inform.common.IdGenerator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.AsmoLogger;

public class Core {
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    public static final int DDL = 4;
    public static final int DANGER = 5;
    public static final int SEC = 6;
    public static final int CURRENT_LOG_LEVEL = 1;
    public static final AsmoLogger logger = (AsmoLogger)LoggerFactory.getLogger((String)"Asmo");
    public static final int CONSTANT_ID_ACTUAL_POINT = -7;
    public static final int WARN_LONG_TIME_SQL = 30000;
    private static final int STAT_PRINT_INTERVAL = 60000;
    public static int serverVersionMajor = 0;
    public static int serverVersionMinor = 0;
    public static int serverVersionRelease = 0;
    public static int platformVersion = 0;
    public static final int THREAD_HANG_DUMP_CALLSTACK_INTERVAL = 300000;
    public static final int SHORT_REQUEST_TRESHOLD = 5000;
    public static final Vfs mountfs = new Vfs();
    public static final Vfs blobfs = new Vfs();
    private static volatile boolean statModified = false;
    public static final Statistics stat = new Statistics(){

        @Override
        protected void modified() {
            statModified = true;
        }
    };
    public static final SSContext.DefaultContext defaultContext = new SSContext.DefaultContext();
    public static final AsmoJsContextFactory asmoJsContextFactory = new AsmoJsContextFactory();
    public static final TimeZoneHost serverTimeZoneHost = new TimeZoneHost(){

        @Override
        public int getTimeZoneOffset() {
            return DateTime.serverZoneOffset();
        }
    };
    public static boolean isTimeZoneConversionUsed = false;
    public static boolean isFstecBuild;
    private static long lastStatDump;
    public static volatile boolean gcOverheated;
    private static final byte[][] BALLONS;
    private static int BALLON_INDEX;
    private static final double WARN_GC_TIME_TRESHOLD = 0.05;
    private static final long WARN_GC_TIME_INTERVAL = 60000L;
    private static final long CHECK_GC_TIME_INTERVAL = 10000L;
    private static long lastWarnGcTick;
    private static long lastCheckGcTick;
    private static long lastGcTime;
    private static ChannelFactory netChannelFactory;
    private static ExecutorService jbossSessionExecutor;
    private static ServerBootstrap serverBootstrap;
    private static Channel serverChannel;
    private static double applicationId;
    private static final long clockBase;
    private static final long nanoBase;
    private static boolean agentStopped;
    private static String agentStopReason;
    private static long hostIdGenerator;
    private static String hostName;
    private static String authorizedKeys;
    private static ArrayList<TagVersionInfo> minClinetVersions;
    private static TagVersionInfo maxClinetVersion;
    private static License license;
    private static int licenseClientLimit;
    private static final Object authorizedKeyMutex;

    public static native int getMetadataDBKind();

    public static native void writeLogLine(int var0, String var1);

    public static native void setLogPath(String var0);

    public static native String odbcDSNtoURL(String var0);

    public static native boolean checkFileSafeOpen(String var0);

    public static native void getSystemMemoryUsage(long[] var0);

    public static native void getProcessMemoryUsage(long[] var0);

    static native void getCurrentSystemTimes(long[] var0);

    static native void getCurrentProcessTimes(long[] var0);

    static native void getCurrentThreadTimes(long[] var0);

    public static native void loadDBConf(String var0, DBConf var1);

    public static native void setCurrentThreadName(String var0);

    public static native long calcCrc64(byte[] var0, int var1);

    public static native void copyIniValuesFromJavaToNative();

    public static native void setFileDescriptorNum(FileDescriptor var0, int var1);

    public static native ServerSocketChannel createChannel(SelectorProvider var0, FileDescriptor var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean JNI_startAgent() {
        Core.getHostName();
        Core.initAuthorizedKeys();
        Thread.currentThread().setName("main");
        try {
            DriverManager.setLogWriter(new PrintWriter(new Writer(){
                final StringBuilder buffer = new StringBuilder();

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    this.buffer.append(cbuf, off, len);
                }

                @Override
                public void flush() throws IOException {
                    if (this.buffer.length() > 0) {
                        logger.info("DriverManager: {}", (Object)this.buffer.toString().trim());
                    }
                    this.buffer.setLength(0);
                }

                @Override
                public void close() throws IOException {
                }
            }));
            logger.info("loading JDBC-drivers");
            DriverManager.getDrivers();
            DriverManager.setLogWriter(null);
            if (Ini.BackupMode) {
                logger.info("start backup process");
                if (MetadataLibrary.coldBackupDatabase()) {
                    logger.info("backup is complete");
                }
                return false;
            }
            logger.info("repl-sample mode:" + Ini.ReplSample);
            AsmoTemplateIDGenerator.init();
            try (DatabaseConnection connection = DatabaseDescriptor.getMetabase().connectPrivileged("JNI_startAgent: get time zone from ServerNode");){
                MetadataNodeReader serverNodeReader = MetadataNodeReader.createNode(null, 2.0, connection);
                if (serverNodeReader != null && serverNodeReader.content != null) {
                    ServerNode.Descriptor serverDescriptor = new ServerNode.Descriptor(new TaggedReader(serverNodeReader.content));
                    if (serverDescriptor.useTimeZone) {
                        char sign;
                        isTimeZoneConversionUsed = true;
                        int offset = serverDescriptor.timeZoneOffsetSec / 60;
                        if (offset > 0) {
                            sign = '+';
                        } else {
                            sign = '-';
                            offset = -offset;
                        }
                        String id = String.format("GMT%c%02d:%02d", Character.valueOf(sign), offset / 60, offset % 60);
                        TimeZone tz = TimeZone.getTimeZone(id);
                        TimeZone.setDefault(tz);
                        DateTime.setTimeZone(tz);
                    }
                }
            }
            catch (Throwable e) {
                logger.error(null, e);
            }
            MtdEngine.initNodeCache();
            if (Ini.CleanupBlobFS) {
                BFS.cleanupTemp(null);
            }
            AsmoTemplateIDGenerator.checkReady();
            Runtime runtime = Runtime.getRuntime();
            ExecutorService jbossExecutor = Executors.newCachedThreadPool(PhaThread.createFactory("ne"));
            netChannelFactory = new NioServerSocketChannelFactory((Executor)jbossExecutor, (Executor)jbossExecutor);
            serverBootstrap = new ServerBootstrap(netChannelFactory);
            int poolSize = runtime.availableProcessors() / 2;
            if (poolSize < 2) {
                poolSize = 2;
            } else if (poolSize > 4) {
                poolSize = 4;
            }
            jbossSessionExecutor = new OrderedMemoryAwareThreadPoolExecutor(poolSize, 0x100000L, runtime.maxMemory() / 3L, 20L, TimeUnit.SECONDS, PhaThread.createFactory("jbs"));
            serverBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                public ChannelPipeline getPipeline() throws Exception {
                    return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new ExecutionHandler((Executor)jbossSessionExecutor), new MultiProtocolServerHandler()});
                }
            });
            serverBootstrap.setOption("reuseAddress", (Object)true);
            InetSocketAddress addr = Ini.EmbeddedMode ? new InetSocketAddress("localhost", Ini.ClientConnectionPort) : new InetSocketAddress(Ini.ClientConnectionPort);
            serverChannel = serverBootstrap.bind((SocketAddress)addr);
            Ini.ClientConnectionPort = ((InetSocketAddress)serverChannel.getLocalAddress()).getPort();
            return true;
        }
        catch (Throwable ex) {
            logger.error(null, ex);
            agentStopped = true;
            return false;
        }
    }

    public static void JNI_agentMainThread() {
        if (Ini.EmbeddedMode) {
            logger.info("EmbeddedMode");
        }
        Thread.currentThread().setName("main");
        try {
            MtdEngine.startNodeCache();
            if (!Ini.BackupMode) {
                Sched.run();
            }
        }
        catch (Throwable ex) {
            logger.error(null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void JNI_beginStopAgent(String reason) {
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            agentStopReason = reason;
            agentStopped = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (applicationId != 0.0) {
                Connector.Metabase connector = new Connector.Metabase();
                try {
                    try {
                        MetadataNodeReader.deleteAgentApplication(connector.connection(), applicationId);
                    }
                    finally {
                        connector.close();
                    }
                }
                catch (SQLException e) {
                    logger.error(null, e);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void JNI_stopAgent() throws Throwable {
        ChannelFuture future;
        if (serverChannel != null && !(future = serverChannel.close()).awaitUninterruptibly(2L, TimeUnit.SECONDS)) {
            logger.warn("long(>2s) close of serverChannel");
        }
        Sched.shutdown();
        RequestExecutor.shutdown();
        ChannelGroupFuture cgf = ClientSession.shutdownClients();
        jbossSessionExecutor.shutdown();
        AsyncExecutor.shutdown();
        Sched.awaitTermination();
        RequestExecutor.awaitTermination();
        if (!jbossSessionExecutor.awaitTermination(2L, TimeUnit.SECONDS)) {
            logger.warn("long(>2s) termination of jbossSessionExecutor");
        }
        cgf.awaitUninterruptibly();
        AsyncExecutor.awaitTermination();
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            if (netChannelFactory != null) {
                netChannelFactory.releaseExternalResources();
            }
            netChannelFactory = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            DatabaseDescriptor.destroyPools();
            RequestStatistics.slice(System.currentTimeMillis(), true);
            Core.dumpThreads(false);
            return;
        }
    }

    public static void JNI_amAttach() {
        logger.info("Attached to AM");
    }

    private static void redirectErrOut() {
        try {
            System.setErr(new Std2Log(AsmoLogger.Level.ERROR));
            System.setOut(new Std2Log(AsmoLogger.Level.INFO));
        }
        catch (UnsupportedEncodingException e) {
            throw InformException.wrap(e);
        }
    }

    public static boolean JNI_tryStartSoftTerminate() {
        return RequestExecutor.canStartSoftTerminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAgentStopped() {
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return agentStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAgentStopReason() {
        Class<Core> clazz = Core.class;
        synchronized (Core.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return agentStopReason;
        }
    }

    public static String getMetadataLogScheme() {
        return Ini.MetabaseLogScheme;
    }

    public static String getMetadataDBTNS() {
        return Ini.MetabaseDBTNS;
    }

    public static String getMetadataDBDSN() {
        return Ini.MetabaseDB;
    }

    public static String getMetadataDBUsername() {
        return Ini.MetabaseLogin;
    }

    public static String getMetadataDBPassword() {
        return Ini.MetabasePassword;
    }

    public static void notifyRecordChanged(double tableID, double recordID) throws Exception {
        boolean TAG_CN_TABLE_DATA = true;
        int TAG_CN_ROWINFO = 2;
        boolean ROW_MODIFIED = false;
        ByteArrayOutputStream msg = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(msg);
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        LittleEndianDataOutputStream headerOut = new LittleEndianDataOutputStream(header);
        headerOut.writeDouble(tableID);
        headerOut.writeInt(1);
        headerOut.flush();
        out.putRaw(1, header);
        header = new ByteArrayOutputStream();
        headerOut = new LittleEndianDataOutputStream(header);
        headerOut.writeDouble(recordID);
        headerOut.writeDouble(0.0);
        headerOut.writeDouble(0.0);
        headerOut.writeInt(0);
        headerOut.writeInt(0);
        headerOut.flush();
        out.putRaw(2, header);
        out.flush();
        AlertingEngine.sendChangeNotification(null, msg.internalBuffer(), msg.size(), 0L);
    }

    public static double generateId() throws InformException {
        return IdGenerator.genId();
    }

    public static void sendUserNotification(double userId, byte[] messageContent) throws IOException, InformException {
        AlertingEngine.sendUserNotification(userId, messageContent, messageContent.length);
    }

    public static String getExceptionDetails(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    public static void suppressErrorToLog(Throwable e) throws CancelRequestException {
        logger.error(null, e);
        if (e instanceof CancelRequestException) {
            throw (CancelRequestException)e;
        }
    }

    public static void JNI_mainEntry(String arg) {
        System.out.println(arg);
    }

    public static void JNI_inMainLoop() {
        long time = System.currentTimeMillis();
        ActionHooks.autoHook(time);
        Core.tryCheckGCTime();
        if (!statModified) {
            return;
        }
        DatabaseDescriptor.statTrySlice(time);
        ClientSession.statTrySlice(time);
        RequestStatistics.sliceIfTimeout(time);
        long dt = time - lastStatDump;
        if (dt > 60000L) {
            logger.info("STAT rq(cnt:{},t:{});sql(cnt:{},t:{},f:{},m:{})", Core.stat.rqCount.get(), Core.stat.rqTime.get(), Core.stat.sqlCount.get(), Core.stat.sqlTime.get(), Core.stat.sqlRowsFetched.get(), Core.stat.sqlRowsModified.get());
            lastStatDump = time;
            statModified = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ballonBlowUp() {
        byte[][] byArray = BALLONS;
        synchronized (BALLONS) {
            if (BALLON_INDEX == BALLONS.length) {
                logger.warn("no more empty ballons");
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            Core.BALLONS[Core.BALLON_INDEX] = new byte[0x400000];
            ++BALLON_INDEX;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ballonTryBlowDown() {
        byte[][] byArray = BALLONS;
        synchronized (BALLONS) {
            if (BALLON_INDEX == 0) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return false;
            }
            Core.BALLONS[--Core.BALLON_INDEX] = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return true;
        }
    }

    private static void tryCheckGCTime() {
        long tick = Core.clock();
        if (tick - lastCheckGcTick < 10000L) {
            return;
        }
        long gcTime = 0L;
        for (GarbageCollectorMXBean b : ManagementFactory.getGarbageCollectorMXBeans()) {
            long t = b.getCollectionTime();
            if (t <= 0L) continue;
            gcTime += t;
        }
        double cp = (double)(gcTime - lastGcTime) / (double)(tick - lastCheckGcTick);
        boolean bl = gcOverheated = cp > 0.05;
        if (gcOverheated && tick - lastWarnGcTick > 60000L) {
            lastWarnGcTick = tick;
            logger.warn("GC-Time: {}%\nRunning tasks", (Object)(cp * 100.0));
        }
        lastGcTime = gcTime;
        lastCheckGcTick = tick;
    }

    private static void dumpRunningTasks() {
    }

    private static void logSysProps() {
        String[] props;
        for (String prop : props = new String[]{"java.version", "java.vendor", "java.home", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.io.tmpdir", "java.compiler"}) {
            logger.info(prop + ": " + System.getProperty(prop));
        }
    }

    public static void init(String[] mountPoints, String[] blobPoints, String[] sharedBlobPoints, String[] jwtTrustedSources) {
        String tempDirProp;
        String[] sp;
        Core.redirectErrOut();
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (!Strings.isVoid(Ini.Locale)) {
            String[] sp2 = Ini.Locale.split("_");
            Locale locale = sp2.length == 1 ? new Locale(sp2[0]) : new Locale(sp2[0], sp2[1]);
            Locale.setDefault(locale);
        }
        Core.logSysProps();
        if (Ini.verbose) {
            logger.info("VERBOSE MODE");
        }
        boolean needCreateTempMountPoint = true;
        if (mountPoints != null && mountPoints.length != 0) {
            logger.info("mount points:");
            for (String s : mountPoints) {
                sp = s.split("=");
                String mountPointName = sp[0];
                logger.info("\t'{}': => '{}'", (Object)mountPointName, (Object)sp[1]);
                mountfs.addMountPoint(mountPointName, sp[1]);
                if (!"temp".equals(mountPointName)) continue;
                needCreateTempMountPoint = false;
            }
        }
        if (needCreateTempMountPoint && (tempDirProp = Core.getTempDir()) != null) {
            File tmpdir = new File(tempDirProp, "agent");
            if (!Strings.isVoid(Ini.AgentID)) {
                tmpdir = new File(tmpdir, Ini.AgentID);
            }
            if (tmpdir.exists()) {
                if (tmpdir.isFile()) {
                    try {
                        if (tmpdir.delete() && tmpdir.mkdirs()) {
                            mountfs.addMountPoint("temp", tmpdir.getAbsolutePath());
                        }
                    }
                    catch (Throwable e) {
                        logger.error(null, e);
                    }
                } else {
                    mountfs.addMountPoint("temp", tmpdir.getAbsolutePath());
                }
            } else if (tmpdir.mkdirs()) {
                mountfs.addMountPoint("temp", tmpdir.getAbsolutePath());
            }
        }
        if (blobPoints != null && blobPoints.length != 0) {
            String id = Ini.EmbeddedMode ? "embedded" : Ini.blobfsId();
            logger.info("blob file storage ({}):", (Object)id);
            String[] stringArray = blobPoints;
            int n = stringArray.length;
            for (int s = 0; s < n; ++s) {
                String s2 = stringArray[s];
                String[] sp3 = s2.split("=");
                String name = sp3[0];
                String path = Ini.EmbeddedMode ? sp3[1] : new File(sp3[1], id).getPath();
                logger.info("\t\"{}:\" => \"{}\"", (Object)name, (Object)path);
                blobfs.addMountPoint(name, path, sp3[1]);
            }
        }
        if (sharedBlobPoints != null && sharedBlobPoints.length != 0) {
            for (String s : sharedBlobPoints) {
                sp = s.split("=");
                String name = sp[0];
                String path = sp[1];
                logger.info("\t\"{}:\" => \"{}\"", (Object)name, (Object)path);
                blobfs.addMountPoint(name, path, path);
            }
        }
        JWT.initTrustedSources(jwtTrustedSources, Ini.jwtKeysDir);
    }

    public static void JNI_initThread(String arg) {
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
    }

    public static double getApplicationId() throws InformException {
        if (applicationId == 0.0) {
            applicationId = Core.generateId();
            Connector.Metabase connector = new Connector.Metabase();
            try {
                try {
                    MetadataNodeReader.createAgentApplication(connector.connection(), applicationId);
                }
                finally {
                    connector.close();
                }
            }
            catch (SQLException e) {
                throw InformException.wrap(e);
            }
            logger.info("ApplicationID: {}", (Object)NumberConverter.doubleToString(applicationId));
        }
        return applicationId;
    }

    public static long nanoClock() {
        return System.nanoTime() - nanoBase;
    }

    public static long clock() {
        return System.currentTimeMillis() - clockBase;
    }

    public static String idstr(double id) {
        return NumberConverter.doubleToString(id);
    }

    public static void JNI_logThreadList() {
        for (Client client : ClientSession.getClients()) {
            client.logRunningRequest();
        }
    }

    private Core() {
    }

    public static native byte[] strToBase64(String var0);

    public static native String base64ToStr(byte[] var0);

    public static synchronized long newHostID() {
        return ++hostIdGenerator;
    }

    public static void JNI_dumpThreads(boolean console) {
        if (!console) {
            logger.info("Dumping threads callstacks:");
        }
        Core.dumpThreads(console);
    }

    private static void dumpThreads(boolean console) {
        for (Map.Entry<Thread, StackTraceElement[]> cs : Thread.getAllStackTraces().entrySet()) {
            Thread t = cs.getKey();
            StringBuilder msg = new StringBuilder("Thread \"");
            msg.append(t.getName()).append("\"(").append((Object)t.getState()).append(',');
            if (t.isAlive()) {
                msg.append('A');
            }
            if (t.isDaemon()) {
                msg.append('D');
            }
            if (t.isInterrupted()) {
                msg.append('I');
            }
            msg.append(") callstack:");
            for (StackTraceElement e : cs.getValue()) {
                msg.append("\n\t").append(e);
            }
            if (console) {
                System.out.println(msg);
                continue;
            }
            logger.info(msg.toString());
        }
    }

    public static void gatherTelemetry(Telemeter.Gatherer gatherer) throws IOException {
    }

    public static String dumpHeap() {
        TimeInfo t = new TimeInfo();
        DateTime.toTimeInfo(DateTime.fromUnixTime(System.currentTimeMillis()), t);
        String path = String.format("%s-%04d-%02d-%02d-%02d%02d%02d-%03d_p%d%s", Ini.DumpPath, t.year, t.month, t.day, t.hour, t.minute, t.second, t.mseconds, Ini.ProcessID, ".hprof");
        HeapDumper.dumpHeap(path, true);
        return path;
    }

    private static void initAuthorizedKeys() {
        File folder;
        if (Ini.authorizedKeysOff) {
            authorizedKeys = null;
            return;
        }
        if (!Strings.isVoid(Ini.authorizedKeysPath) && (folder = new File(Ini.authorizedKeysPath)).isDirectory()) {
            authorizedKeys = folder.getAbsolutePath();
            return;
        }
        folder = new File(Ini.HomePath, "authorized_keys");
        authorizedKeys = folder.exists() ? folder.getAbsolutePath() : null;
    }

    public static boolean needCheckAuthorizedKeys() {
        return authorizedKeys != null;
    }

    public static String getHostName() {
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.error(null, e);
                hostName = "";
            }
        }
        return hostName;
    }

    public static TagVersionInfo getMinClientVersion(int major) {
        ArrayList<TagVersionInfo> versions = minClinetVersions;
        if (versions == null) {
            versions = new ArrayList();
            if (Ini.MinClientVersion != null && !Ini.MinClientVersion.isEmpty()) {
                for (String s : Ini.MinClientVersion.replace(',', ';').split(";")) {
                    if (Strings.isVoid(s)) continue;
                    try {
                        VersionInfo version = new VersionInfo();
                        if (!version.parse(s, null)) continue;
                        versions.add(new TagVersionInfo(version));
                    }
                    catch (IOException ex) {
                        logger.error(null, ex);
                    }
                }
            }
            versions.sort(TagVersionInfo::compare);
            minClinetVersions = versions;
        }
        TagVersionInfo version = null;
        for (TagVersionInfo v : versions) {
            if (v.getMajor() == major) {
                return v;
            }
            if (version != null && VersionInfo.compare(version, v) <= 0) continue;
            version = v;
        }
        return version != null ? version : new TagVersionInfo();
    }

    public static TagVersionInfo getMaxClientVersion() {
        TagVersionInfo maxVersion = maxClinetVersion;
        if (maxVersion == null) {
            VersionInfo version = new VersionInfo(127L, 127L, 32767L);
            if (Ini.MaxClientVersion != null && !Ini.MaxClientVersion.isEmpty()) {
                try {
                    version.parse(Ini.MaxClientVersion, null);
                }
                catch (IOException ex) {
                    version.set(127L, 127L, 32767L);
                    logger.error(null, ex);
                }
            }
            maxClinetVersion = maxVersion = new TagVersionInfo(version);
        }
        return maxVersion;
    }

    private static synchronized void initClientLimit() {
        if (licenseClientLimit >= 0) {
            return;
        }
        if (DatabaseType.getMetabaseType() == DatabaseType.H2 && !Strings.isVoid(Ini.MetabaseDB) && Ini.MetabaseDB.startsWith("mem:")) {
            licenseClientLimit = Integer.MAX_VALUE;
            license = null;
            return;
        }
        licenseClientLimit = 2;
        license = null;
        File licenseFile = new File(Ini.LicensePath);
        if (!licenseFile.exists() || !licenseFile.isFile()) {
            logger.warn("Lic file {} not found", (Object)licenseFile);
            return;
        }
        long fileSize = licenseFile.length();
        if (fileSize > 0x100000L) {
            return;
        }
        try {
            byte[] fileContent = Files.readAllBytes(licenseFile.toPath());
            String licenseContent = new String(fileContent, TaggedWriter.UTF8);
            if ((long)licenseContent.length() != fileSize) {
                return;
            }
            License license = new License();
            license.setLicenseContent(licenseContent);
            if (license.checkLicence(4, licenseContent)) {
                return;
            }
            Core.license = license;
            licenseClientLimit = license.effectiveClientLimit();
        }
        catch (Throwable ex) {
            logger.error(null, ex);
            licenseClientLimit = 2;
            license = null;
        }
    }

    public static int clientLimit() {
        Core.initClientLimit();
        int metadataLimit = MtdEngine.serverNode().descriptor().maxConnectionCount();
        if (licenseClientLimit == 0) {
            return metadataLimit;
        }
        if (metadataLimit == 0) {
            return licenseClientLimit;
        }
        if (licenseClientLimit < metadataLimit) {
            return licenseClientLimit;
        }
        return metadataLimit;
    }

    public static License agentLicense() {
        Core.initClientLimit();
        return license;
    }

    public static String licenseLimitTexts() {
        Core.initClientLimit();
        StringBuilder text = new StringBuilder();
        if (license == null) {
            if (licenseClientLimit <= 2) {
                text.append("\u0423\u0441\u043b\u043e\u0432\u043d\u043e-\u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u0430\u044f \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u0430.\r\n\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432: 2 \u0448\u0442");
            }
        } else {
            license.limitsToString(text);
        }
        ServerNode.Descriptor serverNode = MtdEngine.serverNode().descriptor();
        if (!Strings.isVoid(serverNode.licence)) {
            License license = new License();
            try {
                license.setLicenseContent(serverNode.licence);
                if (license.checkLicence(4, serverNode.licence)) {
                    license = null;
                }
            }
            catch (Throwable ex) {
                logger.error(null, ex);
                license = null;
            }
            text.append("\r\n\r\n");
            if (Core.license == null) {
                text.append("\u0423\u0441\u043b\u043e\u0432\u043d\u043e-\u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u0430\u044f \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445.\r\n\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432: 2 \u0448\u0442");
            } else {
                Core.license.limitsToString(text);
            }
        }
        return text.toString();
    }

    public static boolean isLoginCertExists(String name) {
        return !Strings.isVoid(authorizedKeys) && new File(authorizedKeys, name).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAuthorizedKeyValid(String name, byte[] signature, byte[] data) {
        if (Strings.isVoid(name) || Memory.isVoid(signature) || Memory.isVoid(data)) {
            return false;
        }
        File cert = new File(authorizedKeys, name);
        ArrayList<String> certificates = new ArrayList<String>();
        try (BufferedReader content = new BufferedReader(new FileReader(cert));){
            String line;
            while ((line = content.readLine()) != null) {
                String[] items = line.split("\\s+");
                if (items.length == 1) {
                    certificates.add(line);
                    continue;
                }
                if (items.length <= 1) continue;
                certificates.add(items[1]);
            }
        }
        catch (IOException e) {
            logger.error(null, e);
            return false;
        }
        if (certificates.isEmpty()) {
            return false;
        }
        for (String key : certificates) {
            Object object = authorizedKeyMutex;
            synchronized (object) {
                if (EdDsa.verifyAuthorizedKey(key, signature, signature.length, data, data.length)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static String getTempDir() {
        return TempFolderHelper.tempFolder;
    }

    static {
        BALLONS = new byte[8][];
        for (int i = 0; i < BALLONS.length; ++i) {
            Core.ballonBlowUp();
        }
        lastWarnGcTick = -60000L;
        SmartNumberConverter.setAsDefault();
        applicationId = 0.0;
        clockBase = System.currentTimeMillis();
        nanoBase = System.nanoTime();
        agentStopped = false;
        agentStopReason = null;
        hostIdGenerator = 0L;
        hostName = null;
        authorizedKeys = null;
        minClinetVersions = null;
        maxClinetVersion = null;
        license = null;
        licenseClientLimit = -1;
        authorizedKeyMutex = new Object();
    }

    private static class TempFolderHelper {
        static final String tempFolder = TempFolderHelper.getTempFolder();

        private TempFolderHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String getTempFolder() {
            File tempFile = null;
            try {
                Path tempPath = Files.createTempFile(null, null, new FileAttribute[0]);
                tempFile = tempPath.toFile();
                File tempFolder = tempFile.getParentFile();
                if (tempFolder != null) {
                    String string = tempFolder.getAbsolutePath();
                    return string;
                }
            }
            catch (IOException e) {
                logger.error(null, e);
            }
            finally {
                if (tempFile != null && !tempFile.delete()) {
                    logger.error("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b \"{}\"", tempFile.getAbsolutePath());
                }
            }
            return null;
        }
    }

    private static class Std2Log
    extends PrintStream {
        public Std2Log(final AsmoLogger.Level level) throws UnsupportedEncodingException {
            super((OutputStream)new java.io.ByteArrayOutputStream(){

                @Override
                public void write(byte[] b, int off, int len) {
                    int prev = off;
                    int end = off + len;
                    for (int i = off; i < end; ++i) {
                        if (!this.isnl(b[i])) continue;
                        if (prev != i) {
                            super.write(b, prev, i - prev);
                        }
                        this.flush();
                        prev = i + 1;
                    }
                    if (prev < end) {
                        super.write(b, prev, end - prev);
                    }
                }

                @Override
                public void write(int b) {
                    if (this.isnl((byte)b)) {
                        this.flush();
                    } else {
                        super.write(b);
                    }
                }

                @Override
                public void flush() {
                    if (this.count == 0) {
                        return;
                    }
                    logger.log(level, new String(this.buf, 0, this.count, TaggedWriter.ANSI), new Object[0]);
                    this.count = 0;
                }

                private boolean isnl(byte b) {
                    return b == 10 || b == 13;
                }
            }, false, TaggedWriter.ANSI.name());
        }
    }
}

