/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.MaxGeneratedFieldValue;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.types.DataType;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.mtd.UsersTable;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;

public class FieldValueGenerator
extends ArrayList<Generator> {
    private static final int fvgtNone = 0;
    private static final int fvgtMaxValue = 1;
    private static final int fvgtSequence = 2;
    private static final int fvgtTimestamp = 3;
    private static final int fvgtUser = 4;
    private static final int fvgtStoredProc = 5;
    private static final int fvgtComputerName = 6;
    private static final int fvgtWindowsUserName = 7;
    private static final int fvgtComputerIP = 8;
    private static final int fvgtSession = 9;
    private static final int fvgtEffectiveUser = 10;
    private static final int fvgtBlobSize = 11;
    public static final int TAG_FVG_TYPE = 1;
    public static final int TAG_FVG_FIELD_ID = 2;
    public static final int TAG_FVG_NAME = 3;
    public static final int TAG_FVG_RESULT = 50;
    public static final int TAG_FVG_RESULT_ERROR = 51;
    public static final int TAG_FVG_BIG_RESULT = 52;
    public static final int TAG_FVG_STRING_RESULT = 53;
    private TableDescriptor table;
    private int sessionId;
    private AbstractConnectionManager externalConnectionManager = null;

    public FieldValueGenerator(TableDescriptor metadata, int sessionId) {
        this.table = metadata;
        this.sessionId = sessionId;
    }

    public FieldValueGenerator(TableDescriptor metadata, AbstractConnectionManager connectionManager) {
        assert (connectionManager != null);
        this.table = metadata;
        this.sessionId = 0;
        this.externalConnectionManager = connectionManager;
    }

    public FieldValueGenerator(double tableId, int sessionId) throws InformException {
        this.table = TableDescriptor.getIfExists(tableId);
        this.sessionId = sessionId;
        if (this.table == null) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u0430(\u0443\u0437\u0435\u043b " + NumberConverter.doubleToString(tableId) + ") \u0434\u043b\u044f \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u043e\u043b\u044f");
        }
        if (this.table.getKind() == TableDescriptor.Kind.VIRTUAL) {
            throw new InformException("\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u044b\u0431\u043e\u0440 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439");
        }
    }

    public void fill(BitSet disabledGenerators) {
        for (FieldDescriptor field : this.table.getFields()) {
            FieldDescriptor.AutoValueGenerator generator;
            if (disabledGenerators.get(field.getIndex()) || !(generator = field.getAutoValueGenerator()).isGenerateOnCreate()) continue;
            Generator g = new Generator();
            g.generator = generator.toInt();
            g.fieldId = field.getId();
            g.name = field.getValueGeneratorName();
            this.add(g);
        }
    }

    private String errorMessage(String title, String message, FieldDescriptor field) throws InformException {
        StringBuilder error = new StringBuilder();
        error.append(title).append(" (\u0443\u0437\u0435\u043b: '").append(this.table.getCaption()).append("' ").append(NumberConverter.doubleToString(this.table.getNodeId())).append(", \u043f\u043e\u043b\u0435: '").append(field.getCaption()).append("' ").append(field.getId()).append(")").append(message);
        return error.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void generateBigNumber(SSContext ssContext, ServerSideHost ssHost, AbstractConnectionManager connectionManager, FieldDescriptor field, Generator arg) throws InformException, SQLException {
        switch (arg.generator) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            default: {
                arg.error = String.format("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f(%d) \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u043e\u043b\u044f", new Object[]{arg.generator});
                return;
            }
        }
        maxValue = "";
        switch (arg.generator) {
            case 2: {
                if (arg.name == null || arg.name.isEmpty()) {
                    arg.error = this.errorMessage("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438", String.format(" \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 %d", new Object[]{arg.generator}), field);
                    return;
                }
                database = this.table.getDatabaseDescriptor();
                caps = database.getDatabaseType().caps();
                connection = connectionManager.getConnection(database.getNodeId(), "FieldValueGeneartor:fvgtSequence");
                try {
                    statement = connection.prepareStatement(caps.g_selectFromSequenceSQL(database, arg.name, true));
                    try {
                        resultSet = statement.executeQuery(ssContext);
                        try {
                            if (!resultSet.next()) ** GOTO lbl27
                            maxValue = resultSet.getString(1);
                            if (resultSet.wasNull()) {
                                maxValue = "";
                                Core.logger.warn("sequence NEXTVAL == null");
                            }
                            ** GOTO lbl40
lbl27:
                            // 1 sources

                            arg.error = this.errorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438", ":\r\n'\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438'", field);
                            connection.commit();
                            return;
                        }
                        finally {
                            resultSet.close();
                        }
                    }
                    finally {
                        statement.close();
                    }
                }
                catch (Exception e) {
                    Core.logger.error(null, e);
                    arg.error = this.errorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438", String.format(":\r\n'%s'", new Object[]{e.toString()}), field);
                    return;
                }
lbl40:
                // 1 sources

                connection.commit();
                arg.bigResult = maxValue;
                break;
            }
            case 3: {
                arg.bigResult = Double.toString(DateTime.currentDateTime());
                break;
            }
            case 4: {
                arg.bigResult = Double.toString(ssHost.getUserID());
                break;
            }
            case 10: {
                arg.bigResult = Double.toString(ssHost.getEffectiveUserID());
                break;
            }
            case 5: {
                if (arg.name == null || arg.name.isEmpty()) {
                    arg.error = this.errorMessage("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b", String.format(" \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 %d", new Object[]{arg.generator}), field);
                    return;
                }
                database = this.table.getDatabaseDescriptor();
                caps = database.getDatabaseType().caps();
                connection = connectionManager.getConnection(database.getNodeId(), "FieldValueGeneartor:fvgtStoredProc");
                try {
                    statement = connection.prepareStatement(caps.g_selectResultStoredProcSQL(database, arg.name, false));
                    try {
                        resultSet = statement.executeQuery(ssContext);
                        try {
                            if (!resultSet.next()) ** GOTO lbl70
                            maxValue = resultSet.getString(1);
                            if (resultSet.wasNull()) {
                                maxValue = "";
                                Core.logger.warn("FieldValueGeneartor:fvgtStoredProc == null");
                            }
                            ** GOTO lbl83
lbl70:
                            // 1 sources

                            arg.error = this.errorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b", ":\r\n'\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b'", field);
                            connection.commit();
                            return;
                        }
                        finally {
                            resultSet.close();
                        }
                    }
                    finally {
                        statement.close();
                    }
                }
                catch (Exception e) {
                    Core.logger.error(null, e);
                    arg.error = this.errorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b", String.format(":\r\n'%s'", new Object[]{e.toString()}), field);
                    return;
                }
lbl83:
                // 1 sources

                connection.commit();
                arg.bigResult = maxValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void generate(SSContext ssContext, ServerSideHost ssHost) throws InformException, SQLException {
        if (this.table.getKind() == TableDescriptor.Kind.VIRTUAL) {
            throw new InformException("\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u044b\u0431\u043e\u0440 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439");
        }
        releaseConnectionManager = null;
        if (this.externalConnectionManager == null) {
            releaseConnectionManager = ConnectionManager.capture(this.sessionId, ssHost, "FieldValueGenerator::generate");
            connectionManager = releaseConnectionManager;
        } else {
            connectionManager = this.externalConnectionManager;
        }
        try {
            block56: for (Generator arg : this) {
                switch (arg.generator) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        break;
                    }
                    default: {
                        arg.error = String.format("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f(%d) \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u043e\u043b\u044f", new Object[]{arg.generator});
                        continue block56;
                    }
                }
                field = this.table.getFieldDescriptor(arg.fieldId);
                validFieldType = false;
                if (field != null) {
                    switch (1.$SwitchMap$inform$agent$db$types$DataType[field.getType().ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            switch (arg.generator) {
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 9: 
                                case 10: 
                                case 11: {
                                    validFieldType = true;
                                }
                            }
                            break;
                        }
                        case 5: {
                            validFieldType = arg.generator == 9 || arg.generator == 4 || arg.generator == 10;
                            break;
                        }
                        case 6: {
                            this.generateBigNumber(ssContext, ssHost, connectionManager, field, arg);
                            continue block56;
                        }
                        case 7: 
                        case 8: {
                            switch (arg.generator) {
                                case 6: 
                                case 7: 
                                case 8: {
                                    validFieldType = true;
                                }
                            }
                        }
                    }
                }
                if (!validFieldType) {
                    arg.error = this.errorMessage("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u043e\u043b\u044f", String.format(" \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 %d", new Object[]{arg.generator}), field);
                    continue;
                }
                maxValue = 0.0;
                switch (arg.generator) {
                    case 1: {
                        sql = new SqlStringBuilder();
                        sql.append("select max(").append(field.getRawName()).append(") F from ").appendFull(this.table);
                        connection = connectionManager.getConnection(this.table.getDbId(), "FieldValueGeneartor:fvgtMaxValue");
                        statement = connection.prepareStatement(sql.toString());
                        try {
                            resultSet = statement.executeQuery(ssContext);
                            try {
                                if (resultSet.next()) {
                                    maxValue = resultSet.getDouble(1);
                                    if (resultSet.wasNull()) {
                                        maxValue = 0.0;
                                    }
                                }
                            }
                            finally {
                                resultSet.close();
                            }
                        }
                        finally {
                            statement.close();
                        }
                        value = new MaxGeneratedFieldValue.Value(field.getId(), maxValue + 1.0);
                        MaxGeneratedFieldValue.adjust(this.table.getNodeId(), value);
                        arg.result = value.getValue();
                        break;
                    }
                    case 2: {
                        if (arg.name == null || arg.name.isEmpty()) {
                            arg.error = this.errorMessage("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438", String.format(" \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 %d", new Object[]{arg.generator}), field);
                            break;
                        }
                        database = this.table.getDatabaseDescriptor();
                        caps = database.getDatabaseType().caps();
                        connection = connectionManager.getConnection(database.getNodeId(), "FieldValueGeneartor:fvgtSequence");
                        try {
                            statement = connection.prepareStatement(caps.g_selectFromSequenceSQL(database, arg.name, false));
                            try {
                                resultSet = statement.executeQuery(ssContext);
                                try {
                                    if (!resultSet.next()) ** GOTO lbl83
                                    maxValue = resultSet.getDouble(1);
                                    if (resultSet.wasNull()) {
                                        maxValue = 0.0;
                                        Core.logger.warn("sequence NEXTVAL == null");
                                    }
                                    ** GOTO lbl96
lbl83:
                                    // 1 sources

                                    arg.error = this.errorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438", ":\r\n'\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438'", field);
                                    connection.commit();
                                    break;
                                }
                                finally {
                                    resultSet.close();
                                }
                            }
                            finally {
                                statement.close();
                            }
                        }
                        catch (Exception e) {
                            Core.logger.error(null, e);
                            arg.error = this.errorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438", String.format(":\r\n'%s'", new Object[]{e.toString()}), field);
                            break;
                        }
lbl96:
                        // 1 sources

                        connection.commit();
                        arg.result = maxValue;
                        break;
                    }
                    case 3: {
                        arg.result = DateTime.currentDateTime();
                        break;
                    }
                    case 4: {
                        if (field.getType() == DataType.DIRECTORY) {
                            try {
                                arg.result = new UsersTable().getValidRecordId(ssContext, ssHost, ssHost.getUserID());
                            }
                            catch (IOException e) {
                                Core.logger.error(null, e);
                                arg.error = this.errorMessage("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f ID \u0443\u0447\u0435\u0442\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438", ":\r\n" + e.toString(), field);
                            }
                            break;
                        }
                        arg.result = ssHost.getUserID();
                        break;
                    }
                    case 10: {
                        arg.result = ssHost.getEffectiveUserID();
                        break;
                    }
                    case 5: {
                        if (arg.name == null || arg.name.isEmpty()) {
                            arg.error = this.errorMessage("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b", String.format(" \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 %d", new Object[]{arg.generator}), field);
                            break;
                        }
                        database = this.table.getDatabaseDescriptor();
                        caps = database.getDatabaseType().caps();
                        connection = connectionManager.getConnection(database.getNodeId(), "FieldValueGeneartor:fvgtStoredProc");
                        try {
                            statement = connection.prepareStatement(caps.g_selectResultStoredProcSQL(database, arg.name, false));
                            try {
                                resultSet = statement.executeQuery(ssContext);
                                try {
                                    if (!resultSet.next()) ** GOTO lbl134
                                    maxValue = resultSet.getDouble(1);
                                    if (resultSet.wasNull()) {
                                        maxValue = 0.0;
                                        Core.logger.warn("FieldValueGeneartor:fvgtStoredProc == null");
                                    }
                                    ** GOTO lbl147
lbl134:
                                    // 1 sources

                                    arg.error = this.errorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b", ":\r\n'\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b'", field);
                                    connection.commit();
                                    break;
                                }
                                finally {
                                    resultSet.close();
                                }
                            }
                            finally {
                                statement.close();
                            }
                        }
                        catch (Exception e) {
                            Core.logger.error(null, e);
                            arg.error = this.errorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b", String.format(":\r\n'%s'", new Object[]{e.toString()}), field);
                            break;
                        }
lbl147:
                        // 1 sources

                        connection.commit();
                        arg.result = maxValue;
                        break;
                    }
                    case 6: {
                        if (ssHost.client() == null) {
                            arg.stringResult = "???";
                            break;
                        }
                        arg.stringResult = ssHost.client().getHostComputerName();
                        break;
                    }
                    case 7: {
                        if (ssHost.client() == null) {
                            arg.stringResult = "???";
                            break;
                        }
                        arg.stringResult = ssHost.client().getHostUserName();
                        break;
                    }
                    case 8: {
                        if (ssHost.client() == null) {
                            arg.stringResult = "???";
                            break;
                        }
                        arg.stringResult = ssHost.client().getHostIP();
                        break;
                    }
                    case 9: {
                        arg.result = ssHost.client() == null ? -1.0 : ssHost.client().getSessionId();
                    }
                }
            }
        }
        finally {
            if (releaseConnectionManager != null) {
                releaseConnectionManager.release();
            }
        }
    }

    public void interpretResult() throws InformException {
        StringBuilder error = null;
        for (Generator arg : this) {
            if (arg.error == null) continue;
            error = this.getError(error);
            error.append("\r\n \u041f\u043e\u043b\u0435 ");
            FieldDescriptor field = this.table.getFieldDescriptor(arg.fieldId);
            error.append(field == null ? "???" : field.getCaption()).append('[').append(arg.fieldId).append("]: ");
            error.append(arg.error);
        }
        if (error != null) {
            throw new InformException(error.toString());
        }
    }

    public void store(TaggedWriter out) throws IOException {
        for (Generator arg : this) {
            out.putInt32(2, arg.fieldId);
            if (arg.error != null) {
                out.putAnsi(51, arg.error);
                continue;
            }
            if (arg.stringResult != null) {
                out.putAnsi(53, arg.stringResult);
                continue;
            }
            if (arg.bigResult != null) {
                out.putAnsi(52, arg.bigResult);
                continue;
            }
            out.putDouble(50, arg.result);
        }
    }

    private StringBuilder getError(StringBuilder error) {
        if (error == null) {
            error = new StringBuilder();
            error.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u043e\u043b\u0435\u0439 [\u0443\u0437\u0435\u043b \u0442\u0430\u0431\u043b\u0438\u0446\u044b: ").append(NumberConverter.doubleToString(this.table.getNodeId())).append("]:");
        }
        return error;
    }

    public static class Generator {
        public int generator = 0;
        public int fieldId = 0;
        public boolean onlyInsert = false;
        public String name = null;
        public double result = 0.0;
        public String bigResult = null;
        public String stringResult = null;
        public String error = null;
    }
}

