/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.agent.Request;
import java.util.Arrays;

public class InputChunkQueue {
    private static final int MAX_BYTES_COUNT = 0x2000000;
    private final Request host;
    private byte[][] inputChunkQueue = new byte[][]{null, null};
    private int inputChunkQueueCount = 0;
    private int bytesCount;
    private boolean closed = false;

    public InputChunkQueue(Request host) {
        this.host = host;
    }

    public synchronized void add(byte[] chunk) throws InterruptedException {
        while (this.bytesCount >= 0x2000000) {
            this.wait(1000L);
            if (!this.host.isAlreadyExecuted()) continue;
            return;
        }
        if (this.inputChunkQueue == null) {
            this.inputChunkQueue = new byte[2][];
        } else if (this.inputChunkQueueCount == this.inputChunkQueue.length) {
            this.inputChunkQueue = (byte[][])Arrays.copyOf(this.inputChunkQueue, this.inputChunkQueue.length + 2);
        }
        this.inputChunkQueue[this.inputChunkQueueCount++] = chunk;
        this.bytesCount += chunk.length;
        this.notifyAll();
    }

    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }

    public synchronized boolean hasChunk() {
        return !this.closed || this.inputChunkQueueCount != 0;
    }

    protected synchronized byte[] next() throws InterruptedException {
        this.idle();
        if (this.inputChunkQueueCount == 0) {
            this.wait(1000L);
        }
        if (this.inputChunkQueueCount == 0) {
            return null;
        }
        byte[] result = this.inputChunkQueue[0];
        int newCount = this.inputChunkQueueCount - 1;
        for (int i = 0; i < newCount; ++i) {
            this.inputChunkQueue[i] = this.inputChunkQueue[i + 1];
        }
        this.inputChunkQueue[newCount] = null;
        this.inputChunkQueueCount = newCount;
        this.bytesCount -= result.length;
        this.notifyAll();
        return result;
    }

    private void idle() {
        if (this.host != null) {
            this.host.idle();
        }
    }
}

