/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class ProductInfo {
    public static String DEFAULT_CHANNEL = "r";
    private String name = null;
    private String platform = null;
    private String architecture = null;
    private String channel = DEFAULT_CHANNEL;
    int update = 0;
    private String folder = null;
    private String prefix = null;
    private String suffix = null;
    private final FilenameFilter filenameFilter = new UpdateFilter(this);

    public ProductInfo() {
    }

    public ProductInfo(String name, String platform, String architecture, String channel, int update) {
        this.set(name, platform, architecture, channel, update);
    }

    public ProductInfo(ProductInfo p, int update) {
        this(p.name, p.platform, p.architecture, p.channel, update);
    }

    public void load(TaggedReader in) throws IOException {
        String name = null;
        String platform = null;
        String architecture = null;
        String channel = DEFAULT_CHANNEL;
        int update = 0;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    name = in.getAnsi();
                    break;
                }
                case 2: {
                    platform = in.getAnsi();
                    break;
                }
                case 3: {
                    architecture = in.getAnsi();
                    break;
                }
                case 4: {
                    channel = in.getAnsi();
                    break;
                }
                case 5: {
                    update = in.getInt();
                }
            }
        }
        this.set(name, platform, architecture, channel, update);
    }

    public void storeTo(int tag, TaggedWriter out) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(data);
        stream.putAnsi(1, this.name);
        stream.putAnsi(2, this.platform);
        stream.putAnsi(3, this.architecture);
        stream.putAnsi(4, this.channel);
        stream.putInt32(5, this.update);
        stream.flush();
        out.putRaw(tag, data);
    }

    public void set(String name, String platform, String architecture, String channel, int update) {
        assert (name != null);
        assert (platform != null);
        assert (architecture != null);
        this.name = name;
        this.platform = platform;
        this.architecture = architecture;
        this.channel = !Strings.isVoid(channel) ? channel : DEFAULT_CHANNEL;
        this.update = Math.max(update, 0);
        this.prefix = this.name + "-";
        this.suffix = "-" + this.platform + "-" + this.architecture + ".zip";
        this.folder = this.name + "-" + this.platform + "-" + this.architecture;
    }

    public String folder() {
        this.init();
        return this.folder;
    }

    public String name() {
        this.init();
        return this.name;
    }

    public String prefix() {
        this.init();
        return this.prefix;
    }

    public String suffix() {
        this.init();
        return this.suffix;
    }

    public String channel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public int update() {
        return this.update;
    }

    public FilenameFilter filenameFilter() {
        this.init();
        return this.filenameFilter;
    }

    private void init() {
        if (this.name == null) {
            this.set("phx", "windows", "x32", null, 0);
        }
    }

    private static class UpdateFilter
    implements FilenameFilter {
        final ProductInfo info;

        private UpdateFilter(ProductInfo info) {
            this.info = info;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.info.prefix) && name.endsWith(this.info.suffix);
        }
    }
}

