/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;

public class RequestResult {
    private final Request request;
    private final ByteArrayOutputStream buffer;
    private final TaggedWriter writer;

    public RequestResult(Request request) {
        this.request = request;
        this.buffer = new ByteArrayOutputStream();
        this.writer = new TaggedWriter(this.buffer);
    }

    public RequestResult(Request request, int size) {
        this.request = request;
        this.buffer = new ByteArrayOutputStream(size);
        this.writer = new TaggedWriter(this.buffer);
    }

    public TaggedWriter getWriter() {
        return this.writer;
    }

    public void sendResult() throws Exception {
        this.writer.flush();
        if (this.buffer.size() == 0) {
            this.request.sendResult();
        } else {
            this.request.sendResult(this.buffer.internalBuffer(), this.buffer.size());
        }
    }

    public void sendChunk() throws Exception {
        this.writer.flush();
        if (this.buffer.size() != 0) {
            this.request.sendChunk(this.buffer.internalBuffer(), this.buffer.size());
            this.buffer.reset();
            this.writer.reset(this.buffer);
        }
    }

    public int sendChunkIf(int size) throws Exception {
        this.writer.flush();
        if (this.buffer.size() >= size) {
            int sendSize = this.buffer.size();
            this.request.sendChunk(this.buffer.internalBuffer(), sendSize);
            this.buffer.reset();
            this.writer.reset(this.buffer);
            return sendSize;
        }
        return 0;
    }
}

