/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.Strings;
import inform.adt.taggedio.TagVersionInfo;
import inform.agent.Core;
import inform.agent.ProductInfo;
import inform.agent.db.sql.ParserStringReader;
import java.io.IOException;
import java.io.StreamTokenizer;

public final class VersionInfo
extends TagVersionInfo {
    private String channel = ProductInfo.DEFAULT_CHANNEL;
    private int update = 0;

    public VersionInfo() {
    }

    public VersionInfo(VersionInfo v) {
        super(v.toNumber());
        this.channel = v.channel;
        this.update = v.update;
    }

    public VersionInfo(long major, long minor, long release) {
        super(major, minor, release);
    }

    public void assign(VersionInfo v) {
        super.assign(v);
        this.channel = v.channel;
        this.update = v.update;
    }

    @Override
    public void clear() {
        super.clear();
        this.channel = ProductInfo.DEFAULT_CHANNEL;
        this.update = 0;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public int getUpdate() {
        return this.update;
    }

    public void setUpdate(int update) {
        this.update = update;
    }

    public static void parseVersionString(String version, VersionComponents v) throws IOException {
        if (Strings.isVoid(version)) {
            return;
        }
        String str = version.replace('.', ' ').replace('-', ' ');
        ParserStringReader reader = new ParserStringReader(str.toLowerCase());
        StreamTokenizer parser = new StreamTokenizer(reader);
        parser.parseNumbers();
        parser.wordChars(97, 122);
        String channel = null;
        int tokenType = 0;
        while (tokenType != -1) {
            String u;
            char ch;
            int l;
            tokenType = parser.nextToken();
            if (tokenType == -2 && v.numberCount < v.numbers.length) {
                v.numbers[v.numberCount] = (int)parser.nval;
                ++v.numberCount;
                continue;
            }
            if (tokenType != -3) continue;
            for (l = 0; l < parser.sval.length() && 'a' <= (ch = parser.sval.charAt(l)) && ch <= 'z'; ++l) {
            }
            channel = parser.sval.substring(0, l);
            if ((v.numberCount != 2 || v.numbers[0] <= 5) && v.numberCount != 3 || Strings.isVoid(u = parser.sval.substring(l))) break;
            try {
                v.update = Integer.parseInt(u);
                break;
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
                break;
            }
        }
        if (!Strings.isVoid(channel)) {
            v.channel = channel;
        }
    }

    public boolean parse(String v, ProductInfo productInfo) throws IOException {
        String channel;
        block7: {
            block6: {
                if (productInfo == null) break block6;
                channel = productInfo.channel();
                String prefix = productInfo.prefix();
                String suffix = productInfo.suffix();
                if (!v.startsWith(prefix) || !v.endsWith(suffix)) break block7;
                v = v.substring(prefix.length(), v.length() - suffix.length());
                break block7;
            }
            channel = ProductInfo.DEFAULT_CHANNEL;
            for (int index = 0; index < v.length(); ++index) {
                char ch = v.charAt(index);
                if ('0' > ch || ch > '9') continue;
                v = v.substring(index);
                break;
            }
        }
        if (Strings.isVoid(v)) {
            return false;
        }
        VersionComponents vc = new VersionComponents(0, 0, 0, channel, 0);
        VersionInfo.parseVersionString(v, vc);
        if (vc.numberCount == 3) {
            this.set(vc.numbers[0], vc.numbers[1], vc.numbers[2]);
        } else if (vc.numberCount == 2) {
            this.set(vc.numbers[0], 0L, vc.numbers[1]);
        } else {
            return false;
        }
        this.channel = vc.channel;
        this.update = vc.update;
        return true;
    }

    public static VersionInfo parseRange(String v, int major, int minor, int release, String channel, int update) throws IOException {
        VersionComponents vc = new VersionComponents(major, minor, release, channel, update);
        VersionInfo.parseVersionString(v, vc);
        VersionInfo version = new VersionInfo();
        if (vc.numberCount == 2) {
            if (vc.numbers[0] == 5) {
                version.set(vc.numbers[0], vc.numbers[1], release);
            } else {
                version.set(vc.numbers[0], minor, vc.numbers[1]);
            }
        } else {
            version.set(vc.numbers[0], vc.numbers[1], vc.numbers[2]);
        }
        version.channel = vc.channel;
        version.update = vc.update;
        return version;
    }

    @Override
    public String toString() {
        String str = super.toString();
        if (Strings.isVoid(this.channel)) {
            return str;
        }
        return str + this.channel + this.update;
    }

    public boolean lessThen(VersionInfo v) {
        return this.version == v.version ? this.update < v.update : this.version < v.version;
    }

    public boolean equals(VersionInfo v) {
        return this.version == v.version && Strings.equalsEmpty(this.channel, v.channel) && this.update == v.update;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof VersionInfo) {
            return this.equals((VersionInfo)obj);
        }
        return super.equals(obj);
    }

    public static class VersionComponents {
        public final int[] numbers;
        public int numberCount = 0;
        public String channel;
        public int update;

        public VersionComponents(int major, int minor, int release, String channel, int update) {
            this.numbers = new int[]{major, minor, release};
            this.channel = channel;
            this.update = update;
        }
    }
}

