/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.am;

import inform.adt.DateTime;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.am.AMRequest;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.net.ClientSession;

public class AgentStatistics
extends AMRequest {
    public AgentStatistics(int request, int flags) {
        super(request, flags);
    }

    @Override
    public byte[] run() throws Throwable {
        TaggedReader reader = this.createContentReader();
        long from = 0L;
        long to = Long.MAX_VALUE;
        int aspect = 0;
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    from = DateTime.toUnixTime(reader.getDouble());
                    break;
                }
                case 2: {
                    to = DateTime.toUnixTime(reader.getDouble());
                    break;
                }
                case 3: {
                    aspect = reader.getInt();
                }
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(out);
        switch (aspect) {
            case 1: {
                DatabaseDescriptor.statWrite(from, to, w);
                break;
            }
            case 2: {
                ClientSession.statWrite(from, to, w);
            }
        }
        w.flush();
        return out.toByteArray();
    }
}

