/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.Strings;
import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.types.DataType;
import inform.agent.scripts.sql.ExtraField;
import java.util.Collection;
import java.util.Collections;

public class FieldDescriptor
implements IntegerHash.Entry {
    public static final int KIND_NATIVE = 0;
    public static final int KIND_MULTILOOKUP = 1;
    public static final int KIND_CALCULATED = 2;
    public static final int BLOBFS_TYPE_DEFAULT = 0;
    public static final int BLOBFS_TYPE_SHA1 = 1;
    public static final int FVGOPTION_ONLYINSERT = 1;
    public static final int frtNumber = 0;
    public static final int frtRecordID = 1;
    private static FieldDescriptor internalPrimaryKeyField;
    private int index;
    int id;
    int size;
    String ident;
    DataType type;
    String rawName;
    boolean nullable = true;
    boolean isPrimaryKey;
    boolean isAlternative;
    boolean isRightPadded;
    double referenceId;
    int refFieldId;
    String caption;
    AutoValueGenerator autoValueGenerator = AutoValueGenerator.NONE;
    int valueGeneratorField;
    int valueGeneratorOptions = 0;
    String valueGeneratorName = null;
    BlobRawType blobRawType = BlobRawType.BINARY;
    BlobType blobType = BlobType.TEXT;
    int precision;
    int kind;
    PeriodicFieldStorage periodicStorage;
    boolean dontCheckRefs = false;
    int format = 0;
    MultipleWriteProtection multipleWriteProtection;
    int mwpLabel;
    String blobFS = null;
    int blobFSType = 0;
    boolean usedForParams;
    Collection<LookupField> multiLookupFields;
    boolean detailAudit;
    boolean deleteDataAudit = false;
    boolean isForeignKey = false;
    String foreignKeyRawName = null;
    boolean isForeignKeyCascadeDelete = false;
    boolean isRecordIdPresentation = false;
    String stringDefValue = null;
    double numberDefValue = 0.0;
    boolean hasDefValue = false;
    PostgreSQLReviewType postgreSQLReviewType = null;
    IntegerSet textExtractionFields;
    int[] blobSizeFields = null;
    boolean autoFill;

    public static synchronized FieldDescriptor getInternalPrimaryKeyField() {
        if (internalPrimaryKeyField == null) {
            internalPrimaryKeyField = new FieldDescriptor(-1);
            FieldDescriptor.internalPrimaryKeyField.id = -1;
            FieldDescriptor.internalPrimaryKeyField.isPrimaryKey = true;
            FieldDescriptor.internalPrimaryKeyField.rawName = "ID";
            FieldDescriptor.internalPrimaryKeyField.caption = "ID";
            FieldDescriptor.internalPrimaryKeyField.type = DataType.PRIMARY_KEY;
            FieldDescriptor.internalPrimaryKeyField.nullable = false;
        }
        return internalPrimaryKeyField;
    }

    FieldDescriptor(int index) {
        this.index = index;
        this.id = 0;
        this.size = 0;
        this.valueGeneratorField = 0;
        this.isRightPadded = false;
        this.kind = 0;
        this.periodicStorage = null;
        this.multipleWriteProtection = MultipleWriteProtection.None;
        this.mwpLabel = 0;
        this.precision = -1;
    }

    public FieldDescriptor(int id, String rawName, DataType type, int size, boolean nullable) {
        this.id = id;
        this.caption = this.rawName = rawName;
        this.type = type;
        this.size = size;
        this.nullable = nullable;
        this.precision = -1;
    }

    public FieldDescriptor(int id, String rawName, BlobRawType blobRawType, boolean nullable) {
        this.id = id;
        this.caption = this.rawName = rawName;
        this.type = DataType.BLOB;
        this.blobRawType = blobRawType;
        this.size = 0;
        this.nullable = nullable;
        this.precision = -1;
    }

    public FieldDescriptor(int id, int index, String rawName, String caption, double refTableId) {
        this.id = id;
        this.index = index;
        this.rawName = rawName;
        this.caption = caption;
        this.type = DataType.DIRECTORY;
        this.size = 0;
        this.nullable = true;
        this.precision = -1;
        this.referenceId = refTableId;
    }

    public FieldDescriptor(ExtraField e, int index) {
        this.id = e.id;
        this.index = index;
        this.caption = e.caption;
        this.ident = e.name;
        this.rawName = e.getRawName();
        this.type = e.dataType;
        this.size = 0;
        this.nullable = true;
        this.precision = -1;
    }

    public int getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public String getIdent() {
        return this.ident;
    }

    public DataType getType() {
        return this.type;
    }

    public String getRawName() {
        return this.rawName;
    }

    public boolean isNullable() {
        return this.nullable && !this.isPrimaryKey;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean isAlternativeKey() {
        return this.isAlternative;
    }

    public double getReferenceId() {
        return this.referenceId;
    }

    public int getRefFieldId() {
        return this.refFieldId;
    }

    public String getCaption() {
        return this.caption;
    }

    public boolean isRecordIdPresentation() {
        return this.isRecordIdPresentation;
    }

    public void setRecordIdPresentation(boolean recordIdPresentation) {
        this.isRecordIdPresentation = recordIdPresentation;
    }

    void setValueGeneratorType(int generatorType) {
        if (generatorType != 0) {
            switch (this.type) {
                case DATE_TIME: {
                    break;
                }
                case FLOAT: 
                case DIRECTORY: 
                case INTEGER: 
                case METATREE_NODE: 
                case STRING: {
                    if (generatorType == AutoValueGenerator.USER.toInt() || generatorType == AutoValueGenerator.BLOBSIZE.toInt()) break;
                    this.valueGeneratorField = 0;
                    break;
                }
                default: {
                    generatorType = 0;
                }
            }
        }
        this.autoValueGenerator = AutoValueGenerator.get(generatorType);
    }

    public AutoValueGenerator getAutoValueGenerator() {
        return this.autoValueGenerator;
    }

    public String getValueGeneratorName() {
        return this.valueGeneratorName;
    }

    public int getValueGeneratorField() {
        return this.valueGeneratorField;
    }

    public boolean isCalcValueGeneratorForInsertOnly() {
        return (this.valueGeneratorOptions & 1) == 1;
    }

    public boolean isRightPadded() {
        return this.isRightPadded;
    }

    public int getMWPLabel() {
        return this.mwpLabel;
    }

    public BlobRawType getBlobRawType() {
        return this.blobRawType;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isVirtual() {
        return this.type == DataType.VARIANT || this.kind != 0 || this.periodicStorage != null;
    }

    public boolean isAbstract() {
        return this.type == DataType.VARIANT || this.kind != 0;
    }

    public boolean isDetailAudit() {
        return this.detailAudit;
    }

    public boolean isDeleteDataAudit() {
        return this.deleteDataAudit;
    }

    public int getKind() {
        return this.kind;
    }

    public void toLogString(StringBuilder msg) {
        msg.append(this.caption).append('[').append(this.id).append(']');
    }

    public void toErrorString(StringBuilder msg) {
        this.toLogString(msg);
        if (!Strings.isVoid(this.ident)) {
            msg.append('[').append(this.ident).append(']');
        }
    }

    public String toString() {
        return "FD:" + this.rawName + ":" + this.type;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean isDontCheckRefs() {
        return this.dontCheckRefs;
    }

    public int getFormat() {
        return this.format;
    }

    public boolean hasPeriodicStorage() {
        return this.periodicStorage != null;
    }

    public PeriodicFieldStorage getPeriodicStorage() {
        return this.periodicStorage;
    }

    public String getBlobFS() {
        return this.blobFS;
    }

    public int getBlobFSType() {
        return this.blobFSType;
    }

    public BlobType getBlobType() {
        return this.blobType;
    }

    public boolean isHashedBlobFs() {
        return this.blobFSType != 0;
    }

    public boolean isHasDefValue() {
        return this.hasDefValue;
    }

    public String getStringDefValue() {
        return this.stringDefValue;
    }

    public double getNumberDefValue() {
        return this.numberDefValue;
    }

    public int calcUsedForParamsPriority() {
        if (this.usedForParams) {
            return 0;
        }
        switch (this.type) {
            case STRING: 
            case UNICODE: {
                return -10;
            }
            case FLOAT: 
            case INTEGER: {
                return -20;
            }
            case PRIMARY_KEY: {
                return -30;
            }
        }
        return -99;
    }

    public Iterable<LookupField> multiLookupFields() {
        Collection<LookupField> result = this.multiLookupFields;
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    public boolean isForeignKeyCascadeDelete() {
        return this.isForeignKeyCascadeDelete;
    }

    public String foreignKeyRefs() {
        if (!this.isForeignKey) {
            return null;
        }
        TableDescriptor dir = TableDescriptor.getIfExists(this.referenceId);
        if (dir == null) {
            return null;
        }
        FieldDescriptor ok = dir.getRecordIdField();
        if (ok == null) {
            return null;
        }
        return dir.getRawName();
    }

    public String foreignKeyRawName() {
        return this.foreignKeyRawName;
    }

    public TableDescriptor foreignKeyDir() {
        if (!this.isForeignKey) {
            return null;
        }
        TableDescriptor dir = TableDescriptor.getIfExists(this.referenceId);
        if (dir == null) {
            return null;
        }
        FieldDescriptor ok = dir.getRecordIdField();
        if (ok == null) {
            return null;
        }
        return dir;
    }

    public String foreignKeyRefField() {
        TableDescriptor dir = TableDescriptor.getIfExists(this.referenceId);
        if (dir == null) {
            return null;
        }
        FieldDescriptor ok = dir.getRecordIdField();
        if (ok == null) {
            return null;
        }
        return ok.getRawName();
    }

    public String getNameForIndex(boolean strongUnique, DbScheme scheme) {
        if (scheme == null) {
            return this.getRawName();
        }
        DatabaseCaps caps = scheme.getDatabaseType().caps();
        if (!strongUnique || !this.nullable) {
            return scheme.toCaseIfNeed(this.getRawName());
        }
        String result = "(coalesce(" + scheme.toCaseIfNeed(this.getRawName()) + ", ";
        switch (this.type) {
            case STRING: 
            case UNICODE: {
                result = result + caps.c_string2sql("", false);
                break;
            }
            case DATE_TIME: {
                result = result + caps.c_zeroTime2sql();
                break;
            }
            case BOOLEAN: {
                result = result + caps.c_bool2sql(false);
                break;
            }
            case INTEGER: {
                result = result + "0";
                break;
            }
            default: {
                result = result + "0.0";
            }
        }
        result = result + "))";
        return result;
    }

    @Override
    public int key() {
        return this.id;
    }

    public PostgreSQLReviewType getPostgreSQLReviewType() {
        return this.postgreSQLReviewType;
    }

    public IntegerSet getExtractionTextFields() {
        return this.textExtractionFields;
    }

    public boolean isAutoFill() {
        return this.autoFill;
    }

    public boolean hasExtractionText() {
        return this.textExtractionFields != null;
    }

    public int[] getBlobSizeFields() {
        return this.blobSizeFields;
    }

    public boolean hasBlobSizeFields() {
        return this.blobSizeFields != null && this.blobSizeFields.length > 0;
    }

    public static class LookupField {
        public final int[] path;

        LookupField(int[] path) {
            this.path = path;
        }
    }

    public static class PeriodicFieldStorage {
        public final double tableId;
        public final int fieldId;

        PeriodicFieldStorage(int fieldId, double tableId) {
            this.fieldId = fieldId;
            this.tableId = tableId;
        }
    }

    public static enum PostgreSQLReviewType {
        DEFAULT(0),
        TSVECTOR(1);

        private final int id;

        private PostgreSQLReviewType(int id) {
            this.id = id;
        }

        public int toInt() {
            return this.id;
        }

        public static PostgreSQLReviewType get(int id) {
            for (PostgreSQLReviewType t : PostgreSQLReviewType.values()) {
                if (t.id != id) continue;
                return t;
            }
            return DEFAULT;
        }
    }

    public static enum AutoValueGenerator {
        NONE(0, false),
        MAX_VALUE(1, false),
        ORACLE_SEQUENCE(2, false),
        TIMESTAMP(3, true),
        USER(4, true),
        ORACLE_PROC(5, false),
        COMPUTER_NAME(6, false),
        WINDOWS_USER_NAME(7, false),
        COMPUTER_IP(8, false),
        SESSION(9, false),
        EFFECTIVE_USER(10, true),
        BLOBSIZE(11, true);

        private int id;
        private boolean generateOnCommit;

        private AutoValueGenerator(int id, boolean generateOnCommit) {
            this.id = id;
            this.generateOnCommit = generateOnCommit;
        }

        public int toInt() {
            return this.id;
        }

        public boolean isGenerateOnCreate() {
            return this.id != 0 && !this.generateOnCommit;
        }

        public boolean isGenerateOnCommit() {
            return this.generateOnCommit;
        }

        public static AutoValueGenerator get(int id) {
            for (AutoValueGenerator t : AutoValueGenerator.values()) {
                if (t.id != id) continue;
                return t;
            }
            return NONE;
        }
    }

    public static enum BlobType {
        TEXT(0),
        IMAGE(1),
        OBJECT(2),
        SCHEME(3),
        REPORT(4),
        DOCUMENT(5);

        private int id;

        private BlobType(int id) {
            this.id = id;
        }

        public int toInt() {
            return this.id;
        }

        public static BlobType get(int id) {
            for (BlobType t : BlobType.values()) {
                if (t.id != id) continue;
                return t;
            }
            return TEXT;
        }
    }

    public static enum BlobRawType {
        BINARY(0),
        TEXT(1);

        private int id;

        private BlobRawType(int id) {
            this.id = id;
        }

        public int toInt() {
            return this.id;
        }

        public static BlobRawType get(int id) {
            for (BlobRawType t : BlobRawType.values()) {
                if (t.id != id) continue;
                return t;
            }
            return BINARY;
        }
    }

    public static enum MultipleWriteProtection {
        None(0),
        Fields(1),
        AllFields(2);

        private int id;

        private MultipleWriteProtection(int id) {
            this.id = id;
        }

        public int toInt() {
            return this.id;
        }

        public static MultipleWriteProtection get(int id) {
            for (MultipleWriteProtection t : MultipleWriteProtection.values()) {
                if (t.id != id) continue;
                return t;
            }
            return None;
        }
    }
}

