/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.GeneratedSqlInfo;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSetPostProcess;
import inform.agent.db.sql.QueryTokenizer;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.sql.SQLException;
import org.mozilla.javascript.Context;

public abstract class GeneratedSql
extends GeneratedSqlInfo {
    protected boolean hasError;
    protected String error;
    protected String errorDetailing;
    protected String sqlText;
    protected boolean emptyDataset = false;
    protected boolean advanced;
    protected boolean lockRecords = false;
    protected boolean skipLockedRecords = false;
    protected boolean disabledLockRecords = false;
    protected boolean validForSelectBlob = false;
    protected boolean subject = false;
    protected boolean hasPrimaryKeyExpression = false;
    public static final int TAG_JSG_ERROR = 1;
    public static final int TAG_JSG_SQL_TEXT = 2;
    public static final int TAG_JSG_SQL_PARAMETERS = 3;
    public static final int TAG_JSG_SQL_EMPTY_DATASET = 4;
    public static final int TAG_JSG_SQL_ADVANCED = 5;
    public static final int TAG_JSG_SQL_QUERY_CONTENT = 6;
    public static final int TAG_JSG_SQL_DISABLED_LOCK_RECORDS = 7;
    public static final int TAG_JSG_SQL_VALID_FOR_SELECT_BLOBS = 8;
    public static final int TAG_JSG_SQL_SUBJECT = 9;
    public static final int TAG_JSG_SQL_FAILED_SORT = 10;
    public static final int TAG_JSG_SQL_HASPRIMARYKEYEXPR = 11;
    public static final int TAG_JSG_ERROR_DETAILING = 12;
    public static final int TAG_JSG_PARAM_NULL = 1;
    public static final int TAG_JSG_PARAM_INT = 2;
    public static final int TAG_JSG_PARAM_DOUBLE = 3;
    public static final int TAG_JSG_PARAM_ANSI = 4;
    public static final int TAG_JSG_PARAM_BLOB = 5;
    public static final int TAG_JSG_PARAM_DATE = 6;
    public static final int TAG_JSG_PARAM_UNICODE = 7;
    public static final int TAG_JSG_PARAM_BOOLEAN = 8;

    public GeneratedSql() {
    }

    public GeneratedSql(String sqlText) {
        this.sqlText = sqlText;
        this.hasError = false;
    }

    public boolean isHasError() {
        return this.hasError;
    }

    public String getError() {
        return this.error;
    }

    public String getErrorDetailing() {
        return this.errorDetailing;
    }

    public boolean isLockRecords() {
        return this.lockRecords && !Ini.ReadonlyMode;
    }

    public void setLockRecords(boolean lockRecords, boolean skipLockedRecords) {
        this.lockRecords = lockRecords;
        this.skipLockedRecords = lockRecords && skipLockedRecords;
    }

    public boolean isDisabledLockRecords() {
        return this.disabledLockRecords;
    }

    public final String getSqlText() {
        if (this.isLockRecords()) {
            if (this.skipLockedRecords) {
                return this.sqlText + " for update skip locked";
            }
            return this.sqlText + " for update nowait";
        }
        return this.sqlText;
    }

    public TaggedReader getParamersReader() {
        return null;
    }

    public boolean isEmptyDataset() {
        return this.emptyDataset;
    }

    public boolean setParametersTo(PreparedStatement statement) throws IOException, SQLException, TaggedReaderException {
        statement.clearParameters();
        return this.appendParametersTo(statement);
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public boolean isValidForSelectBlob() {
        return this.validForSelectBlob;
    }

    public boolean isSubject() {
        return this.subject;
    }

    public boolean hasPrimaryKeyExpression() {
        return this.hasPrimaryKeyExpression;
    }

    public boolean hasPostProcess() {
        return false;
    }

    public ResultSetPostProcess createPostProcess(SSContext ssContext, Context context, ServerSideHost ssHost, AbstractConnectionManager connectionManager, int nullSortKind) {
        return null;
    }

    public String formatInsensitiveSql(boolean paramsInlined) {
        String sql = this.getSqlText();
        if (sql == null) {
            sql = "";
        }
        if (!paramsInlined) {
            StringBuilder text = new StringBuilder(sql);
            text.append('\n');
            this.logParameters(1, text);
            sql = text.toString();
        }
        sql = QueryTokenizer.formatInsensitiveText(sql);
        return sql;
    }

    public abstract boolean appendParametersTo(PreparedStatement var1) throws IOException, SQLException, TaggedReaderException;

    public abstract void logParameters(int var1, StringBuilder var2);

    public abstract Sorting getSortingGeneration();

    public static enum Sorting {
        DEFAULT,
        GENERATED,
        FAILED;

    }
}

