/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.InformException;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlExecutor;
import inform.agent.db.utils.SqlParameter;
import inform.agent.scripts.SSContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

public class PhenixLinks {
    public static final int ALL_RECORDS = 0;
    public static final int ELEMENTS = 1;
    public static final int LINKED = 2;
    public static final int PARENT_ELEMENTS = 3;
    public static final int PARENT_LINKED = 4;
    public static final int FIELD_ID_TABLE = 1;
    public static final int FIELD_ID_RECORD = 2;
    public static final int FIELD_ID_LINK_TABLE = 3;
    public static final int FIELD_ID_LINK_RECORD = 4;
    public static final String[] FIELD_NAMES = new String[]{"TABLE_ID", "RECORD_ID", "LNK_TABLE_ID", "LNK_RECORD_ID"};
    private final ServerSideHost ssHost;
    private HashMap<Record, LinkRecord> links = new HashMap();

    public PhenixLinks(ServerSideHost ssHost) {
        this.ssHost = ssHost;
    }

    public void idle() {
        if (this.ssHost != null) {
            this.ssHost.idle();
        }
    }

    public void add(LinkRecord r) {
        this.links.put(r.right, r);
    }

    public LinkRecord get(Record r) {
        return this.links.get(r);
    }

    static String getLinkTableName(int linkId) {
        if (linkId == 1) {
            return "PHX_ELEMENTS";
        }
        return "PHX_LINKED";
    }

    static void appendLinkTableName(StringBuilder sql, DatabaseDescriptor database, int linkId) {
        String tableName = PhenixLinks.getLinkTableName(linkId);
        if (database != null) {
            database.appendTableRawName(tableName, sql);
        } else {
            sql.append(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(SSContext ssContext, double tableId, DatabaseConnection connection, int linkId) {
        try {
            if (!connection.isLinkTableExists(ssContext, linkId)) {
                return;
            }
            StringBuilder sql = new StringBuilder();
            sql.append("select TABLE_ID,RECORD_ID,LNK_RECORD_ID from ");
            PhenixLinks.appendLinkTableName(sql, connection.getDescriptor(), linkId);
            sql.append(" where LNK_TABLE_ID=? order by LNK_RECORD_ID");
            try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
                statement.setDouble(1, tableId);
                try (ResultSet resultSet = statement.executeQuery(ssContext);){
                    while (resultSet.next()) {
                        this.idle();
                        LinkRecord link = new LinkRecord();
                        link.left.table = resultSet.getDouble(1);
                        link.left.row = resultSet.getDouble(2);
                        link.right.table = tableId;
                        link.right.row = resultSet.getDouble(3);
                        this.add(link);
                    }
                }
            }
        }
        catch (SQLException ex) {
            Core.logger.error("LoadLinks error", ex);
        }
    }

    private static void appendExecutorParams(SqlExecutor cmd, int count) {
        for (int i = 0; i < count; ++i) {
            cmd.params.add(new SqlParameter(SqlDataType.DOUBLE));
        }
    }

    public static SqlExecutor createSelectLeftTableExecutor(SSContext ssContext, int linkId, DatabaseConnection connection) {
        SqlExecutor cmd = new SqlExecutor(ssContext, connection);
        cmd.sqlText.append("select TABLE_ID from ");
        PhenixLinks.appendLinkTableName(cmd.sqlText.getBuilder(), connection.getDescriptor(), linkId);
        cmd.sqlText.append(" where TABLE_ID=? and RECORD_ID=? and LNK_TABLE_ID=? and LNK_RECORD_ID=?");
        PhenixLinks.appendExecutorParams(cmd, 4);
        return cmd;
    }

    public static SqlExecutor createSelectRightTableExecutor(SSContext ssContext, int linkId, DatabaseConnection connection) {
        SqlExecutor cmd = new SqlExecutor(ssContext, connection);
        cmd.sqlText.append("select LNK_TABLE_ID, LNK_RECORD_ID from ");
        PhenixLinks.appendLinkTableName(cmd.sqlText.getBuilder(), connection.getDescriptor(), linkId);
        cmd.sqlText.append(" where TABLE_ID=? and RECORD_ID=?");
        PhenixLinks.appendExecutorParams(cmd, 2);
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasElements(SSContext ssContext, double tableId, DatabaseConnection connection) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select TABLE_ID from ");
        PhenixLinks.appendLinkTableName(sql, connection.getDescriptor(), 1);
        sql.append(" where TABLE_ID=").append((long)tableId);
        try (PreparedStatement statement = connection.prepareStatement("PhenixLinks.hasElements", sql.toString());){
            boolean bl;
            ResultSet fetch = statement.executeQuery(ssContext);
            try {
                bl = fetch.next();
            }
            catch (Throwable throwable) {
                fetch.close();
                throw throwable;
            }
            fetch.close();
            return bl;
        }
    }

    public static SqlExecutor createUpdateLeftExecutor(SSContext ssContext, int linkId, DatabaseConnection connection) {
        SqlExecutor cmd = new SqlExecutor(ssContext, connection);
        cmd.sqlText.append("update ");
        PhenixLinks.appendLinkTableName(cmd.sqlText.getBuilder(), connection.getDescriptor(), linkId);
        cmd.sqlText.append(" set TABLE_ID=?, RECORD_ID=? where LNK_TABLE_ID=? and LNK_RECORD_ID=?");
        PhenixLinks.appendExecutorParams(cmd, 4);
        return cmd;
    }

    public static SqlExecutor createInsertExecutor(SSContext ssContext, int linkId, DatabaseConnection connection) {
        SqlExecutor cmd = new SqlExecutor(ssContext, connection);
        cmd.sqlText.append("insert into ");
        PhenixLinks.appendLinkTableName(cmd.sqlText.getBuilder(), connection.getDescriptor(), linkId);
        cmd.sqlText.append(" (TABLE_ID,RECORD_ID,LNK_TABLE_ID,LNK_RECORD_ID) values (?,?,?,?)");
        PhenixLinks.appendExecutorParams(cmd, 4);
        return cmd;
    }

    public static SqlExecutor createDeleteExecutor(SSContext ssContext, int linkId, DatabaseConnection connection) {
        SqlExecutor cmd = new SqlExecutor(ssContext, connection);
        cmd.sqlText.append("delete from ");
        PhenixLinks.appendLinkTableName(cmd.sqlText.getBuilder(), connection.getDescriptor(), linkId);
        cmd.sqlText.append(" where TABLE_ID=? and RECORD_ID=? and LNK_TABLE_ID=? and LNK_RECORD_ID=?");
        PhenixLinks.appendExecutorParams(cmd, 4);
        return cmd;
    }

    public static SqlExecutor createLeftDeleteExecutor(SSContext ssContext, int linkId, DatabaseConnection connection) {
        SqlExecutor cmd = new SqlExecutor(ssContext, connection);
        cmd.sqlText.append("delete from ");
        PhenixLinks.appendLinkTableName(cmd.sqlText.getBuilder(), connection.getDescriptor(), linkId);
        cmd.sqlText.append(" where TABLE_ID=? and RECORD_ID=?");
        PhenixLinks.appendExecutorParams(cmd, 2);
        return cmd;
    }

    public static SqlExecutor createLeftOrRightDeleteExecutor(SSContext ssContext, int linkId, DatabaseConnection connection) {
        SqlExecutor cmd = new SqlExecutor(ssContext, connection);
        cmd.sqlText.append("delete from ");
        PhenixLinks.appendLinkTableName(cmd.sqlText.getBuilder(), connection.getDescriptor(), linkId);
        cmd.sqlText.append(" where (TABLE_ID=? and RECORD_ID=?) or (LNK_TABLE_ID=? and LNK_RECORD_ID=?)");
        PhenixLinks.appendExecutorParams(cmd, 4);
        return cmd;
    }

    public Iterator<LinkRecord> iterator() {
        return this.links.values().iterator();
    }

    public static class HasElements {
        private final AbstractConnectionManager connections;
        private final DoubleSet has = new DoubleSet();
        private final DoubleSet processed = new DoubleSet();
        private final SSContext ssContext;

        public HasElements(SSContext ssContext, AbstractConnectionManager connections) {
            this.ssContext = ssContext;
            this.connections = connections;
        }

        public boolean hasElements(TableDescriptor table) throws InformException, SQLException {
            DatabaseConnection connection;
            double tableId = table.getNodeId();
            if (this.processed.add(tableId) && PhenixLinks.hasElements(this.ssContext, tableId, connection = this.connections.getConnection(table.getDbId(), "PhenixLinks::hasElements"))) {
                this.has.add(tableId);
            }
            return this.has.contains(tableId);
        }
    }

    public static class LinkRecord {
        public final Record left = new Record();
        public final Record right = new Record();
        public boolean dropped = false;
        public double userId = 0.0;

        public void setBinary(byte[] bin) throws IOException {
            ByteArrayInputStream bais = new ByteArrayInputStream(bin);
            LittleEndianDataInputStream stream = new LittleEndianDataInputStream(bais);
            this.left.table = stream.readDouble();
            this.right.table = stream.readDouble();
            this.left.row = stream.readDouble();
            this.right.row = stream.readDouble();
            this.dropped = stream.readByte() != 0;
            this.userId = stream.readDouble();
        }

        public int setBinaryOptions(byte[] bin) throws IOException {
            ByteArrayInputStream bais = new ByteArrayInputStream(bin);
            LittleEndianDataInputStream stream = new LittleEndianDataInputStream(bais);
            this.left.table = stream.readDouble();
            this.left.row = stream.readDouble();
            this.right.table = stream.readDouble();
            this.right.row = stream.readDouble();
            return stream.readInt();
        }
    }

    public static class Record {
        public double table;
        public double row;

        public Record() {
            this.row = 0.0;
            this.table = 0.0;
        }

        public Record(double table, double row) {
            this.table = table;
            this.row = row;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Record)) {
                return false;
            }
            Record r = (Record)obj;
            return r.table == this.table && r.row == this.row;
        }

        public int hashCode() {
            long a = Double.doubleToLongBits(this.table);
            long b = Double.doubleToLongBits(this.row);
            int a1 = (int)a;
            int a2 = (int)(a >> 32);
            int b1 = (int)b;
            int b2 = (int)(b >> 32);
            return (a1 ^ a2) << 3 ^ (b1 ^ b2);
        }
    }
}

