/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.DateTime;
import inform.adt.TimeZoneHost;
import inform.adt.collections.ArrayMap;
import inform.adt.collections.Cursor;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.GeneratedSql;
import inform.agent.db.SearchGeneratedSql;
import inform.agent.db.SearchParameters;
import inform.agent.db.SortField;
import inform.agent.db.sql.engine.Engine;
import inform.agent.scripts.Constants;
import inform.agent.scripts.ScriptableHost;
import inform.agent.scripts.format.FormatManager;
import inform.agent.scripts.sql.ExpressionFilterQuery;
import inform.agent.scripts.sql.QueryParameter;
import inform.agent.scripts.sql.ReturnedFields;
import inform.common.DateFunction;
import java.io.IOException;
import java.util.ArrayList;

public class SqlGenerator {
    private double searchId;
    private double tableId;
    private double databaseId = 0.0;
    private byte[] searchContent;
    private final ArrayList<SortField> sortFields;
    private final ReturnedFields usedFields;
    private byte[] constantsContent;
    private TimeZoneHost constantsContentTimeZone = null;
    private double actualPoint;
    private boolean actualPointAssigned;
    private boolean hasSearch;
    private boolean nested;
    private boolean inlineParams = false;
    private boolean debugMode = false;
    private final SearchParameters parameters;
    private byte[] paramContent = null;
    private byte[] clientSideParamContent = null;
    private int blobReceiving = 0;
    private boolean generateFileBlobs;
    private ExpressionFilterQuery expressionFilterQuery = null;
    private String expressionFilter = null;
    private int fetchLimit = -1;
    private int nullSortKind = 0;
    private final ServerSideHost ssHost;
    private final TimeZoneHost timeZoneHost;
    private Constants constants = null;
    private boolean customExcludeOrderBy = false;
    private int customSubjectFieldId = 0;
    private byte[] relation = null;

    public SqlGenerator(ServerSideHost ssHost, TimeZoneHost timeZoneHost) {
        this.ssHost = ssHost;
        this.timeZoneHost = timeZoneHost;
        this.sortFields = new ArrayList();
        this.usedFields = new ReturnedFields();
        this.parameters = new SearchParameters();
    }

    public TimeZoneHost getTimeZoneHost() {
        return this.timeZoneHost;
    }

    public double getTableId() {
        return this.tableId;
    }

    public void setTableId(double tableId) {
        this.tableId = tableId;
    }

    public double getSearchId() {
        return this.searchId;
    }

    public void setSearchId(double searchId) {
        this.searchId = searchId;
        if (!this.hasSearch && searchId != 0.0) {
            this.hasSearch = true;
        }
    }

    public double getDatabaseId() {
        return this.databaseId;
    }

    public void setDatabaseId(double databaseId) {
        this.databaseId = databaseId;
    }

    public byte[] getSearchContent() {
        return this.searchContent;
    }

    public void setSearchContent(byte[] searchContent) {
        this.searchContent = searchContent;
        if (!this.hasSearch && searchContent != null && searchContent.length != 0) {
            this.hasSearch = true;
        }
    }

    public SearchParameters getParameters() {
        return this.parameters;
    }

    public SortField addSortField() {
        SortField field = new SortField();
        this.sortFields.add(field);
        return field;
    }

    public ArrayList<SortField> getSortFields() {
        return this.sortFields;
    }

    public void addUsedField(int fieldId) {
        this.usedFields.add(fieldId);
    }

    public void setReturnedFields(IntegerSet fields) {
        this.usedFields.setFields(fields);
    }

    public void setConstantsContent(byte[] constantsContent, TimeZoneHost timeZoneHost) {
        this.constantsContent = constantsContent;
        this.constantsContentTimeZone = timeZoneHost;
    }

    public void setActualPoint(double actualPoint) {
        this.actualPoint = actualPoint;
        this.actualPointAssigned = true;
    }

    public double getActualPoint() {
        return this.actualPoint;
    }

    public boolean hasActualPoint() {
        return this.actualPointAssigned;
    }

    public void setBlobReceiving(int blobReceiving) {
        this.blobReceiving = blobReceiving;
    }

    public void setGenerateFileBlobs(boolean generateFileBlobs) {
        this.generateFileBlobs = generateFileBlobs;
    }

    public void setNestedSql() {
        this.nested = true;
    }

    public void setParamContent(byte[] paramContent) {
        this.paramContent = paramContent;
    }

    public void setClientSideParamContent(byte[] clientSideParamContent) {
        this.clientSideParamContent = clientSideParamContent;
    }

    public boolean isCustomExcludeOrderBy() {
        return this.customExcludeOrderBy;
    }

    public void setCustomExcludeOrderBy(boolean customExcludeOrderBy) {
        this.customExcludeOrderBy = customExcludeOrderBy;
    }

    public int getCustomSubjectFieldId() {
        return this.customSubjectFieldId;
    }

    public void setCustomSubjectFieldId(int customSubjectFieldId) {
        this.customSubjectFieldId = customSubjectFieldId;
    }

    public void setFetchLimit(int limit) {
        this.fetchLimit = limit;
    }

    public int getNullSortKind() {
        return this.nullSortKind;
    }

    public void setNullSortKind(int nullSortKind) {
        this.nullSortKind = nullSortKind;
    }

    private GeneratedSql getGeneratedSql(int databaseType, byte[] inputData) throws IOException, TaggedReaderException {
        return new SearchGeneratedSql(SqlGenerator.generateSql(this.tableId, this.ssHost.getUserID(), this.databaseId, databaseType, this, inputData));
    }

    public GeneratedSql getGeneratedSql(Method method, int databaseType) throws IOException, TaggedReaderException {
        double user = this.ssHost == null ? 0.0 : this.ssHost.getUserID();
        switch (method) {
            default: {
                return new SearchGeneratedSql(SqlGenerator.generateSql(this.tableId, user, this.databaseId, databaseType, this, this.getInputData()));
            }
            case NEW_WAY: 
        }
        return Engine.generate(this.tableId, user, this.databaseId, databaseType, this, this.getInputData());
    }

    public GeneratedSql getGeneratedSql(Method method, int databaseType, byte[] inputData) throws IOException, TaggedReaderException {
        switch (method) {
            default: {
                return this.getGeneratedSql(databaseType, inputData);
            }
            case NEW_WAY: 
        }
        return Engine.generate(this.tableId, this.ssHost.getUserID(), this.databaseId, databaseType, this, inputData);
    }

    public static Method extractSearchGenerationMethod(byte[] inputData) throws IOException {
        TaggedReader in = new TaggedReader(inputData);
        while (in.next()) {
            if (in.getCurrentTag() != 27) continue;
            switch (in.getInt()) {
                case 1: {
                    return Method.STANDARD;
                }
                case 2: {
                    return Method.NEW_WAY;
                }
            }
            return Method.DEFAULT;
        }
        return Method.DEFAULT;
    }

    public static double extractRootTabled(byte[] inputData) throws IOException {
        TaggedReader in = new TaggedReader(inputData);
        while (in.next()) {
            if (in.getCurrentTag() != 1) continue;
            return in.getNodeID();
        }
        return 0.0;
    }

    private static native byte[] generateSql(double var0, double var2, double var4, int var6, SqlGenerator var7, byte[] var8);

    public static native byte[] transformToQuery(double var0);

    public static native String doubleToString(double var0);

    public String getExpressionFilter() {
        return this.expressionFilter;
    }

    public ExpressionFilterQuery getExpressionFilterQuery() {
        return this.expressionFilterQuery;
    }

    public void setExpressionFilter(ExpressionFilterQuery expressionFilterQuery, String expressionFilter) {
        this.expressionFilterQuery = expressionFilterQuery;
        this.expressionFilter = expressionFilter;
    }

    public int JNI_ExpressionFilterParametersCount() {
        if (this.expressionFilterQuery == null) {
            return 0;
        }
        if (this.expressionFilterQuery.getSqlParameters() == null) {
            return 0;
        }
        return this.expressionFilterQuery.getSqlParameters().items().size();
    }

    public QueryParameter JNI_ExpressionFilterGetParameter(int index) {
        return this.expressionFilterQuery.getSqlParameters().items().get(index);
    }

    public int JNI_RequiredFilterFieldCount() {
        if (this.expressionFilterQuery == null) {
            return 0;
        }
        return this.expressionFilterQuery.requiredFilterFieldCount();
    }

    public int JNI_RequiredFilterField(int index) {
        if (this.expressionFilterQuery == null) {
            return 0;
        }
        return this.expressionFilterQuery.requiredFilterField(index);
    }

    public String JNI_ExpressionFilterGetDirectoriesSQL() {
        try {
            return this.expressionFilterQuery.getDirectorySQL();
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
            return "";
        }
    }

    public ReturnedFields getReturnedFields() {
        return this.usedFields;
    }

    private void storeUsedFields(TaggedWriter writer) throws IOException {
        if (this.usedFields.empty() || !this.hasSearch) {
            return;
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(data);
        for (Cursor.Integer field : this.usedFields) {
            stream.putInt32(1, field.value);
        }
        stream.flush();
        writer.putRaw(29, data);
    }

    private ByteArrayOutputStream getCustomization() throws IOException {
        if (this.customExcludeOrderBy || this.customSubjectFieldId != 0) {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(data);
            if (this.customExcludeOrderBy) {
                out.putEmpty(2);
            }
            if (this.customSubjectFieldId != 0) {
                out.putInt32(3, this.customSubjectFieldId);
            }
            out.flush();
            if (data.size() == 0) {
                return null;
            }
            return data;
        }
        return null;
    }

    private byte[] getInputData() throws IOException {
        ByteArrayOutputStream customization;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(data);
        if (this.tableId != 0.0) {
            writer.putDouble(5, this.tableId);
        }
        if (this.inlineParams) {
            writer.putEmpty(30);
        }
        if (this.debugMode) {
            writer.putEmpty(34);
        }
        if (this.relation != null) {
            writer.putRaw(22, this.relation);
        }
        if (this.searchId != 0.0) {
            writer.putDouble(31, this.searchId);
        }
        if (this.searchContent != null && this.searchContent.length != 0) {
            writer.putRaw(14, this.searchContent);
        }
        for (SortField sortField : this.sortFields) {
            sortField.storeAs(writer);
        }
        if (this.hasSearch) {
            if (this.paramContent != null) {
                writer.putRaw(15, this.paramContent);
            } else if (this.clientSideParamContent != null) {
                writer.putRaw(26, this.clientSideParamContent);
            } else {
                this.parameters.storeAs(writer);
            }
        }
        this.storeUsedFields(writer);
        if (this.constantsContent != null && this.constantsContent.length != 0) {
            writer.putRaw(32, this.constantsContent);
        }
        if (this.actualPointAssigned && this.tableId != 0.0 && !this.hasSearch) {
            writer.putDouble(33, this.actualPoint);
        }
        if (this.blobReceiving != 0) {
            writer.putInt32(39, this.blobReceiving);
        }
        if (this.generateFileBlobs) {
            writer.putEmpty(49);
        }
        if (this.nested) {
            writer.putEmpty(40);
        }
        if (this.fetchLimit != -1) {
            writer.putInt32(23, this.fetchLimit);
        }
        if ((customization = this.getCustomization()) != null && customization.size() > 0) {
            writer.putRaw(35, customization);
        }
        if (this.nullSortKind != 0) {
            writer.putInt32(50, this.nullSortKind);
        }
        writer.flush();
        return data.toByteArray();
    }

    public void setInlineParams(boolean inlineParams) {
        this.inlineParams = inlineParams;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public static double calcDateFunction(int f) {
        if (f == 0) {
            return 0.0;
        }
        DateFunction function = DateFunction.fromID(f);
        if (function == DateFunction.sfNone) {
            return 0.0;
        }
        return function.getDate();
    }

    public Constants getConstants() {
        if (this.constants == null) {
            if (this.ssHost != null && this.ssHost instanceof ScriptableHost) {
                ScriptableHost host = (ScriptableHost)((Object)this.ssHost);
                this.constants = host.getConstants();
            }
            if (this.constants == null) {
                double userId = 0.0;
                if (this.ssHost != null) {
                    userId = this.ssHost.getUserID();
                }
                this.constants = new Constants(userId);
                if (this.constantsContent != null) {
                    try {
                        this.constants.load(this.constantsContent, this.constantsContentTimeZone != null ? this.constantsContentTimeZone : this.ssHost);
                    }
                    catch (TaggedReaderException | IOException ex) {
                        Core.logger.error(null, ex);
                    }
                }
            }
        }
        return this.constants;
    }

    public double toServerTimeByFormat(double value, int format) {
        return FormatManager.toServerTime(value, format, this.timeZoneHost);
    }

    public double toServerTime(double value) {
        return DateTime.toServerTime(value, this.timeZoneHost);
    }

    public void setConstants(Constants constants) {
        this.constants = constants;
    }

    public void setRelation(byte[] relation) {
        this.relation = relation;
    }

    public static enum Method {
        STANDARD(0),
        NEW_WAY(1);

        public static final Method DEFAULT;
        private final int typeId;
        static final ArrayMap<Method> kindMap;

        private Method(int value) {
            this.typeId = value;
        }

        public int toInt() {
            return this.typeId;
        }

        public static Method fromInt(int typeId) {
            return kindMap.get(typeId);
        }

        static {
            DEFAULT = STANDARD;
            kindMap = new ArrayMap<Method>(Method.values());
        }
    }
}

