/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.adt.InformException;
import inform.adt.collections.IntegerHash;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableHost;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;

public class ConnectionManager
extends AbstractConnectionManager
implements IntegerHash.Entry {
    private static final AtomicInteger ID_GEN = new AtomicInteger();
    private static final long ATTACH_WAIT_TIME = 5000L;
    private static final IntegerHash<ConnectionManager> pool = new IntegerHash();
    private final int sessionId;
    private boolean psCaptured;

    private ConnectionManager(SSContext context, int sessionId, String who, boolean freshNeed) {
        super(context, who, freshNeed);
        this.sessionId = sessionId;
    }

    public ConnectionManager(SSContext context, String who, boolean freshNeed) {
        this(context, -1, who, freshNeed);
    }

    public ConnectionManager(SSContext context, String who) {
        this(context, who, false);
    }

    @Override
    public boolean isPersonalSession() {
        return this.sessionId != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionManager create(ServerSideHost ssHost, String who) {
        SSContext context = ssHost instanceof ScriptableHost ? ((ScriptableHost)((Object)ssHost)).getRootContext() : null;
        ConnectionManager result = new ConnectionManager(context, ID_GEN.incrementAndGet(), who, false);
        IntegerHash<ConnectionManager> integerHash = pool;
        synchronized (integerHash) {
            pool.add(result);
        }
        ssHost.personalSessionCreated(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionManager capture(int sessionId, ServerSideHost ssHost, String who) throws InformException {
        ConnectionManager result;
        if (sessionId <= 0) {
            sessionId = -1;
        }
        if (sessionId == 0) {
            sessionId = -1;
        }
        if (sessionId == -1) {
            SSContext context = ssHost != null && ssHost instanceof ScriptableHost ? ((ScriptableHost)((Object)ssHost)).getRootContext() : null;
            result = new ConnectionManager(context, who);
        } else {
            IntegerHash<ConnectionManager> integerHash = pool;
            synchronized (integerHash) {
                result = pool.get(sessionId);
            }
        }
        if (result == null) {
            throw new InformException("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0439 \u0438\u043b\u0438 \u0443\u0436\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0439 \u0441\u0435\u0441\u0441\u0438\u0438(sessionId: " + sessionId + ")");
        }
        result.capture(ssHost);
        return result;
    }

    private synchronized void capture(ServerSideHost ssHost) throws InformException {
        if (this.psCaptured) {
            long st = Core.clock();
            while (this.psCaptured) {
                try {
                    this.wait(100L);
                    if (Core.clock() - st <= 5000L) continue;
                    break;
                }
                catch (InterruptedException e) {
                    throw InformException.wrap(e);
                }
            }
        }
        if (this.psCaptured) {
            String detail = ssHost != null ? ssHost.toLogString() : "\u043d\u0435\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 server side host";
            throw new InformException("\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0435\u0441\u0441\u0438\u044f \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430").detail("\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0435\u0441\u0441\u0438\u0438(sessionId: " + this.sessionId + ")").detail(detail);
        }
        this.psCaptured = true;
        this.ssHost = ssHost;
    }

    public static void close(int sessionId, ServerSideHost ssHost) throws InformException, SQLException {
        if (sessionId == -1) {
            throw new IllegalArgumentException("\u0421\u0435\u0441\u0441\u0438\u044f \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0441\u043d\u0430\u043b\u044c\u043d\u043e\u0439");
        }
        ConnectionManager session = ConnectionManager.capture(sessionId, ssHost, null);
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.sessionId != -1) {
            this.releaseHook();
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                this.ssHost = null;
                this.psCaptured = false;
                this.notify();
            }
        } else {
            super.release();
        }
    }

    @Override
    public int key() {
        return this.sessionId;
    }

    @Override
    protected void killSessionHelper(DatabaseConnection c, String cause) {
        c.killSession(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() throws InformException, SQLException {
        if (this.sessionId != -1) {
            IntegerHash<ConnectionManager> integerHash = pool;
            synchronized (integerHash) {
                pool.remove(this.sessionId);
            }
            this.ssHost.personalSessionClosed(this);
        }
        super.release();
    }
}

