/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.adt.CallStack;
import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.ObjectSizer;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ActionHooks;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.LogContext;
import inform.agent.RequestStatistics;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.BatchInsertEngine;
import inform.agent.db.commit.DataTransaction;
import inform.agent.db.commit.DeleteEngine;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.AbstractStatement;
import inform.agent.db.connect.Advisor;
import inform.agent.db.connect.CallableStatement;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.FetchHint;
import inform.agent.db.connect.Plan;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.types.SqlDataType;
import inform.agent.net.Client;
import inform.agent.scripts.SSContext;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.impl.AsmoLogger;

public abstract class DatabaseConnection
implements Connector,
DoubleHash.Entry,
LogContext {
    private static final ActionHooks.Hook STUB_HOOK = new ActionHooks.Hook("DatabaseConnection::STUB_HOOK"){

        @Override
        protected void hook() {
        }
    };
    private static final AtomicInteger idGenerator = new AtomicInteger();
    protected final int id = idGenerator.incrementAndGet();
    @ObjectSizer.HintShared
    protected final DatabaseDescriptor descriptor;
    protected Connection connection;
    protected final DatabaseMetaData jdbcMetadata;
    protected final boolean isProxyConnection;
    private final Set<AbstractStatement> statements = new HashSet<AbstractStatement>();
    private int fixateTransactionNo = 0;
    private int fixateNo = 0;
    private int transactionChangeNo = 0;
    protected boolean transactionSupported;
    protected volatile boolean dirty;
    protected volatile boolean pendingDirty;
    protected volatile boolean dirtySqlConsole;
    protected volatile boolean obsolete;
    protected volatile boolean autoCommitMode;
    protected boolean deferredCheckConstraints = false;
    final long creationTime = System.currentTimeMillis();
    long lastCheckTime;
    @ObjectSizer.HintShared
    AbstractConnectionManager manager;
    @ObjectSizer.HintShared
    ActionHooks.Hook hook = STUB_HOOK;
    private DataTransaction transaction;
    String usedBy;
    boolean closed = false;
    private boolean readonly;
    private boolean hasPossibleWriteOperations;
    protected boolean anycaseFixationNeed;
    protected String toStringCache;
    private static final int CACHE_UNKNOWN = 0;
    private static final int CACHE_EXISTS = 1;
    private static final int CACHE_NOT_EXISTS = 2;
    private int ELEMENTS_EXISTS_CACHE = 0;
    private int LINKS_EXISTS_CACHE = 0;

    protected DatabaseConnection(DatabaseDescriptor descriptor) throws SQLException, InformException {
        this.descriptor = descriptor;
        StringBuilder msg = new StringBuilder("connecting ");
        msg.append(this.toString()).append(" to ");
        msg.append(descriptor);
        msg.append('(');
        msg.append(this.connectionString());
        msg.append(") [");
        descriptor.appendPoolInfo(msg);
        msg.append(']');
        Core.logger.log(AsmoLogger.Level.INFO, msg.toString(), null, this);
        this.connection = this.establishConnection();
        try {
            this.connection.setAutoCommit(false);
            this.transactionSupported = true;
        }
        catch (SQLException ex) {
            Core.logger.log(AsmoLogger.Level.ERROR, ".setAutoCommit throws exeption", ex, this);
        }
        this.jdbcMetadata = this.connection.getMetaData();
        this.isProxyConnection = false;
    }

    protected DatabaseConnection(DatabaseDescriptor descriptor, DatabaseConnection connection) {
        this.descriptor = descriptor;
        boolean bl = this.isProxyConnection = descriptor.getEffectiveDatabaseId() != descriptor.getNodeId();
        assert (this.isProxyConnection);
        StringBuilder msg = new StringBuilder("connecting ");
        msg.append(this.toString()).append(" to ");
        msg.append(connection.descriptor);
        msg.append('(');
        msg.append(connection.connectionString());
        msg.append(") [");
        connection.descriptor.appendPoolInfo(msg);
        msg.append(']');
        Core.logger.log(AsmoLogger.Level.INFO, msg.toString(), null, this);
        this.connection = connection.connection;
        this.jdbcMetadata = connection.jdbcMetadata;
        this.transactionSupported = connection.transactionSupported;
    }

    synchronized void attach(AbstractConnectionManager manager) {
        if (this.manager != null) {
            throw new IllegalStateException(String.format("%s is already attached to %s", this, this.manager));
        }
        this.manager = manager;
        this.hook = manager.hook();
    }

    public boolean attached(AbstractConnectionManager mgr) {
        return this.manager == mgr;
    }

    final void fastCheck() {
        try {
            if (this.pendingDirty) {
                this.setDirty();
            } else if (System.currentTimeMillis() - this.lastCheckTime > (long)Ini.ConnectionCheckInterval && !this.internal_Check()) {
                this.setDirty();
            }
        }
        catch (SQLException e) {
            this.setDirty();
            Core.logger.error("fastCheck SQLException used:" + this.usedBy, e);
        }
        finally {
            this.lastCheckTime = System.currentTimeMillis();
        }
    }

    protected boolean internal_Check() throws SQLException {
        return this.connection.getMetaData() != null;
    }

    public final boolean isObsolete() {
        return this.obsolete || this.connection == null || System.currentTimeMillis() - this.creationTime > (long)Ini.ConnectionLifetime;
    }

    public final boolean isTransactionSupported() {
        return this.transactionSupported;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void setDirty() {
        this.dirty = true;
    }

    public void setAutoCommit() throws SQLException {
        this.dirty = true;
        this.autoCommitMode = true;
        this.connection.setAutoCommit(true);
    }

    public final void setPendingDirty() {
        this.pendingDirty = true;
    }

    public final void setDirtySqlConsole() {
        this.dirtySqlConsole = true;
        this.dirty = true;
    }

    public final DatabaseDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected abstract String connectionString();

    protected void generateToString(StringBuilder builder) {
    }

    public final String toString() {
        if (this.toStringCache == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.descriptor.getDatabaseType().shortName()).append('(').append(this.id);
            this.generateToString(builder);
            this.descriptor.appendNodeName(builder.append(','));
            this.toStringCache = builder.append(')').toString();
        }
        return this.toStringCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        ArrayList<AbstractStatement> _statements;
        Set<AbstractStatement> set = this.statements;
        synchronized (set) {
            if (this.statements.isEmpty()) {
                return;
            }
            _statements = new ArrayList<AbstractStatement>(this.statements);
        }
        this.setDirty();
        for (AbstractStatement s : _statements) {
            try {
                s.statement().cancel();
            }
            catch (SQLException e) {
                Core.logger.error("Statement.cancel", e);
            }
        }
    }

    public void commitForReleaseSelectLocks() throws SQLException {
    }

    @Override
    public final void commit() throws SQLException {
        boolean skip;
        if (Ini.AutoRollback) {
            this.rollback();
            return;
        }
        boolean bl = skip = this.readonly && !this.dirty;
        if (skip && this.anycaseFixationNeed && this.fixateNo != this.transactionChangeNo) {
            skip = false;
        }
        if (!skip && this.transaction != null) {
            this.transaction.register();
            this.transaction = null;
        }
        if (!skip && this.transactionSupported && !this.isProxyConnection) {
            Core.logger.logSql("COMMIT " + this.toString(), this);
            if (!this.autoCommitMode) {
                this.hook.beginLongOperation(System.currentTimeMillis(), 2280000L);
                try {
                    this.connection.commit();
                }
                finally {
                    this.hook.endLongOperation();
                }
            }
            this.fixateNo = this.transactionChangeNo;
        }
        this.fixateTransactionNo = this.transactionChangeNo;
    }

    public final void rollback() throws SQLException {
        this.transaction = null;
        if (this.transactionSupported) {
            Core.logger.logSql("ROLLBACK " + this.toString(), this);
            if (!this.autoCommitMode && !this.isProxyConnection) {
                this.hook.beginLongOperation(System.currentTimeMillis(), 2280000L);
                try {
                    this.connection.rollback();
                }
                catch (SQLException e) {
                    this.setDirty();
                    throw e;
                }
                finally {
                    this.hook.endLongOperation();
                }
            }
            this.fixateNo = this.transactionChangeNo;
        }
        this.fixateTransactionNo = this.transactionChangeNo;
    }

    public void restoreTransactionAfterException(boolean commit) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        boolean needFixation = this.anycaseFixationNeed && this.fixateNo != this.transactionChangeNo || this.fixateTransactionNo != this.transactionChangeNo;
        this.manager = null;
        this.transaction = null;
        this.lastCheckTime = System.currentTimeMillis();
        if (!this.statements.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append("used by \"").append(this.usedBy).append("\" and has ").append(this.statements.size()).append(" unclosed statement(s):");
            int idx = 0;
            for (AbstractStatement s : this.statements) {
                msg.append("\n\t").append(idx++).append(": ").append(s.getLogMessage());
            }
            Core.logger.log(AsmoLogger.Level.WARN, msg.toString(), null, this);
            for (AbstractStatement s : new ArrayList<AbstractStatement>(this.statements)) {
                s.close();
            }
            Set<AbstractStatement> set = this.statements;
            synchronized (set) {
                this.statements.clear();
            }
        }
        if (this.transactionSupported && needFixation && !this.isProxyConnection) {
            this.hook.beginLongOperation(System.currentTimeMillis(), 2280000L);
            try {
                this.connection.rollback();
                Core.logger.logSql("ROLLBACK " + this.toString(), this);
            }
            catch (SQLException e) {
                this.setDirty();
                Core.logger.error(this + "-ROLLBACK", e);
            }
            finally {
                this.hook.endLongOperation();
            }
        }
        this.hook = STUB_HOOK;
        this.closed = true;
        this.fixateTransactionNo = this.transactionChangeNo;
        this.descriptor.releaseConnection(this);
    }

    final void real_Close() {
        if (this.isProxyConnection) {
            return;
        }
        if (this.connection == null) {
            Core.logger.warn("Connection {} is already really closed", (Object)this);
            return;
        }
        StringBuilder msg = new StringBuilder("disconnecting ");
        msg.append(this.toString()).append(' ');
        if (this.isDirty()) {
            if (this.dirtySqlConsole) {
                msg.append("(used by sqlconsole)");
            } else {
                msg.append("(dirty)");
            }
        }
        msg.append('[');
        this.descriptor.appendPoolInfo(msg);
        msg.append(']');
        Core.logger.log(AsmoLogger.Level.INFO, msg.toString(), null, this);
        if (this.fixateTransactionNo != this.transactionChangeNo) {
            Core.logger.error("\u041e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f{} \u0431\u0435\u0437 \u0432\u044b\u0437\u043e\u0432\u043e\u0432\u0430 commit \u0438\u043b\u0438 rollback", this);
        }
        this.hook.beginLongOperation(System.currentTimeMillis(), 2280000L);
        try {
            Connection c = this.connection;
            this.connection = null;
            c.close();
        }
        catch (SQLException e) {
            Core.logger.error(this + "-CLOSE", e);
            if (Ini.DbKillSession) {
                this.killSessionImpl("\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0411\u0414");
            }
        }
        finally {
            this.hook.endLongOperation();
        }
    }

    @Deprecated
    void killSession(String cause) {
        this.killSessionImpl(cause);
    }

    protected void killSessionImpl(String cause) {
    }

    protected PreparedStatement newPreparedStatement(String comment, String sql) throws SQLException {
        return new PreparedStatement(comment, sql, this.connection.prepareStatement(sql), this);
    }

    protected PreparedStatement newPreparedStatement(String comment, String sql, FetchHint hint) throws SQLException {
        return this.newPreparedStatement(comment, sql);
    }

    public final PreparedStatement prepareStatement(String comment, String sql) throws SQLException {
        if (this.closed || this.connection == null) {
            throw new SQLException(new InformException("\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e").detail(this.toString()));
        }
        try {
            PreparedStatement result = this.newPreparedStatement(comment, sql);
            this.registerStatement(result);
            return result;
        }
        catch (SQLException e) {
            this.setDirty();
            throw e;
        }
    }

    public final PreparedStatement prepareStatement(String comment, String sql, FetchHint hint) throws SQLException {
        if (this.closed || this.connection == null) {
            throw new SQLException(new InformException("\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e").detail(this.toString()));
        }
        try {
            PreparedStatement result = this.newPreparedStatement(comment, sql, hint);
            this.registerStatement(result);
            return result;
        }
        catch (SQLException e) {
            this.setDirty();
            throw e;
        }
    }

    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(CallStack.getCurrentMethodName(1), sql);
    }

    protected Statement newStatement() throws SQLException {
        return new Statement(this, this.connection.createStatement());
    }

    public final Statement createStatement() throws SQLException {
        Statement statement = this.newStatement();
        this.registerStatement(statement);
        return statement;
    }

    protected CallableStatement newCallableStatement(String comment, String sql) throws SQLException {
        return new CallableStatement(comment, sql, this.connection.prepareCall(sql), this);
    }

    public final CallableStatement prepareCall(String comment, String sql) throws SQLException {
        if (this.closed || this.connection == null) {
            throw new SQLException(new InformException("\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e").detail(this.toString()));
        }
        try {
            CallableStatement result = this.newCallableStatement(comment, sql);
            this.registerStatement(result);
            return result;
        }
        catch (SQLException e) {
            this.setDirty();
            throw e;
        }
    }

    public final CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(CallStack.getCurrentMethodName(1), sql);
    }

    public final Plan createExplainPlan(boolean trace, String sqlText) throws SQLException, InformException {
        try {
            return this.newExplainPlan(trace, sqlText);
        }
        catch (SQLException e) {
            this.setDirty();
            throw e;
        }
    }

    protected Plan newExplainPlan(boolean trace, String sqlText) throws SQLException, InformException {
        return null;
    }

    public final Advisor createAdvisor(String sqlText) throws SQLException, InformException {
        try {
            return this.newAdvisor(sqlText);
        }
        catch (SQLException e) {
            this.setDirty();
            throw e;
        }
    }

    protected Advisor newAdvisor(String sqlText) throws SQLException, InformException {
        throw new UnsupportedOperationException("\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0411\u0414");
    }

    protected boolean explainLastSql(String prefix, StringBuilder out) throws SQLException {
        return false;
    }

    protected abstract Connection establishConnection() throws SQLException, InformException;

    @Override
    public double key() {
        return this.descriptor.getNodeId();
    }

    public DbScheme openScheme() {
        return this.openScheme(this.descriptor.getScheme());
    }

    public DbScheme openScheme(String name) {
        return new DbScheme(this, this.jdbcMetadata, name);
    }

    public static int getTotalConnectionCount() {
        return idGenerator.get();
    }

    void notifyStatementExecuted() {
        ++this.transactionChangeNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerStatement(AbstractStatement statement) {
        ++this.transactionChangeNo;
        Set<AbstractStatement> set = this.statements;
        synchronized (set) {
            this.statements.add(statement);
        }
        int cnt = this.statements.size();
        if (cnt % 64 == 0) {
            Core.logger.log(AsmoLogger.Level.WARN, "too many (" + cnt + ") opened statements", null, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterStatement(AbstractStatement statement) {
        Set<AbstractStatement> set = this.statements;
        synchronized (set) {
            this.statements.remove(statement);
        }
    }

    public DataTransaction transaction(TableDataAudit tableDataAudit) throws InformException {
        if (this.transaction == null) {
            this.transaction = new DataTransaction(this, tableDataAudit);
        }
        this.transaction.checkTransaction(tableDataAudit);
        return this.transaction;
    }

    public TableDataAudit getTableDataAudit() {
        if (this.transaction == null) {
            return null;
        }
        return this.transaction.getTableDataAudit();
    }

    public DeleteEngine getDeleteEngine() {
        if (this.transaction == null) {
            return null;
        }
        return this.transaction.getDeleteEngine();
    }

    public void setDeleteEngine(DeleteEngine deleteEngine) {
        if (this.transaction != null) {
            this.transaction.setDeleteEngine(deleteEngine);
        }
    }

    @Override
    public DatabaseConnection connection() throws InformException {
        return this;
    }

    public static boolean isErrorCode(SQLException e, int code) {
        if (e.getErrorCode() == code) {
            return true;
        }
        Throwable c = e.getCause();
        if (c instanceof SQLException) {
            return DatabaseConnection.isErrorCode((SQLException)c, code);
        }
        return false;
    }

    public final SQLException tryGetUniqueIndexConstraintException(SQLException ex) {
        for (Throwable t : ex) {
            if (!(t instanceof SQLException) || !this.isUniqueIndexConstraintException((SQLException)t)) continue;
            return (SQLException)t;
        }
        return null;
    }

    public boolean isUniqueIndexConstraintException(SQLException ex) {
        return false;
    }

    public SQLException prepareException(SQLException e) {
        return e;
    }

    @Override
    public void contextMessage(LogContext.Builder out) {
        out.append("drv", this.id);
    }

    @Override
    public Client client() {
        return null;
    }

    @Override
    public RequestStatistics.Value rqstat() {
        return null;
    }

    @Override
    public SSContext getSSContext() {
        return null;
    }

    void beforeReturnFromPool(String who) {
        this.usedBy = who;
        this.closed = false;
        this.readonly = false;
        this.hasPossibleWriteOperations = false;
    }

    @Override
    public void markAsReadonly() throws IllegalStateException {
        if (this.hasPossibleWriteOperations) {
            throw new IllegalStateException("transaction modified");
        }
        this.readonly = true;
    }

    void possibleWriteOperation() {
        if (this.readonly) {
            throw new IllegalStateException("readonly transaction");
        }
        this.hasPossibleWriteOperations = true;
    }

    public byte[] getPlanContent(ResultSet planResultSet) throws Throwable {
        int i;
        ByteArrayOutputStream planContent = new ByteArrayOutputStream();
        TaggedWriter plan = new TaggedWriter(planContent);
        ResultSetMetaData metadata = planResultSet.getMetaData();
        int columnCount = metadata.getColumnCount();
        block8: for (i = 1; i <= columnCount; ++i) {
            switch (metadata.getColumnType(i)) {
                case -7: 
                case -3: 
                case -2: 
                case 70: 
                case 2000: 
                case 2001: 
                case 2003: 
                case 2004: {
                    continue block8;
                }
                default: {
                    plan.putAnsi(1, metadata.getColumnLabel(i));
                }
            }
        }
        while (planResultSet.next()) {
            block10: for (i = 1; i <= columnCount; ++i) {
                switch (metadata.getColumnType(i)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        double numVal = planResultSet.getDouble(i);
                        if (planResultSet.wasNull()) {
                            plan.putEmpty(2);
                            continue block10;
                        }
                        plan.putAnsi(3, NumberConverter.doubleToString(numVal));
                        continue block10;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        String strVal = planResultSet.getString(i);
                        if (planResultSet.wasNull()) {
                            plan.putEmpty(2);
                            continue block10;
                        }
                        plan.putAnsi(3, strVal);
                        continue block10;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        double dateTime = planResultSet.getDateTime(i);
                        if (planResultSet.wasNull()) {
                            plan.putEmpty(2);
                            continue block10;
                        }
                        plan.putAnsi(3, DateTime.toString(dateTime));
                        continue block10;
                    }
                    default: {
                        plan.putAnsi(3, "<!!!unsupported type!!!>");
                    }
                }
            }
        }
        plan.flush();
        return planContent.toByteArray();
    }

    public boolean isLinkTableExists(SSContext ssContext, int linkTable) throws SQLException {
        switch (linkTable) {
            case 1: {
                int ee = this.ELEMENTS_EXISTS_CACHE;
                if (ee == 0) {
                    ee = this.openScheme().getTable(ssContext, "PHX_ELEMENTS") != null ? 1 : 2;
                    this.ELEMENTS_EXISTS_CACHE = ee;
                }
                return ee == 1;
            }
            case 2: {
                int le = this.LINKS_EXISTS_CACHE;
                if (le == 0) {
                    le = this.openScheme().getTable(ssContext, "PHX_LINKED") != null ? 1 : 2;
                    this.LINKS_EXISTS_CACHE = le;
                }
                return le == 1;
            }
        }
        throw new IllegalArgumentException("linkTable==" + linkTable);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    protected void custom_PreparedStatement_setNull(java.sql.PreparedStatement statement, int parameterIndex, SqlDataType type) throws SQLException {
        statement.setNull(parameterIndex, type.toSqlType());
    }

    public void setAllConstraintsDeferred(SSContext ssContext) throws SQLException {
        this.setPendingDirty();
        this.deferredCheckConstraints = true;
    }

    public BatchInsertEngine createBatchInsertEngine(AbstractConnectionManager connectionManager) throws SQLException {
        return new BatchInsertEngine(connectionManager, this);
    }
}

