/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.adt.DateTime;
import inform.adt.NumberConverter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.GeneratedSqlInfo;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.AbstractStatement;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.Geometry;
import inform.agent.db.types.SqlDataType;
import inform.agent.scripts.SSContext;
import java.io.ByteArrayInputStream;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.Arrays;

public class PreparedStatement
extends AbstractStatement {
    private static final int DEFAULT_PARAM_SIZE = 32;
    private static final int TRUNCATED_STRING_LENGTH = 128;
    private final String sql;
    private final java.sql.PreparedStatement statement;
    private Object[] paramValues;
    private SqlDataType[] paramTypes;
    private int paramValuesCount;
    private int batchCount = 1;
    private String sqlInfo = null;
    private final String logComment;
    private int lastBatchUpdateCount;
    private int hashCode = 0;
    private long lastStartExecTime;
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    public PreparedStatement(String logComment, String sql, java.sql.PreparedStatement stmt, DatabaseConnection connection) {
        super(connection, stmt);
        this.sql = sql;
        this.statement = stmt;
        this.logComment = logComment;
    }

    @Override
    protected java.sql.PreparedStatement statement() {
        return this.statement;
    }

    protected void setParam(int index, Object value, SqlDataType type) {
        int valueHashCode = value == null ? 0 : value.hashCode();
        this.hashCode = (this.hashCode << 3 | this.hashCode >> 29) ^ valueHashCode;
        if (this.batchCount > 1) {
            return;
        }
        if (this.paramValues == null) {
            this.paramValues = new Object[32];
            this.paramTypes = new SqlDataType[32];
        }
        this.paramValuesCount = Math.max(index, this.paramValuesCount);
        --index;
        if (this.paramValuesCount > this.paramValues.length) {
            int newSize = this.paramValues.length * 2;
            if (newSize < this.paramValuesCount) {
                newSize = this.paramValuesCount;
            }
            this.paramValues = Arrays.copyOf(this.paramValues, newSize);
            this.paramTypes = Arrays.copyOf(this.paramTypes, newSize);
        }
        this.paramValues[index] = value;
        this.paramTypes[index] = type;
    }

    public int getParamValuesCount() {
        return this.paramValuesCount;
    }

    public void setSqlInfo(GeneratedSqlInfo info) {
        StringBuilder str = new StringBuilder();
        boolean addComma = false;
        if (info.getUserId() != 0.0) {
            if (addComma) {
                str.append(", ");
            } else {
                addComma = true;
            }
            str.append("u: ").append(NumberConverter.doubleToString(info.getUserId()));
        }
        if (info.getOwnerId() != 0.0) {
            if (addComma) {
                str.append(", ");
            } else {
                addComma = true;
            }
            str.append("script: ").append(NumberConverter.doubleToString(info.getOwnerId()));
        }
        if (info.getTableId() != 0.0) {
            str.append("t:").append(NumberConverter.doubleToString(info.getTableId()));
            addComma = true;
        }
        if (info.getSearchId() != 0.0) {
            if (addComma) {
                str.append(", ");
            } else {
                addComma = true;
            }
            str.append("s:").append(NumberConverter.doubleToString(info.getSearchId()));
        }
        if (info.getUid() != 0) {
            if (addComma) {
                str.append(", ");
            } else {
                addComma = true;
            }
            str.append("uid:").append(info.getUid());
        }
        if (info.getScriptName() != null && !info.getScriptName().isEmpty()) {
            if (addComma) {
                str.append(", ");
            } else {
                addComma = true;
            }
            str.append("name: ").append(info.getScriptName());
        }
        if (addComma) {
            this.sqlInfo = str.toString();
        }
    }

    private static void appendBytes(StringBuilder out, byte[] data) {
        out.append('[').append(data.length).append('x');
        for (int i = 0; i < Math.min(32, data.length); ++i) {
            byte b = data[i];
            out.append(HEX[b >> 4 & 0xF]);
            out.append(HEX[b & 0xF]);
        }
        if (data.length > 32) {
            out.append("...");
        }
        out.append(']');
    }

    private static void appendBytes(StringBuilder out, BlobGhost data) {
        out.append('[').append(data.length).append('x');
        if (data.length > 0) {
            out.append("...");
        }
        out.append(']');
    }

    private static void appendStringTop(StringBuilder out, StringTop value) {
        out.append('[').append(value.length).append(':');
        PreparedStatement.appendString(out, value.top);
        out.append("...]");
    }

    private static void appendString(StringBuilder out, String v) {
        boolean needQuote = false;
        boolean hasSQuote = false;
        boolean hasDQuote = false;
        for (int i = v.length() - 1; i >= 0; --i) {
            char c = v.charAt(i);
            needQuote |= c < ' ' || c == ',' || c == '}';
            hasSQuote |= c == '\'';
            hasDQuote |= c == '\"';
        }
        if (!needQuote) {
            out.append(v);
            return;
        }
        char quote = '\"';
        if (hasDQuote && !hasSQuote) {
            quote = '\'';
        }
        out.append(quote);
        int l = v.length();
        int s = 0;
        for (int i = 0; i < l; ++i) {
            char c = v.charAt(i);
            if (c >= ' ' && c != quote && c != '\\') continue;
            if (i > s) {
                out.append(v, s, i);
            }
            out.append('\\');
            if (c < ' ') {
                out.append((int)c);
            } else {
                out.append(c);
            }
            s = i + 1;
        }
        if (l > s) {
            out.append(v, s, l);
        }
        out.append(quote);
    }

    public String getFullSql() {
        StringBuilder result = new StringBuilder();
        int pcount = 0;
        for (int pos = 0; pos < this.sql.length(); ++pos) {
            char c = this.sql.charAt(pos);
            if (c == '\"') {
                char cc;
                result.append(c);
                ++pos;
                while (pos < this.sql.length() && (cc = this.sql.charAt(pos)) != '\"') {
                    result.append(cc);
                    if (cc == '\\') {
                        result.append(this.sql.charAt(++pos));
                    }
                    ++pos;
                }
                if (pos >= this.sql.length()) continue;
                result.append('\"');
                continue;
            }
            if (c == '\'') {
                char cc;
                result.append(c);
                ++pos;
                while (pos < this.sql.length() && (cc = this.sql.charAt(pos)) != '\'') {
                    result.append(cc);
                    if (cc == '\\') {
                        result.append(this.sql.charAt(++pos));
                    }
                    ++pos;
                }
                if (pos >= this.sql.length()) continue;
                result.append('\'');
                continue;
            }
            if (c == '?') {
                if (pcount < this.paramValuesCount) {
                    Object p;
                    if ((p = this.paramValues[pcount++]) == null) {
                        result.append("null");
                        continue;
                    }
                    if (p instanceof Double) {
                        result.append(NumberConverter.doubleToString((Double)p));
                        continue;
                    }
                    if (p instanceof Timestamp) {
                        result.append(this.connection.getDescriptor().getDatabaseType().caps().c_dateTime2sql(DateTime.fromUnixTime(((Timestamp)p).getTime())));
                        continue;
                    }
                    if (p instanceof String) {
                        result.append(this.connection.getDescriptor().getDatabaseType().caps().c_string2sql((String)p));
                        continue;
                    }
                    result.append(p.toString());
                    continue;
                }
                result.append(c);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    protected void generateLogMessage(StringBuilder msg) {
        if (this.logComment != null) {
            msg.append(this.logComment).append(' ');
        }
        if (this.sqlInfo != null && !this.sqlInfo.isEmpty()) {
            msg.append('[').append(this.sqlInfo).append("] ");
        }
        if (this.batchCount > 1) {
            msg.append("batch ");
        }
        msg.append("\"").append(this.sql).append("\"");
        msg.append(" [hash: ").append(Integer.toHexString(this.hashCode)).append(']');
        if (this.batchCount == 1) {
            if (this.paramValuesCount > 0) {
                int LINE_LENGTH_LIMIT = 80;
                int ml = msg.length();
                if (ml >= 80) {
                    msg.append("\n ");
                }
                int nlpos = ml + 80;
                msg.append(" {");
                String delimiter = "";
                for (int i = 0; i < this.paramValuesCount; ++i) {
                    ml = msg.length();
                    if (ml >= nlpos) {
                        nlpos = ml + 80;
                        msg.append("\n  ");
                    }
                    msg.append(delimiter);
                    PreparedStatement.appendLogParameter(msg, this.paramTypes[i], i + 1, this.paramValues[i]);
                    delimiter = ", ";
                }
                msg.append("}");
            }
        } else {
            msg.append(' ').append(this.batchCount - 1);
            msg.append(" batch sets");
        }
        this.hashCode = 0;
    }

    public static char sqlDataType2char(SqlDataType type) {
        if (type == null) {
            return '!';
        }
        switch (type) {
            case INTEGER: {
                return 'i';
            }
            case DOUBLE: {
                return 'f';
            }
            case STRING: {
                return 's';
            }
            case BLOB: {
                return 'r';
            }
            case DATE_TIME: {
                return 'd';
            }
            case UNICODE: {
                return 'u';
            }
            case BOOLEAN: {
                return 'b';
            }
            case TIMESTAMP: {
                return 't';
            }
            case GEOMETRY: {
                return 'g';
            }
        }
        return '?';
    }

    public static void appendLogParameter(StringBuilder out, SqlDataType type, int index, Object value) {
        out.append(PreparedStatement.sqlDataType2char(type)).append(index).append('@');
        if (value == null) {
            out.append("null");
        } else if (value instanceof Double) {
            out.append(NumberConverter.doubleToString((Double)value));
        } else if (value instanceof Timestamp) {
            out.append(DateTime.toLogString(DateTime.fromUnixTime(((Timestamp)value).getTime())));
        } else if (value instanceof byte[]) {
            PreparedStatement.appendBytes(out, (byte[])value);
        } else if (value instanceof BlobGhost) {
            PreparedStatement.appendBytes(out, (BlobGhost)value);
        } else if (value instanceof StringTop) {
            PreparedStatement.appendStringTop(out, (StringTop)value);
        } else if (value instanceof String) {
            PreparedStatement.appendString(out, (String)value);
        } else {
            out.append(value.toString());
        }
    }

    private static Object[] sliceParameters(Object[] params, int count, boolean truncateStrings) {
        Object[] result = new Object[count];
        for (int i = 0; i < count; ++i) {
            String s;
            Object v = params[i];
            if (v instanceof byte[]) {
                v = new BlobGhost(((byte[])v).length);
            } else if (v instanceof String && (s = (String)v).length() > 128) {
                v = new StringTop(s);
            }
            result[i] = v;
        }
        return result;
    }

    public final ResultSet executeQuery(SSContext ssContext) throws SQLException {
        long startNanoTime;
        this.beforeClose();
        if (Ini.TraceSql) {
            Core.logger.logSql(this.getLogMessage(), this.connection);
        }
        if (Core.logger.getCollectSql()) {
            Core.logger.collectSql(this.connection, this.getFullSql());
        }
        this.beforeExecute(ssContext, this.sql);
        if (this.paramTypes != null && this.paramValues != null) {
            this.rqStat.paramTypes = Arrays.copyOf(this.paramTypes, this.paramValuesCount);
            this.rqStat.paramValues = PreparedStatement.sliceParameters(this.paramValues, this.paramValuesCount, false);
        }
        this.rqStat.comments = this.logComment;
        this.rqStat.sqlInfo = this.sqlInfo;
        this.rqStat.startTimeNano = startNanoTime = System.nanoTime();
        this.rqStat.startTime = this.lastStartExecTime = System.currentTimeMillis();
        this.connection.hook.beginLongOperation(this.lastStartExecTime, this.queryTimeout);
        try {
            ResultSet result = this.newResultSet(this.statement.executeQuery(), this.lastStartExecTime);
            result.startFetchTime = System.currentTimeMillis();
            this.rqStat.executeDurationNano = System.nanoTime() - startNanoTime;
            this.longSQLMessage(this.rqStat.executeDurationNano / 1000000L, Ini.TraceSql, false);
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            this.connection.setDirty();
            SQLException generatedError = this.generateError(e);
            this.rqStat.exception = generatedError;
            throw generatedError;
        }
        finally {
            long executeNanoTime;
            this.connection.hook.endLongOperation();
            this.rqStat.executeDurationNano = executeNanoTime = System.nanoTime() - startNanoTime;
            this.statSql(executeNanoTime / 1000000L);
        }
    }

    public final int executeUpdate(SSContext ssContext) throws SQLException {
        long startNanoTime;
        this.beforeClose();
        this.connection.possibleWriteOperation();
        if (Ini.TraceSql) {
            Core.logger.logSql(this.getLogMessage(), this.connection);
        }
        if (Core.logger.getCollectSql()) {
            Core.logger.collectSql(this.connection, this.getFullSql());
        }
        this.beforeExecute(ssContext, this.sql);
        if (this.paramTypes != null && this.paramValues != null) {
            this.rqStat.paramTypes = Arrays.copyOf(this.paramTypes, this.paramValuesCount);
            this.rqStat.paramValues = PreparedStatement.sliceParameters(this.paramValues, this.paramValuesCount, true);
        }
        this.rqStat.comments = this.logComment;
        this.rqStat.sqlInfo = this.sqlInfo;
        this.rqStat.startTimeNano = startNanoTime = System.nanoTime();
        this.rqStat.startTime = this.lastStartExecTime = System.currentTimeMillis();
        this.connection.hook.beginLongOperation(this.lastStartExecTime, this.queryTimeout);
        try {
            long nanoTime;
            int result = this.statement.executeUpdate();
            if (this.isLogDangerSQL) {
                this.logDangerSql();
            }
            this.rqStat.executeDurationNano = nanoTime = System.nanoTime() - startNanoTime;
            this.longSQLMessage(nanoTime / 1000000L, Ini.TraceSql, true);
            this.statRMod(result);
            if (result < 0 && (result = this.statement.getUpdateCount()) < 0) {
                result = 0;
            }
            this.rqStat.recordCount = result;
            int n = result;
            return n;
        }
        catch (SQLException e) {
            this.connection.setDirty();
            SQLException generatedError = this.generateError(e);
            this.rqStat.exception = generatedError;
            throw generatedError;
        }
        finally {
            long executeNanoTime;
            this.connection.hook.endLongOperation();
            this.rqStat.executeDurationNano = executeNanoTime = System.nanoTime() - startNanoTime;
            this.statSql(executeNanoTime / 1000000L);
        }
    }

    public final int execute(SSContext ssContext) throws SQLException {
        long startNanoTime;
        this.beforeClose();
        this.connection.possibleWriteOperation();
        if (Ini.TraceSql) {
            Core.logger.logSql(this.getLogMessage(), this.connection);
        }
        if (Core.logger.getCollectSql()) {
            Core.logger.collectSql(this.connection, this.getFullSql());
        }
        this.beforeExecute(ssContext, this.sql);
        if (this.paramTypes != null && this.paramValues != null) {
            this.rqStat.paramTypes = Arrays.copyOf(this.paramTypes, this.paramValuesCount);
            this.rqStat.paramValues = PreparedStatement.sliceParameters(this.paramValues, this.paramValuesCount, false);
        }
        this.rqStat.comments = this.logComment;
        this.rqStat.sqlInfo = this.sqlInfo;
        this.rqStat.startTimeNano = startNanoTime = System.nanoTime();
        this.rqStat.startTime = this.lastStartExecTime = System.currentTimeMillis();
        this.connection.hook.beginLongOperation(this.lastStartExecTime, this.queryTimeout);
        try {
            long nanoTime;
            int uc = -1;
            boolean result = this.statement.execute();
            if (!result && this.isLogDangerSQL) {
                this.logDangerSql();
            }
            this.rqStat.executeDurationNano = nanoTime = System.nanoTime() - startNanoTime;
            this.longSQLMessage(nanoTime / 1000000L, Ini.TraceSql, true);
            if (!result) {
                uc = this.statement.getUpdateCount();
                this.rqStat.recordCount = uc;
                this.statRMod(uc);
            }
            int n = uc;
            return n;
        }
        catch (SQLException e) {
            this.connection.setDirty();
            SQLException generatedError = this.generateError(e);
            this.rqStat.exception = generatedError;
            throw generatedError;
        }
        finally {
            long executeNanoTime;
            this.connection.hook.endLongOperation();
            this.rqStat.executeDurationNano = executeNanoTime = System.nanoTime() - startNanoTime;
            this.statSql(executeNanoTime / 1000000L);
        }
    }

    public void setNull(int parameterIndex, SqlDataType type) throws SQLException {
        this.connection.custom_PreparedStatement_setNull(this.statement, parameterIndex, type);
        this.setParam(parameterIndex, null, type);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.statement.setBoolean(parameterIndex, x);
        this.setParam(parameterIndex, x, SqlDataType.BOOLEAN);
    }

    public void setGeometry(int parameterIndex, Geometry x) throws SQLException {
        throw new UnsupportedOperationException("\u0422\u0438\u043f \"\u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u0421\u0423\u0411\u0414");
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.statement.setInt(parameterIndex, x);
        this.setParam(parameterIndex, x, SqlDataType.INTEGER);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.statement.setDouble(parameterIndex, x);
        this.setParam(parameterIndex, x, SqlDataType.DOUBLE);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.statement.setString(parameterIndex, x);
        this.setParam(parameterIndex, x, SqlDataType.STRING);
    }

    public void setNString(int parameterIndex, String x) throws SQLException {
        this.statement.setNString(parameterIndex, x);
        this.setParam(parameterIndex, x, SqlDataType.UNICODE);
    }

    public void setBlob(int parameterIndex, byte[] x) throws SQLException {
        this.statement.setBytes(parameterIndex, x);
        this.setParam(parameterIndex, x, SqlDataType.BLOB);
    }

    public void setBlob(int parameterIndex, byte[] x, int length) throws SQLException {
        if (x.length == length) {
            this.setBlob(parameterIndex, x);
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(x, 0, length);
            this.statement.setBlob(parameterIndex, in, length);
            this.setParam(parameterIndex, x, SqlDataType.BLOB);
        }
    }

    public void setBlob(int parameterIndex, byte[] x, int offset, int length) throws SQLException {
        if (offset == 0 && x.length == length) {
            this.setBlob(parameterIndex, x);
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(x, offset, length);
            this.statement.setBlob(parameterIndex, in, length);
            this.setParam(parameterIndex, x, SqlDataType.BLOB);
        }
    }

    public void setDateTime(int parameterIndex, double x) throws SQLException {
        this.setTimestamp(parameterIndex, DateTime.toSqlTime(x));
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.statement.setTimestamp(parameterIndex, x);
        this.setParam(parameterIndex, x, SqlDataType.TIMESTAMP);
    }

    private void clearInternalParams() {
        this.paramValuesCount = 0;
        if (this.paramValues != null) {
            Arrays.fill(this.paramValues, null);
        }
    }

    public void clearParameters() throws SQLException {
        this.statement.clearParameters();
        this.clearInternalParams();
    }

    public void addBatch() throws SQLException {
        this.statement.addBatch();
        this.clearInternalParams();
        ++this.batchCount;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.statement.getParameterMetaData();
    }

    public ResultSet getResultSet() throws SQLException {
        java.sql.ResultSet rs = this.statement.getResultSet();
        if (rs == null) {
            return null;
        }
        ResultSet result = this.newResultSet(rs, this.lastStartExecTime);
        result.startFetchTime = System.currentTimeMillis();
        return result;
    }

    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    public void clearBatch() throws SQLException {
        try {
            this.statement.clearBatch();
            this.batchCount = 1;
        }
        catch (SQLException e) {
            this.connection.setDirty();
            throw new SQLException(e.toString(), this.getLogMessage(), e);
        }
    }

    public void setTableDesc(TableDescriptor tableDesc) {
        this.tableDescriptor = tableDesc;
    }

    public int getLastBatchUpdateCount() {
        return this.lastBatchUpdateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] executeBatch(SSContext ssContext) throws SQLException {
        long startNanoTime;
        this.beforeClose();
        this.connection.possibleWriteOperation();
        if (Ini.TraceSql) {
            Core.logger.logSql(this.getLogMessage(), this.connection);
        }
        if (Core.logger.getCollectSql()) {
            Core.logger.collectSql(this.connection, this.getFullSql());
        }
        this.beforeExecute(ssContext, this.sql);
        if (this.paramTypes != null && this.paramValues != null) {
            this.rqStat.paramTypes = Arrays.copyOf(this.paramTypes, this.paramValuesCount);
            this.rqStat.paramValues = PreparedStatement.sliceParameters(this.paramValues, this.paramValuesCount, false);
        }
        this.rqStat.comments = this.logComment;
        this.rqStat.sqlInfo = this.sqlInfo;
        this.rqStat.startTimeNano = startNanoTime = System.nanoTime();
        this.rqStat.startTime = this.lastStartExecTime = System.currentTimeMillis();
        this.connection.hook.beginLongOperation(this.lastStartExecTime, this.queryTimeout);
        try {
            int[] r = this.statement.executeBatch();
            DatabaseCaps caps = this.connection.descriptor.getDatabaseType().caps();
            int bacthCount = 0;
            try {
                bacthCount = this.lastBatchUpdateCount = caps.calculateUpdatesCount(r, this.statement);
                this.rqStat.recordCount = bacthCount;
            }
            finally {
                if (this.isLogDangerSQL) {
                    this.logDangerSql(bacthCount);
                }
            }
            if (this.lastBatchUpdateCount > 0) {
                this.statRMod(this.lastBatchUpdateCount);
            }
            int[] nArray = r;
            return nArray;
        }
        catch (SQLException e) {
            this.connection.setDirty();
            SQLException generatedError = this.generateError(e);
            this.rqStat.exception = generatedError;
            throw generatedError;
        }
        finally {
            long executeNanoTime;
            this.connection.hook.endLongOperation();
            this.rqStat.executeDurationNano = executeNanoTime = System.nanoTime() - startNanoTime;
            this.statSql(executeNanoTime / 1000000L);
        }
    }

    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    protected ResultSet newResultSet(java.sql.ResultSet rs, long startTime) {
        return new ResultSet(rs, this, startTime);
    }

    static class StringTop {
        final int length;
        final String top;

        StringTop(String value) {
            this.length = value.length();
            this.top = value.substring(0, 128);
        }
    }

    static class BlobGhost {
        final int length;

        BlobGhost(int length) {
            this.length = length;
        }
    }
}

