/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.h2.schema;

import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.h2.Connection;
import inform.agent.db.connect.h2.schema.Table;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import java.sql.DatabaseMetaData;

public class Scheme
extends DbScheme {
    public Scheme(String name, Connection connection, DatabaseMetaData metaData) {
        super(connection, metaData, name);
    }

    @Override
    protected DbTable newTableObject(String name) {
        return new Table(name, this);
    }

    @Override
    public String ct2sql(DataType type, FieldDescriptor.BlobRawType brt, int size, boolean keyable) {
        switch (type) {
            case DIRECTORY: 
            case METATREE_NODE: 
            case PRIMARY_KEY: {
                return "bigint";
            }
            case FLOAT: 
            case INTERVAL: {
                return "decfloat";
            }
            case INTEGER: {
                return "integer";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case STRING: 
            case UNICODE: {
                return "varchar(" + size + ")";
            }
            case DATE_TIME: {
                return "timestamp";
            }
            case BLOB: {
                if (brt == FieldDescriptor.BlobRawType.TEXT) {
                    return "clob";
                }
                return "blob";
            }
            case FILE: {
                return "varchar(256)";
            }
            case GEOMETRY: {
                return "geometry";
            }
        }
        return super.ct2sql(type, brt, size, keyable);
    }

    @Override
    public String toCaseIfNeed(String name) {
        if (Strings.startsWith(name, '\"')) {
            return name;
        }
        return name.toUpperCase();
    }
}

