/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.mssql.schema;

import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.Statement;
import inform.agent.db.connect.mssql.schema.Table;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

class Column
extends DbColumn {
    Column(Table table, String name, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable) {
        super(name, table);
        this.type = type;
        this.blobRawType = brt;
        this.size = type == DataType.UNICODE ? size / 2 : size;
        this.nullable = nullable;
    }

    @Override
    public void internal_setType(SSContext ssContext, Statement statement, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable, boolean keyable, FieldDescriptor fd) throws SQLException {
        StringBuilder sql = new StringBuilder("ALTER TABLE ");
        sql.append(this.table.fullName()).append(" ALTER COLUMN ").append(this.name());
        sql.append(' ').append(this.table.getParent().ct2sql(type, brt, size, keyable));
        this.scheme().columnDefValue(fd, sql, false);
        if (this.nullable != nullable) {
            if (!nullable) {
                sql.append(" NOT");
            }
            sql.append(" NULL");
        }
        try {
            statement.execute(ssContext, sql.toString());
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1439) {
                throw new SQLFeatureNotSupportedException(e);
            }
            if (e.getErrorCode() == 22858) {
                throw new SQLFeatureNotSupportedException(e);
            }
            throw e;
        }
    }

    @Override
    public void internal_drop(SSContext ssContext, Statement statement) throws SQLException {
        if (this.isForeignKey() && !Strings.isVoid(this.foreignKeyName)) {
            statement.execute(ssContext, "ALTER TABLE " + this.table.fullName() + " DROP CONSTRAINT " + this.foreignKeyName);
        }
        statement.execute(ssContext, "ALTER TABLE " + this.table.fullName() + " DROP COLUMN " + this.name());
    }

    @Override
    public void internal_rename(SSContext ssContext, Statement statement, String to) throws SQLException {
        statement.execute(ssContext, String.format("EXEC sp_rename \"%s\", %s, 'COLUMN'", this.fullName(), to));
    }
}

