/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.oracle;

import inform.adt.DateTime;
import inform.adt.Memory;
import inform.agent.db.connect.AbstractStatement;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.oracle.BlobStream;
import inform.agent.db.connect.oracle.Connection;
import inform.agent.db.connect.oracle.ResultSet;
import inform.agent.db.types.SqlDataType;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import oracle.sql.DATE;

class CallableStatement
extends inform.agent.db.connect.CallableStatement {
    private final OracleCallableStatement statement;

    CallableStatement(String comment, String sql, OracleCallableStatement statement, Connection connection) {
        super(comment, sql, (java.sql.CallableStatement)statement, (DatabaseConnection)connection);
        this.statement = statement;
    }

    @Override
    protected ResultSet newResultSet(java.sql.ResultSet rs, long startTime) {
        return new ResultSet((OracleResultSet)rs, (AbstractStatement)this, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBlobBytes(int idx) throws SQLException {
        Blob blob = this.statement.getBlob(idx);
        try {
            byte[] byArray = blob == null ? null : blob.getBytes(1L, (int)blob.length());
            return byArray;
        }
        finally {
            if (blob != null && !(blob instanceof BLOB)) {
                blob.free();
            }
        }
    }

    @Override
    public BlobStream getBlobStream(int idx) throws SQLException {
        Blob blob = this.statement.getBlob(idx);
        return blob == null ? null : new BlobStream(blob);
    }

    @Override
    public double getDateTime(int idx) throws SQLException {
        DATE date = this.statement.getDATE(idx);
        if (date == null) {
            return 0.0;
        }
        byte[] bytes = date.shareBytes();
        return DateTime.createDateTime((bytes[0] - 100) * 100 + (bytes[1] & 0xFF) - 100, bytes[2], bytes[3], bytes[4] - 1, bytes[5] - 1, bytes[6] - 1, 0);
    }

    @Override
    public void setNull(int parameterIndex, SqlDataType type) throws SQLException {
        if (type == SqlDataType.GEOMETRY) {
            this.statement.setNull(parameterIndex, 2002, "MDSYS.SDO_GEOMETRY");
            this.setParam(parameterIndex, null, SqlDataType.GEOMETRY);
        } else {
            super.setNull(parameterIndex, type);
        }
    }

    @Override
    public void setBlob(int parameterIndex, byte[] x, int length) throws SQLException {
        this.setBlob(parameterIndex, Memory.trim(x, length));
    }

    @Override
    public final void setDateTime(int parameterIndex, double x) throws SQLException {
        Calendar cal = DateTime.toCalendar(x);
        int cent = cal.get(1) / 100;
        byte[] bytes = new byte[]{(byte)(cent + 100), (byte)(cal.get(1) - cent * 100 + 100), (byte)(cal.get(2) + 1), (byte)cal.get(5), (byte)(cal.get(11) + 1), (byte)(cal.get(12) + 1), (byte)(cal.get(13) + 1)};
        DATE date = new DATE(bytes);
        this.statement.setDATE(parameterIndex, date);
        this.setParam(parameterIndex, date, SqlDataType.DATE_TIME);
    }

    @Override
    public final void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.statement.setDATE(parameterIndex, new DATE(x));
        this.setParam(parameterIndex, x, SqlDataType.TIMESTAMP);
    }
}

