/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.oracle;

import inform.adt.DateTime;
import inform.adt.Memory;
import inform.adt.TimeInfo;
import inform.agent.db.connect.AbstractStatement;
import inform.agent.db.connect.oracle.Connection;
import inform.agent.db.connect.oracle.ResultSet;
import inform.agent.db.types.SqlDataType;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.DATE;

public class PreparedStatement
extends inform.agent.db.connect.PreparedStatement {
    private final OraclePreparedStatement statement;
    private TimeInfo tempTimeInfo;

    PreparedStatement(String logComment, String sql, OraclePreparedStatement statement, Connection connection) {
        super(logComment, sql, (java.sql.PreparedStatement)statement, connection);
        this.statement = statement;
    }

    @Override
    protected ResultSet newResultSet(java.sql.ResultSet rs, long startTime) {
        return new ResultSet((OracleResultSet)rs, (AbstractStatement)this, startTime);
    }

    @Override
    public void setNull(int parameterIndex, SqlDataType type) throws SQLException {
        switch (type) {
            case GEOMETRY: {
                this.statement.setNull(parameterIndex, 2002, "MDSYS.SDO_GEOMETRY");
                this.setParam(parameterIndex, null, type);
                break;
            }
            case BOOLEAN: {
                this.statement.setNull(parameterIndex, 4);
                this.setParam(parameterIndex, null, type);
                break;
            }
            default: {
                super.setNull(parameterIndex, type);
            }
        }
    }

    @Override
    public void setBlob(int parameterIndex, byte[] x, int length) throws SQLException {
        this.setBlob(parameterIndex, Memory.trim(x, length));
    }

    @Override
    public final void setDateTime(int parameterIndex, double x) throws SQLException {
        if (this.tempTimeInfo == null) {
            this.tempTimeInfo = new TimeInfo();
        }
        DateTime.toTimeInfo(x, this.tempTimeInfo);
        int cent = this.tempTimeInfo.year / 100;
        byte[] tempDateBytes = new byte[]{(byte)(cent + 100), (byte)(this.tempTimeInfo.year - cent * 100 + 100), (byte)this.tempTimeInfo.month, (byte)this.tempTimeInfo.day, (byte)(this.tempTimeInfo.hour + 1), (byte)(this.tempTimeInfo.minute + 1), (byte)(this.tempTimeInfo.second + 1)};
        DATE date = new DATE(tempDateBytes);
        this.statement.setDATE(parameterIndex, date);
        this.setParam(parameterIndex, date, SqlDataType.DATE_TIME);
    }

    @Override
    public final void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.statement.setDATE(parameterIndex, new DATE(x));
        this.setParam(parameterIndex, x, SqlDataType.TIMESTAMP);
    }
}

