/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.oracle.schema;

import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbColumnable;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

class Column
extends DbColumn {
    Column(DbColumnable table, String name, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable) {
        super(name, table);
        this.type = type;
        this.blobRawType = brt;
        this.size = type == DataType.UNICODE ? size / 2 : size;
        this.nullable = nullable;
    }

    @Override
    public void internal_setType(SSContext ssContext, Statement statement, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable, boolean keyable, FieldDescriptor fd) throws SQLException {
        StringBuilder sql = new StringBuilder("ALTER TABLE ");
        sql.append(this.table.fullName()).append(" MODIFY (").append(this.name());
        sql.append(' ').append(this.table.getParent().ct2sql(type, brt, size, keyable));
        this.scheme().columnDefValue(fd, sql, false);
        if (this.nullable != nullable) {
            if (!nullable) {
                sql.append(" NOT");
            }
            sql.append(" NULL");
        }
        sql.append(')');
        try {
            statement.execute(ssContext, sql.toString());
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1439) {
                throw new SQLFeatureNotSupportedException(e);
            }
            if (DatabaseConnection.isErrorCode(e, 1440)) {
                throw new SQLFeatureNotSupportedException(e);
            }
            if (e.getErrorCode() == 22858) {
                throw new SQLFeatureNotSupportedException(e);
            }
            throw e;
        }
    }

    @Override
    public void internal_drop(SSContext ssContext, Statement statement) throws SQLException {
        if (this.isForeignKey() && !Strings.isVoid(this.foreignKeyName)) {
            statement.execute(ssContext, "ALTER TABLE " + this.table.fullName() + " DROP CONSTRAINT " + this.foreignKeyName);
        }
        statement.execute(ssContext, "ALTER TABLE " + this.table.fullName() + " DROP (" + this.name() + ")");
    }

    @Override
    public void internal_rename(SSContext ssContext, Statement statement, String to) throws SQLException {
        statement.execute(ssContext, "ALTER TABLE " + this.table.fullName() + " RENAME COLUMN " + this.name() + " TO " + to);
    }

    @Override
    protected boolean isTypesCompatible(DataType type1, DataType type2) {
        if (type1 == DataType.BOOLEAN && type2 == DataType.FLOAT) {
            return true;
        }
        return super.isTypesCompatible(type1, type2);
    }
}

