/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.expr;

import inform.agent.db.TableDescriptor;
import inform.agent.db.expr.DVBinaryOpEvalutor;
import inform.agent.db.expr.DVEvaluator;
import inform.agent.db.expr.DVFieldEvaliator;
import inform.agent.db.expr.DVFunctionEvaluator;
import inform.agent.db.expr.DVIgnoreEvaluator;
import inform.agent.db.expr.DVUnaryOpEvaluator;
import inform.agent.db.expr.DVValueEvaluator;
import inform.agent.db.utils.FieldLocation;
import inform.agent.expr.ConstantTerm;
import inform.agent.expr.Expression;
import inform.agent.expr.FieldTerm;
import inform.agent.expr.FunctionTerm;
import inform.agent.expr.OperationTerm;
import inform.agent.expr.Term;
import inform.agent.expr.ValueTerm;
import inform.agent.scripts.Constants;
import inform.agent.scripts.ParametersList;
import java.util.ArrayList;

public class DVExpression
extends Expression<DVEvaluator> {
    private final TableDescriptor table;
    private final ArrayList<FieldLocation> path;
    private Constants constants;

    public DVExpression(ArrayList<FieldLocation> path, double userId) {
        super(null);
        this.table = TableDescriptor.get(path.get((int)0).tableId);
        this.path = path;
        this.constants = new Constants(userId);
    }

    @Override
    public Constants getConstants() {
        return this.constants;
    }

    @Override
    public ParametersList getParameters() {
        throw new IllegalStateException();
    }

    @Override
    public DVEvaluator createIgnored() {
        return new DVIgnoreEvaluator();
    }

    @Override
    public DVEvaluator createNOP(DVEvaluator left, DVEvaluator right) {
        throw new IllegalStateException();
    }

    @Override
    public DVEvaluator createEvaluator(Term term) {
        switch (term.getToken()) {
            case field: {
                return new DVFieldEvaliator((FieldTerm)term, this.table, this.path);
            }
            case globalConst: {
                return new DVValueEvaluator((ConstantTerm)term);
            }
            case value: {
                return new DVValueEvaluator((ValueTerm)term);
            }
            case functionRoundTo: {
                return new DVFunctionEvaluator((FunctionTerm)term);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public DVEvaluator createEvaluator(Term term, DVEvaluator arg) {
        switch (term.getToken()) {
            case add: 
            case sub: {
                return new DVUnaryOpEvaluator((OperationTerm)term, arg);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public DVEvaluator createEvaluator(Term term, DVEvaluator left, DVEvaluator right) {
        switch (term.getToken()) {
            case add: 
            case sub: 
            case mul: 
            case div: 
            case mod: {
                return new DVBinaryOpEvalutor((OperationTerm)term, left, right);
            }
        }
        throw new IllegalStateException();
    }
}

