/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.expr;

import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.expr.DVEvaluator;
import inform.agent.db.utils.DirectoriesCollection;
import inform.agent.expr.Expression;
import inform.agent.expr.OperationTerm;
import java.io.IOException;

public class DVUnaryOpEvaluator
extends DVEvaluator {
    private final DVEvaluator operand;

    public DVUnaryOpEvaluator(OperationTerm term, DVEvaluator operand) {
        super(term);
        this.operand = operand;
    }

    @Override
    public void afterLoad(DirectoriesCollection collection) throws IOException {
        if (this.isIgnored()) {
            return;
        }
        this.operand.afterLoad(collection);
    }

    @Override
    public void generate(StringBuilder sql, DatabaseCaps caps) throws Exception {
        if (this.isIgnored()) {
            return;
        }
        if (this.term.getToken() == Expression.Token.sub) {
            sql.append('-');
        }
        this.operand.generate(sql, caps);
    }

    @Override
    public boolean isStringType() throws Exception {
        return this.operand.isStringType();
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.operand.isIgnored();
    }
}

