/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.TimeZoneHost;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.MultitypeArrayGetter;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.scripts.format.FormatManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public abstract class AbstractDataRequest
extends Request {
    protected static final int TAG_RESULT_ROWS_METADATA = 6;
    private static final int TAG_RESULT_COLUMN_COUNT = 1;
    protected static final int TAG_RESULT_COLUMN_NAME = 2;
    protected static final int TAG_RESULT_COLUMN_DATA_TYPE = 3;
    protected static final int TAG_RESULT_COLUMN_ID = 4;
    protected static final int TAG_RESULT_ROWS_CONTENT = 7;
    protected static final int TAG_RESULT_ROW = 1;
    protected static final int TAG_PARAMETER_NULL = 10;
    protected static final int TAG_PARAMETER_INTEGER = 11;
    protected static final int TAG_PARAMETER_DOUBLE = 12;
    protected static final int TAG_PARAMETER_DATE_TIME = 13;
    protected static final int TAG_PARAMETER_STRING = 14;
    protected static final int TAG_PARAMETER_DATA_TYPE = 15;
    protected static final int TAG_PARAMETER_TYPE = 16;
    protected static final int TAG_RESULT_WARNING = 20;
    protected static final int TAG_UPDATE_COUNT = 21;

    public AbstractDataRequest(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    protected int writeResultSet(TaggedWriter writer, ResultSet rs, double tableId, int[] formats) throws Exception {
        int MAX_ROWS_CONTENT_SIZE = 0xFA00000;
        this.idle();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TaggedWriter wrt = new TaggedWriter(out);
        ResultSetMetaData rsm = rs.getMetaData();
        int cc = rsm.getColumnCount();
        wrt.putInt32(1, cc);
        DataType[] types = new DataType[cc];
        for (int i = 1; i <= cc; ++i) {
            wrt.putAnsi(2, rsm.getColumnLabel(i));
            types[i - 1] = DataType.getDataTypeBySqlTypeId(rsm.getColumnType(i));
            wrt.putInt32(3, types[i - 1].getTypeId());
        }
        wrt.flush();
        writer.putRaw(6, out);
        this.idle();
        out = new ByteArrayOutputStream();
        wrt = new TaggedWriter(out);
        int recordCount = 0;
        while (rs.next()) {
            ++recordCount;
            wrt.putEmpty(1);
            for (int i = 1; i <= cc; ++i) {
                AbstractDataRequest.writeParamValue(wrt, rs, i, types[i - 1], formats != null ? formats[i - 1] : 0, this, tableId);
            }
            if (out.size() > 0xFA00000) {
                throw new InformException("\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439");
            }
            this.idle();
        }
        wrt.flush();
        writer.putRaw(7, out);
        return recordCount;
    }

    protected static void writeParamValue(TaggedWriter writer, MultitypeArrayGetter getter, int idx, DataType type, int format, TimeZoneHost timeZoneHost, double tableId) throws Exception {
        try {
            switch (type.toSqlDataType()) {
                case BOOLEAN: {
                    boolean b = getter.getBoolean(idx);
                    if (getter.wasNull()) {
                        writer.putEmpty(10);
                        break;
                    }
                    writer.putInt32(11, b ? 1 : 0);
                    break;
                }
                case INTEGER: {
                    int i = getter.getInt(idx);
                    if (getter.wasNull()) {
                        writer.putEmpty(10);
                        break;
                    }
                    writer.putInt32(11, i);
                    break;
                }
                case DOUBLE: {
                    double f = getter.getDouble(idx);
                    if (getter.wasNull()) {
                        writer.putEmpty(10);
                        break;
                    }
                    if (FormatManager.hasTime(format)) {
                        writer.putDouble(12, FormatManager.fromServerTime(f, format, timeZoneHost));
                        break;
                    }
                    writer.putDouble(12, f);
                    break;
                }
                case DATE_TIME: 
                case TIMESTAMP: {
                    double d = getter.getDateTime(idx);
                    if (getter.wasNull()) {
                        writer.putEmpty(10);
                        break;
                    }
                    writer.putDouble(13, d);
                    break;
                }
                case STRING: 
                case UNICODE: {
                    String s = getter.getString(idx);
                    if (getter.wasNull()) {
                        writer.putEmpty(10);
                        break;
                    }
                    writer.putAnsi(14, s);
                    break;
                }
                default: {
                    writer.putEmpty(10);
                    break;
                }
            }
        }
        catch (SQLException e) {
            String cn;
            try {
                cn = getter.getColumnLabel(idx);
            }
            catch (Throwable t) {
                Core.logger.error(null, t);
                cn = null;
            }
            if (cn == null && tableId == 0.0) {
                throw e;
            }
            StringBuilder tmp = new StringBuilder("\u041f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
            tmp.append(tableId != 0.0 ? " \u043f\u043e\u043b\u044f" : " \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430");
            if (cn != null) {
                tmp.append(" \"").append(cn).append('\"');
            }
            if (tableId != 0.0) {
                tmp.append(" \u0442\u0430\u0431\u043b\u0438\u0446\u044b (ID:").append((long)tableId).append(')');
            }
            tmp.append(" \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: ").append(e.getMessage());
            throw new SQLException(tmp.toString(), e);
        }
    }

    protected static TableDescriptor checkTable(double tableId) throws InformException {
        if (tableId == 0.0) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u0430");
        }
        TableDescriptor td = TableDescriptor.get(tableId);
        if (td.getDbId() == 0.0) {
            throw new IllegalArgumentException("\u0423 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0431\u0430\u0437\u0430 \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        return td;
    }
}

