/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.GeneratedSql;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.request.AbstractDataRequest;
import inform.agent.db.types.DataType;
import inform.agent.mtd.nodes.FindNode;
import inform.agent.mtd.nodes.Node;
import java.sql.ResultSetMetaData;

public class ExecuteSearch
extends AbstractDataRequest {
    public ExecuteSearch(RequestHeader rq) {
        super(rq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        SqlGenerator sqlGenerator = new SqlGenerator(this, this);
        TaggedReader reader = this.createRequestContentReader();
        double tableId = 0.0;
        double debugNodeId = this.getNodeID();
        SqlGenerator.Method generationMethod = SqlGenerator.Method.DEFAULT;
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 5: {
                    tableId = reader.getDouble();
                    sqlGenerator.setTableId(tableId);
                    break;
                }
                case 15: {
                    sqlGenerator.getParameters().load(reader.getRaw());
                    break;
                }
                case 14: {
                    byte[] bytes = reader.getRaw();
                    generationMethod = SqlGenerator.extractSearchGenerationMethod(bytes);
                    FindNode.Descriptor fd = new FindNode.Descriptor(bytes);
                    tableId = fd.getRootTableId();
                    sqlGenerator.setSearchContent(bytes);
                }
            }
        }
        Object node = this.getNode(tableId);
        this.checkAccess((Node)node, 0x4000000);
        TableDescriptor td = ExecuteSearch.checkTable(tableId);
        GeneratedSql generatedSql = sqlGenerator.getGeneratedSql(generationMethod, -500);
        if (generatedSql.isHasError()) {
            throw new InformException(generatedSql.getError()).detail(generatedSql.getErrorDetailing());
        }
        if (debugNodeId == 0.0) {
            debugNodeId = tableId;
        }
        ConnectionManager cm = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:ExecuteSearch");
        try {
            DatabaseConnection connection = cm.getConnection(td.getDbId(), "rq:ExecuteSearch");
            try (PreparedStatement statement = connection.prepareStatement(generatedSql.getSqlText());){
                statement.setSqlInfo(generatedSql);
                generatedSql.setParametersTo(statement);
                int recordCount = 0;
                try (ResultSet rs = statement.executeQuery(null);){
                    int[] formats = null;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    TaggedWriter writer = new TaggedWriter(out);
                    ResultSetMetaData rsm = rs.getMetaData();
                    int cc = rsm.getColumnCount();
                    DataType[] types = new DataType[cc];
                    formats = new int[cc];
                    ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                    TaggedWriter wrt = new TaggedWriter(tmp);
                    for (int i = 1; i <= cc; ++i) {
                        String n = rsm.getColumnLabel(i);
                        FieldDescriptor fd = td.getField(n);
                        if (fd != null) {
                            String idn = fd.getIdent();
                            wrt.putAnsi(2, Strings.isVoid(idn) ? n : idn);
                            wrt.putInt32(4, fd.getId());
                            formats[i - 1] = fd.getFormat();
                        } else {
                            wrt.putAnsi(2, n);
                        }
                        DataType ft = DataType.getDataTypeBySqlTypeId(rsm.getColumnType(i));
                        wrt.putInt32(3, ft.getTypeId());
                        types[i - 1] = ft;
                    }
                    writer.putRaw(6, tmp);
                    ByteArrayOutputStream tmp2 = new ByteArrayOutputStream();
                    TaggedWriter wrt2 = new TaggedWriter(tmp2);
                    while (rs.next()) {
                        ++recordCount;
                        wrt2.putEmpty(1);
                        for (int i = 0; i < types.length; ++i) {
                            ExecuteSearch.writeParamValue(wrt2, rs, i + 1, types[i], formats[i], this, debugNodeId);
                        }
                        this.idle();
                    }
                    writer.putRaw(7, tmp2);
                    writer.flush();
                    int dataSize = out.size();
                    this.sendResult(out.internalBuffer(), out.size());
                    if (recordCount > 30000 || dataSize > 0x4000000) {
                        Core.logger.warn("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0431\u043e\u043b\u044c\u0448\u043e\u0433\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u0434\u0430\u043d\u043d\u044b\u0445: {} \u0437\u0430\u043f\u0438\u0441\u0435\u0439, {} \u0431\u0430\u0439\u0442", (Object)recordCount, (Object)dataSize);
                    }
                }
            }
        }
        finally {
            cm.release();
        }
    }
}

