/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.RequestHeader;
import inform.agent.db.SqlGenerator;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.request.AbstractDataRequest;
import inform.agent.db.types.DataType;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.FindNode;
import java.sql.Timestamp;
import java.util.ArrayList;

public class ExecuteSql
extends AbstractDataRequest {
    private static final int TAG_ESQL_COMMAND = 1;
    private static final int TAG_ESQL_FIND_ID = 2;
    private static final int TAG_ESQL_FIND_PARAMS = 3;
    private static final int TAG_ESQL_FIND_CONTENT = 4;
    private static final int TAG_ESQL_FIELD_VALUES = 5;
    private static final int TAG_ESQL_OWNER_NODE = 6;
    private static final int TAG_ESQL_PROCESSED_ROW_COUNT = 7;
    private static final int TAG_ESQL_FIELD_VALUE_FIELD_ID = 1;
    private static final int TAG_ESQL_FIELD_VALUE_FIELD_NAME = 2;
    private static final int TAG_ESQL_FIELD_VALUE_NULL = 3;
    private static final int TAG_ESQL_FIELD_VALUE_INT = 4;
    private static final int TAG_ESQL_FIELD_VALUE_DOUBLE = 5;
    private static final int TAG_ESQL_FIELD_VALUE_STRING = 6;
    private static final int TAG_ESQL_FIELD_VALUE_DATETIME = 7;
    private static final int ESCMD_NONE = 0;
    private static final int ESCMD_DELETE = 1;
    private static final int ESCMD_UPDATE = 2;

    public ExecuteSql(RequestHeader rq) {
        super(rq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void execute() throws Throwable {
        command = 0;
        findId = 0.0;
        ownerId = 0.0;
        findParams = null;
        findContent = null;
        fieldValues = null;
        findParamsEx = null;
        reader = this.createRequestContentReader();
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    command = reader.getInt();
                    break;
                }
                case 2: {
                    findId = reader.getDouble();
                    break;
                }
                case 3: {
                    findParamsEx = reader.getRaw();
                    break;
                }
                case 4: {
                    findContent = reader.getRaw();
                    break;
                }
                case 5: {
                    fieldValues = reader.getRaw();
                    break;
                }
                case 6: {
                    this.rqstat.ownerId = ownerId = reader.getDouble();
                }
            }
        }
        if (command == 2 && (fieldValues == null || fieldValues.length == 0)) {
            return;
        }
        generationMethod = SqlGenerator.Method.DEFAULT;
        sqlGenerator = new SqlGenerator(this, this);
        tableId = 0.0;
        if (findId != 0.0) {
            this.rqstat.nodeId = findId;
            sqlGenerator.setSearchId(findId);
            mtdNode = MtdEngine.getValidNode(findId);
            if (!(mtdNode instanceof FindNode)) {
                throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u0443\u0437\u043b\u0430 \u043f\u043e\u0438\u0441\u043a\u0430(" + NumberConverter.doubleToString(findId) + ")");
            }
            node = (FindNode)mtdNode;
            findContent = node.getContent();
            fd = node.getDescriptor();
            if (fd.getKind() == 1) {
                throw new IllegalArgumentException("\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f/\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0438\u0441\u0435\u0439");
            }
            tableId = fd.getRootTableId();
        } else if (findContent != null && findContent.length > 0) {
            rdr = new TaggedReader(findContent);
            while (rdr.next()) {
                switch (rdr.getCurrentTag()) {
                    case 5: {
                        this.rqstat.nodeId = tableId = rdr.getDouble();
                        break;
                    }
                    case 14: {
                        findContent = rdr.getRaw();
                        generationMethod = SqlGenerator.extractSearchGenerationMethod(findContent);
                        break;
                    }
                    case 15: {
                        findParams = rdr.getRaw();
                    }
                }
            }
        } else {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u043e\u0438\u0441\u043a");
        }
        td = ExecuteSql.checkTable(tableId);
        sqlGenerator.setNestedSql();
        if (findParamsEx != null) {
            sqlGenerator.getParameters().loadEx(findParamsEx);
        } else if (findParams != null) {
            sqlGenerator.getParameters().load(findParams);
        }
        sqlGenerator.setTableId(tableId);
        sqlGenerator.setSearchContent(findContent);
        generatedSql = sqlGenerator.getGeneratedSql(generationMethod, -500);
        if (generatedSql.isHasError()) {
            throw new InformException(generatedSql.getError()).detail(generatedSql.getErrorDetailing());
        }
        sqlText = generatedSql.getSqlText();
        fromBegin = sqlText.indexOf(" from ");
        if (fromBegin < 0) {
            throw new InformException(sqlText);
        }
        sqlText = sqlText.substring(fromBegin);
        pk = td.getRecordIdField();
        data = new ByteArrayOutputStream();
        out = new TaggedWriter(data);
        cm = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:ExecuteSql");
        try {
            connection = cm.getConnection(td.getDbId(), "rq:ExecuteSql");
            statement = null;
            try {
                switch (command) {
                    case 1: {
                        sql = new SqlStringBuilder();
                        sql.append("DELETE FROM ").appendFull(td).append(" WHERE ").append(pk).append(" IN (SELECT T0.").append(pk).append(sqlText).append(')');
                        statement = connection.prepareStatement(sql.toString());
                        statement.setLogDangerSQL();
                        statement.setSqlInfo(generatedSql);
                        generatedSql.setParametersTo((PreparedStatement)statement);
                        rowCount = statement.executeUpdate(null);
                        if (rowCount > 0) {
                            audit = new TableDataAudit(this.ssContext, connection, this.getUserID(), 0.0, 0.0, 0.0, this.getSessionID());
                            audit.setOwnerId(ownerId);
                            audit.registrateModification(td, 0.0, AuditModification.EXTERNAL_DELETE);
                            audit.flush();
                        }
                        out.putInt32(7, rowCount);
                        Core.logger.info("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439(row count:{}) \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b(node: {}, user: {})", new Object[]{rowCount, NumberConverter.doubleToString(tableId), NumberConverter.doubleToString(this.getUserID())});
                        ** break;
lbl107:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        paramValues = new ArrayList<Object>();
                        sql = new SqlStringBuilder();
                        sql.append("UPDATE ").appendFull(td).append(" SET ");
                        rdr = new TaggedReader(fieldValues);
                        sep = 32;
                        fieldDescriptor = null;
                        while (rdr.next()) {
                            switch (rdr.getCurrentTag()) {
                                case 1: 
                                case 2: {
                                    x = null;
                                    if (rdr.getCurrentTag() == 1) {
                                        id = rdr.getInt();
                                        fieldDescriptor = td.getFieldDescriptor(id);
                                        x = id;
                                    } else {
                                        n = rdr.getAnsi();
                                        fieldDescriptor = td.getField(n);
                                        x = n;
                                    }
                                    if (fieldDescriptor == null) {
                                        throw new IllegalArgumentException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 SQL \u043e\u043f\u0440\u0435\u0442\u043e\u0440\u0430: \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e\u043b\u0435 '" + x + "' \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 '" + td.getRawName() + "'");
                                    }
                                    sql.append((char)sep).append(fieldDescriptor.getRawName()).append('=');
                                    sep = 44;
                                    break;
                                }
                                case 3: {
                                    sql.append("NULL");
                                    break;
                                }
                                case 4: {
                                    if (!ExecuteSql.$assertionsDisabled && fieldDescriptor == null) {
                                        throw new AssertionError();
                                    }
                                    sql.append('?');
                                    intVal = rdr.getInt();
                                    if (fieldDescriptor.getType() == DataType.BOOLEAN) {
                                        paramValues.add(intVal != 0);
                                        break;
                                    }
                                    paramValues.add(intVal);
                                    break;
                                }
                                case 5: {
                                    sql.append('?');
                                    paramValues.add(rdr.getDouble());
                                    break;
                                }
                                case 6: {
                                    sql.append('?');
                                    paramValues.add(rdr.getAnsi());
                                    break;
                                }
                                case 7: {
                                    sql.append('?');
                                    paramValues.add(DateTime.toSqlTime(rdr.getDouble()));
                                }
                            }
                        }
                        sql.append(" WHERE ").append(pk).append(" IN (SELECT T0.").append(pk).append(sqlText).append(')');
                        statement = connection.prepareStatement(sql.toString());
                        statement.setLogDangerSQL();
                        statement.setSqlInfo(generatedSql);
                        idx = 0;
                        for (E pv : paramValues) {
                            if (pv == null) {
                                statement.setNull(fromBegin, SqlDataType.UNSUPPORTED);
                                continue;
                            }
                            if (pv instanceof Boolean) {
                                statement.setBoolean(++idx, (Boolean)pv);
                                continue;
                            }
                            if (pv instanceof Integer) {
                                statement.setInt(++idx, (Integer)pv);
                                continue;
                            }
                            if (pv instanceof Double) {
                                statement.setDouble(++idx, (Double)pv);
                                continue;
                            }
                            if (pv instanceof String) {
                                statement.setString(++idx, (String)pv);
                                continue;
                            }
                            if (!(pv instanceof Timestamp)) continue;
                            statement.setTimestamp(++idx, (Timestamp)pv);
                        }
                        generatedSql.appendParametersTo((PreparedStatement)statement);
                        rowCount = statement.executeUpdate(null);
                        out.putInt32(7, rowCount);
                        Core.logger.info("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439(row count:{}) \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b(node: {}, user: {})", new Object[]{rowCount, NumberConverter.doubleToString(tableId), NumberConverter.doubleToString(this.getUserID())});
                        break;
                    }
                    ** default:
lbl201:
                    // 1 sources

                    break;
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            cm.commit();
        }
        finally {
            cm.release();
        }
        out.flush();
        this.sendResult(data.internalBuffer(), data.size());
    }
}

