/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.Memory;
import inform.adt.NumberConverter;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.LogContext;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.GeneratedSql;
import inform.agent.db.SearchFilterExpressionBuilder;
import inform.agent.db.SearchParameters;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.utils.PackedRowContent;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.nodes.Node;
import java.io.OutputStream;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;

public class GetRecordContent
extends Request {
    public static final int RECORDS_IN_FRAME = 64;
    private static final String MSG_GET_RECORDS_INTERNAL_ERROR = "\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430 \u0437\u0430\u043f\u0438\u0441\u0438: \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430";
    public static final String MSG_DENIED_VIRTUAL_TABLE = "\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u044b\u0431\u043e\u0440 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439";
    static final String TABLE_ALIAS = "TT";
    private double userNodeId;
    private double[] records;
    private double tableNodeId;
    private int recordCount;
    private double workPeriod;
    private boolean hasWorkPeriod;
    private byte[] constants;
    private int blobReceiving;
    private int geoFormat;
    private TableDescriptor tableDescriptor;
    private FieldDescriptor recordIdField;
    private double databaseId;
    private StringBuilder logInfo;
    private String sqlText = null;
    private ConnectionManager connectionManager;
    private int recordIndex;
    double ownerNodeId = 0.0;
    int ownerDatasourceId = 0;

    public GetRecordContent(RequestHeader rq) {
        super(rq, RequestDuration.MIDDLE);
    }

    public static void generateFieldList(StringBuilder sql, TableDescriptor tableDescriptor, String tableAlias) {
        int sep = 32;
        if (tableDescriptor.getKind() == TableDescriptor.Kind.INTERNAL) {
            sql.append(' ');
            if (tableAlias != null) {
                sql.append(tableAlias).append('.');
            }
            sql.append("ID");
            sep = 44;
        }
        for (FieldDescriptor f : tableDescriptor.getFields()) {
            if (f.isAbstract() || f.getType() == DataType.BLOB || f.getType() == DataType.FILE) continue;
            sql.append((char)sep);
            if (tableAlias != null) {
                sql.append(tableAlias).append('.');
            }
            sql.append(f.getRawName());
            sep = 44;
        }
    }

    private PreparedStatement nextPeriodicStatement() throws Throwable {
        if (this.recordIndex >= this.records.length) {
            return null;
        }
        PreparedStatement statement = null;
        ByteArrayOutputStream sqlGeneratorInput = new ByteArrayOutputStream();
        TaggedWriter sqlGeneratorWriter = new TaggedWriter(sqlGeneratorInput);
        sqlGeneratorWriter.putDouble(5, this.tableNodeId);
        SearchParameters searchParameters = new SearchParameters();
        boolean recordsParamId = true;
        searchParameters.addParameter(1);
        int paramCount = this.records.length - this.recordIndex;
        if (paramCount > 64) {
            paramCount = 64;
        }
        for (int i = 0; i < paramCount; ++i) {
            searchParameters.addDouble(this.records[this.recordIndex++]);
        }
        searchParameters.storeAs(sqlGeneratorWriter);
        if (this.hasWorkPeriod) {
            sqlGeneratorWriter.putDouble(33, this.workPeriod);
        }
        ByteArrayOutputStream customization = new ByteArrayOutputStream();
        TaggedWriter customizationWriter = new TaggedWriter(customization);
        SearchFilterExpressionBuilder expr = new SearchFilterExpressionBuilder();
        expr.addExpression(0, 1, 0);
        expr.addFieldOperand(0, -1, false);
        expr.addParamId(1);
        expr.storeAs(1, customizationWriter);
        customizationWriter.putEmpty(2);
        customizationWriter.flush();
        sqlGeneratorWriter.putRaw(35, customization);
        sqlGeneratorWriter.flush();
        SqlGenerator sqlGenerator = new SqlGenerator(this, this);
        sqlGenerator.setTableId(this.tableNodeId);
        if (!Memory.isVoid(this.constants)) {
            sqlGenerator.setConstantsContent(this.constants, this);
        }
        GeneratedSql sql = sqlGenerator.getGeneratedSql(SqlGenerator.Method.DEFAULT, -500, sqlGeneratorInput.toByteArray());
        this.sqlText = sql.getSqlText();
        DatabaseConnection conn = this.connectionManager.getConnection(this.databaseId, "rq:GetRecordContent::nextPeriodicStatememt");
        if (!this.connectionManager.isPersonalSession()) {
            conn.markAsReadonly();
        }
        statement = conn.prepareStatement(this.getClass().getSimpleName(), this.sqlText);
        statement.setQueryTimeout();
        statement.setSqlInfo(sql);
        sql.setParametersTo(statement);
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPeriodic() throws Throwable {
        RequestResult result = new RequestResult(this, 8192);
        TaggedWriter out = result.getWriter();
        ByteArrayOutputStream data = new ByteArrayOutputStream(1024);
        PackedRowContent content = new PackedRowContent(this.blobReceiving, this.geoFormat, this.rq.client.isClientLevel(3), this, this.rq.client.isClientLevel(6));
        ArrayList<FieldDescriptor> recordFields = null;
        int[] columnsMap = null;
        boolean needSendMetadata = true;
        this.recordIndex = 0;
        while (this.recordIndex < this.recordCount) {
            this.idle();
            PreparedStatement statement = this.nextPeriodicStatement();
            if (statement == null) break;
            try (ResultSet resultSet = statement.executeQuery(null);){
                int recordIdFieldIdx = resultSet.findColumn(this.recordIdField.getRawName());
                while (resultSet.next()) {
                    this.idle();
                    if (needSendMetadata) {
                        needSendMetadata = false;
                        out.putInt32(39, this.blobReceiving);
                        ResultSetMetaData metadata = resultSet.getMetaData();
                        List<FieldDescriptor> tableFields = this.tableDescriptor.getFields();
                        recordFields = new ArrayList<FieldDescriptor>();
                        for (FieldDescriptor field : tableFields) {
                            if (field.isAbstract()) continue;
                            recordFields.add(field);
                        }
                        columnsMap = new int[recordFields.size()];
                        block9: for (int index = 0; index < columnsMap.length; ++index) {
                            FieldDescriptor field;
                            field = recordFields.get(index);
                            columnsMap[index] = -1;
                            for (int i = 0; i < metadata.getColumnCount(); ++i) {
                                String columnName = metadata.getColumnLabel(i + 1);
                                if (!columnName.equalsIgnoreCase(field.getRawName())) continue;
                                columnsMap[index] = i + 1;
                                continue block9;
                            }
                        }
                        data.reset();
                        content.packMetadata(recordFields, (OutputStream)data);
                        out.putRaw(27, data);
                    }
                    double rowId = 0.0;
                    if (this.recordIdField.getType().isDoublePresentation()) {
                        rowId = resultSet.getDouble(recordIdFieldIdx);
                    }
                    out.putDouble(1, rowId);
                    data.reset();
                    content.packRecordContent(resultSet, recordFields, columnsMap, this.tableNodeId, rowId, data);
                    out.putRaw(2, data);
                    result.sendChunkIf(3072);
                }
            }
            finally {
                statement.close();
            }
        }
        result.sendResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStandard() throws Throwable {
        int paramCount = 1;
        DatabaseDescriptor db = this.tableDescriptor.getDatabaseDescriptor();
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        GetRecordContent.generateFieldList(sql, this.tableDescriptor, TABLE_ALIAS);
        sql.append(" from ");
        db.appendTableRawName(this.tableDescriptor.getRawName(), sql);
        sql.append(" ").append(TABLE_ALIAS).append(" where ").append(this.recordIdField.getRawName()).append(" in (?");
        int frameSize = this.records.length;
        if (frameSize > 64) {
            frameSize = 64;
        }
        --frameSize;
        while (frameSize > 0) {
            sql.append(",?");
            ++paramCount;
            --frameSize;
        }
        sql.append(')');
        this.sqlText = sql.toString();
        DatabaseConnection conn = this.connectionManager.getConnection(this.databaseId, "rq:GetRecordContent::runStandard");
        if (!this.connectionManager.isPersonalSession()) {
            conn.markAsReadonly();
        }
        try (PreparedStatement statement = conn.prepareStatement(this.getClass().getSimpleName(), this.sqlText);){
            statement.setQueryTimeout();
            RequestResult result = new RequestResult(this, 8192);
            TaggedWriter out = result.getWriter();
            ByteArrayOutputStream data = new ByteArrayOutputStream(1024);
            PackedRowContent content = new PackedRowContent(this.blobReceiving, this.geoFormat, this.rq.client.isClientLevel(3), this, this.rq.client.isClientLevel(6));
            ArrayList<FieldDescriptor> recordFields = null;
            int[] columnsMap = null;
            boolean needSendMetadata = true;
            this.recordIndex = 0;
            while (this.recordIndex < this.recordCount) {
                this.idle();
                if (paramCount == 0) {
                    this.recordIndex = this.records.length;
                } else {
                    for (int p = 0; p < paramCount; ++p) {
                        if (this.recordIndex < this.records.length) {
                            statement.setDouble(p + 1, this.records[this.recordIndex++]);
                            continue;
                        }
                        statement.setDouble(p + 1, 0.0);
                    }
                }
                ResultSet resultSet = statement.executeQuery(null);
                int recordIdFieldIdx = resultSet.findColumn(this.recordIdField.getRawName());
                try {
                    while (resultSet.next()) {
                        this.idle();
                        if (needSendMetadata) {
                            needSendMetadata = false;
                            out.putInt32(39, this.blobReceiving);
                            ResultSetMetaData metadata = resultSet.getMetaData();
                            List<FieldDescriptor> tableFields = this.tableDescriptor.getFields();
                            recordFields = new ArrayList<FieldDescriptor>();
                            for (FieldDescriptor field : tableFields) {
                                if (field.isAbstract()) continue;
                                recordFields.add(field);
                            }
                            columnsMap = new int[recordFields.size()];
                            block11: for (int index = 0; index < columnsMap.length; ++index) {
                                FieldDescriptor field;
                                field = recordFields.get(index);
                                columnsMap[index] = -1;
                                for (int i = 0; i < metadata.getColumnCount(); ++i) {
                                    String columnName = metadata.getColumnLabel(i + 1);
                                    if (!columnName.equalsIgnoreCase(field.getRawName())) continue;
                                    columnsMap[index] = i + 1;
                                    continue block11;
                                }
                            }
                            data.reset();
                            content.packMetadata(recordFields, (OutputStream)data);
                            out.putRaw(27, data);
                        }
                        double rowId = 0.0;
                        if (this.recordIdField.getType().isNumberPresentation()) {
                            rowId = resultSet.getDouble(recordIdFieldIdx);
                        }
                        out.putDouble(1, rowId);
                        data.reset();
                        content.packRecordContent(resultSet, recordFields, columnsMap, this.tableNodeId, rowId, data);
                        out.putRaw(2, data);
                        result.sendChunkIf(3072);
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            result.sendResult();
        }
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        this.userNodeId = this.getUserID();
        this.records = null;
        this.tableNodeId = 0.0;
        this.recordCount = 0;
        this.workPeriod = 0.0;
        this.hasWorkPeriod = false;
        this.constants = null;
        this.blobReceiving = 0;
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 5: {
                    this.tableNodeId = in.getDouble();
                    Object node = this.getNode(this.tableNodeId);
                    this.ssContext.nodeId = this.tableNodeId;
                    if (!AccessMask.accessDenied(0x4000000, this.security().accessMask((Node)node))) break;
                    this.sendResult();
                    return;
                }
                case 6: {
                    this.recordCount = in.getInt();
                    break;
                }
                case 7: {
                    if (this.recordCount * 64 / 8 != in.getCurrentTagSize()) {
                        this.sendError(MSG_GET_RECORDS_INTERNAL_ERROR, "GetRecordContentRequest");
                        return;
                    }
                    this.records = LittleEndian.toDoubleArray(in.getRaw());
                    break;
                }
                case 32: {
                    this.constants = in.getRaw();
                    break;
                }
                case 33: {
                    this.workPeriod = in.getDouble();
                    this.hasWorkPeriod = true;
                    break;
                }
                case 39: {
                    this.blobReceiving = in.getInt();
                    break;
                }
                case 43: {
                    this.geoFormat = in.getInt();
                    break;
                }
                case 41: {
                    this.ssContext.ownerId = this.ownerNodeId = in.getDouble();
                    break;
                }
                case 42: {
                    this.ssContext.uid = this.ownerDatasourceId = in.getInt();
                }
            }
        }
        if (this.records == null || this.records.length == 0) {
            this.sendResult();
            return;
        }
        this.logInfo = new StringBuilder();
        this.logInfo.append("rq: ").append(30).append(" u: ").append(NumberConverter.doubleToString(this.getUserID())).append(" d: ").append(NumberConverter.doubleToString(this.databaseId)).append(" t: ").append(NumberConverter.doubleToString(this.tableNodeId));
        if (this.ownerNodeId != 0.0) {
            this.logInfo.append(" o:").append((long)this.ownerNodeId);
        }
        if (this.ownerDatasourceId != 0) {
            this.logInfo.append(" uid:").append(this.ownerDatasourceId);
        }
        this.rqstat.nodeId = this.tableNodeId;
        this.rqstat.ownerId = this.ownerNodeId;
        this.rqstat.ownerDatasourceId = this.ownerDatasourceId;
        this.tableDescriptor = TableDescriptor.get(this.tableNodeId);
        if (this.tableDescriptor.getKind() == TableDescriptor.Kind.VIRTUAL) {
            throw new InformException(MSG_DENIED_VIRTUAL_TABLE).detail(this.logInfo.toString());
        }
        this.recordIdField = this.tableDescriptor.getRecordIdField();
        if (this.recordIdField == null) {
            StringBuilder msg = new StringBuilder();
            msg.append("\u041f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0434\u043b\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b [").append(Core.idstr(this.tableDescriptor.getNodeId())).append("] ").append(this.tableDescriptor.getRawName()).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            throw new InformException(msg.toString()).detail(this.logInfo.toString());
        }
        this.databaseId = this.tableDescriptor.getDbId();
        this.connectionManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:GetRecordContent");
        DatabaseConnection conn = this.connectionManager.getConnection(this.databaseId, "rq:GetRecordContent:logger");
        if (!this.connectionManager.isPersonalSession()) {
            conn.markAsReadonly();
        }
        Core.logger.setCollectSql(conn, true);
        try {
            try {
                if (this.tableDescriptor.isHasPeriodicStorage()) {
                    this.runPeriodic();
                } else {
                    this.runStandard();
                }
                this.connectionManager.commit();
            }
            finally {
                Core.logger.setCollectSql(conn, false);
                this.connectionManager.release();
            }
        }
        catch (Throwable ex) {
            this.logInfo.append("\r\n").append(this.sqlText).append("\r\n");
            throw InformException.detail(ex, this.logInfo.toString());
        }
    }

    @Override
    public void contextMessage(LogContext.Builder out) {
        super.contextMessage(out);
        out.append("d", (long)this.databaseId);
        out.append("t", (long)this.tableNodeId);
        if (this.ownerNodeId != 0.0) {
            out.append("o", (long)this.ownerNodeId);
        }
        if (this.ownerDatasourceId != 0) {
            out.append("uid", this.ownerDatasourceId);
        }
    }
}

