/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.GeneratedSql;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.Plan;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.nodes.Node;

public class GetSQLText
extends Request {
    public GetSQLText(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getPlanContent(DatabaseConnection connection, String sqlText) throws Throwable {
        try (Plan plan = connection.createExplainPlan(false, sqlText);){
            ResultSet rs = plan.explain(null);
            byte[] byArray = connection.getPlanContent(rs);
            return byArray;
        }
    }

    private byte[] getPlanContentByTableNodeId(double tableNodeId, String sqlText) throws Throwable {
        TableDescriptor tableDescriptor = TableDescriptor.get(tableNodeId);
        return this.getPlanContentByDatabaseId(tableDescriptor.getDbId(), sqlText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getPlanContentByDatabaseId(double databaseId, String sqlText) throws Throwable {
        DatabaseDescriptor db = DatabaseDescriptor.getDatabase(databaseId);
        try (DatabaseConnection connection = db.connect(this, "rq:GetSQLText::getPlanContentByDatabaseId");){
            byte[] byArray = this.getPlanContent(connection, sqlText);
            return byArray;
        }
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        double userNodeId = this.getUserID();
        int fetchLimit = Integer.MAX_VALUE;
        double tableNodeId = 0.0;
        boolean explainPlan = false;
        boolean inlineParams = false;
        boolean rawSql = false;
        String sqlText = "";
        double databaseId = 0.0;
        SqlGenerator.Method generationMethod = SqlGenerator.Method.DEFAULT;
        ByteArrayOutputStream searchConent = new ByteArrayOutputStream();
        TaggedWriter searchWriter = new TaggedWriter(searchConent);
        block8: while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 5: {
                    tableNodeId = in.getDouble();
                    searchWriter.putDouble(5, tableNodeId);
                    continue block8;
                }
                case 23: {
                    fetchLimit = in.getInt();
                    searchWriter.putInt32(23, fetchLimit);
                    continue block8;
                }
                case 37: {
                    explainPlan = true;
                    searchWriter.putEmpty(30);
                    continue block8;
                }
                case 30: {
                    inlineParams = true;
                    searchWriter.putEmpty(30);
                    continue block8;
                }
                case 25: {
                    rawSql = true;
                    sqlText = in.getAnsi();
                    in.takeNextTag();
                    databaseId = in.getDouble();
                    continue block8;
                }
                case 14: {
                    byte[] raw = in.getRaw();
                    searchWriter.putRaw(14, raw);
                    generationMethod = SqlGenerator.extractSearchGenerationMethod(raw);
                    continue block8;
                }
            }
            in.transferTag(searchWriter);
        }
        searchWriter.flush();
        StringBuilder result = new StringBuilder();
        if (rawSql) {
            result.append(sqlText);
        } else {
            Object node = this.getNode(tableNodeId);
            if (AccessMask.accessDenied(0x4000000, this.security().accessMask((Node)node))) {
                this.sendResult();
                return;
            }
            SqlGenerator sqlGenerator = new SqlGenerator(this, this);
            sqlGenerator.setTableId(tableNodeId);
            GeneratedSql sql = sqlGenerator.getGeneratedSql(generationMethod, -500, searchConent.toByteArray());
            if (sql.isHasError()) {
                throw new InformException(sql.getError()).detail(sql.getErrorDetailing());
            }
            sqlText = sql.getSqlText();
            result.append(sqlText);
            if (!inlineParams) {
                result.append('\n');
                sql.logParameters(1, result);
            }
        }
        ByteArrayOutputStream resultContent = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(resultContent);
        out.putAnsi(25, result.toString());
        if (explainPlan) {
            byte[] planContent = null;
            planContent = rawSql ? this.getPlanContentByDatabaseId(databaseId, sqlText) : this.getPlanContentByTableNodeId(tableNodeId, sqlText);
            if (planContent != null && planContent.length != 0) {
                out.putRaw(37, planContent);
            }
        }
        out.flush();
        this.sendResult(resultContent.internalBuffer(), resultContent.size());
    }
}

