/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.TimeZoneHost;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.LogContext;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.GeneratedSql;
import inform.agent.db.Row;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.MultitypeArrayGetter;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.ResultSetPostProcess;
import inform.agent.db.sql.SimpleSqlBuilder;
import inform.agent.db.types.DataType;
import inform.agent.db.utils.PackedRowContent;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.Constants;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.sql.ExpressionFilterQuery;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Context;

public class GetTableRecordsRef
extends Request {
    double databaseId;
    double tableNodeId;
    double findNodeId;
    double ownerNodeId = 0.0;
    int ownerDatasourceId = 0;

    public GetTableRecordsRef(RequestHeader rq) {
        super(rq, RequestDuration.LONG);
    }

    public StringBuilder getLogInfo() {
        StringBuilder logInfo = new StringBuilder();
        logInfo.append("rq: ").append(31).append(" u: ").append(NumberConverter.doubleToString(this.client().getUserId())).append(" d: ").append(NumberConverter.doubleToString(this.databaseId)).append(" t: ").append(NumberConverter.doubleToString(this.tableNodeId));
        if (this.findNodeId != 0.0) {
            logInfo.append(" f: ").append(NumberConverter.doubleToString(this.findNodeId));
        }
        if (this.ownerNodeId != 0.0) {
            logInfo.append(" o:").append((long)this.ownerNodeId);
        }
        if (this.ownerDatasourceId != 0) {
            logInfo.append(" uid:").append(this.ownerDatasourceId);
        }
        return logInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        GeneratedSql sql;
        byte[] requestContent = this.getRequestContent();
        TaggedReader in = this.createRequestContentReader();
        double userNodeId = this.getUserID();
        Params params = new Params();
        params.bomStringMpde = this.rq.client.isClientLevel(6);
        this.tableNodeId = this.getNodeID();
        this.findNodeId = 0.0;
        byte[] expressionFilterContent = null;
        SqlGenerator.Method generationMethod = SqlGenerator.Method.DEFAULT;
        Constants constants = new Constants(this.getUserID());
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 5: {
                    this.tableNodeId = in.getDouble();
                    break;
                }
                case 23: {
                    params.fetchLimit = in.getInt();
                    if (params.fetchLimit != 0) break;
                    this.sendResult();
                    return;
                }
                case 39: {
                    params.blobReceiving = in.getInt();
                    break;
                }
                case 31: {
                    this.findNodeId = in.getDouble();
                    if (this.findNodeId == 0.0) break;
                    this.ssContext.nodeId = this.findNodeId;
                    break;
                }
                case 32: {
                    constants.load(in.getRaw(), (TimeZoneHost)this);
                    break;
                }
                case 41: {
                    this.ssContext.ownerId = this.ownerNodeId = in.getDouble();
                    break;
                }
                case 42: {
                    this.ssContext.uid = this.ownerDatasourceId = in.getInt();
                    break;
                }
                case 43: {
                    params.geoFormat = in.getInt();
                    break;
                }
                case 46: {
                    expressionFilterContent = in.getRaw();
                    break;
                }
                case 50: {
                    params.nullSortKind = in.getInt();
                    break;
                }
                case 14: {
                    byte[] raw = in.getRaw();
                    generationMethod = SqlGenerator.extractSearchGenerationMethod(raw);
                }
            }
        }
        this.rqstat.nodeId = this.findNodeId == 0.0 ? this.tableNodeId : this.findNodeId;
        this.rqstat.ownerId = this.ownerNodeId;
        this.rqstat.ownerDatasourceId = this.ownerDatasourceId;
        Object node = this.getNode(this.tableNodeId);
        if (AccessMask.accessDenied(0x4000000, this.security().accessMask((Node)node))) {
            this.sendResult();
            return;
        }
        SqlGenerator sqlGenerator = new SqlGenerator(this, this);
        sqlGenerator.setTableId(this.tableNodeId);
        sqlGenerator.setConstants(constants);
        if (expressionFilterContent != null && expressionFilterContent.length != 0) {
            ExpressionFilterQuery expressionFilterQuery = new ExpressionFilterQuery((ServerSideHost)this, sqlGenerator);
            expressionFilterQuery.load(new TaggedReader(expressionFilterContent));
            String expressionFilterCondition = SimpleSqlBuilder.getExpressionFilterCondition(expressionFilterQuery);
            if (expressionFilterCondition != null) {
                sqlGenerator.setExpressionFilter(expressionFilterQuery, expressionFilterCondition);
            }
        }
        if ((sql = sqlGenerator.getGeneratedSql(generationMethod, -500, requestContent)).isHasError()) {
            throw new InformException(sql.getError()).detail(this.getLogInfo().toString()).detail(sql.getErrorDetailing());
        }
        if (sql.isEmptyDataset()) {
            this.sendResult();
            return;
        }
        if (!params.needRealId) {
            params.needRealId = sql.hasPrimaryKeyExpression();
        }
        params.tableDescriptor = TableDescriptor.get(this.tableNodeId);
        this.databaseId = params.tableDescriptor.getDbId();
        String sqlText = sql.getSqlText();
        try {
            ConnectionManager connectionManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:GetTableRecordsRef");
            DatabaseConnection conn = connectionManager.getConnection(this.databaseId, "rq:GetTableRecordsRef:logger");
            if (!connectionManager.isPersonalSession()) {
                conn.markAsReadonly();
            }
            Core.logger.setCollectSql(conn, true);
            try {
                GetTableRecordsRef.executeSql(null, this, sql, connectionManager, params);
            }
            finally {
                Core.logger.setCollectSql(conn, false);
                connectionManager.release();
            }
        }
        catch (Throwable ex) {
            StringBuilder logInfo = this.getLogInfo();
            logInfo.append("\r\n").append(sqlText).append("\r\n");
            throw InformException.detail(ex, logInfo.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSql(SSContext ssContext, Request request, GeneratedSql sql, AbstractConnectionManager connectionManager, Params params) throws Exception {
        double databaseId = params.getDatabaseID();
        String sqlText = sql.getSqlText();
        long start = System.currentTimeMillis();
        long dataSize = 0L;
        DatabaseConnection database = connectionManager.getConnection(databaseId, "rq:GetTableRecordsRef");
        if (!connectionManager.isPersonalSession()) {
            database.markAsReadonly();
        }
        try (PreparedStatement statement = database.prepareStatement(request.getClass().getSimpleName(), sqlText);){
            statement.setQueryTimeout();
            statement.setSqlInfo(sql);
            statement.setTableDesc(params.tableDescriptor);
            sql.setParametersTo(statement);
            try (ResultSet resultSet = statement.executeQuery(ssContext);){
                Context context = null;
                try {
                    long recordCount;
                    String columnName;
                    int i;
                    ResultSetPostProcess postProcess;
                    if (sql.hasPostProcess()) {
                        context = Core.asmoJsContextFactory.enterContext();
                        postProcess = sql.createPostProcess(ssContext, context, request, connectionManager, params.nullSortKind);
                        postProcess.setResultSet(resultSet, !sql.isAdvanced() || sql.hasPrimaryKeyExpression());
                    } else {
                        postProcess = null;
                    }
                    long duration = System.currentTimeMillis() - start;
                    if (duration > 30000L) {
                        Core.logger.info("! long time({}) sql request {}", (Object)duration, (Object)request.toString());
                    }
                    MultitypeArrayGetter mag = postProcess != null ? postProcess : resultSet;
                    FieldDescriptor recordIdField = params.tableDescriptor.getRecordIdField();
                    boolean hasPrimaryKey = false;
                    int recordIdFieldIdx = 0;
                    if (recordIdField != null && (!sql.isAdvanced() || sql.hasPrimaryKeyExpression())) {
                        for (i = 1; i <= mag.getColumnCount(); ++i) {
                            columnName = mag.getColumnLabel(i);
                            if (!recordIdField.getRawName().equalsIgnoreCase(columnName)) continue;
                            recordIdFieldIdx = i;
                            hasPrimaryKey = true;
                            break;
                        }
                    }
                    if (!hasPrimaryKey && params.needRealId) {
                        for (i = 1; i <= mag.getColumnCount(); ++i) {
                            columnName = mag.getColumnLabel(i);
                            if (!"ID".equalsIgnoreCase(columnName)) continue;
                            recordIdFieldIdx = i;
                            break;
                        }
                    }
                    boolean geometryGlient = request.client().isClientLevel(3);
                    List<FieldDescriptor> tableFields = params.tableDescriptor.getFields();
                    ArrayList<FieldDescriptor> recordFields = new ArrayList<FieldDescriptor>();
                    for (FieldDescriptor field : tableFields) {
                        if (field.getKind() == 2) {
                            if (!resultSet.isColumnExists(field.getRawName())) continue;
                            recordFields.add(field);
                            continue;
                        }
                        if (field.isAbstract() || !geometryGlient && field.getType() == DataType.GEOMETRY) continue;
                        recordFields.add(field);
                    }
                    int[] columnsMap = new int[recordFields.size()];
                    block12: for (int index = 0; index < columnsMap.length; ++index) {
                        FieldDescriptor field = (FieldDescriptor)recordFields.get(index);
                        columnsMap[index] = -1;
                        for (int i2 = 0; i2 < mag.getColumnCount(); ++i2) {
                            String columnName2 = mag.getColumnLabel(i2 + 1);
                            if (!columnName2.equalsIgnoreCase(field.getRawName())) continue;
                            columnsMap[index] = i2 + 1;
                            continue block12;
                        }
                    }
                    RequestResult result = new RequestResult(request, 8192);
                    TaggedWriter out = result.getWriter();
                    ByteArrayOutputStream data = new ByteArrayOutputStream(1024);
                    PackedRowContent content = new PackedRowContent(params.blobReceiving, params.geoFormat, geometryGlient, request, params.bomStringMpde);
                    boolean needSendRecordFields = true;
                    if (!hasPrimaryKey) {
                        for (recordCount = 0L; !request.isCancelled() && recordCount < (long)params.fetchLimit && resultSet.next(); ++recordCount) {
                            request.idle();
                            if (postProcess != null && !postProcess.next()) continue;
                            if (needSendRecordFields) {
                                needSendRecordFields = false;
                                out.putEmpty(38);
                                out.putInt32(39, params.blobReceiving);
                                if (sql.getSortingGeneration() != GeneratedSql.Sorting.DEFAULT) {
                                    out.putBool(44, sql.getSortingGeneration() == GeneratedSql.Sorting.FAILED);
                                }
                                data.reset();
                                content.packMetadata(recordFields, (OutputStream)data);
                                out.putRaw(27, data);
                            }
                            dataSize += (long)result.sendChunkIf(4032);
                            double rowId = recordIdFieldIdx > 0 ? resultSet.getDouble(recordIdFieldIdx) : Row.generateVirtualRecordId();
                            data.reset();
                            content.packRecordContent(mag, recordFields, columnsMap, params.tableDescriptor.getNodeId(), rowId, data);
                            out.putEmpty(21);
                            out.putDouble(1, rowId);
                            out.putRaw(2, data);
                        }
                    } else {
                        boolean needId = recordIdField.getType().isNumeric();
                        double rowId = 0.0;
                        for (recordCount = 0L; !request.isCancelled() && recordCount < (long)params.fetchLimit && resultSet.next(); ++recordCount) {
                            request.idle();
                            if (postProcess != null && !postProcess.next()) continue;
                            if (needSendRecordFields) {
                                needSendRecordFields = false;
                                out.putInt32(39, params.blobReceiving);
                                if (sql.getSortingGeneration() != GeneratedSql.Sorting.DEFAULT) {
                                    out.putBool(44, sql.getSortingGeneration() == GeneratedSql.Sorting.FAILED);
                                }
                                data.reset();
                                content.packMetadata(recordFields, (OutputStream)data);
                                out.putRaw(27, data);
                            }
                            dataSize += (long)result.sendChunkIf(4032);
                            if (needId) {
                                rowId = resultSet.getDouble(recordIdFieldIdx);
                            }
                            data.reset();
                            content.packRecordContent(mag, recordFields, columnsMap, params.tableDescriptor.getNodeId(), rowId, data);
                            out.putEmpty(21);
                            out.putDouble(1, rowId);
                            out.putRaw(2, data);
                        }
                    }
                    result.sendResult();
                    if (recordCount > 30000L || dataSize > 0x4000000L) {
                        Core.logger.warn("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0431\u043e\u043b\u044c\u0448\u043e\u0433\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u0434\u0430\u043d\u043d\u044b\u0445: {} \u0437\u0430\u043f\u0438\u0441\u0435\u0439, {} \u0431\u0430\u0439\u0442", (Object)recordCount, (Object)dataSize);
                    }
                }
                finally {
                    if (context != null) {
                        context.exit();
                    }
                }
            }
            connectionManager.commit();
        }
    }

    @Override
    public void contextMessage(LogContext.Builder out) {
        super.contextMessage(out);
        out.append("d", (long)this.databaseId);
        out.append("t", (long)this.tableNodeId);
        if (this.findNodeId != 0.0) {
            out.append("f", (long)this.findNodeId);
        }
        if (this.ownerNodeId != 0.0) {
            out.append("o", (long)this.ownerNodeId);
        }
        if (this.ownerDatasourceId != 0) {
            out.append("uid", this.ownerDatasourceId);
        }
    }

    public static class Params {
        public TableDescriptor tableDescriptor = null;
        public int fetchLimit = Integer.MAX_VALUE;
        public int blobReceiving = 0;
        public int geoFormat = 0;
        public boolean bomStringMpde = false;
        public boolean needRealId = false;
        public double overrideDatabaseID = 0.0;
        public int nullSortKind = 0;

        public double getDatabaseID() {
            if (this.overrideDatabaseID != 0.0) {
                return this.overrideDatabaseID;
            }
            return this.tableDescriptor.getDbId();
        }
    }
}

