/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.TableLinkList;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;

public class LookupHasDataLink
extends Request {
    public LookupHasDataLink(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(result);
        double master_table_id = in.getDouble(2);
        double master_row_id = in.getDouble(3);
        double child_table_id = in.getDouble(4);
        int data_link = in.getInt(8);
        TableDescriptor masterTDesc = new TableDescriptor(master_table_id, true);
        TableDescriptor childTDesc = new TableDescriptor(child_table_id, true);
        double databaseId = this.getNodeID();
        Node requestNode = MtdEngine.getNode(databaseId);
        if (requestNode != null && requestNode instanceof TableNode) {
            databaseId = ((TableNode)requestNode).getDescriptor().getDbId();
        }
        ConnectionManager connectionManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:LookupHasDataLink");
        try {
            DatabaseConnection connection = connectionManager.getConnection(databaseId, "rq:LookupHasDataLink");
            String masterPKName = masterTDesc.getPrimaryKeyFields().get(0).getRawName();
            String schemeName = connection.getDescriptor().getScheme();
            String masterTName = masterTDesc.getRawName();
            String childTName = childTDesc.getRawName();
            String childLinkField = "";
            TableLinkList linkList = masterTDesc.getLinkList();
            LinkDescriptor lDesc = linkList.getLink(data_link);
            if (lDesc != null && lDesc.getTable() == childTDesc.getNodeId() && lDesc.getFields().size() > 0) {
                for (int i = 0; i < childTDesc.getFields().size(); ++i) {
                    FieldDescriptor fDesc = childTDesc.getFields().get(i);
                    if (lDesc.getFields().get(0).getFieldId() != fDesc.getId()) continue;
                    childLinkField = fDesc.getRawName();
                }
            }
            if (childLinkField.isEmpty()) {
                this.sendError("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043f\u043e\u043b\u0435 \u0441\u0432\u044f\u0437\u0438 \u0443 \u0442\u0430\u0431\u043b\u0438\u0446", "");
                return;
            }
            StringBuilder sql = new StringBuilder();
            sql.append("select  DISTINCT T0.").append(masterPKName);
            sql.append(" from ").append(schemeName).append(".").append(masterTName).append(" T0 ");
            sql.append(" inner join ").append(schemeName).append(".").append(childTName).append(" T1 on ");
            sql.append("(T1.").append(childLinkField).append("=T0.").append(masterPKName);
            sql.append(") where T0.").append(masterPKName).append(" = ?");
            String sqlText = sql.toString();
            try (PreparedStatement statement = connection.prepareStatement(sqlText);){
                statement.setDouble(1, master_row_id);
                try (ResultSet resultSet = statement.executeQuery(null);){
                    if (resultSet.next()) {
                        writer.putDouble(6, child_table_id);
                        writer.putDouble(7, 0.0);
                    }
                }
            }
        }
        finally {
            connectionManager.release();
        }
        writer.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

