/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.schema;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbColumnable;
import inform.agent.db.schema.DbObject;
import inform.agent.db.schema.DbTable;
import inform.agent.db.schema.DbView;
import inform.agent.db.schema.Restructure;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbScheme
extends DbObject {
    protected static final String[] TYPES_TABLE = new String[]{"TABLE"};
    private static final String[] TYPES_VIEW = new String[]{"VIEW"};
    protected final DatabaseType type;
    protected final DatabaseConnection connection;
    protected final DatabaseMetaData metadata;
    protected Map<String, DbTable> tables;
    protected Map<String, DbView> views;

    public DbScheme(DatabaseConnection connection, DatabaseMetaData metadata, String name) {
        super(name);
        if (name != null) {
            this.name = this.toCaseIfNeed(name);
        }
        this.type = connection.getDescriptor().getDatabaseType();
        this.connection = connection;
        this.metadata = metadata;
    }

    public DatabaseType getDatabaseType() {
        return this.type;
    }

    protected String catalog() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Collection<String> fetchNames(SSContext ssContext, String nameFilter, String[] types) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        String cat = this.catalog();
        cat = Strings.isVoid(cat) ? null : Strings.unquote(cat);
        this.name = Strings.isVoid(this.name) ? null : Strings.unquote(this.name);
        nameFilter = Strings.isVoid(nameFilter) ? null : Strings.unquote(nameFilter);
        try (ResultSet rsTables = null;){
            rsTables = this.metadata.getTables(cat, this.name, nameFilter, types);
            if (rsTables != null) {
                while (rsTables.next()) {
                    result.add(this.nameFromDb(rsTables.getString("TABLE_NAME")));
                }
            }
        }
        return result;
    }

    protected Collection<String> fetchTablesNames(SSContext ssContext, String nameFilter) throws SQLException {
        return this.fetchNames(ssContext, nameFilter, TYPES_TABLE);
    }

    protected Collection<String> fetchViewsNames(SSContext ssContext, String nameFilter) throws SQLException {
        return this.fetchNames(ssContext, nameFilter, TYPES_VIEW);
    }

    public Map<String, DbTable> getAllTables(SSContext ssContext) throws SQLException {
        if (this.tables == null) {
            this.tables = new HashMap<String, DbTable>();
            for (String tname : this.fetchTablesNames(ssContext, null)) {
                this.tables.put(tname, this.newTableObject(tname));
            }
        }
        return this.tables;
    }

    public Map<String, DbView> getAllViews(SSContext ssContext) throws SQLException {
        if (this.views == null) {
            this.views = new HashMap<String, DbView>();
            for (String vname : this.fetchViewsNames(ssContext, null)) {
                this.views.put(vname, this.newViewObject(vname));
            }
        }
        return this.views;
    }

    public final DbTable createTable(SSContext ssContext, Statement statement, TableDescriptor td, Restructure.Logger logger) throws InformException, SQLException {
        if (this.getTable(ssContext, td.getRawName()) != null) {
            throw new InformException(String.format("Table with name [%s.%s] already exists", this.name, td.getRawName()));
        }
        DbTable result = this.newTable(ssContext, statement, td, logger);
        result.log("CREATED");
        this.tables.put(result.name, result);
        return result;
    }

    public String getForeignKeyRawName(String tableName, String fieldName, FieldDescriptor fd) {
        if (fd == null || Strings.isVoid(fd.foreignKeyRawName())) {
            return "SYSPHXFKC_" + tableName + "_" + fieldName;
        }
        return fd.foreignKeyRawName();
    }

    public String valueOfColumnDefValue(FieldDescriptor fd) {
        switch (fd.getType()) {
            case BOOLEAN: {
                return this.type.caps().c_bool2sql(fd.getNumberDefValue() != 0.0);
            }
            case INTEGER: {
                return this.type.caps().c_float2sql((long)fd.getNumberDefValue());
            }
            case FLOAT: 
            case METATREE_NODE: 
            case DIRECTORY: {
                return this.type.caps().c_float2sql(fd.getNumberDefValue());
            }
            case INTERVAL: {
                return this.type.caps().c_interval2sql(fd.getNumberDefValue());
            }
            case DATE_TIME: {
                return this.type.caps().c_dateTime2sql(fd.getNumberDefValue());
            }
            case STRING: 
            case UNICODE: {
                return this.type.caps().c_string2sql(fd.getStringDefValue(), true);
            }
        }
        return null;
    }

    public void columnDefValue(FieldDescriptor fd, StringBuilder sql, boolean addSet) {
        if (fd.isHasDefValue()) {
            if (addSet) {
                sql.append(" SET");
            }
            sql.append(" DEFAULT ");
            switch (fd.getType()) {
                case BOOLEAN: {
                    sql.append(this.type.caps().c_bool2sql(fd.getNumberDefValue() != 0.0));
                    break;
                }
                case INTEGER: {
                    sql.append(this.type.caps().c_float2sql((long)fd.getNumberDefValue()));
                    break;
                }
                case FLOAT: 
                case METATREE_NODE: 
                case DIRECTORY: {
                    sql.append(this.type.caps().c_float2sql(fd.getNumberDefValue()));
                    break;
                }
                case INTERVAL: {
                    sql.append(this.type.caps().c_interval2sql(fd.getNumberDefValue()));
                    break;
                }
                case DATE_TIME: {
                    sql.append(this.type.caps().c_dateTime2sql(fd.getNumberDefValue()));
                    break;
                }
                case STRING: 
                case UNICODE: {
                    sql.append(this.type.caps().c_string2sql(fd.getStringDefValue(), true));
                }
            }
        }
    }

    public String columnDefValue(FieldDescriptor fd, boolean addSet) {
        StringBuilder sql = new StringBuilder();
        this.columnDefValue(fd, sql, addSet);
        return sql.toString();
    }

    public String getSqlForTable(TableDescriptor table, DbTable dbTable) {
        List<FieldDescriptor> fields;
        StringBuilder sql = new StringBuilder("CREATE TABLE ");
        sql.append(dbTable.fullName()).append("\r\n(\r\n");
        if (table.getKind() == TableDescriptor.Kind.INTERNAL) {
            fields = new ArrayList<FieldDescriptor>(table.getFields().size() + 1);
            fields.add(FieldDescriptor.getInternalPrimaryKeyField());
            fields.addAll(table.getFields());
        } else {
            fields = table.getFields();
        }
        String comma = " ";
        for (FieldDescriptor fd : fields) {
            if (fd.isVirtual()) continue;
            sql.append(comma).append(this.enquoteIfNeed(fd.getRawName())).append(' ').append(this.ct2sql(fd));
            this.columnDefValue(fd, sql, false);
            if (!fd.isNullable()) {
                sql.append(" NOT");
            }
            sql.append(" NULL");
            comma = ",\r\n ";
        }
        this.genConstraintSql(sql, table);
        for (FieldDescriptor fd : fields) {
            if (fd.isVirtual() || fd.getType() != DataType.DIRECTORY || !fd.isForeignKey()) continue;
            TableDescriptor dir = TableDescriptor.get(fd.getReferenceId());
            sql.append(comma).append(" CONSTRAINT ").append(this.getForeignKeyRawName(dbTable.name(), fd.getRawName(), fd)).append(" FOREIGN KEY (").append(this.enquoteIfNeed(fd.getRawName())).append(") REFERENCES ");
            dir.getDatabaseDescriptor().appendTableRawName(dir.getRawName(), sql);
            sql.append(" (").append(dir.getValidRecordIdField().getRawName()).append(')');
        }
        sql.append("\r\n)\r\n");
        return sql.toString();
    }

    protected final DbTable newTable(SSContext ssContext, Statement statement, TableDescriptor table, Restructure.Logger logger) throws InformException, SQLException {
        DbTable result = this.newTableObject(this.toCaseIfNeed(table.getRawName()));
        String sql = this.getSqlForTable(table, result);
        statement.execute(ssContext, sql);
        logger.log(table, "\u0441\u043e\u0437\u0434\u0430\u043d\u0430 \u043d\u043e\u0432\u0430\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u0432 \u0411\u0414\n%s", sql);
        return result;
    }

    protected void genConstraintSql(StringBuilder sql, TableDescriptor table, String primaryKeyName) {
        sql.append(",\r\nPRIMARY KEY (").append(primaryKeyName).append(')');
    }

    protected final void genConstraintSql(StringBuilder sql, TableDescriptor table) {
        switch (table.getKind()) {
            case INTERNAL: {
                this.genConstraintSql(sql, table, FieldDescriptor.getInternalPrimaryKeyField().getRawName());
                break;
            }
            case EXTERNAL: {
                FieldDescriptor pk;
                if (!table.isExternalStructureManaged() || (pk = table.getRecordIdField()) == null) break;
                this.genConstraintSql(sql, table, pk.getRawName());
            }
        }
    }

    protected DbTable newTableObject(String name) {
        return new DbTable(name, this);
    }

    public final DbTable getTable(SSContext ssContext, String name) throws SQLException {
        if (Strings.isVoid(name)) {
            return null;
        }
        name = this.toCaseIfNeed(name);
        if (this.tables == null) {
            this.tables = new HashMap<String, DbTable>();
        } else if (this.tables.containsKey(name)) {
            return this.tables.get(name);
        }
        DbTable table = this.fetchTablesNames(ssContext, name).isEmpty() ? null : this.newTableObject(name);
        this.tables.put(name, table);
        return table;
    }

    public final DbColumnable getColumnableObject(SSContext ssContext, String name) throws SQLException {
        DbColumnable c = this.getTable(ssContext, name);
        if (c != null) {
            return c;
        }
        c = this.getView(ssContext, name);
        return c;
    }

    public final DbView createView(SSContext ssContext, Statement statement, TableDescriptor td) throws InformException, SQLException {
        if (this.getView(ssContext, td.getRawName()) != null) {
            throw new InformException(String.format("View with name [%s.%s] already exists", this.name, td.getRawName()));
        }
        DbView result = this.newView(ssContext, statement, td);
        result.log("CREATED");
        this.views.put(result.name, result);
        return result;
    }

    protected DbView newView(SSContext ssContext, Statement statement, TableDescriptor td) throws InformException, SQLException {
        DbView result = this.newViewObject(this.toCaseIfNeed(td.getRawName()));
        statement.execute(ssContext, td.getSqlForView());
        return result;
    }

    protected DbView newViewObject(String name) {
        return new DbView(name, this);
    }

    public final DbView getView(SSContext ssContext, String name) throws SQLException {
        if (Strings.isVoid(name)) {
            return null;
        }
        name = this.toCaseIfNeed(name);
        if (this.views == null) {
            this.views = new HashMap<String, DbView>();
        } else if (this.views.containsKey(name)) {
            return this.views.get(name);
        }
        DbView view = this.fetchViewsNames(ssContext, name).isEmpty() ? null : this.newViewObject(name);
        this.views.put(name, view);
        return view;
    }

    @Override
    void deleteInternalDbObject(DbObject obj) {
        if (obj instanceof DbTable) {
            this.tables.remove(obj.name());
        } else if (obj instanceof DbView) {
            this.views.remove(obj.name());
        } else {
            super.deleteInternalDbObject(obj);
        }
    }

    @Override
    void renameInternalDbObject(DbObject obj, String oldName) {
        if (obj instanceof DbTable) {
            this.tables.remove(oldName);
            this.tables.put(obj.name(), (DbTable)obj);
        } else if (obj instanceof DbView) {
            this.views.remove(oldName);
            this.views.put(obj.name(), (DbView)obj);
        } else {
            super.renameInternalDbObject(obj, oldName);
        }
    }

    public String ct2sql(DataType type, FieldDescriptor.BlobRawType brt, int size, boolean keyable) {
        throw new IllegalArgumentException(String.format("Unknown column type [%s]", new Object[]{type}));
    }

    public String ct2sql(FieldDescriptor fd) {
        return this.ct2sql(fd.getType(), fd.getBlobRawType(), fd.getSize(), fd.isRecordIdPresentation());
    }

    public boolean getKeyableByType(int type) {
        return false;
    }

    @Override
    public DbObject getParent() {
        return null;
    }

    @Override
    public DbScheme scheme() {
        return this;
    }

    public String nameFromDb(String name) {
        return name;
    }

    public String toCaseIfNeed(String name) {
        return name;
    }

    public final String enquoteIfNeed(String name) {
        return this.type.caps().enquoteIfNeed(name);
    }

    public boolean isNamesEquals(String nameA, String nameB) {
        if (nameA.equals(nameB)) {
            return true;
        }
        if ((nameA = this.toCaseIfNeed(nameA)).equals(nameB = this.toCaseIfNeed(nameB))) {
            return true;
        }
        nameA = Strings.unquote(nameA);
        nameB = Strings.unquote(nameB);
        return nameA.equals(nameB);
    }

    public DatabaseDescriptor getDescriptor() {
        return this.connection.getDescriptor();
    }

    public DatabaseConnection getConnection() {
        return this.connection;
    }
}

