/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

public enum AggregateFunction {
    NONE(0, ""),
    Sum(1, " sum( "),
    CountEx(2, " count(*)"),
    Count(3, " count("),
    Min(4, " min("),
    Max(5, " max("),
    Avg(6, " avg("),
    StringAGG(7, " string_agg("),
    Unknown(-1, "(");

    private final int typeId;
    public final String sql;
    static final AggregateFunction[] items;

    private AggregateFunction(int value, String sql) {
        this.typeId = value;
        this.sql = sql;
    }

    public int toInt() {
        return this.typeId;
    }

    public static AggregateFunction fromInt(int typeId) {
        if (0 <= typeId && typeId < items.length) {
            return items[typeId];
        }
        return Unknown;
    }

    static {
        items = AggregateFunction.values();
    }
}

