/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.LittleEndian;
import inform.adt.TimeInfo;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.LinkField;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.sql.engine.DataEntry;
import inform.agent.db.sql.engine.FieldExpression;
import inform.agent.db.sql.engine.Function;
import inform.agent.db.sql.engine.Generate;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.db.sql.engine.SearchField;
import inform.agent.db.types.DataType;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import java.io.IOException;
import java.util.ArrayList;

public class Condition {
    public static final String SOURCE_WHERE = "\u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u043f\u043e\u0438\u0441\u043a\u0430";
    public static final String SOURCE_LINK = "\u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u0441\u0432\u044f\u0437\u0438";
    public static final String SOURCE_RELATIONS = "\u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u0441\u0432\u044f\u0437\u0438 \u043f\u043e \u043f\u043e\u043b\u044f\u043c";
    public static final String SOURCE_HAVING = "\u043f\u043e\u0441\u0442\u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u043f\u043e\u0438\u0441\u043a\u0430";
    public static final String SOURCE_HIERARCHY_ROOT = "\u043a\u043e\u0440\u043d\u0435 \u0438\u0435\u0440\u0430\u0440\u0445\u0438\u0438 \u043f\u043e\u0438\u0441\u043a\u0430";
    public static final String SOURCE_HIERARCHY_CONNECTION = "\u0438\u0435\u0440\u0430\u0440\u0445\u0438\u0438 \u043f\u043e\u0438\u0441\u043a\u0430";
    public final boolean havingContext;
    final Search search;
    final String source;
    ArrayList<Item> items;
    ArrayList<Item> originalItems = null;
    private boolean adjusted = false;
    ArrayList<PlainItem> plainItems = null;
    TimeInfo timeInfo = null;

    public Condition(Search search, String source) {
        this.search = search;
        this.source = source;
        this.havingContext = false;
    }

    public Condition(Search search, String source, boolean havingContext) {
        this.search = search;
        this.source = source;
        this.havingContext = havingContext;
    }

    public Condition(Search search, Condition condition) {
        this.search = search;
        this.source = condition.source;
        this.havingContext = condition.havingContext;
        if (condition.items != null) {
            this.items = new ArrayList(condition.items.size());
            for (Item item : condition.items) {
                this.items.add(new Item(item));
            }
        }
    }

    public boolean isEmpty() {
        return this.items == null || this.items.isEmpty();
    }

    public void load(TaggedReader in) throws IOException {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        Item item = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    byte[] raw = in.getRaw();
                    item = new Item();
                    item.braceCount = LittleEndian.getInt(raw, 0);
                    item.operator = Operator.fromInt(LittleEndian.getInt(raw, 4));
                    item.logicalOperator = LogicalOperator.fromInt(LittleEndian.getInt(raw, 8));
                    this.items.add(item);
                    break;
                }
                case 12: {
                    assert (item != null);
                    item.modificator = in.getInt();
                    break;
                }
                case 13: {
                    assert (item != null);
                    assert (item.right != null);
                    item.right.function = Function.fromInt(in.getInt());
                    break;
                }
                case 2: {
                    assert (item != null);
                    byte[] raw = in.getRaw();
                    int entryId = LittleEndian.getInt(raw, 0);
                    Operand operand = item.loadOperand(entryId == -1 ? Operand.Kind.Parameter : Operand.Kind.Field);
                    operand.entryId = entryId;
                    operand.fieldId = LittleEndian.getInt(raw, 4);
                    break;
                }
                case 10: {
                    assert (item != null);
                    Operand operand = item.loadOperand(Operand.Kind.Field);
                    byte[] raw = in.getRaw();
                    operand.entryId = LittleEndian.getInt(raw, 0);
                    operand.fieldId = LittleEndian.getInt(raw, 4);
                    operand.prior = true;
                    break;
                }
                case 3: {
                    assert (item != null);
                    Operand operand = item.loadOperand(Operand.Kind.Value);
                    operand.dataType = DataType.INTEGER;
                    operand.int_val = in.getInt();
                    break;
                }
                case 4: {
                    assert (item != null);
                    Operand operand = item.loadOperand(Operand.Kind.Value);
                    operand.dataType = DataType.FLOAT;
                    operand.dbl_val = in.getDouble();
                    break;
                }
                case 5: {
                    assert (item != null);
                    Operand operand = item.loadOperand(Operand.Kind.Value);
                    operand.dataType = DataType.STRING;
                    operand.str_val = in.getString();
                    break;
                }
                case 6: {
                    assert (item != null);
                    Operand operand = item.loadOperand(Operand.Kind.Value);
                    operand.dataType = DataType.DATE_TIME;
                    operand.dbl_val = in.getDouble();
                    break;
                }
                case 7: {
                    assert (item != null);
                    item.loadOperand(Operand.Kind.Null);
                    break;
                }
                case 8: {
                    assert (item != null);
                    Operand operand = item.loadOperand(Operand.Kind.Parameter);
                    operand.entryId = -1;
                    operand.fieldId = in.getInt();
                    break;
                }
                case 9: {
                    assert (item != null);
                    Operand operand = item.loadOperand(Operand.Kind.Value);
                    operand.dataType = DataType.PRIMARY_KEY;
                    operand.dbl_val = in.getDouble();
                    break;
                }
                case 11: {
                    assert (item != null);
                    item.rightExpression = new FieldExpression();
                    item.rightExpression.load(in.getSubStreamReader());
                }
            }
        }
        for (Item i : this.items) {
            if (i.left == null) {
                i.loadOperand(Operand.Kind.Null);
            }
            if (i.rightExpression != null || i.right != null) continue;
            i.loadOperand(Operand.Kind.Null);
        }
    }

    public void loadRelations(TaggedReader in) throws IOException {
        Item item = null;
        Parameter param = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 10: {
                    item = new Item();
                    if (this.items == null) {
                        this.items = new ArrayList();
                    } else {
                        item.logicalOperator = LogicalOperator.AND;
                    }
                    this.items.add(item);
                    item.modificator = 0;
                    item.ignored = false;
                    item.left = new Operand(Operand.Kind.Field);
                    item.left.entryId = this.search.rootEntry.entryId;
                    in.getInt(item.left.fieldId);
                    param = null;
                    break;
                }
                case 18: {
                    assert (item != null);
                    param = this.search.newParameter(DataType.getDataTypeById(in.getInt()));
                    item.right = new Operand(Operand.Kind.Parameter);
                    item.right.entryId = -1;
                    item.right.fieldId = param.getId();
                    break;
                }
                case 11: {
                    assert (item != null);
                    if (param != null) {
                        param.internalAddValue(in.getDouble());
                        break;
                    }
                    item.right = new Operand(Operand.Kind.Value);
                    item.right.dataType = DataType.PRIMARY_KEY;
                    item.right.dbl_val = in.getDouble();
                    break;
                }
                case 12: {
                    assert (item != null);
                    if (param != null) {
                        param.internalAddValue(null);
                        break;
                    }
                    item.right = new Operand(Operand.Kind.Null);
                    in.skip();
                    break;
                }
                case 13: {
                    assert (item != null);
                    if (param != null) {
                        param.internalAddValue(in.getInt());
                        break;
                    }
                    item.right = new Operand(Operand.Kind.Value);
                    item.right.dataType = DataType.INTEGER;
                    item.right.int_val = in.getInt();
                    break;
                }
                case 14: {
                    assert (item != null);
                    if (param != null) {
                        param.internalAddValue(in.getDouble());
                        break;
                    }
                    item.right.dataType = DataType.FLOAT;
                    item.right.dbl_val = in.getDouble();
                    break;
                }
                case 15: {
                    assert (item != null);
                    if (param != null) {
                        param.internalAddValue(in.getString());
                        break;
                    }
                    item.right.dataType = DataType.STRING;
                    item.right.str_val = in.getString();
                    break;
                }
                case 16: {
                    assert (item != null);
                    if (param != null) {
                        param.internalAddValue(in.getDouble());
                        break;
                    }
                    item.right.dataType = DataType.DATE_TIME;
                    item.right.dbl_val = in.getDouble();
                }
            }
        }
    }

    public void loadSystemLink(int dataLinkId, double parentTableId, double parentRecordId) {
        ArrayList<Item> relations = null;
        int entryId = this.search.rootEntry.entryId;
        switch (dataLinkId) {
            case 1: 
            case 2: {
                relations = new ArrayList<Item>();
                Item item = new Item();
                item.left = new Operand(Operand.Kind.Field);
                item.left.entryId = entryId;
                item.left.fieldId = -1;
                item.operator = Operator.Equal;
                item.right = new Operand(Operand.Kind.Field);
                item.right.entryId = Generate.LINK_ENTRY_ID[dataLinkId];
                item.right.fieldId = 4;
                relations.add(item);
                item = new Item();
                item.logicalOperator = LogicalOperator.AND;
                item.left = new Operand(Operand.Kind.Field);
                item.left.entryId = Generate.LINK_ENTRY_ID[dataLinkId];
                item.left.fieldId = 1;
                item.operator = Operator.Equal;
                item.right = new Operand(Operand.Kind.Value);
                item.right.dataType = DataType.PRIMARY_KEY;
                item.right.dbl_val = parentTableId;
                relations.add(item);
                item = new Item();
                item.logicalOperator = LogicalOperator.AND;
                item.left = new Operand(Operand.Kind.Field);
                item.left.entryId = Generate.LINK_ENTRY_ID[dataLinkId];
                item.left.fieldId = 2;
                item.operator = Operator.Equal;
                item.right = new Operand(Operand.Kind.Value);
                item.right.dataType = DataType.PRIMARY_KEY;
                item.right.dbl_val = parentRecordId;
                relations.add(item);
                item = new Item();
                item.logicalOperator = LogicalOperator.AND;
                item.left = new Operand(Operand.Kind.Field);
                item.left.entryId = Generate.LINK_ENTRY_ID[dataLinkId];
                item.left.fieldId = 3;
                item.operator = Operator.Equal;
                item.right = new Operand(Operand.Kind.Value);
                item.right.dataType = DataType.PRIMARY_KEY;
                item.right.dbl_val = this.search.rootTableId();
                relations.add(item);
                break;
            }
            case 3: 
            case 4: {
                relations = new ArrayList();
                Item item = new Item();
                item.left = new Operand(Operand.Kind.Field);
                item.left.entryId = entryId;
                item.left.fieldId = -1;
                item.operator = Operator.Equal;
                item.right = new Operand(Operand.Kind.Field);
                item.right.entryId = Generate.LINK_ENTRY_ID[dataLinkId];
                item.right.fieldId = 2;
                relations.add(item);
                item = new Item();
                item.logicalOperator = LogicalOperator.AND;
                item.left = new Operand(Operand.Kind.Field);
                item.left.entryId = Generate.LINK_ENTRY_ID[dataLinkId];
                item.left.fieldId = 1;
                item.operator = Operator.Equal;
                item.right = new Operand(Operand.Kind.Value);
                item.right.dataType = DataType.PRIMARY_KEY;
                item.right.dbl_val = this.search.rootTableId();
                relations.add(item);
                item = new Item();
                item.logicalOperator = LogicalOperator.AND;
                item.left = new Operand(Operand.Kind.Field);
                item.left.entryId = Generate.LINK_ENTRY_ID[dataLinkId];
                item.left.fieldId = 3;
                item.operator = Operator.Equal;
                item.right = new Operand(Operand.Kind.Value);
                item.right.dataType = DataType.PRIMARY_KEY;
                item.right.dbl_val = parentTableId;
                relations.add(item);
                item = new Item();
                item.logicalOperator = LogicalOperator.AND;
                item.left = new Operand(Operand.Kind.Field);
                item.left.entryId = Generate.LINK_ENTRY_ID[dataLinkId];
                item.left.fieldId = 4;
                item.operator = Operator.Equal;
                item.right = new Operand(Operand.Kind.Value);
                item.right.dataType = DataType.PRIMARY_KEY;
                item.right.dbl_val = parentRecordId;
                relations.add(item);
            }
        }
        if (relations != null) {
            if (this.items != null && !this.items.isEmpty()) {
                this.items.get((int)0).logicalOperator = LogicalOperator.AND;
                relations.addAll(this.items);
            }
            this.items = relations;
        }
    }

    public void loadDataLink(LinkDescriptor link, SearchEntry entry) {
        ArrayList<Item> relations = null;
        block8: for (LinkField field : link.getFields()) {
            switch (field.getLinkType()) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    continue block8;
                }
            }
            if (relations == null) {
                relations = new ArrayList<Item>();
            }
            Item item = new Item();
            item.logicalOperator = relations.isEmpty() ? LogicalOperator.NONE : LogicalOperator.AND;
            item.left = new Operand(Operand.Kind.Field);
            item.left.entryId = entry.entryId;
            item.left.fieldId = field.getFieldId();
            item.operator = Operator.Equal;
            switch (field.getLinkType()) {
                case 1: {
                    item.right = new Operand(Operand.Kind.Value);
                    item.right.dataType = field.getConstType();
                    item.right.dbl_val = field.getNumberValue();
                    item.right.int_val = (int)item.right.dbl_val;
                    item.right.str_val = field.getStringValue();
                    if (item.right.str_val != null) break;
                    item.right.str_val = "";
                    break;
                }
                case 2: {
                    item.right = new Operand(Operand.Kind.Field);
                    item.right.entryId = entry.parentEntry.entryId;
                    item.right.fieldId = field.getLinkField();
                    break;
                }
                case 3: {
                    item.right = new Operand(Operand.Kind.Field);
                    item.right.entryId = entry.parentEntry.entryId;
                    item.right.fieldId = -1;
                }
            }
            relations.add(item);
        }
        if (relations != null) {
            if (this.items != null && !this.items.isEmpty()) {
                this.items.get((int)0).logicalOperator = LogicalOperator.AND;
                relations.addAll(this.items);
            }
            this.items = relations;
        }
    }

    private void addNullLinkBind(Item nullBind) {
        if (nullBind == null || nullBind.right.kind != Operand.Kind.Field || nullBind.left.fieldId == -1 || nullBind.right.fieldId == -1) {
            return;
        }
        nullBind.braceCount = 1;
        Item b = new Item();
        b.braceCount = 1;
        b.operator = Operator.Equal;
        b.logicalOperator = LogicalOperator.OR;
        b.left = new Operand(Operand.Kind.Field);
        b.left.entryId = nullBind.left.entryId;
        b.left.fieldId = nullBind.left.fieldId;
        b.right = new Operand(Operand.Kind.Null);
        this.items.add(b);
        b = new Item();
        b.braceCount = -2;
        b.operator = Operator.Equal;
        b.logicalOperator = LogicalOperator.AND;
        b.left = new Operand(Operand.Kind.Field);
        b.left.entryId = nullBind.right.entryId;
        b.left.fieldId = nullBind.right.fieldId;
        b.right = new Operand(Operand.Kind.Null);
        this.items.add(b);
    }

    public void loadFieldBindings(TaggedReader in, SearchEntry entry) throws IOException {
        TableDescriptor table = entry.tryGetTableDescriptor();
        if (table == null) {
            return;
        }
        Item b = null;
        Item nullBind = null;
        boolean needAddNullBinds = true;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 13: {
                    needAddNullBinds = false;
                    break;
                }
                case 1: {
                    int tmp_int = in.getInt();
                    FieldDescriptor fieldDescriptor = table.getFieldDescriptor(tmp_int);
                    if (fieldDescriptor == null) {
                        b = null;
                        break;
                    }
                    if (this.items == null) {
                        this.items = new ArrayList();
                    }
                    if (needAddNullBinds) {
                        this.addNullLinkBind(nullBind);
                    }
                    nullBind = null;
                    b = new Item();
                    b.operator = Operator.Equal;
                    b.logicalOperator = this.items.isEmpty() ? LogicalOperator.NONE : LogicalOperator.AND;
                    b.left = new Operand(Operand.Kind.Field);
                    b.left.entryId = entry.entryId;
                    b.left.fieldId = tmp_int;
                    b.lineNo = b.left.fieldId == -1 ? 1 : fieldDescriptor.getIndex() + 2;
                    this.items.add(b);
                    break;
                }
                case 2: {
                    if (b == null) break;
                    b.right = new Operand(Operand.Kind.Parameter);
                    b.right.entryId = -1;
                    b.right.fieldId = in.getInt();
                    break;
                }
                case 12: {
                    Operand.Kind kind;
                    if (b == null) break;
                    int tmp_int = in.getInt();
                    if (tmp_int == 0) {
                        tmp_int = entry.entryId;
                    }
                    Operand.Kind kind2 = kind = tmp_int != -1 ? Operand.Kind.Field : Operand.Kind.Parameter;
                    if (b.right != null) {
                        if (b.right.kind != kind) {
                            Operand right = new Operand(kind);
                            right.fieldId = b.right.fieldId;
                            b.right = right;
                        }
                    } else {
                        b.right = new Operand(kind);
                    }
                    b.right.entryId = tmp_int;
                    break;
                }
                case 4: {
                    if (b == null) break;
                    if (b.right == null) {
                        b.right = new Operand(Operand.Kind.Field);
                    }
                    assert (b.right.kind == Operand.Kind.Field || b.right.kind == Operand.Kind.Parameter);
                    if (b.right.entryId == 0 && entry.parentEntry != null) {
                        b.right.entryId = entry.parentEntry.entryId;
                    }
                    b.right.fieldId = in.getInt();
                    nullBind = b;
                    break;
                }
                case 7: {
                    if (b == null) break;
                    b.right = new Operand(Operand.Kind.Value);
                    b.right.dataType = DataType.INTEGER;
                    b.right.int_val = in.getInt();
                    break;
                }
                case 8: {
                    if (b == null) break;
                    b.right = new Operand(Operand.Kind.Value);
                    b.right.dataType = DataType.FLOAT;
                    b.right.dbl_val = in.getDouble();
                    break;
                }
                case 9: {
                    if (b == null) break;
                    b.right = new Operand(Operand.Kind.Value);
                    b.right.dataType = DataType.STRING;
                    b.right.str_val = in.getString();
                    break;
                }
                case 10: {
                    if (b == null) break;
                    b.right = new Operand(Operand.Kind.Value);
                    b.right.dataType = DataType.DATE_TIME;
                    b.right.dbl_val = in.getDouble();
                    break;
                }
                case 11: {
                    if (b == null) break;
                    b.right = new Operand(Operand.Kind.Null);
                    break;
                }
                case 14: {
                    this.load(in.getSubStreamReader());
                    return;
                }
            }
        }
        if (needAddNullBinds) {
            this.addNullLinkBind(nullBind);
        }
    }

    static Operand createPeriodicOperand(Search search, Search periodicSearch, DataEntry.ActualPointKind kind, int entryId, int fieldId, double value) {
        Operand arg;
        switch (kind) {
            case Bind: {
                if (entryId == -1) {
                    Parameter p = search.getValidParameter(fieldId, "\u0441\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u0442\u043e\u0447\u043a\u0438 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438", "id \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430", periodicSearch.parentEntry.entryId);
                    if (p.getIsIgnored() || p.getIsNull()) {
                        return Condition.createPeriodicOperand(search, periodicSearch, DataEntry.ActualPointKind.Default, entryId, fieldId, value);
                    }
                    if (p.getDataType() != DataType.DATE_TIME) {
                        throw new Search.Exception(search, "\u041d\u0435 \u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 (id: " + fieldId + ") \u0432 \u0441\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u0442\u043e\u0447\u043a\u0438 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438");
                    }
                    if (periodicSearch.parameters == null) {
                        periodicSearch.parameters = new ParametersList();
                    }
                    Parameter np = periodicSearch.parameters.createParameter(DataType.DATE_TIME);
                    np.applyParamBinding(p);
                    np.unwrap();
                    if (np.getValueCount() != 1) {
                        np.setValue(np.getSingleValue());
                    }
                    arg = new Operand(Operand.Kind.Parameter);
                    arg.entryId = -1;
                    arg.fieldId = np.getId();
                    break;
                }
                Parameter np = periodicSearch.parameters.createParameter(DataType.DATE_TIME);
                np.setDatasourceBinding(entryId);
                np.setFieldBinding(fieldId);
                arg = new Operand(Operand.Kind.Parameter);
                arg.entryId = -1;
                arg.fieldId = np.getId();
                break;
            }
            case Value: {
                arg = new Operand(Operand.Kind.Value);
                arg.dataType = DataType.DATE_TIME;
                arg.dbl_val = value;
                break;
            }
            default: {
                arg = new Operand(Operand.Kind.Value);
                arg.dataType = DataType.DATE_TIME;
                arg.dbl_val = periodicSearch.constants.get(-7).getAsDateValue();
            }
        }
        return arg;
    }

    void fillUsedFields(SearchEntry entry, Operand operand) {
        if (operand != null && operand.kind == Operand.Kind.Field && operand.entryId == entry.entryId) {
            entry.addUsedField(operand.fieldId);
        }
    }

    public void fillUsedFields(SearchEntry entry) {
        this.prepare();
        if (this.plainItems.isEmpty()) {
            return;
        }
        for (PlainItem t : this.plainItems) {
            if (t.kind != PlainKind.Condition) continue;
            this.fillUsedFields(entry, t.item.left);
            if (t.item.rightExpression != null && !t.item.rightExpression.isEmpty()) {
                t.item.rightExpression.fillUsedFields(entry);
                continue;
            }
            this.fillUsedFields(entry, t.item.right);
        }
    }

    void applyIneffectiveEntry(int entryId) {
        if (this.isEmpty()) {
            return;
        }
        for (Item item : this.items) {
            if (item.left != null && item.left.kind == Operand.Kind.Field && item.left.entryId == entryId) {
                item.ignored = true;
            }
            if (item.right == null || item.right.kind != Operand.Kind.Field || item.right.entryId != entryId) continue;
            item.ignored = true;
        }
    }

    public void adjust(DatabaseCaps caps) {
        this.adjust(caps, true);
    }

    private DataType getSearchFieldType(SearchEntry entry, int fieldId, int lineNo) {
        Object field;
        if (this.havingContext && entry.parentEntry == null && (field = this.search.fields.find(fieldId)) != null) {
            if (((SearchField)field).dataType == DataType.FLOAT || ((SearchField)field).dataType == DataType.INTEGER || ((SearchField)field).dataType == DataType.BOOLEAN) {
                return ((SearchField)field).dataType;
            }
            switch (((SearchField)field).function) {
                case Count: 
                case CountEx: {
                    return DataType.INTEGER;
                }
                case Avg: {
                    return DataType.FLOAT;
                }
                case StringAGG: {
                    return DataType.STRING;
                }
            }
            return ((SearchField)field).dataType;
        }
        if (fieldId == -1 && entry.getTableDescriptor().getRecordIdField() != null) {
            return DataType.PRIMARY_KEY;
        }
        field = entry.findFieldDescriptor(fieldId);
        if (field == null) {
            return fieldId == -1 ? DataType.PRIMARY_KEY : DataType.NONE;
        }
        return ((FieldDescriptor)field).getType();
    }

    public void adjust(DatabaseCaps caps, boolean processUsage) {
        if (this.adjusted) {
            return;
        }
        this.adjusted = true;
        if (this.isEmpty()) {
            return;
        }
        SearchField searchField = null;
        Item nextItem = null;
        for (int index = this.items.size() - 1; index >= 0; --index) {
            try {
                Item item = this.items.get(index);
                if (item.lineNo < 0) {
                    item.lineNo = index + 1;
                }
                boolean ignored = item.ignored;
                SearchEntry leftEntry = null;
                Parameter rightParam = null;
                if (item.left != null) {
                    if (!item.ignored && item.left.kind == Operand.Kind.Parameter) {
                        Parameter parameter = this.search.getValidParameter(item.left.fieldId, this.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
                        if (parameter.getIsIgnored()) {
                            ignored = true;
                        }
                    } else if (item.left.kind == Operand.Kind.Field && item.left.entryId != -10) {
                        if (this.search.isUnionItem() && this.search.parentSearch != null && item.left.entryId == this.search.parentSearch.rootEntry.entryId) {
                            item.left.entryId = this.search.rootEntry.entryId;
                        }
                        leftEntry = this.search.getValidEntry(item.left.entryId, this.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
                        item.left.dataType = this.getSearchFieldType(leftEntry, item.left.fieldId, item.lineNo);
                        if (processUsage) {
                            leftEntry.addUsage();
                        }
                    }
                }
                if (item.rightExpression != null) {
                    if (searchField == null) {
                        searchField = new SearchField(Integer.MAX_VALUE);
                        searchField.source = this.source;
                        searchField.line = "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ";
                    }
                    searchField.lineNo = item.lineNo;
                    searchField.expression = item.rightExpression;
                    item.rightExpression.adjust(this.search, caps, searchField);
                    if (item.rightExpression.terms == null || item.rightExpression.terms.isEmpty()) {
                        ignored = true;
                    }
                } else if (item.operator == Operator.Expression) {
                    ignored = true;
                } else if (item.right == null) {
                    ignored = true;
                } else if (item.right.kind == Operand.Kind.Parameter) {
                    rightParam = this.search.getValidParameter(item.right.fieldId, this.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
                    if (rightParam.getIsIgnored()) {
                        ignored = true;
                    }
                } else if (item.right.kind == Operand.Kind.Field && item.right.entryId != -10) {
                    if (this.search.isUnionItem() && this.search.parentSearch != null && item.right.entryId == this.search.parentSearch.rootEntry.entryId) {
                        item.right.entryId = this.search.rootEntry.entryId;
                    }
                    SearchEntry entry = this.search.getValidEntry(item.right.entryId, this.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
                    item.right.dataType = this.getSearchFieldType(entry, item.right.fieldId, item.lineNo);
                    if (entry.isSubject()) {
                        switch (item.operator) {
                            case Equal: {
                                item.operator = Operator.In;
                                break;
                            }
                            case NotEqual: {
                                item.operator = Operator.NotIn;
                            }
                        }
                    } else if (processUsage) {
                        entry.addUsage();
                    }
                }
                if (!ignored) {
                    if (item.right != null) {
                        SearchEntry entry;
                        Search deepSearch;
                        if (item.left.isFieldOrParam() && item.right.isIntegerValue()) {
                            item.right.changeIntegerType(item.left.dataType);
                        } else if (item.right.isFieldOrParam() && item.left.isIntegerValue()) {
                            item.left.changeIntegerType(item.right.dataType);
                        }
                        if (this.search.isSubject() && processUsage && rightParam != null && rightParam.getDatasourceBinding() != 0 && (deepSearch = this.search.getDeepSearch()) != null && (entry = deepSearch.entries.get(rightParam.getDatasourceBinding())) != null) {
                            entry.addUsage();
                        }
                    }
                    nextItem = item;
                    continue;
                }
                if (leftEntry != null) {
                    if (processUsage) {
                        leftEntry.withdraw();
                    }
                    leftEntry.checkUsageCount(true);
                }
                if (index > 0) {
                    Item prevItem = this.items.get(index - 1);
                    prevItem.braceCount += item.braceCount;
                } else if (nextItem != null) {
                    nextItem.braceCount += item.braceCount;
                }
                this.items.remove(index);
                continue;
            }
            catch (Search.Exception e) {
                throw e;
            }
            catch (Throwable e) {
                int lineNo = index + 1;
                throw new Search.Exception(this.search, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 " + this.source + " (\u0441\u0442\u0440\u043e\u043a\u0430: " + lineNo + ")", e);
            }
        }
        if (this.isEmpty()) {
            this.items = null;
        } else {
            this.items.get((int)0).logicalOperator = LogicalOperator.NONE;
        }
    }

    public void prepare() {
        if (this.plainItems != null) {
            return;
        }
        this.plainItems = new ArrayList();
        if (this.isEmpty()) {
            return;
        }
        for (Item item : this.items) {
            int i;
            if (item.logicalOperator != LogicalOperator.NONE) {
                this.plainItems.add(new PlainItem(PlainKind.Operator, item));
            }
            for (i = 0; i < item.braceCount; ++i) {
                this.plainItems.add(new PlainItem(PlainKind.OpenBrace, item));
            }
            this.plainItems.add(new PlainItem(PlainKind.Condition, item));
            for (i = 0; i > item.braceCount; --i) {
                this.plainItems.add(new PlainItem(PlainKind.CloseBrace, item));
            }
        }
    }

    private int addAnsiHierarchicAdditionalField(int hierarchicId, Item item, SearchEntry entry, int fieldId) {
        SearchField field2;
        if (entry.entryId == hierarchicId) {
            return fieldId;
        }
        for (SearchField field2 : this.search.additionalFields) {
            if (field2.mapFieldId != fieldId || field2.mapEntryId != entry.entryId) continue;
            return field2.id;
        }
        FieldDescriptor fieldDescriptor = entry.getValidFieldDescriptor(fieldId, this.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
        field2 = this.search.newAdditionalFieldId("R", entry.entryId, fieldId, fieldDescriptor.getType(), fieldDescriptor.getSize(), fieldDescriptor.isNullable());
        return field2.id;
    }

    private void adjustAnsiHierarchicOperand(int hierarchicId, Item item, Operand operand, boolean force) {
        SearchEntry entry;
        if (operand == null) {
            return;
        }
        if (operand.kind != Operand.Kind.Field || operand.entryId < 0) {
            operand.prior = false;
            return;
        }
        if ((force || operand.prior) && !(entry = this.search.getValidEntry(operand.entryId, this.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo)).isSubject()) {
            operand.fieldId = this.addAnsiHierarchicAdditionalField(hierarchicId, item, entry, operand.fieldId);
            operand.entryId = hierarchicId;
        }
        operand.prior = false;
    }

    public void adjustAnsiHierarchic(int hierarchicId, DatabaseCaps caps, boolean force) {
        this.adjust(caps, true);
        if (this.items != null) {
            for (Item item : this.items) {
                this.adjustAnsiHierarchicOperand(hierarchicId, item, item.left, force);
                this.adjustAnsiHierarchicOperand(hierarchicId, item, item.right, force);
                if (!force || item.rightExpression == null || item.rightExpression.terms == null) continue;
                for (FieldExpression.Term term : item.rightExpression.terms) {
                    if (term.token != FieldExpression.Token.Argument || term.item == null || term.item.kind != FieldExpression.Kind.Field) continue;
                    SearchEntry entry = this.search.getValidEntry(term.item.entryId, this.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
                    term.item.fieldId = this.addAnsiHierarchicAdditionalField(hierarchicId, item, entry, term.item.fieldId);
                    term.item.entryId = hierarchicId;
                }
            }
        }
    }

    public void reset() {
        block3: {
            block2: {
                this.adjusted = false;
                this.plainItems = null;
                if (this.items == null || this.originalItems != null) break block2;
                this.originalItems = new ArrayList(this.items.size());
                for (Item item : this.items) {
                    this.originalItems.add(new Item(item));
                }
                break block3;
            }
            if (this.originalItems == null) break block3;
            this.items = new ArrayList(this.originalItems.size());
            for (Item item : this.originalItems) {
                this.items.add(new Item(item));
            }
        }
    }

    public static class PlainItem {
        public final PlainKind kind;
        public final Item item;

        public PlainItem(PlainKind kind, Item item) {
            this.kind = kind;
            this.item = item;
        }
    }

    public static enum PlainKind {
        Empty,
        OpenBrace,
        CloseBrace,
        Operator,
        Condition;

    }

    public static class Item {
        public int braceCount = 0;
        public LogicalOperator logicalOperator = LogicalOperator.NONE;
        public Operand left = null;
        public Operator operator = Operator.NONE;
        public Operand right = null;
        public FieldExpression rightExpression = null;
        public int modificator = 0;
        public boolean ignored = false;
        public int lineNo = -1;

        public Item() {
        }

        public Item(Item item) {
            this.braceCount = item.braceCount;
            this.logicalOperator = item.logicalOperator;
            if (item.left != null) {
                this.left = new Operand(item.left);
            }
            this.operator = item.operator;
            if (item.right != null) {
                this.right = new Operand(item.right);
            }
            if (item.rightExpression != null) {
                this.rightExpression = new FieldExpression(item.rightExpression);
            }
            this.modificator = item.modificator;
            this.ignored = item.ignored;
            this.lineNo = item.lineNo;
        }

        private Operand loadOperand(Operand.Kind kind) {
            if (this.left == null) {
                this.left = new Operand(kind);
                return this.left;
            }
            assert (this.right == null);
            this.right = new Operand(kind);
            return this.right;
        }
    }

    public static class Operand {
        final Kind kind;
        Function function = Function.NONE;
        DataType dataType = DataType.NONE;
        boolean prior = false;
        int entryId = 0;
        int fieldId = 0;
        int int_val = 0;
        double dbl_val = 0.0;
        String str_val = "";

        public Operand(Kind kind) {
            this.kind = kind;
        }

        public Operand(Operand o) {
            this.kind = o.kind;
            this.function = o.function;
            this.dataType = o.dataType;
            this.prior = o.prior;
            this.entryId = o.entryId;
            this.fieldId = o.fieldId;
            this.int_val = o.int_val;
            this.dbl_val = o.dbl_val;
            this.str_val = o.str_val;
        }

        boolean isFieldOrParam() {
            return this.kind == Kind.Parameter || this.kind == Kind.Field;
        }

        boolean isIntegerValue() {
            return this.kind == Kind.Value && this.dataType == DataType.INTEGER;
        }

        public void changeIntegerType(DataType dataType) {
            assert (this.isIntegerValue());
            switch (dataType) {
                case BOOLEAN: {
                    this.dataType = dataType;
                    break;
                }
                case FLOAT: 
                case INTERVAL: {
                    this.dataType = dataType;
                    this.dbl_val = this.int_val;
                    break;
                }
                case STRING: 
                case UNICODE: 
                case BIG_NUMBER: {
                    this.dataType = dataType;
                    this.str_val = Integer.toString(this.int_val);
                }
            }
        }

        public static enum Kind {
            Null,
            Value,
            Parameter,
            Field;

        }
    }

    public static enum LogicalOperator {
        NONE(0, " "),
        AND(1, " and "),
        OR(2, " or ");

        private final int typeId;
        public final String sql;
        static final LogicalOperator[] items;

        private LogicalOperator(int value, String sql) {
            this.typeId = value;
            this.sql = sql;
        }

        public int toInt() {
            return this.typeId;
        }

        public static LogicalOperator fromInt(int typeId) {
            if (0 <= typeId && typeId < items.length) {
                return items[typeId];
            }
            return NONE;
        }

        static {
            items = LogicalOperator.values();
        }
    }

    public static enum Operator {
        NONE(0, " "),
        Equal(1, " = "),
        NotEqual(2, " <> "),
        More(3, " > "),
        MoreOrEqual(4, " >= "),
        Less(5, " < "),
        LessOrEqual(6, " <= "),
        Like(7, " like "),
        NotLike(8, " not like "),
        LikeEx(9, " like "),
        NotLikeEx(10, " not like "),
        Expression(11, " ???CUSTOM_SQL_EXPR??? "),
        In(1000, " in "),
        NotIn(1001, " not in ");

        private final int typeId;
        public final String sql;
        static final Operator[] items;

        private Operator(int value, String sql) {
            this.typeId = value;
            this.sql = sql;
        }

        public int toInt() {
            return this.typeId;
        }

        public static Operator fromInt(int typeId) {
            if (0 <= typeId && typeId < items.length) {
                Operator result = items[typeId];
                if (result.typeId == typeId) {
                    return result;
                }
            }
            return NONE;
        }

        static {
            items = Operator.values();
        }
    }
}

