/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.collections.ArrayMap;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.LinkField;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.sql.engine.Condition;
import inform.agent.db.sql.engine.FieldExpression;
import inform.agent.db.sql.engine.Generate;
import inform.agent.db.sql.engine.PeriodicTables;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.db.sql.engine.SearchField;
import inform.agent.db.sql.engine.SearchFields;
import inform.agent.db.sql.engine.TableEntry;
import inform.agent.db.types.DataType;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.sql.JoinType;
import java.io.IOException;
import java.util.ArrayList;

public abstract class DataEntry
extends SearchEntry {
    JoinType joinType = JoinType.INNER;
    int linkId;
    LinkDescriptor linkDescriptor;
    Condition linkCondition;
    Condition fieldBindings;
    ActualPointKind actualPointKind = ActualPointKind.Default;
    int actualPointEntry;
    int actualPointField;
    double actualPointValue;
    ArrayList<SearchEntry> linkedEntries;

    public DataEntry(int entryId, SearchEntry.Kind kind, double tableId) {
        super(entryId, kind, tableId);
    }

    @Override
    void loaded() {
        super.loaded();
        if (this.parentEntry == this.owner.rootEntry && this.owner.kind == Search.Kind.Advanced) {
            this.linkId = 0;
            this.fieldBindings = null;
        }
        if (this.parentEntry != null) {
            if (0 < this.linkId && this.linkId < 5) {
                throw new Search.Exception(this.owner, "\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u0435 \u0441\u0432\u044f\u0437\u0438 \u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b, \u0421\u0432\u044f\u0437\u0430\u043d\u043d\u043e\u0435, \u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432, \u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0421\u0432\u044f\u0437\u0430\u043d\u043d\u043e\u0433\u043e");
            }
            if (this.linkId > 5) {
                TableDescriptor parentTable = this.parentEntry.getTableDescriptor();
                try {
                    this.linkDescriptor = parentTable.getLinkList().getLink(this.linkId);
                    if (this.linkDescriptor != null) {
                        this.linkCondition = new Condition(this.owner, "\u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u0441\u0432\u044f\u0437\u0438");
                        this.linkCondition.loadDataLink(this.linkDescriptor, this);
                    }
                }
                catch (IOException e) {
                    throw InformException.wrap(e);
                }
            }
        }
    }

    @Override
    public void reset() {
        if (this.linkedEntries != null) {
            this.linkedEntries.clear();
        }
        super.reset();
    }

    @Override
    public boolean hasDistinctRelations() {
        if (this.ignored() || this.parentEntry == null || this.linkId == 5) {
            return this.hasChildrenDistinctRelations();
        }
        if (this.linkId >= 1 && this.linkId <= 4) {
            return true;
        }
        if (this.linkId == 0 && (this.fieldBindings == null || this.fieldBindings.isEmpty())) {
            return true;
        }
        boolean hasRelationWithParents = false;
        if (this.linkDescriptor != null) {
            block4: for (LinkField f : this.linkDescriptor.getFields()) {
                switch (f.getLinkType()) {
                    case 2: 
                    case 3: {
                        if (f.getFieldId() == -1) continue block4;
                        return true;
                    }
                    case 1: {
                        return true;
                    }
                }
                hasRelationWithParents = true;
                return true;
            }
        }
        if (this.fieldBindings != null) {
            for (Condition.Item item : this.fieldBindings.items) {
                if (item.left.kind != Condition.Operand.Kind.Field) {
                    return true;
                }
                if (item.left.fieldId == -1) {
                    if (item.right.kind == Condition.Operand.Kind.Parameter && this.owner != null && this.owner.parameters != null) {
                        Parameter p = this.owner.parameters.get(item.right.fieldId);
                        if (p == null) {
                            return true;
                        }
                        if (!p.getIsIgnored() && p.getValueCount() > 1) {
                            return true;
                        }
                    }
                    hasRelationWithParents = true;
                    continue;
                }
                SearchEntry entry = item.left.entryId == this.entryId || this.owner == null ? this : this.owner.getValidEntry(item.left.entryId, this.fieldBindings.source, "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ", item.lineNo);
                TableDescriptor table = entry.getTableDescriptor();
                FieldDescriptor field = table.getFieldDescriptor(item.left.fieldId);
                if (field == null) {
                    return true;
                }
                if (field.isPrimaryKey()) {
                    if (item.right.kind == Condition.Operand.Kind.Parameter && this.owner != null && this.owner.parameters != null) {
                        Parameter p = this.owner.parameters.get(item.right.fieldId);
                        if (p == null) {
                            return true;
                        }
                        if (!p.getIsIgnored() && p.getValueCount() > 1) {
                            return true;
                        }
                    }
                    hasRelationWithParents = true;
                    continue;
                }
                return true;
            }
        }
        if (!hasRelationWithParents) {
            return true;
        }
        return this.hasChildrenDistinctRelations();
    }

    @Override
    public boolean hasRelations() {
        return this.linkCondition != null && !this.linkCondition.isEmpty() || this.fieldBindings != null && !this.fieldBindings.isEmpty();
    }

    @Override
    public void adjustRelations(DatabaseCaps caps) {
        super.adjustRelations(caps);
        if (this.linkCondition != null) {
            this.linkCondition.adjust(caps, false);
        }
        if (this.fieldBindings != null) {
            this.fieldBindings.adjust(caps, false);
            if (!this.fieldBindings.isEmpty()) {
                for (Condition.Item item : this.fieldBindings.items) {
                    SearchEntry entry;
                    if (item.left.kind == Condition.Operand.Kind.Field && !this.isChildOf(item.left.entryId)) {
                        if (this.linkedEntries == null) {
                            this.linkedEntries = new ArrayList();
                        }
                        if ((entry = this.owner.entries.get(item.left.entryId)) != null) {
                            this.linkedEntries.add(entry);
                        }
                    }
                    if (item.right != null && item.right.kind == Condition.Operand.Kind.Field && !this.isChildOf(item.right.entryId)) {
                        if (this.linkedEntries == null) {
                            this.linkedEntries = new ArrayList();
                        }
                        if ((entry = this.owner.entries.get(item.right.entryId)) != null) {
                            this.linkedEntries.add(entry);
                        }
                    }
                    if (item.rightExpression == null || item.rightExpression.terms == null) continue;
                    for (FieldExpression.Term term : item.rightExpression.terms) {
                        SearchEntry entry2;
                        if (term.token != FieldExpression.Token.Argument || term.item.kind != FieldExpression.Kind.Field || this.isChildOf(term.item.entryId)) continue;
                        if (this.linkedEntries == null) {
                            this.linkedEntries = new ArrayList();
                        }
                        if ((entry2 = this.owner.entries.get(term.item.entryId)) == null) continue;
                        this.linkedEntries.add(entry2);
                    }
                }
            }
        }
    }

    @Override
    public void addLinkUsage() {
        if (!(this.linkVisibility() || this.linkedEntries == null || this.linkedEntries.isEmpty() || this.excludeIfExcludedFromConditions() && (this.checkUsageCount() || this.owner.entryExclusionMethod == Generate.EntryExclusionMethod.WithParent) && this.usageCount == 0)) {
            for (SearchEntry entry : this.linkedEntries) {
                if (entry.linkVisibility()) continue;
                entry.linkVisibility(true);
                entry.addUsage();
                entry.addLinkUsage();
            }
        }
        super.addLinkUsage();
    }

    @Override
    void fillUsedFields(SearchEntry entry) {
        if (!this.ignored()) {
            this.owner.fillUsedFields(entry, this.linkCondition);
            this.owner.fillUsedFields(entry, this.fieldBindings);
        }
        super.fillUsedFields(entry);
    }

    @Override
    public int initNestedAlias(int alias) {
        if (this.inplaceSearch != null) {
            alias = this.inplaceSearch.initEntryAlias(alias);
        }
        return this.initChildNestedAlias(alias);
    }

    @Override
    void expandPeriodic() {
        if (this.periodicExpanded()) {
            return;
        }
        this.periodicExpanded(true);
        if (this.inplaceSearch != null || this.excludePeriodicData()) {
            return;
        }
        TableDescriptor tableDescriptor = this.getTableDescriptor();
        if (!tableDescriptor.isHasPeriodicStorage()) {
            return;
        }
        PeriodicTables periodicTables = new PeriodicTables(tableDescriptor);
        for (FieldDescriptor field : tableDescriptor.getFields()) {
            if (!field.hasPeriodicStorage() || this.significantFields != null && !this.significantFields.contains(field.getId())) continue;
            periodicTables.add(field.getPeriodicStorage().tableId);
        }
        if (periodicTables.isEmpty()) {
            return;
        }
        this.inplaceSearch = new Search(this.owner);
        this.inplaceSearch.kind = Search.Kind.Advanced;
        this.inplaceSearch.searchNodeId = this.owner.searchNodeId;
        this.inplaceSearch.isNested(true);
        this.inplaceSearch.parentEntry = this;
        this.inplaceSearch.rootEntry = new TableEntry(++this.inplaceSearch.lastEntryId, this.tableId, this.inplaceSearch);
        this.inplaceSearch.rootEntry.generated(true);
        TableEntry entry = new TableEntry(++this.inplaceSearch.lastEntryId, this.tableId, this.inplaceSearch);
        this.inplaceSearch.rootEntry.addEntry(entry);
        this.inplaceSearch.entries.add(this.inplaceSearch.rootEntry);
        this.inplaceSearch.entries.add(entry);
        this.inplaceSearch.periodicInitialized(true);
        Condition.Operand periodicOperand = Condition.createPeriodicOperand(this.owner, this.inplaceSearch, this.actualPointKind, this.actualPointEntry, this.actualPointField, this.actualPointValue);
        for (PeriodicTables.Table table : periodicTables.tables) {
            if (table.table == null) continue;
            TableEntry e = new TableEntry(++this.inplaceSearch.lastEntryId, table.storage.tableId, this.inplaceSearch);
            entry.addEntry(e);
            e.parentEntry = entry;
            this.inplaceSearch.entries.add(e);
            table.entryId = e.entryId;
            e.joinType = JoinType.LEFT_OUTER;
            e.fieldBindings = new Condition(this.inplaceSearch, "\u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u0441\u0432\u044f\u0437\u0438 \u043f\u043e \u043f\u043e\u043b\u044f\u043c");
            e.fieldBindings.items = new ArrayList();
            Condition.Item item = new Condition.Item();
            e.fieldBindings.items.add(item);
            item.operator = Condition.Operator.Equal;
            item.left = new Condition.Operand(Condition.Operand.Kind.Field);
            item.left.entryId = e.entryId;
            item.left.fieldId = table.storage.referenceFieldId;
            item.right = new Condition.Operand(Condition.Operand.Kind.Field);
            item.right.entryId = entry.entryId;
            item.right.fieldId = -1;
            item = new Condition.Item();
            e.fieldBindings.items.add(item);
            item.logicalOperator = Condition.LogicalOperator.AND;
            item.operator = Condition.Operator.LessOrEqual;
            item.left = new Condition.Operand(Condition.Operand.Kind.Field);
            item.left.entryId = e.entryId;
            item.left.fieldId = table.storage.beginFieldId;
            item.right = periodicOperand;
            item = new Condition.Item();
            e.fieldBindings.items.add(item);
            item.logicalOperator = Condition.LogicalOperator.AND;
            item.operator = Condition.Operator.More;
            item.left = new Condition.Operand(Condition.Operand.Kind.Field);
            item.left.entryId = e.entryId;
            item.left.fieldId = table.storage.endFieldId;
            item.right = periodicOperand;
        }
        this.inplaceSearch.fields = new SearchFields(this.inplaceSearch.rootEntry.getTableDescriptor(), true);
        if (tableDescriptor.getKind() == TableDescriptor.Kind.INTERNAL) {
            SearchField field = new SearchField(-1);
            field.dataType = DataType.PRIMARY_KEY;
            field.proxyField = tableDescriptor.getRecordIdField();
            if (field.proxyField == null) {
                field.proxyField = FieldDescriptor.getInternalPrimaryKeyField();
            }
            this.inplaceSearch.fields.items.add(0, field);
        }
        block6: for (SearchField sf : this.inplaceSearch.fields.items) {
            switch (sf.dataType) {
                case VARIANT: 
                case FILE: {
                    continue block6;
                }
                case BLOB: {
                    continue block6;
                }
            }
            if (sf.proxyField == null || sf.proxyField.getKind() != 0 || sf.expression != null) continue;
            sf.expression = new FieldExpression();
            if (sf.id == -1) {
                sf.expression.newField(entry.entryId, -1);
                continue;
            }
            if (sf.proxyField.hasPeriodicStorage()) {
                PeriodicTables.Table table = periodicTables.find(sf.proxyField.getPeriodicStorage().tableId);
                if (table == null || table.table == null || table.entryId == 0) continue;
                sf.expression.newField(table.entryId, sf.proxyField.getPeriodicStorage().fieldId);
                continue;
            }
            sf.expression.newField(entry.entryId, sf.id);
        }
    }

    @Override
    public void excludeByRelations() {
        if (!(this.linkVisibility() || this.linkedEntries == null || this.linkedEntries.isEmpty() || this.excludeIfExcludedFromConditions() && (this.checkUsageCount() || this.owner.entryExclusionMethod == Generate.EntryExclusionMethod.WithParent) && this.usageCount == 0)) {
            this.owner.rootEntry.clearLinkVisibility();
            this.addLinkUsage();
        }
        super.excludeByRelations();
    }

    @Override
    public void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 8: {
                this.joinType = JoinType.LEFT_OUTER;
                break;
            }
            case 3: {
                this.linkId = in.getInt();
                break;
            }
            case 10: {
                this.fieldBindings = new Condition(this.owner, "\u0441\u0432\u044f\u0437\u0438 \u043f\u043e \u043f\u043e\u043b\u044f\u043c \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 " + this.toString());
                this.fieldBindings.loadFieldBindings(in.getSubStreamReader(), this);
                break;
            }
            case 11: {
                this.excludeIfExcludedFromConditions(false);
                break;
            }
            case 12: {
                if (this.actualPointKind == ActualPointKind.Disabled) {
                    in.skip();
                    in.skip();
                    break;
                }
                this.loadActualPointBind(in.getSubStreamReader());
                break;
            }
            case 16: {
                this.actualPointKind = ActualPointKind.Disabled;
                break;
            }
            default: {
                super.loadTag(in);
            }
        }
    }

    private void loadActualPointBind(TaggedReader in) throws IOException {
        if (this.actualPointKind == ActualPointKind.Disabled) {
            return;
        }
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    byte[] raw = in.getRaw();
                    this.actualPointEntry = LittleEndian.getInt(raw, 0);
                    this.actualPointField = LittleEndian.getInt(raw, 4);
                    this.actualPointKind = ActualPointKind.Bind;
                    break;
                }
                case 2: {
                    this.actualPointValue = in.getDouble();
                    this.actualPointKind = ActualPointKind.Value;
                }
            }
        }
    }

    public void setActualPointValue(double actualPointValue) {
        this.actualPointValue = actualPointValue;
        this.actualPointKind = ActualPointKind.Value;
    }

    @Override
    protected void assignProps(SearchEntry entry) {
        super.assignProps(entry);
        if (entry instanceof DataEntry) {
            DataEntry dataEntry = (DataEntry)entry;
            this.joinType = dataEntry.joinType;
            this.linkId = dataEntry.linkId;
            this.actualPointKind = dataEntry.actualPointKind;
            this.actualPointEntry = dataEntry.actualPointEntry;
            this.actualPointField = dataEntry.actualPointField;
            this.actualPointValue = dataEntry.actualPointValue;
        }
    }

    public static enum ActualPointKind {
        Default(0),
        Bind(1),
        Value(2),
        Disabled(-1);

        private final int typeId;
        static final ArrayMap<ActualPointKind> kindMap;

        private ActualPointKind(int value) {
            this.typeId = value;
        }

        public int toInt() {
            return this.typeId;
        }

        public static ActualPointKind fromInt(int typeId) {
            return kindMap.get(typeId);
        }

        static {
            kindMap = new ArrayMap<ActualPointKind>(ActualPointKind.values());
        }
    }
}

