/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.types;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.connect.oracle.Geometry;
import inform.common.Empty;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public abstract class Geometry {
    protected static final int VER_ORAOLD = 0;
    protected static final int VER_ORACLE = 1;
    protected static final int VER_POSTGRESQL = 2;
    protected static final int VER_WKB = 3;
    private static final int TAG_VERSION = 1;
    protected static final int TAG_DATA = 2;
    private final int version;

    public static Geometry deserialize(byte[] data) throws IOException, TaggedReaderException {
        if (data.length == 0) {
            return null;
        }
        TaggedReader reader = new TaggedReader(data);
        if (!reader.next()) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u0435\u0441\u0435\u0440\u0438\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u0442\u044c \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044e");
        }
        int version = reader.getInt(1);
        switch (version) {
            case 0: {
                return new Geometry.Old(reader);
            }
            case 1: {
                return new Geometry.New(reader);
            }
            case 2: {
                return new inform.agent.db.connect.postgresql.Geometry(reader);
            }
            case 3: {
                return new WkbGeometry(reader);
            }
        }
        throw new UnsupportedOperationException("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044f\u043c\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438: " + version);
    }

    public Geometry(int version) {
        this.version = version;
    }

    public final void serialize(OutputStream out) throws IOException {
        TaggedWriter writer = new TaggedWriter(out);
        writer.putInt32(1, this.version);
        this.store(writer);
        writer.flush();
    }

    public final void serializeWkb(ByteArrayOutputStream out) throws IOException, SQLException {
        TaggedWriter writer = new TaggedWriter(out);
        writer.putInt32(1, 3);
        byte[] wkb = this.toWKB();
        if (wkb.length != 0) {
            writer.putRaw(2, wkb);
        }
        writer.flush();
    }

    protected abstract void store(TaggedWriter var1) throws IOException;

    public abstract byte[] toWKB() throws SQLException;

    public String toString() {
        return String.format("G[%1X]", this.version);
    }

    public static class WkbGeometry
    extends Geometry {
        private final byte[] data;

        WkbGeometry(TaggedReader reader) throws IOException, TaggedReaderException {
            super(3);
            this.data = reader.next() ? reader.getRaw(2) : Empty.byteArray;
        }

        public WkbGeometry(byte[] wkb) {
            super(3);
            this.data = wkb;
        }

        @Override
        protected void store(TaggedWriter out) throws IOException {
            if (this.data.length != 0) {
                out.putRaw(2, this.data);
            }
        }

        @Override
        public byte[] toWKB() {
            return this.data;
        }
    }
}

