/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.utils;

import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlParameter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class SqlParameterList
extends ArrayList<SqlParameter> {
    public void applyTo(PreparedStatement statement) throws SQLException {
        int paramIndex = 1;
        for (SqlParameter param : this) {
            param.applyTo(paramIndex, statement);
            ++paramIndex;
        }
    }

    public int nvlCount() {
        int count = 0;
        for (SqlParameter p : this) {
            if (!p.isNull()) continue;
            ++count;
        }
        return count;
    }

    public void addParameters(SqlParameterList params) {
        for (SqlParameter p : params) {
            this.addParameter(p);
        }
    }

    public void addParameter(SqlParameter p) {
        if (p.getType() == SqlDataType.BLOB && p.getBlobRawType() == FieldDescriptor.BlobRawType.TEXT) {
            SqlParameter clob = new SqlParameter(SqlDataType.STRING);
            byte[] data = p.getBlob();
            String text = data == null ? "" : new String(p.getBlob(), TaggedWriter.ANSI);
            clob.setString(text);
            this.add(clob);
        } else {
            this.add(p);
        }
    }

    public SqlParameterList cloneStruct() {
        SqlParameterList list = new SqlParameterList();
        for (SqlParameter p : this) {
            list.add(new SqlParameter(p.getType()));
        }
        return list;
    }

    public boolean isEqualValues(SqlParameterList list) {
        if (this.size() != list.size()) {
            return false;
        }
        Iterator it = this.iterator();
        Iterator il = list.iterator();
        while (it.hasNext() && il.hasNext()) {
            SqlParameter t = (SqlParameter)it.next();
            SqlParameter l = (SqlParameter)il.next();
            if (t == null || l == null) {
                return false;
            }
            if (t.isEqualValue(l)) continue;
            return false;
        }
        return true;
    }
}

