/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.expr;

import inform.adt.taggedio.TaggedReader;
import inform.agent.expr.Expression;
import inform.agent.expr.Term;
import java.io.IOException;

public class OperationTerm
extends Term {
    private int operationId = -1;
    protected int rangeId = 0;
    protected boolean any = false;
    protected Expression.Token token = Expression.Token.invalid;
    protected Expression.Priority priority = Expression.Priority.NONE;
    public static final int opNOP = -1;
    public static final int opPlus = 0;
    public static final int opMinus = 1;
    public static final int opMulti = 2;
    public static final int opDiv = 3;
    public static final int opPerc = 4;
    public static final int opLess = 5;
    public static final int opLessEqual = 6;
    public static final int opMore = 7;
    public static final int opMoreEqual = 8;
    public static final int opEqual = 9;
    public static final int opAnd = 10;
    public static final int opOr = 11;
    public static final int opNot = 12;
    public static final int opNotEqual = 13;
    public static final int opLike = 14;
    public static final int opNotLike = 15;
    public static final int opStartWith = 16;
    public static final int opNotStartWith = 17;
    public static final int opBetween = 18;
    public static final int opBetweenInclusive = 19;
    public static final int opFastFilter = 201;
    public static final int opRangeDefault = 0;
    public static final int opDateRangeDMY = 1;
    public static final int opDateRangeMY = 2;
    public static final int opDateRangeQY = 3;
    public static final int opDateRangeY = 4;
    public static final int opStringCaseInsensitive = 5;
    public static final int opBoolRange2 = 6;
    public static final int opBoolRange3 = 7;

    public OperationTerm(Expression expr) {
        super(expr);
    }

    public OperationTerm(int operationId, Expression expr) {
        super(expr);
        this.setOperationId(operationId);
    }

    public OperationTerm(int elementId, int operationId, Expression expr) {
        super(expr);
        this.id = elementId;
        this.setOperationId(operationId);
    }

    @Override
    public final Term createClone(Expression e) {
        OperationTerm o = new OperationTerm(e);
        o.operationId = this.operationId;
        o.rangeId = this.rangeId;
        o.any = this.any;
        o.token = this.token;
        o.priority = this.priority;
        return o;
    }

    @Override
    public Expression.Token getToken() {
        return this.token;
    }

    @Override
    public Expression.Priority getPriority() {
        return this.priority;
    }

    @Override
    public void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 4: {
                this.setOperationId(in.getInt());
                break;
            }
            case 26: {
                this.rangeId = in.getInt();
                break;
            }
            case 27: {
                this.any = true;
                break;
            }
            default: {
                super.loadTag(in);
            }
        }
    }

    @Override
    public void afterLoad() {
    }

    public int getOperationId() {
        return this.operationId;
    }

    public void setOperationId(int id) {
        this.operationId = id;
        switch (this.operationId) {
            case -1: {
                this.token = Expression.Token.nop;
                this.priority = Expression.Priority.NONE;
                break;
            }
            case 0: {
                this.token = Expression.Token.add;
                this.priority = Expression.Priority.ADD;
                break;
            }
            case 1: {
                this.token = Expression.Token.sub;
                this.priority = Expression.Priority.ADD;
                break;
            }
            case 2: {
                this.token = Expression.Token.mul;
                this.priority = Expression.Priority.MUL;
                break;
            }
            case 3: {
                this.token = Expression.Token.div;
                this.priority = Expression.Priority.MUL;
                break;
            }
            case 4: {
                this.token = Expression.Token.mod;
                this.priority = Expression.Priority.MUL;
                break;
            }
            case 5: {
                this.token = Expression.Token.less;
                this.priority = Expression.Priority.COMPARE;
                break;
            }
            case 6: {
                this.token = Expression.Token.lessEqual;
                this.priority = Expression.Priority.COMPARE;
                break;
            }
            case 7: {
                this.token = Expression.Token.greater;
                this.priority = Expression.Priority.COMPARE;
                break;
            }
            case 8: {
                this.token = Expression.Token.greaterEqual;
                this.priority = Expression.Priority.COMPARE;
                break;
            }
            case 9: {
                this.token = Expression.Token.equal;
                this.priority = Expression.Priority.COMPARE;
                break;
            }
            case 13: {
                this.token = Expression.Token.notEqual;
                this.priority = Expression.Priority.COMPARE;
                break;
            }
            case 14: {
                this.token = Expression.Token.like;
                this.priority = Expression.Priority.COMPARE;
                break;
            }
            case 15: {
                this.token = Expression.Token.notLike;
                this.priority = Expression.Priority.COMPARE;
                break;
            }
            case 10: {
                this.token = Expression.Token.and;
                this.priority = Expression.Priority.AND;
                break;
            }
            case 11: {
                this.token = Expression.Token.or;
                this.priority = Expression.Priority.OR;
                break;
            }
            case 12: {
                this.token = Expression.Token.not;
                this.priority = Expression.Priority.NOT;
                break;
            }
            case 16: {
                this.token = Expression.Token.startWith;
                this.priority = Expression.Priority.COMPARE;
                break;
            }
            case 17: {
                this.token = Expression.Token.notStartWith;
                this.priority = Expression.Priority.COMPARE;
                break;
            }
            case 201: {
                this.token = Expression.Token.fastFilter;
                this.priority = Expression.Priority.COMPARE;
                break;
            }
            default: {
                this.token = Expression.Token.invalid;
            }
        }
    }

    public int getRangeId() {
        return this.rangeId;
    }

    public void setRangeId(int rangeId) {
        this.rangeId = rangeId;
    }

    public boolean isAny() {
        return this.any;
    }
}

