/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.collections.Cursor;
import inform.adt.collections.IntegerList;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.VersionInfo;
import inform.agent.db.ClosableResult;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditInfo;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.utils.SqlCommand;
import inform.agent.db.utils.SqlParameter;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.SSContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

public class AuditJournal {
    public static final int REPL_OP_CODE_EXPORT = 1;
    public static final int REPL_OP_CODE_IMPORT = 2;
    public static final int REPL_OP_CODE_FILEIMPORT = 3;
    public static final int REPL_OP_CODE_FILEEXPORT = 4;
    public static final int REPL_OP_CODE_BLOB_EXPORT = 5;
    public static final int REPL_OP_CODE_BLOB_IMPORT = 6;
    public static final int LOGIN_CODE_LOGIN = 1;
    public static final int LOGIN_CODE_LOGOUT = 2;
    public static final int LOGIN_CODE_OFFLINED = 3;
    public static final int LOGIN_CODE_FAILED_LOGIN = 10;
    public static final int EVENT_CODE_AUDIT_ON = 1;
    public static final int EVENT_CODE_AUDIT_OFF = 2;
    public static final int EVENT_CODE_RUN = 3;
    public static final int EVENT_CODE_ACTIVATE = 4;
    public static final int EVENT_CODE_DOWNLOAD_CLIENT = 5;
    public static final int EVENT_CODE_AUTH_CHANGED = 7;
    private static final int TAG_REPL_JOURNAL = 1;
    private static final int RJ_OP_CODE_INDEX = 0;
    private static final int RJ_OP_START_TIME_INDEX = 1;
    private static final int RJ_OP_FINISH_TIME_INDEX = 2;
    private static final int RJ_DATA_SLICE_TIME_BEGIN_INDEX = 3;
    private static final int RJ_USER_ID_INDEX = 4;
    private static final int RJ_REPL_NODE_ID_INDEX = 5;
    private static final int RJ_RESULT_MESSAGE_INDEX = 6;
    private static final int RJ_RESULT_CODE_INDEX = 7;
    private static final int RJ_FILE_ID_INDEX = 8;
    private static final int RJ_CHANEL_ID_INDEX = 9;
    private static final int RJ_DATA_SLICE_TIME_END_INDEX = 10;
    private static final int RJ_README_INDEX = 11;
    private static final int RJ_REPLICA_SIZE_INDEX = 12;
    private static final int RJ_FILE_NAME_INDEX = 13;
    private static final int TAG_LOGIN_AUDIT_JOURNAL = 2;
    private static final int LA_USER_ID_INDEX = 0;
    private static final int LA_LOGIN_TIME_INDEX = 1;
    private static final int LA_CODE_INDEX = 2;
    private static final int LA_COMPUTER_NAME_INDEX = 3;
    private static final int LA_COMPUTER_IP_INDEX = 4;
    private static final int LA_WINDOWS_LOGIN_INDEX = 5;
    private static final int LA_CLIENT_ID_INDEX = 6;
    private static final int LA_LOGOUT_TIME_INDEX = 7;
    private static final int LA_EXT_INFO_INDEX = 8;
    private static final int LA_AGENT_IP_INDEX = 9;
    private static final int LA_AGENT_ID_INDEX = 10;
    private static final int LA_SERVER_ID_INDEX = 11;
    private static final int TAG_AUDIT_EVENT_JOURNAL = 3;
    private static final int AE_USER_ID_INDEX = 0;
    private static final int AE_CONNECT_NDEX = 1;
    private static final int AE_TIME_BEGIN_INDEX = 2;
    private static final int AE_EVENT_INDEX = 3;
    private static final int AE_EVENT_CATEGORY_INDEX = 4;
    private static final int AE_METADATA_NODE_ID_INDEX = 5;
    private static final int AE_INFO_INDEX = 6;
    private static final int AE_TIME_END_INDEX = 7;
    private static final int AE_LOADING_TIME1_INDEX = 8;
    private static final int AE_LOADING_TIME2_INDEX = 9;
    private static final int TAG_CLIENT_LOG_JOURNAL = 4;
    private static final int ACEW_USER_ID_INDEX = 0;
    private static final int ACEW_SESSION_ID_INDEX = 1;
    private static final int ACEW_TIME_INDEX = 2;
    private static final int ACEW_ERROR_INDEX = 3;
    private static final int ACEW_WARN_INDEX = 4;
    private static final int TAG_JOB_JOURNAL = 5;
    private static final int AJJ_BEGIN_TIME_INDEX = 0;
    private static final int AJJ_END_TIME_INDEX = 1;
    private static final int AJJ_USER_INDEX = 2;
    private static final int AJJ_JOB_INDEX = 3;
    private static final int AJJ_SUCCESSFUL_INDEX = 4;
    private static final int AJJ_SERVER_ID_INDEX = 5;
    private static final int AJJ_AGENT_ID_INDEX = 6;
    private static final int AJJ_MESSAGE_INDEX = 7;
    private static final int AJJ_PROCESS_ID_INDEX = 8;
    private static final int TAG_DATA_FILTER_STORAGE = 15;
    private static final int TAG_PIVOT_CONF_TABLE = 23;
    private static final int DFS_USER_ID_INDEX = 0;
    private static final int DFS_FORM_ID_INDEX = 1;
    private static final int DFS_CONTROL_ID_INDEX = 2;
    private static final int DFS_NAME_INDEX = 3;
    private static final int DFS_CONTENT_INDEX = 4;
    private static final int DFS_SORT_INDEX = 5;
    private static final int TAG_PIVOT_CONF_FIELD_TITLE = 1;
    private static final int TAG_PIVOT_CONF_FIELD_FORM = 2;
    private static final int TAG_PIVOT_CONF_FIELD_CONTROL = 3;
    private static final int TAG_PIVOT_CONF_FIELD_USER = 4;
    private static final int TAG_PIVOT_CONF_FIELD_MOD_TIME = 5;
    private static final int TAG_PIVOT_CONF_FIELD_SETTINGS = 6;
    private static final int TAG_PIVOT_CONF_FIELD_SORT = 7;
    private static final int TAG_PIVOT_CONF_FIELD_DEF_CONF = 8;
    private static final int PIVOT_TITLE_INDEX = 0;
    private static final int PIVOT_FORM_ID_INDEX = 1;
    private static final int PIVOT_CONTROL_ID_INDEX = 2;
    private static final int PIVOT_USER_INDEX = 3;
    private static final int PIVOT_MODIFY_TIME_INDEX = 4;
    private static final int PIVOT_CONTENT_INDEX = 5;
    private static final int PIVOT_SORT_INDEX = 6;
    private static final int PIVOT_DEF_CONF_INDEX = 7;
    public static final int CLIENT_UPDATE_EVENT = 0;
    private static final int TAG_JOURNAL_TABLE = 1;
    private static final int TAG_JF_INDEX = 5;
    private static final int TAG_JF_FIELD_ID = 6;
    private static final int TAG_AUDITABLE_EVENTS = 7;
    private static final int TAG_AUDITABLE_EVENT = 1;
    private final Journal journal;
    private final int[] fieldIds = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private boolean enabled = false;
    private double tableId = 0.0;
    private IntegerList auditableEvents = new IntegerList(1);
    private static final String S_INVALID_REPL_JOURNAL = "\u0416\u0443\u0440\u043d\u0430\u043b \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438\u0439 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d";

    static int getAuditTag(Journal journal) {
        switch (journal) {
            case REPLICATION: {
                return 1;
            }
            case LOGIN: {
                return 2;
            }
            case EVENTS: {
                return 3;
            }
            case CLIENTLOG: {
                return 4;
            }
            case DATAFILTER: {
                return 15;
            }
            case JOB_JOURNAL: {
                return 5;
            }
        }
        return 0;
    }

    private static double getAuditNodeID(Journal journal) {
        if (journal == Journal.DATAFILTER) {
            return 2.0;
        }
        return 4.0;
    }

    public AuditJournal(Journal journal) {
        this.journal = journal;
        this.initAuditJournal(AuditJournal.getAuditNodeID(journal), AuditJournal.getAuditTag(journal));
    }

    private AuditJournal(Journal journal, boolean customLoad) {
        this.journal = journal;
    }

    public static AuditJournal createPivotConfJournal() {
        AuditJournal j = new AuditJournal(Journal.PIVOTCONF, true);
        j.enabled = false;
        try {
            Node mtdNode = MtdEngine.getNode(2.0);
            if (mtdNode == null) {
                return j;
            }
            BasicNode node = mtdNode.getRealNode();
            if (node == null) {
                return j;
            }
            byte[] content = node.getContent();
            if (content == null || content.length == 0) {
                return j;
            }
            TaggedReader in = new TaggedReader(new ByteArrayInputStream(content), content.length);
            while (in.next()) {
                if (in.getCurrentTag() != 23) continue;
                j.tableId = in.getDouble();
                if (j.tableId == 0.0) {
                    return j;
                }
                TableDescriptor t = TableDescriptor.get(j.tableId);
                in = in.getSubStreamReader();
                while (in.next()) {
                    switch (in.getCurrentTag()) {
                        case 1: {
                            int fieldId = j.fieldIds[0] = in.getInt();
                            t.checkFieldExists(fieldId);
                            break;
                        }
                        case 2: {
                            int fieldId = j.fieldIds[1] = in.getInt();
                            t.checkFieldExists(fieldId);
                            break;
                        }
                        case 3: {
                            int fieldId = j.fieldIds[2] = in.getInt();
                            t.checkFieldExists(fieldId);
                            break;
                        }
                        case 4: {
                            int fieldId = j.fieldIds[3] = in.getInt();
                            t.checkFieldExists(fieldId);
                            break;
                        }
                        case 5: {
                            j.fieldIds[4] = in.getInt();
                            break;
                        }
                        case 6: {
                            int fieldId = j.fieldIds[5] = in.getInt();
                            t.checkFieldExists(fieldId);
                            break;
                        }
                        case 7: {
                            j.fieldIds[6] = in.getInt();
                            break;
                        }
                        case 8: {
                            j.fieldIds[7] = in.getInt();
                        }
                    }
                }
                break block12;
            }
            j.enabled = true;
        }
        catch (InformException | IOException ex) {
            j.enabled = false;
            Core.logger.error(null, ex);
        }
        return j;
    }

    private void initAuditJournal(double nodeId, int tag) {
        try {
            Node mtdNode = MtdEngine.getNode(nodeId);
            if (mtdNode == null) {
                return;
            }
            BasicNode node = mtdNode.getRealNode();
            if (node == null) {
                return;
            }
            byte[] content = node.getContent();
            if (content == null || content.length == 0) {
                return;
            }
            TaggedReader in = new TaggedReader(new ByteArrayInputStream(content), content.length);
            while (in.next()) {
                if (in.getCurrentTag() != tag) continue;
                in = in.getSubStreamReader();
                while (in.next()) {
                    switch (in.getCurrentTag()) {
                        case 1: {
                            in.skip();
                            this.tableId = in.getDouble(151);
                            this.enabled = true;
                            break;
                        }
                        case 7: {
                            TaggedReader subReader = in.getSubStreamReader();
                            while (subReader.next()) {
                                switch (subReader.getCurrentTag()) {
                                    case 1: {
                                        this.auditableEvents.add(subReader.getInt());
                                    }
                                }
                            }
                            break;
                        }
                        case 5: {
                            int index = in.getInt();
                            if (index < 0 || index >= this.fieldIds.length) break;
                            this.fieldIds[index] = in.getInt(6);
                        }
                    }
                }
                break;
            }
        }
        catch (InformException | IOException ex) {
            this.enabled = false;
            Core.logger.error(null, ex);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateTime getLastSuccessfulReplication(SSContext ssContext, double replNodeId, double channelNodeId) throws SQLException {
        if (this.journal != Journal.REPLICATION) {
            throw new InformException("getLastSuccessfulReplication invalid journal: " + this.journal.toString());
        }
        if (!this.enabled || this.tableId == 0.0) {
            throw new InformException(S_INVALID_REPL_JOURNAL);
        }
        TableDescriptor tableInfo = TableDescriptor.get(this.tableId);
        SqlCommand command = new SqlCommand();
        command.sqlText.append("select MAX(");
        if (!Sql.addField(10, this.fieldIds, tableInfo, command)) {
            throw new InformException(S_INVALID_REPL_JOURNAL);
        }
        command.sqlText.append(") from ").appendFull(tableInfo).append(" where ");
        if (!Sql.addField(7, this.fieldIds, tableInfo, command)) {
            throw new InformException(S_INVALID_REPL_JOURNAL);
        }
        command.sqlText.append("<> ? and ");
        if (!Sql.addField(5, this.fieldIds, tableInfo, command)) {
            throw new InformException(S_INVALID_REPL_JOURNAL);
        }
        command.sqlText.append("=? and ");
        if (!Sql.addField(9, this.fieldIds, tableInfo, command)) {
            throw new InformException(S_INVALID_REPL_JOURNAL);
        }
        command.sqlText.append("=?");
        command.params.add(new SqlParameter().setBoolean(false));
        command.params.add(new SqlParameter().setDouble(replNodeId));
        command.params.add(new SqlParameter().setDouble(channelNodeId));
        try (DatabaseConnection connection = tableInfo.getDatabaseDescriptor().connect(null, "AuditJournal::getLastSuccessfulReplication");){
            connection.markAsReadonly();
            try (ClosableResult result = command.executeQuery(ssContext, connection);){
                ResultSet resultSet = result.getResultSet();
                if (resultSet.next()) {
                    double time = resultSet.getDateTime(1);
                    if (!resultSet.wasNull()) {
                        DateTime dateTime = new DateTime(time);
                        return dateTime;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateReplication(SSContext ssContext, UpdateReplicationParams params) {
        if (Ini.ReadonlyMode) {
            throw new InformException("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!");
        }
        if (this.journal != Journal.REPLICATION) {
            Core.logger.error("updateReplication invalid journal: {}", (Object)this.journal);
            return;
        }
        try {
            if (!this.enabled || this.tableId == 0.0 || params.auditId == 0.0 || params.fileSize == 0.0) {
                return;
            }
            TableDescriptor table = TableDescriptor.get(this.tableId);
            if (table == null || table.getDatabaseDescriptor() == null) {
                this.enabled = false;
                return;
            }
            Sql sql = new Sql(this.getComment(), false, params.auditId, this.fieldIds, table);
            sql.setNumber(12, params.fileSize);
            if (params.fileName != null) {
                sql.setString(13, params.fileName);
            }
            try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::registrateReplication");){
                sql.execute(ssContext, connection);
                connection.commit();
            }
        }
        catch (InformException | SQLException ex) {
            Core.logger.error(null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double registerReplication(SSContext ssContext, ReplicationParams params) {
        if (Ini.ReadonlyMode) {
            throw new InformException("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!");
        }
        double journalId = 0.0;
        if (this.journal != Journal.REPLICATION) {
            Core.logger.error("registerReplication invalid journal: {}", (Object)this.journal);
            return journalId;
        }
        try {
            if (!this.enabled || this.tableId == 0.0) {
                return journalId;
            }
            TableDescriptor table = TableDescriptor.get(this.tableId);
            if (table == null || table.getDatabaseDescriptor() == null) {
                this.enabled = false;
                return journalId;
            }
            journalId = Core.generateId();
            Sql sql = new Sql(this.getComment(), true, journalId, this.fieldIds, table);
            sql.setInt(0, params.opCode);
            sql.setDateTime(1, params.timeBeginOperation);
            sql.setDateTime(2, params.timeEndOperation);
            sql.setDateTime(3, params.dataSliceBegin);
            sql.setDateTime(10, params.dataSliceEnd);
            sql.setID(4, params.userNodeId);
            sql.setID(5, params.replNodeId);
            sql.setString(6, params.resultMessage);
            sql.setBool(7, params.successfullyResult);
            sql.setNumber(8, params.replicaId);
            sql.setNumber(9, params.channelId);
            sql.setNumber(12, params.replicaSize);
            if (params.fileName != null) {
                sql.setString(13, params.fileName);
            }
            if (params.note != null) {
                sql.setString(11, params.note);
            }
            try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::registrateReplication");){
                sql.execute(ssContext, connection);
                connection.commit();
            }
        }
        catch (InformException | SQLException ex) {
            Core.logger.error(null, ex);
        }
        return journalId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ReplicationParams> getAuditReplications(SSContext ssContext, int numRec, int opCode) throws SQLException, InformException {
        ArrayList<ReplicationParams> list = new ArrayList<ReplicationParams>();
        if (this.journal != Journal.REPLICATION) {
            Core.logger.error("getAuditReplications invalid journal: {}", (Object)this.journal);
            return list;
        }
        if (!this.enabled || this.tableId == 0.0) {
            return list;
        }
        TableDescriptor tableInfo = TableDescriptor.getIfExists(this.tableId);
        if (tableInfo == null || tableInfo.getDbDescIfExists() == null) {
            throw new InformException("\u0416\u0443\u0440\u043d\u0430\u043b \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438\u0439 \u043d\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d[\u0443\u0437\u0435\u043b: " + (long)this.tableId + "]");
        }
        int[] indexes = new int[]{0, 1, 2, 3, 10, 4, 5, 6, 7, 8, 9, 12, 13, 11};
        SqlCommand command = new SqlCommand();
        command.sqlText.append("select");
        String sep = " ";
        for (int index : indexes) {
            command.sqlText.append(sep);
            sep = ",";
            if (Sql.addField(index, this.fieldIds, tableInfo, command)) continue;
            throw new InformException(S_INVALID_REPL_JOURNAL);
        }
        command.sqlText.append(" from ").appendFull(tableInfo);
        if (opCode > 0) {
            command.sqlText.append(" where ");
            if (!Sql.addField(0, this.fieldIds, tableInfo, command)) {
                throw new InformException("AuditJournal::getAuditReplications: RJ_OP_CODE_INDEX \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d.");
            }
            command.sqlText.append("=?");
            command.params.add(new SqlParameter().setInteger(opCode));
        }
        command.sqlText.append(" order by ");
        if (!Sql.addField(1, this.fieldIds, tableInfo, command)) {
            throw new InformException("AuditJournal::getAuditReplications: RJ_OP_START_TIME_INDEX \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d.");
        }
        command.sqlText.append(" desc");
        try (DatabaseConnection connection = tableInfo.getDatabaseDescriptor().connect(null, "AuditJournal::getAuditReplications");
             ClosableResult result = command.executeQuery(ssContext, connection);){
            if (numRec <= 0) {
                numRec = Integer.MAX_VALUE;
            }
            ResultSet resultSet = result.getResultSet();
            while (resultSet.next() && numRec-- > 0) {
                int col = 1;
                ReplicationParams param = new ReplicationParams();
                param.opCode = resultSet.getInt(col++);
                param.timeBeginOperation = resultSet.getDateTime(col++);
                param.timeEndOperation = resultSet.getDateTime(col++);
                param.dataSliceBegin = resultSet.getDateTime(col++);
                param.dataSliceEnd = resultSet.getDateTime(col++);
                param.userNodeId = resultSet.getDouble(col++);
                param.replNodeId = resultSet.getDouble(col++);
                param.resultMessage = resultSet.getString(col++);
                param.successfullyResult = resultSet.getBoolean(col++);
                param.replicaId = resultSet.getDouble(col++);
                param.channelId = resultSet.getDouble(col++);
                param.replicaSize = resultSet.getDouble(col++);
                param.fileName = resultSet.getString(col++);
                param.note = resultSet.getString(col++);
                list.add(param);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRegisteredReplicaIdCount(SSContext ssContext, double replicaId) throws SQLException {
        if (this.journal != Journal.REPLICATION) {
            Core.logger.error("getRegisteredReplicaIdCount invalid journal: {}", (Object)this.journal);
            return 0;
        }
        if (!this.enabled || this.tableId == 0.0) {
            return 0;
        }
        TableDescriptor tableInfo = TableDescriptor.getIfExists(this.tableId);
        if (tableInfo == null || tableInfo.getDbDescIfExists() == null) {
            throw new InformException("\u0416\u0443\u0440\u043d\u0430\u043b \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438\u0439 \u043d\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d[\u0443\u0437\u0435\u043b: " + (long)this.tableId + "]");
        }
        SqlCommand command = new SqlCommand();
        command.sqlText.append("select COUNT(*) from ").appendFull(tableInfo).append(" where ");
        if (!Sql.addField(8, this.fieldIds, tableInfo, command)) {
            throw new InformException(S_INVALID_REPL_JOURNAL);
        }
        command.sqlText.append("=? and ");
        if (!Sql.addField(0, this.fieldIds, tableInfo, command)) {
            throw new InformException(S_INVALID_REPL_JOURNAL);
        }
        command.sqlText.append(" in (").append(2).append(", ").append(3).append(") and ");
        if (!Sql.addField(7, this.fieldIds, tableInfo, command)) {
            throw new InformException(S_INVALID_REPL_JOURNAL);
        }
        command.sqlText.append(" is not null and ");
        if (!Sql.addField(7, this.fieldIds, tableInfo, command)) {
            throw new InformException("AuditJournal::getRegisteredReplicaIdCount: RJ_RESULT_CODE_INDEX \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d.");
        }
        command.sqlText.append("<> ?");
        command.params.add(new SqlParameter().setDouble(replicaId));
        command.params.add(new SqlParameter().setBoolean(false));
        try (DatabaseConnection connection = tableInfo.getDatabaseDescriptor().connect(null, "AuditJournal::getRegisteredReplicaIdCount");
             ClosableResult result = command.executeQuery(ssContext, connection);){
            ResultSet resultSet = result.getResultSet();
            if (resultSet.next()) {
                int replcaCount;
                int n = replcaCount = resultSet.getInt(1);
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registrateLogin(LoginParams params) {
        if (Ini.ReadonlyMode) {
            return;
        }
        if (this.journal != Journal.LOGIN) {
            Core.logger.error("registrateLogin invalid journal: {}", (Object)this.journal);
            return;
        }
        try {
            TableDescriptor table;
            boolean insert;
            if (!this.enabled || this.tableId == 0.0) {
                return;
            }
            boolean bl = insert = params.auditId == 0.0;
            if (params.sessionId == 0.0) {
                params.sessionId = Core.generateId();
            }
            if (insert) {
                params.auditId = params.sessionId;
            }
            if ((table = TableDescriptor.getIfExists(this.tableId)) == null || table.getDbDescIfExists() == null) {
                this.enabled = false;
                return;
            }
            Sql sql = new Sql(this.getComment(), insert, params.auditId, this.fieldIds, table);
            sql.setID(0, params.userId);
            sql.setInt(2, params.code);
            switch (params.code) {
                case 2: {
                    sql.setTimestamp(7, params.time);
                    break;
                }
                case 10: {
                    sql.setTimestamp(1, params.time);
                    sql.setTimestamp(7, params.time);
                    break;
                }
                default: {
                    sql.setTimestamp(1, params.time);
                }
            }
            sql.setString(3, params.computer);
            sql.setString(4, params.ip);
            sql.setString(5, params.computerLogin);
            sql.setInt(6, params.clientId);
            StringBuilder info = new StringBuilder();
            if (params.info != null) {
                info.append((CharSequence)info);
            }
            if (params.clientVersion != null) {
                if (info.length() != 0) {
                    info.append("; ");
                }
                info.append(params.clientVersion.toString());
            }
            if (info.length() != 0) {
                info.append("; ");
            }
            if (Core.isTimeZoneConversionUsed) {
                char c_tz_s;
                int c_tz_m;
                int c_tz_h;
                char s_tz_s;
                int s_tz_h;
                int serverTimeZoneOffset = DateTime.serverZoneOffset();
                int s_tz_m = (serverTimeZoneOffset - (s_tz_h = serverTimeZoneOffset / 3600000) * 3600000) / 60000;
                if (s_tz_m < 0) {
                    s_tz_m = -s_tz_m;
                }
                if (s_tz_h < 0) {
                    s_tz_s = '-';
                    s_tz_h = -s_tz_h;
                } else {
                    s_tz_s = '+';
                }
                if (params.timeZoneAssigned) {
                    c_tz_h = params.timeZoneOffset / 3600000;
                    c_tz_m = (params.timeZoneOffset - c_tz_h * 3600000) / 60000;
                    if (c_tz_m < 0) {
                        c_tz_m = -c_tz_m;
                    }
                    if (c_tz_h < 0) {
                        c_tz_s = '-';
                        c_tz_h = -c_tz_h;
                    } else {
                        c_tz_s = '+';
                    }
                } else {
                    c_tz_h = s_tz_h;
                    c_tz_m = s_tz_m;
                    c_tz_s = s_tz_s;
                }
                info.append("client tz: ").append(c_tz_s);
                if (c_tz_h < 10) {
                    info.append('0');
                }
                info.append(c_tz_h).append(':');
                if (c_tz_m < 10) {
                    info.append('0');
                }
                info.append(c_tz_m).append("; server tz: ").append(s_tz_s);
                if (s_tz_h < 10) {
                    info.append('0');
                }
                info.append(s_tz_h).append(':');
                if (s_tz_m < 10) {
                    info.append('0');
                }
                info.append(s_tz_m);
            } else {
                info.append("no time zone conversion");
            }
            sql.setString(8, info.toString());
            sql.setString(9, params.agentIP);
            sql.setString(10, Ini.AgentID);
            sql.setString(11, Ini.ServerID);
            try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::registrateLogin");){
                sql.execute(null, connection);
                connection.commit();
            }
        }
        catch (InformException | SQLException ex) {
            Core.logger.error(null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClientLog(ClientLogParams params) {
        if (this.journal != Journal.CLIENTLOG) {
            Core.logger.error("registrateClientLog invalid journal: {}", (Object)this.journal);
            return;
        }
        try {
            if (!this.enabled || this.tableId == 0.0) {
                return;
            }
            if (params.sessionId == 0.0) {
                params.sessionId = Core.generateId();
            }
            double logId = Core.generateId();
            TableDescriptor table = TableDescriptor.getIfExists(this.tableId);
            if (table == null || table.getDbDescIfExists() == null) {
                this.enabled = false;
                return;
            }
            Sql sql = new Sql(this.getComment(), true, logId, this.fieldIds, table);
            sql.setNumber(0, params.userId);
            sql.setNumber(1, params.sessionId);
            sql.setDateTime(2, params.time);
            sql.setBytes(3, params.error);
            sql.setBytes(4, params.warn);
            try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::registrateClientLog");){
                sql.execute(null, connection);
                connection.commit();
            }
        }
        catch (InformException | SQLException ex) {
            Core.logger.error(null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registrateEvent(SSContext context, EventParams params) {
        if (Ini.ReadonlyMode) {
            return;
        }
        if (this.journal != Journal.EVENTS) {
            Core.logger.error("registrateAuditEvent invalid journal: {}", (Object)this.journal);
            return;
        }
        if (!this.enabled || this.tableId == 0.0) {
            return;
        }
        try {
            TableDescriptor table;
            if (params.auditId == 0.0) {
                params.auditId = Core.generateId();
            }
            if ((table = TableDescriptor.get(this.tableId)) == null || table.getDatabaseDescriptor() == null) {
                this.enabled = false;
                return;
            }
            Sql sql = new Sql(this.getComment(), true, params.auditId, this.fieldIds, table);
            sql.setID(0, params.userId);
            if (params.loginId != 0.0) {
                sql.setID(1, params.loginId);
            }
            sql.setDateTime(2, DateTime.fromUnixTime(params.startTime));
            if (params.stopTime != 0L) {
                sql.setDateTime(7, DateTime.fromUnixTime(params.stopTime));
            }
            if (params.code != 0) {
                sql.setInt(3, params.code);
            }
            if (params.kind != 0) {
                sql.setInt(4, params.kind);
            }
            if (params.nodeId != 0.0) {
                sql.setID(5, params.nodeId);
            }
            if (params.remark != null && !params.remark.isEmpty()) {
                sql.setString(6, params.remark);
            }
            if (params.loadingTime1 != 0.0) {
                sql.setNumber(8, params.loadingTime1);
            }
            if (params.loadingTime2 != 0.0) {
                sql.setNumber(9, params.loadingTime2);
            }
            try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::registrateEvent");){
                if (connection.getDescriptor().isAuditEnabled() && table.getAuditType() != TableDescriptor.AuditType.NONE) {
                    sql.audit = new TableDataAudit(context, connection, params.userId, 0.0, 0.0, 0.0, params.loginId);
                }
                sql.execute(context, connection);
                connection.commit();
            }
        }
        catch (InformException | SQLException ex) {
            Core.logger.error(null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEvent(SSContext context, UpdateEventParams params, double userId, double sessionId) {
        if (!this.enabled || this.tableId == 0.0) {
            return;
        }
        try {
            TableDescriptor table = TableDescriptor.get(this.tableId);
            if (table == null || table.getDatabaseDescriptor() == null) {
                this.enabled = false;
                return;
            }
            Sql sql = new Sql(this.getComment(), false, params.auditId, this.fieldIds, table);
            sql.setDateTime(7, DateTime.fromUnixTime(params.stopTime));
            if (params.loadingTime1 != 0.0) {
                sql.setNumber(8, params.loadingTime1);
            }
            if (params.loadingTime2 != 0.0) {
                sql.setNumber(9, params.loadingTime2);
            }
            try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::updateEvent");){
                if (connection.getDescriptor().isAuditEnabled() && table.getAuditType() != TableDescriptor.AuditType.NONE) {
                    sql.audit = new TableDataAudit(context, connection, userId, 0.0, 0.0, 0.0, sessionId);
                }
                sql.execute(context, connection);
                connection.commit();
            }
        }
        catch (InformException | SQLException ex) {
            Core.logger.error(null, ex);
        }
    }

    public static void registerAuthChangeEvent(SSContext context, double userId, double loginId, double nodeId) {
        AuditJournal journal = new AuditJournal(Journal.EVENTS);
        if (journal.isEnabled()) {
            EventParams params = new EventParams();
            params.userId = userId;
            params.loginId = loginId;
            params.startTime = params.stopTime = System.currentTimeMillis();
            params.code = 7;
            params.nodeId = nodeId;
            journal.registrateEvent(context, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFilter[] readDataFilters(SSContext ssContext, DataFilterParam params) throws SQLException {
        if (this.journal != Journal.DATAFILTER) {
            throw new InformException("readDataFilters invalid journal: " + this.journal.toString());
        }
        if (!this.enabled) {
            return null;
        }
        if (this.tableId == 0.0) {
            this.enabled = false;
            return null;
        }
        TableDescriptor tableInfo = TableDescriptor.get(this.tableId);
        SqlCommand command = new SqlCommand();
        command.sqlText.append("select ");
        FieldDescriptor recordId = tableInfo.getRecordIdField();
        if (recordId == null) {
            this.enabled = false;
            return null;
        }
        command.sqlText.append(recordId).append(',');
        if (!Sql.addField(0, this.fieldIds, tableInfo, command)) {
            this.enabled = false;
            return null;
        }
        command.sqlText.append(',');
        if (!Sql.addField(3, this.fieldIds, tableInfo, command)) {
            this.enabled = false;
            return null;
        }
        command.sqlText.append(',');
        if (!Sql.addField(5, this.fieldIds, tableInfo, command)) {
            this.enabled = false;
            return null;
        }
        command.sqlText.append(',');
        if (!Sql.addField(4, this.fieldIds, tableInfo, command)) {
            this.enabled = false;
            return null;
        }
        command.sqlText.append(" from ").appendFull(tableInfo).append(" where (");
        if (!Sql.addField(0, this.fieldIds, tableInfo, command)) {
            throw new InformException("AuditJournal::readDataFilters: DFS_USER_ID_INDEX \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d.");
        }
        command.sqlText.append(" IS NULL");
        if (params.userId != 0.0) {
            command.sqlText.append(" OR ");
            if (!Sql.addField(0, this.fieldIds, tableInfo, command)) {
                this.enabled = false;
                return null;
            }
            command.sqlText.append("=?");
        }
        command.sqlText.append(") AND ");
        if (!Sql.addField(1, this.fieldIds, tableInfo, command)) {
            this.enabled = false;
            return null;
        }
        command.sqlText.append("=?");
        command.sqlText.append(" AND ");
        if (!Sql.addField(2, this.fieldIds, tableInfo, command)) {
            this.enabled = false;
            return null;
        }
        command.sqlText.append("=?");
        command.sqlText.append(" ORDER BY ");
        if (!Sql.addField(5, this.fieldIds, tableInfo, command)) {
            throw new InformException("AuditJournal::readDataFilters: DFS_SORT_INDEX \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d.");
        }
        if (params.userId != 0.0) {
            command.params.add(new SqlParameter().setDouble(params.userId));
        }
        command.params.add(new SqlParameter().setDouble(params.formId));
        command.params.add(new SqlParameter().setDouble(params.controlId));
        ArrayList<DataFilter> filters = new ArrayList<DataFilter>();
        try (DatabaseConnection connection = tableInfo.getDatabaseDescriptor().connect(null, "AuditJournal::readDataFilters");
             ClosableResult result = command.executeQuery(ssContext, connection);){
            ResultSet resultSet = result.getResultSet();
            while (resultSet.next()) {
                DataFilter f = new DataFilter();
                f.recordID = resultSet.getAsDouble(1);
                f.userId = resultSet.getAsDouble(2);
                f.formId = params.formId;
                f.controlId = params.controlId;
                f.name = resultSet.getString(3);
                f.sort = resultSet.getAsDouble(4);
                f.content = resultSet.getBlobBytes(5);
                filters.add(f);
            }
        }
        DataFilter[] dataFilters = new DataFilter[filters.size()];
        return filters.toArray(dataFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PivotConf[] readPivotConfig(SSContext ssContext, PivotConfParam params) throws SQLException {
        if (this.journal != Journal.PIVOTCONF) {
            throw new InformException("readPivotConfig invalid journal: " + this.journal.toString());
        }
        if (!this.enabled) {
            return null;
        }
        if (this.tableId == 0.0) {
            this.enabled = false;
            return null;
        }
        boolean hasDefConfField = false;
        TableDescriptor tableInfo = TableDescriptor.get(this.tableId);
        SqlCommand command = new SqlCommand();
        command.sqlText.append("select ");
        FieldDescriptor recordId = tableInfo.getRecordIdField();
        if (recordId == null) {
            this.enabled = false;
            return null;
        }
        command.sqlText.append(recordId).append(',');
        if (!Sql.addField(3, this.fieldIds, tableInfo, command)) {
            this.enabled = false;
            return null;
        }
        command.sqlText.append(',');
        if (!Sql.addField(0, this.fieldIds, tableInfo, command)) {
            this.enabled = false;
            return null;
        }
        command.sqlText.append(',');
        if (!Sql.addField(6, this.fieldIds, tableInfo, command)) {
            this.enabled = false;
            return null;
        }
        command.sqlText.append(',');
        if (Sql.addField(7, this.fieldIds, tableInfo, command)) {
            hasDefConfField = true;
            command.sqlText.append(',');
        }
        if (!Sql.addField(5, this.fieldIds, tableInfo, command)) {
            this.enabled = false;
            return null;
        }
        command.sqlText.append(" from ").appendFull(tableInfo).append(" where ");
        if (params.configId == 0.0) {
            if (!Sql.addField(1, this.fieldIds, tableInfo, command)) {
                this.enabled = false;
                return null;
            }
            command.sqlText.append("=?");
            command.sqlText.append(" AND ");
            if (!Sql.addField(2, this.fieldIds, tableInfo, command)) {
                this.enabled = false;
                return null;
            }
            command.sqlText.append("=?");
            if (params.userId != 0.0) {
                command.sqlText.append(" AND (");
                if (!Sql.addField(3, this.fieldIds, tableInfo, command)) {
                    this.enabled = false;
                    return null;
                }
                command.sqlText.append("=?");
                command.sqlText.append(" OR ");
                if (!Sql.addField(3, this.fieldIds, tableInfo, command)) {
                    this.enabled = false;
                    return null;
                }
                command.sqlText.append(" IS NULL)");
            }
        } else {
            command.sqlText.append(recordId).append("=?");
        }
        if (params.configId == 0.0) {
            command.sqlText.append(" ORDER BY ");
            if (!Sql.addField(6, this.fieldIds, tableInfo, command)) {
                throw new InformException("AuditJournal::readPivotConfig: PIVOT_SORT_INDEX \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d.");
            }
            command.params.add(new SqlParameter().setDouble(params.formId));
            command.params.add(new SqlParameter().setDouble(params.controlId));
            if (params.userId != 0.0) {
                command.params.add(new SqlParameter().setDouble(params.userId));
            }
        } else {
            command.params.add(new SqlParameter().setDouble(params.configId));
        }
        ArrayList<PivotConf> pivotConfig = new ArrayList<PivotConf>();
        try (DatabaseConnection connection = tableInfo.getDatabaseDescriptor().connect(null, "AuditJournal::readPivotConfig");
             ClosableResult result = command.executeQuery(ssContext, connection);){
            ResultSet resultSet = result.getResultSet();
            while (resultSet.next()) {
                PivotConf f = new PivotConf();
                int colIndex = 0;
                f.recordID = resultSet.getAsDouble(++colIndex);
                f.userId = resultSet.getAsDouble(++colIndex);
                f.formId = params.formId;
                f.controlId = params.controlId;
                f.name = resultSet.getString(++colIndex);
                f.sort = resultSet.getAsDouble(++colIndex);
                if (hasDefConfField) {
                    f.defConf = resultSet.getAsInteger(++colIndex) != 0;
                }
                f.content = resultSet.getBlobBytes(++colIndex);
                pivotConfig.add(f);
            }
        }
        PivotConf[] dataFilters = new PivotConf[pivotConfig.size()];
        return pivotConfig.toArray(dataFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDataFilterExists(SSContext ssContext, double filterId, DatabaseConnection connection) throws SQLException {
        if (this.journal != Journal.DATAFILTER) {
            throw new InformException("isDataFilterExists invalid journal: " + this.journal.toString());
        }
        if (!this.enabled) {
            return false;
        }
        if (this.tableId == 0.0) {
            this.enabled = false;
            return false;
        }
        TableDescriptor tableInfo = TableDescriptor.get(this.tableId);
        if (tableInfo == null || tableInfo.getDatabaseDescriptor() == null) {
            this.enabled = false;
            return false;
        }
        SqlCommand command = new SqlCommand();
        command.sqlText.append("select ");
        FieldDescriptor recordId = tableInfo.getRecordIdField();
        if (recordId == null) {
            this.enabled = false;
            return false;
        }
        command.sqlText.append(recordId);
        command.sqlText.append(" from ").appendFull(tableInfo).append(" where ");
        command.sqlText.append(recordId).append("=?");
        command.params.add(new SqlParameter().setDouble(filterId));
        try (ClosableResult result = command.executeQuery(ssContext, connection);){
            ResultSet resultSet = result.getResultSet();
            boolean bl = resultSet.next();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPivotConfExists(SSContext ssContext, double confId, DatabaseConnection connection) throws SQLException {
        if (this.journal != Journal.PIVOTCONF) {
            throw new InformException("isPivotConfExists invalid journal: " + this.journal.toString());
        }
        if (!this.enabled) {
            return false;
        }
        if (this.tableId == 0.0) {
            this.enabled = false;
            return false;
        }
        TableDescriptor tableInfo = TableDescriptor.get(this.tableId);
        if (tableInfo == null || tableInfo.getDatabaseDescriptor() == null) {
            this.enabled = false;
            return false;
        }
        SqlCommand command = new SqlCommand();
        command.sqlText.append("select ");
        FieldDescriptor recordId = tableInfo.getRecordIdField();
        if (recordId == null) {
            this.enabled = false;
            return false;
        }
        command.sqlText.append(recordId);
        command.sqlText.append(" from ").appendFull(tableInfo).append(" where ");
        command.sqlText.append(recordId).append("=?");
        command.params.add(new SqlParameter().setDouble(confId));
        try (ClosableResult result = command.executeQuery(ssContext, connection);){
            ResultSet resultSet = result.getResultSet();
            boolean bl = resultSet.next();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataFilters(SSContext ssContext, double[] dataFilters, Request request) throws SQLException {
        if (this.journal != Journal.DATAFILTER) {
            throw new InformException("isDataFilterExists invalid journal: " + this.journal.toString());
        }
        if (!this.enabled) {
            return;
        }
        if (this.tableId == 0.0) {
            this.enabled = false;
            return;
        }
        TableDescriptor tableInfo = TableDescriptor.get(this.tableId);
        if (tableInfo == null || tableInfo.getDatabaseDescriptor() == null) {
            this.enabled = false;
            return;
        }
        SqlCommand command = new SqlCommand();
        command.sqlText.append("delete from ").appendFull(tableInfo).append(" where ");
        FieldDescriptor recordId = tableInfo.getRecordIdField();
        if (recordId == null) {
            this.enabled = false;
            return;
        }
        if (dataFilters.length == 1) {
            command.sqlText.append(recordId).append("=?");
            command.params.add(new SqlParameter().setDouble(dataFilters[0]));
        } else {
            command.sqlText.append(recordId).append(" in (");
            int comma = 32;
            for (double filterId : dataFilters) {
                command.sqlText.append((char)comma).append('?');
                comma = 44;
                command.params.add(new SqlParameter().setDouble(filterId));
            }
            command.sqlText.append(')');
        }
        try (DatabaseConnection connection = tableInfo.getDatabaseDescriptor().connect(null, "AuditJournal::isDataFilterExists");){
            command.executeUpdate(ssContext, connection);
            TableDataAudit audit = new TableDataAudit(ssContext, connection, request.getUserID(), request.getEffectiveUserID(), 0.0, 0.0, request.getSessionID());
            audit.setOwnerId(request.getNodeID());
            for (double filterId : dataFilters) {
                audit.registrateModification(tableInfo, filterId, AuditModification.DELETE);
            }
            audit.flush();
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePivotConfig(SSContext ssContext, double[] config, Request request) throws SQLException {
        if (this.journal != Journal.PIVOTCONF) {
            throw new InformException("deletePivotConfig invalid journal: " + this.journal.toString());
        }
        if (!this.enabled) {
            return;
        }
        if (this.tableId == 0.0) {
            this.enabled = false;
            return;
        }
        TableDescriptor tableInfo = TableDescriptor.get(this.tableId);
        if (tableInfo == null || tableInfo.getDatabaseDescriptor() == null) {
            this.enabled = false;
            return;
        }
        SqlCommand command = new SqlCommand();
        command.sqlText.append("delete from ").appendFull(tableInfo).append(" where ");
        FieldDescriptor recordId = tableInfo.getRecordIdField();
        if (recordId == null) {
            this.enabled = false;
            return;
        }
        if (config.length == 1) {
            command.sqlText.append(recordId).append("=?");
            command.params.add(new SqlParameter().setDouble(config[0]));
        } else {
            command.sqlText.append(recordId).append(" in [");
            int comma = 32;
            for (double confId : config) {
                command.sqlText.append((char)comma).append('?');
                comma = 44;
                command.params.add(new SqlParameter().setDouble(confId));
            }
            command.sqlText.append(']');
        }
        try (DatabaseConnection connection = tableInfo.getDatabaseDescriptor().connect(null, "AuditJournal::deletePivotConfig");){
            command.executeUpdate(ssContext, connection);
            TableDataAudit audit = new TableDataAudit(ssContext, connection, request.getUserID(), request.getEffectiveUserID(), 0.0, 0.0, request.getSessionID());
            audit.setOwnerId(request.getNodeID());
            for (double confId : config) {
                audit.registrateModification(tableInfo, confId, AuditModification.DELETE);
            }
            audit.flush();
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameDataFilter(SSContext ssContext, DataFilter filter, Request request) throws SQLException {
        if (filter.recordID == 0.0) {
            return;
        }
        if (Ini.ReadonlyMode) {
            return;
        }
        if (this.journal != Journal.DATAFILTER) {
            throw new InformException("storeDataFilters invalid journal: " + this.journal.toString());
        }
        if (!this.enabled) {
            return;
        }
        if (this.tableId == 0.0) {
            this.enabled = false;
            return;
        }
        TableDescriptor table = TableDescriptor.get(this.tableId);
        if (table == null || table.getDatabaseDescriptor() == null) {
            this.enabled = false;
            return;
        }
        try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::renameDataFilter");){
            Sql sql = new Sql(this.getComment(), false, filter.recordID, this.fieldIds, table);
            sql.setString(3, filter.name);
            sql.audit = new TableDataAudit(ssContext, connection, request.getUserID(), request.getEffectiveUserID(), 0.0, 0.0, request.getSessionID());
            sql.audit.setOwnerId(request.getNodeID());
            AuditInfo auditInfo = new AuditInfo(sql.audit, table, filter.recordID, AuditModification.MODIFY);
            auditInfo.setField(table.getFieldDescriptor(this.fieldIds[3])).setString(filter.name);
            sql.execute(ssContext, connection);
            sql.audit.flush();
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renamePivotConf(SSContext ssContext, double recordID, String newName, Request request) throws SQLException {
        if (recordID == 0.0) {
            return;
        }
        if (Ini.ReadonlyMode) {
            return;
        }
        if (this.journal != Journal.PIVOTCONF) {
            throw new InformException("renamePivotConf invalid journal: " + this.journal.toString());
        }
        if (!this.enabled) {
            return;
        }
        if (this.tableId == 0.0) {
            this.enabled = false;
            return;
        }
        TableDescriptor table = TableDescriptor.get(this.tableId);
        if (table == null || table.getDatabaseDescriptor() == null) {
            this.enabled = false;
            return;
        }
        try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::renamePivotConf");){
            Sql sql = new Sql(this.getComment(), false, recordID, this.fieldIds, table);
            sql.setString(0, newName);
            sql.setTimestamp(4, System.currentTimeMillis());
            sql.audit = new TableDataAudit(ssContext, connection, request.getUserID(), request.getEffectiveUserID(), 0.0, 0.0, request.getSessionID());
            sql.audit.setOwnerId(request.getNodeID());
            AuditInfo auditInfo = new AuditInfo(sql.audit, table, recordID, AuditModification.MODIFY);
            auditInfo.setField(table.getFieldDescriptor(this.fieldIds[0])).setString(newName);
            sql.execute(ssContext, connection);
            sql.audit.flush();
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefPivotConf(SSContext ssContext, double recordID, boolean value) throws SQLException {
        if (recordID == 0.0) {
            return;
        }
        if (Ini.ReadonlyMode) {
            return;
        }
        if (this.journal != Journal.PIVOTCONF) {
            throw new InformException("setDefPivotConf invalid journal: " + this.journal.toString());
        }
        if (!this.enabled) {
            return;
        }
        if (this.tableId == 0.0) {
            this.enabled = false;
            return;
        }
        TableDescriptor table = TableDescriptor.get(this.tableId);
        if (table == null || table.getDatabaseDescriptor() == null) {
            this.enabled = false;
            return;
        }
        Sql sql = new Sql(this.getComment(), false, recordID, this.fieldIds, table);
        if (!sql.setBool(7, value)) {
            return;
        }
        sql.setTimestamp(4, System.currentTimeMillis());
        try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::renamePivotConf");){
            sql.execute(ssContext, connection);
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataFilterSorting(SSContext ssContext, DataFilter[] dataFilters, Request request) throws SQLException {
        if (Ini.ReadonlyMode) {
            return;
        }
        if (this.journal != Journal.DATAFILTER) {
            throw new InformException("updateDataFilterSorting invalid journal: " + this.journal.toString());
        }
        if (!this.enabled) {
            return;
        }
        if (this.tableId == 0.0) {
            this.enabled = false;
            return;
        }
        TableDescriptor table = TableDescriptor.get(this.tableId);
        if (table == null || table.getDatabaseDescriptor() == null) {
            this.enabled = false;
            return;
        }
        try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::updateDataFilterSorting");){
            TableDataAudit audit = new TableDataAudit(ssContext, connection, request.getUserID(), request.getEffectiveUserID(), 0.0, 0.0, request.getSessionID());
            audit.setOwnerId(request.getNodeID());
            for (DataFilter filter : dataFilters) {
                if (filter.recordID == 0.0) {
                    filter.recordID = Core.generateId();
                }
                Sql sql = new Sql(this.getComment(), !this.isDataFilterExists(ssContext, filter.recordID, connection), filter.recordID, this.fieldIds, table);
                sql.setNumber(5, filter.sort);
                AuditInfo auditInfo = new AuditInfo(audit, table, filter.recordID, AuditModification.MODIFY);
                auditInfo.setField(table.getFieldDescriptor(this.fieldIds[5])).setNumber(filter.sort);
                audit.registrateModification(table, filter.recordID, AuditModification.MODIFY);
                sql.execute(ssContext, connection);
            }
            audit.flush();
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePivotConfigSorting(SSContext ssContext, PivotConf[] config, Request request) throws SQLException {
        if (Ini.ReadonlyMode) {
            return;
        }
        if (this.journal != Journal.PIVOTCONF) {
            throw new InformException("updatePivotConfigSorting invalid journal: " + this.journal.toString());
        }
        if (!this.enabled) {
            return;
        }
        if (this.tableId == 0.0) {
            this.enabled = false;
            return;
        }
        TableDescriptor table = TableDescriptor.get(this.tableId);
        if (table == null || table.getDatabaseDescriptor() == null) {
            this.enabled = false;
            return;
        }
        try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::updatePivotConfigSorting");){
            TableDataAudit audit = new TableDataAudit(ssContext, connection, request.getUserID(), request.getEffectiveUserID(), 0.0, 0.0, request.getSessionID());
            audit.setOwnerId(request.getNodeID());
            for (PivotConf conf : config) {
                if (conf.recordID == 0.0) {
                    conf.recordID = Core.generateId();
                }
                Sql sql = new Sql(this.getComment(), !this.isPivotConfExists(ssContext, conf.recordID, connection), conf.recordID, this.fieldIds, table);
                sql.setNumber(6, conf.sort);
                sql.setTimestamp(4, System.currentTimeMillis());
                sql.execute(ssContext, connection);
                AuditInfo auditInfo = new AuditInfo(audit, table, conf.recordID, AuditModification.MODIFY);
                auditInfo.setField(table.getFieldDescriptor(this.fieldIds[6])).setNumber(conf.sort);
                audit.registrateModification(table, conf.recordID, AuditModification.MODIFY);
            }
            audit.flush();
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDataFilters(SSContext ssContext, DataFilter[] dataFilters, Request request) throws SQLException {
        if (Ini.ReadonlyMode) {
            return;
        }
        if (this.journal != Journal.DATAFILTER) {
            throw new InformException("storeDataFilters invalid journal: " + this.journal.toString());
        }
        if (!this.enabled) {
            return;
        }
        if (this.tableId == 0.0) {
            this.enabled = false;
            return;
        }
        TableDescriptor table = TableDescriptor.get(this.tableId);
        if (table == null || table.getDatabaseDescriptor() == null) {
            this.enabled = false;
            return;
        }
        try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::storeDataFilters");){
            for (DataFilter filter : dataFilters) {
                if (filter.recordID == 0.0) {
                    filter.recordID = Core.generateId();
                }
                Sql sql = new Sql(this.getComment(), !this.isDataFilterExists(ssContext, filter.recordID, connection), filter.recordID, this.fieldIds, table);
                sql.setNumberIf(0, filter.userId);
                sql.setNumber(1, filter.formId);
                sql.setNumber(2, filter.controlId);
                sql.setString(3, filter.name);
                sql.setBytes(4, filter.content);
                sql.setNumber(5, filter.sort);
                sql.audit = new TableDataAudit(ssContext, connection, request.getUserID(), request.getEffectiveUserID(), 0.0, 0.0, request.getSessionID());
                sql.audit.setOwnerId(request.getNodeID());
                AuditInfo auditInfo = new AuditInfo(sql.audit, table, filter.recordID, sql.insert ? AuditModification.APPEND : AuditModification.MODIFY);
                auditInfo.setField(table.getFieldDescriptor(this.fieldIds[0])).setNumber(filter.userId);
                auditInfo.setField(table.getFieldDescriptor(this.fieldIds[1])).setNumber(filter.formId);
                auditInfo.setField(table.getFieldDescriptor(this.fieldIds[2])).setNumber(filter.controlId);
                auditInfo.setField(table.getFieldDescriptor(this.fieldIds[3])).setString(filter.name);
                auditInfo.setField(table.getFieldDescriptor(this.fieldIds[4])).setBlob(filter.content);
                auditInfo.setField(table.getFieldDescriptor(this.fieldIds[5])).setNumber(filter.sort);
                sql.execute(ssContext, connection);
                sql.audit.flush();
            }
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePivotConf(SSContext ssContext, PivotConf pivotConf, Request request) throws SQLException {
        if (Ini.ReadonlyMode) {
            return;
        }
        if (this.journal != Journal.PIVOTCONF) {
            throw new InformException("storePivotConf invalid journal: " + this.journal.toString());
        }
        if (!this.enabled) {
            return;
        }
        if (this.tableId == 0.0) {
            this.enabled = false;
            return;
        }
        TableDescriptor table = TableDescriptor.get(this.tableId);
        if (table == null || table.getDatabaseDescriptor() == null) {
            this.enabled = false;
            return;
        }
        try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::storePivotConf");){
            if (pivotConf.recordID == 0.0) {
                pivotConf.recordID = Core.generateId();
            }
            Sql sql = new Sql(this.getComment(), !this.isPivotConfExists(ssContext, pivotConf.recordID, connection), pivotConf.recordID, this.fieldIds, table);
            sql.setNumberIf(3, pivotConf.userId);
            sql.setNumber(1, pivotConf.formId);
            sql.setNumber(2, pivotConf.controlId);
            sql.setString(0, pivotConf.name);
            sql.setBytes(5, pivotConf.content);
            sql.setNumber(6, pivotConf.sort);
            sql.setTimestamp(4, System.currentTimeMillis());
            sql.audit = new TableDataAudit(ssContext, connection, request.getUserID(), request.getEffectiveUserID(), 0.0, 0.0, request.getSessionID());
            sql.audit.setOwnerId(request.getNodeID());
            AuditInfo auditInfo = new AuditInfo(sql.audit, table, pivotConf.recordID, sql.insert ? AuditModification.APPEND : AuditModification.MODIFY);
            auditInfo.setField(table.getFieldDescriptor(this.fieldIds[3])).setNumber(pivotConf.userId);
            auditInfo.setField(table.getFieldDescriptor(this.fieldIds[1])).setNumber(pivotConf.formId);
            auditInfo.setField(table.getFieldDescriptor(this.fieldIds[2])).setNumber(pivotConf.controlId);
            auditInfo.setField(table.getFieldDescriptor(this.fieldIds[0])).setString(pivotConf.name);
            auditInfo.setField(table.getFieldDescriptor(this.fieldIds[5])).setBlob(pivotConf.content);
            auditInfo.setField(table.getFieldDescriptor(this.fieldIds[6])).setNumber(pivotConf.sort);
            sql.execute(ssContext, connection);
            sql.audit.flush();
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerJob(SSContext context, JobParams params) {
        if (Ini.ReadonlyMode) {
            return;
        }
        if (this.journal != Journal.JOB_JOURNAL) {
            Core.logger.error("registerJob invalid journal: {}", (Object)this.journal);
            return;
        }
        if (!this.enabled || this.tableId == 0.0) {
            return;
        }
        try {
            TableDescriptor table = TableDescriptor.get(this.tableId);
            if (table == null || table.getDatabaseDescriptor() == null) {
                this.enabled = false;
                return;
            }
            if (params.auditId == 0.0) {
                params.auditId = Core.generateId();
            }
            Sql sql = new Sql(this.getComment(), true, params.auditId, this.fieldIds, table);
            sql.setDateTime(0, DateTime.fromUnixTime(params.startTime));
            sql.setID(2, params.userId);
            sql.setID(3, params.jobId);
            if (!Strings.isVoid(Ini.ServerID)) {
                sql.setString(5, Ini.ServerID);
            }
            if (!Strings.isVoid(Ini.AgentID)) {
                sql.setString(6, Ini.AgentID);
            }
            if (Ini.ProcessID != 0) {
                sql.setNumber(8, Ini.ProcessID);
            }
            try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::registerJob");){
                sql.execute(context, connection);
                connection.commit();
            }
        }
        catch (InformException | SQLException ex) {
            Core.logger.error(null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJob(SSContext context, UpdateJobParams params) {
        if (!this.enabled || this.tableId == 0.0 || params.auditId == 0.0) {
            return;
        }
        try {
            TableDescriptor table = TableDescriptor.get(this.tableId);
            if (table == null || table.getDatabaseDescriptor() == null) {
                this.enabled = false;
                return;
            }
            Sql sql = new Sql(this.getComment(), false, params.auditId, this.fieldIds, table);
            sql.setDateTime(1, DateTime.fromUnixTime(params.stopTime));
            sql.setBool(4, params.successful);
            if (!Strings.isVoid(params.message)) {
                sql.setString(7, params.message);
            }
            try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(null, "AuditJournal::updateJob");){
                sql.execute(context, connection);
                connection.commit();
            }
        }
        catch (InformException | SQLException ex) {
            Core.logger.error(null, ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String getJournalErrorText(Throwable ex) {
        msg = new StringBuilder();
        msg.append(ex.getMessage());
        detailing = new StringBuilder();
lbl5:
        // 3 sources

        try {
            block2: for (t = ex; t != null; t = t.getCause()) {
                block6: {
                    if (!(t instanceof SQLException)) break block6;
                    e = (SQLException)t;
                    for (i = 0; i < 8 && e != null; e = e.getNextException(), ++i) {
                        sql = e.getSQLState();
                        if (sql == null || sql.isEmpty()) continue;
                        msg.append("\n").append(sql);
                        continue block2;
                    }
                    ** GOTO lbl5
                }
                if (!(t instanceof InformException)) continue;
                for (String d : ((InformException)t).details()) {
                    detailing.append("\n").append(d);
                }
                ** GOTO lbl5
            }
        }
        catch (Throwable e) {
            Core.logger.error(null, e);
        }
        if (detailing.length() != 0) {
            msg.append("\n{").append((CharSequence)detailing).append('}');
        }
        return msg.toString();
    }

    public boolean containsAuditableEvent(int event) {
        for (Cursor.Integer c : this.auditableEvents) {
            if (event != c.value) continue;
            return true;
        }
        return false;
    }

    private String getComment() {
        return this.journal.toString() + " journal";
    }

    private static class Sql {
        final String comment;
        boolean insert;
        double auditId;
        int[] fieldIds;
        DatabaseDescriptor database;
        TableDescriptor table;
        SqlCommand command = new SqlCommand();
        StringBuilder values = new StringBuilder();
        private char delimiter;
        TableDataAudit audit = null;

        Sql(String comment, boolean insert, double auditId, int[] fieldIds, TableDescriptor table) {
            this.comment = comment;
            this.insert = insert;
            this.auditId = auditId;
            this.fieldIds = fieldIds;
            this.table = table;
            this.command.setTableDescriptor(table);
            this.database = table.getDatabaseDescriptor();
            if (insert) {
                this.command.sqlText.append("/*").append(comment).append("*/ insert into ");
                this.database.appendTableRawName(table.getRawName(), this.command.sqlText.getBuilder());
                this.command.sqlText.append(" (").append(table.getRecordIdField().getRawName());
                this.values.append("?");
                SqlParameter param = new SqlParameter();
                param.setDouble(auditId);
                this.command.params.add(param);
                this.delimiter = (char)44;
            } else {
                this.command.sqlText.append("/*").append(comment).append("*/ update ");
                this.database.appendTableRawName(table.getRawName(), this.command.sqlText.getBuilder());
                this.command.sqlText.append(" set ");
                this.delimiter = (char)32;
            }
        }

        void execute(SSContext ssContext, DatabaseConnection connection) throws SQLException {
            if (this.insert) {
                this.command.sqlText.append(") values (").append(this.values).append(')');
            } else {
                this.command.sqlText.append(" where ").append(this.table.getRecordIdField().getRawName()).append("=?");
                SqlParameter param = new SqlParameter();
                param.setDouble(this.auditId);
                this.command.params.add(param);
            }
            if (this.audit != null) {
                this.audit.registrateModification(this.table, this.auditId, this.insert ? AuditModification.APPEND : AuditModification.MODIFY);
            }
            this.command.executeUpdate(ssContext, connection);
        }

        static boolean addField(int index, int[] fieldIds, TableDescriptor table, SqlCommand command) {
            if (index < 0 || index >= fieldIds.length || fieldIds[index] <= 0) {
                return false;
            }
            FieldDescriptor field = table.getFieldDescriptor(fieldIds[index]);
            if (field == null) {
                return false;
            }
            command.sqlText.append(field);
            return true;
        }

        SqlParameter add(int index) {
            if (index < 0 || index >= this.fieldIds.length || this.fieldIds[index] <= 0) {
                return null;
            }
            FieldDescriptor field = this.table.getFieldDescriptor(this.fieldIds[index]);
            if (field == null) {
                return null;
            }
            if (this.insert) {
                this.command.sqlText.append(this.delimiter).append(field.getRawName());
                this.values.append(this.delimiter).append('?');
            } else {
                this.command.sqlText.append(this.delimiter).append(field.getRawName()).append("=?");
            }
            this.delimiter = (char)44;
            SqlParameter param = new SqlParameter();
            this.command.params.add(param);
            return param;
        }

        boolean setBool(int index, boolean value) {
            SqlParameter param = this.add(index);
            if (param == null) {
                return false;
            }
            param.setBoolean(value);
            return true;
        }

        boolean setInt(int index, int value) {
            SqlParameter param = this.add(index);
            if (param == null) {
                return false;
            }
            param.setInteger(value);
            return true;
        }

        boolean setNumber(int index, double value) {
            SqlParameter param = this.add(index);
            if (param == null) {
                return false;
            }
            param.setDouble(value);
            return true;
        }

        boolean setNumberIf(int index, double value) {
            SqlParameter param = this.add(index);
            if (param == null) {
                return false;
            }
            param.setDouble(value);
            if (value == 0.0) {
                param.setNull();
            }
            return true;
        }

        boolean setID(int index, double value) {
            SqlParameter param = this.add(index);
            if (param == null) {
                return false;
            }
            param.setDouble(value);
            return true;
        }

        boolean setDateTime(int index, double value) {
            SqlParameter param = this.add(index);
            if (param == null) {
                return false;
            }
            param.setDateTime(value);
            if (value == 0.0) {
                param.setNull();
            }
            return true;
        }

        boolean setTimestamp(int index, long value) {
            SqlParameter param = this.add(index);
            if (param == null) {
                return false;
            }
            param.setTimestamp(value);
            if (value == 0L) {
                param.setNull();
            }
            return true;
        }

        boolean setString(int index, String value) {
            SqlParameter param = this.add(index);
            if (param == null) {
                return false;
            }
            if (value == null || value.isEmpty()) {
                param.setString("");
                param.setNull();
            } else {
                FieldDescriptor field = this.table.getFieldDescriptor(this.fieldIds[index]);
                int size = field.getSize();
                if (size > 0 && value.length() > size) {
                    value = value.substring(0, size - 1);
                }
                param.setString(value);
            }
            return true;
        }

        boolean setBytes(int index, byte[] value) {
            SqlParameter param = this.add(index);
            if (param == null) {
                return false;
            }
            param.setBlob(value);
            if (value == null || value.length == 0) {
                param.setNull();
            }
            return true;
        }
    }

    public static class UpdateJobParams {
        public double auditId = 0.0;
        public long stopTime = 0L;
        public boolean successful = false;
        public String message = "";
    }

    public static class JobParams {
        public long startTime = 0L;
        public double userId = 0.0;
        public double jobId = 0.0;
        public double auditId = 0.0;
    }

    public static class PivotConf
    extends PivotConfParam {
        public double recordID;
        public String name = "";
        public byte[] content = null;
        public double sort = 0.0;
        public boolean defConf = false;
    }

    public static class DataFilter
    extends DataFilterParam {
        public double recordID;
        public String name = "";
        public byte[] content = null;
        public double sort = 0.0;
    }

    public static class PivotConfParam {
        public double userId = 0.0;
        public double formId = 0.0;
        public double controlId = 0.0;
        public double configId = 0.0;
    }

    public static class DataFilterParam {
        public double userId = 0.0;
        public double formId = 0.0;
        public double controlId = 0.0;
    }

    public static class ClientLogParams {
        public double userId = 0.0;
        public double sessionId = 0.0;
        public double time = 0.0;
        public byte[] error = null;
        public byte[] warn = null;
    }

    public static class UpdateEventParams {
        public double auditId = 0.0;
        public long stopTime = 0L;
        public double loadingTime1 = 0.0;
        public double loadingTime2 = 0.0;
    }

    public static class EventParams {
        public double userId = 0.0;
        public double loginId = 0.0;
        public long startTime = 0L;
        public long stopTime = 0L;
        public int code = 0;
        public int kind = 0;
        public double nodeId = 0.0;
        public String remark = null;
        public double loadingTime1 = 0.0;
        public double loadingTime2 = 0.0;
        public double auditId = 0.0;
    }

    public static class LoginParams {
        public double userId = 0.0;
        public int code = 0;
        public long time = 0L;
        public String computer = null;
        public String ip = null;
        public String computerLogin = null;
        public int clientId = 0;
        public double auditId = 0.0;
        public VersionInfo clientVersion = null;
        public double sessionId = 0.0;
        public String agentIP = null;
        public String info = null;
        public int timeZoneOffset = 0;
        public boolean timeZoneAssigned = false;
    }

    public static class UpdateReplicationParams {
        public double auditId = 0.0;
        public double fileSize = 0.0;
        public String fileName = null;
    }

    public static class ReplicationParams {
        public int opCode = 0;
        public double timeBeginOperation = 0.0;
        public double timeEndOperation = 0.0;
        public double dataSliceBegin = 0.0;
        public double dataSliceEnd = 0.0;
        public double userNodeId = 0.0;
        public double replNodeId = 0.0;
        public String resultMessage = null;
        public boolean successfullyResult = false;
        public double replicaId = 0.0;
        public double channelId = 0.0;
        public double replicaSize = 0.0;
        public String fileName = null;
        public String note = null;
    }

    public static enum Journal {
        REPLICATION,
        LOGIN,
        EVENTS,
        CLIENTLOG,
        DATAFILTER,
        PIVOTCONF,
        JOB_JOURNAL;

    }
}

