/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.agent.Core;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.net.Client;
import inform.agent.net.ClientSession;
import java.sql.SQLException;
import java.sql.Timestamp;

public class LockEngine {
    private static final int LOCK_MTD = 1;
    private static final int LOCK_REPLICA = 2;
    private static final String sqlSelectLocker = "select L.ID,L.APP_ID,L.USER_ID,L.SESSION_ID,L.CREATION_TIME from " + MetadataNodeReader.mtdLocksTableName + " L where L.LOCK_TYPE=? and L.NODE_ID=? and L.RECORD_ID=?";
    private static final String getSqlSelectLockerExceptSession = sqlSelectLocker + " and L.SESSION_ID<>?";
    private static final String sqlDeleteAllClientLocks = "delete from " + MetadataNodeReader.mtdLocksTableName + " where SESSION_ID=?";
    private static final String sqlDeleteLock = "delete from " + MetadataNodeReader.mtdLocksTableName + " where LOCK_TYPE=? and NODE_ID=? and RECORD_ID=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locker getNodeLocker(double nodeId, double recordId, double sessionId) throws InformException {
        Locker locker;
        Connector.Metabase connector = new Connector.Metabase();
        try {
            locker = LockEngine.getLocker(1, nodeId, recordId, sessionId, connector.connection());
        }
        catch (Throwable throwable) {
            try {
                connector.close();
                throw throwable;
            }
            catch (Throwable e) {
                throw InformException.wrap(e);
            }
        }
        connector.close();
        return locker;
    }

    public static Locker getNodeLocker(double nodeId, double recordId, double sessionId, DatabaseConnection connection) throws SQLException {
        return LockEngine.getLocker(1, nodeId, recordId, sessionId, connection);
    }

    public static Locker getReplicaLocker(double nodeId, double recordId, DatabaseConnection connection) throws SQLException {
        return LockEngine.getLocker(2, nodeId, recordId, 0.0, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Locker getLocker(int lockType, double nodeId, double recordId, double sessionId, DatabaseConnection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("LockEngine.getLocker", sessionId == 0.0 ? sqlSelectLocker : getSqlSelectLockerExceptSession);){
            statement.setDouble(1, lockType);
            statement.setDouble(2, nodeId);
            statement.setDouble(3, recordId);
            if (sessionId != 0.0) {
                statement.setDouble(4, sessionId);
            }
            try (ResultSet resultSet = statement.executeQuery(connection.getSSContext());){
                if (resultSet.next()) {
                    double lockId = resultSet.getAsDouble(1);
                    double applicationId = resultSet.getAsDouble(2);
                    double userId = resultSet.getAsDouble(3);
                    double lockerSessionId = resultSet.getAsDouble(4);
                    Timestamp timestamp = resultSet.getTimestamp(5);
                    long time = timestamp != null ? timestamp.getTime() : 0L;
                    Locker locker = new Locker(lockId, applicationId, lockType, nodeId, recordId, userId, lockerSessionId, time);
                    return locker;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locker lockNode(double nodeId, double recordId, Client client) throws SQLException {
        try (Connector.Metabase connector = new Connector.Metabase();){
            DatabaseConnection connection = connector.connection();
            if (LockEngine.insertLockValidated(1, nodeId, recordId, client.getUserId(), client.getSessionId(), connection)) {
                Locker locker = null;
                return locker;
            }
            Locker locker = LockEngine.getLocker(1, nodeId, recordId, client.getSessionId(), connection);
            if (locker == null) {
                Locker locker2 = new Locker(0.0, 0.0, 1, nodeId, recordId, 0.0, -1.0, 0L);
                return locker2;
            }
            if (locker.sessionId == client.getSessionId()) {
                Locker locker3 = null;
                return locker3;
            }
            Locker locker4 = locker;
            return locker4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Locker lockReplica(double nodeId, double recordId, double userId) {
        try (Connector.Metabase connector = new Connector.Metabase();){
            DatabaseConnection connection = connector.connection();
            if (LockEngine.insertLockValidated(2, nodeId, recordId, userId, 0.0, connection)) {
                Locker locker = null;
                return locker;
            }
            Locker locker = LockEngine.getLocker(2, nodeId, recordId, 0.0, connection);
            if (locker == null) {
                Locker locker2 = new Locker(0.0, 0.0, 2, nodeId, recordId, 0.0, -1.0, 0L);
                return locker2;
            }
            Locker locker3 = locker;
            return locker3;
        }
        catch (Throwable e) {
            throw InformException.wrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlockNode(double nodeId, double recordId) throws SQLException {
        try (Connector.Metabase connector = new Connector.Metabase();){
            LockEngine.deleteLock(1, nodeId, recordId, connector.connection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlockReplica(double nodeId, double recordId) {
        try (Connector.Metabase connector = new Connector.Metabase();){
            LockEngine.deleteLock(2, nodeId, recordId, connector.connection());
        }
        catch (Throwable e) {
            throw InformException.wrap(e);
        }
    }

    public static void unlockAll(Client client) {
        try (Connector.Metabase connector = new Connector.Metabase();){
            LockEngine.unlockAll(client, connector.connection());
        }
        catch (Throwable e) {
            throw InformException.wrap(e);
        }
    }

    private static void unlockAll(Client client, DatabaseConnection connection) {
        try {
            try (PreparedStatement statement = connection.prepareStatement("LockEngine.unlockAll", sqlDeleteAllClientLocks);){
                statement.setDouble(1, client.getSessionId());
                statement.executeUpdate(connection.getSSContext());
            }
            connection.commit();
        }
        catch (Throwable t) {
            Core.logger.error(null, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteObsoleteLocks(DatabaseConnection connection) {
        DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ").append(MetadataNodeReader.mtdLocksTableName).append(" where ").append("ID").append(" in (select L.").append("ID").append(" from ").append(MetadataNodeReader.mtdLocksTableName).append(" L left outer join ").append(MetadataNodeReader.mtdAgentsTableName).append(" A ON A.").append("ID").append("=L.").append("APP_ID").append(" where A.").append("ID").append(" is null or (");
        caps.daysBetween(sql, caps.currentDateTime(), "A.ACTIVITY");
        sql.append(") > ?)");
        try {
            try (PreparedStatement statement = connection.prepareStatement("LockEngine.deleteObsoleteLocks", sql.toString());){
                statement.setDouble(1, 0.008333333333333333);
                statement.executeUpdate(connection.getSSContext());
            }
            connection.commit();
        }
        catch (SQLException e) {
            Core.logger.error(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validateLocks(DatabaseConnection connection, int lockType, double nodeId, double recordId) {
        Object sql;
        Locker locker = null;
        try {
            locker = LockEngine.getLocker(lockType, nodeId, recordId, 0.0, connection);
        }
        catch (SQLException e) {
            Core.logger.error(null, e);
            try {
                connection.rollback();
            }
            catch (SQLException e2) {
                Core.logger.error(null, e2);
            }
        }
        DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
        if (locker != null && locker.sessionId != 0.0 && locker.applicationId == Core.getApplicationId() && !ClientSession.hasSession(locker.sessionId)) {
            sql = "delete from " + MetadataNodeReader.mtdLocksTableName + " where ID=?";
            try {
                try (PreparedStatement statement = connection.prepareStatement("LockEngine.validateLocks 1", (String)sql);){
                    statement.setDouble(1, locker.lockId);
                    statement.executeUpdate(connection.getSSContext());
                }
                connection.commit();
                return true;
            }
            catch (SQLException e) {
                Core.logger.error(null, e);
                try {
                    connection.rollback();
                }
                catch (Throwable t) {
                    Core.logger.error(null, t);
                }
            }
        }
        sql = new StringBuilder();
        ((StringBuilder)sql).append("delete from ").append(MetadataNodeReader.mtdLocksTableName).append(" where ").append("LOCK_TYPE").append("=? and ").append("NODE_ID").append("=? and ").append("RECORD_ID").append("=? and ").append("ID").append(" in (select L.").append("ID").append(" from ").append(MetadataNodeReader.mtdLocksTableName).append(" L left outer join ").append(MetadataNodeReader.mtdAgentsTableName).append(" A ON A.").append("ID").append("=L.").append("APP_ID").append(" where A.").append("ID").append(" is null or (");
        caps.daysBetween((StringBuilder)sql, caps.currentDateTime(), "A.ACTIVITY");
        ((StringBuilder)sql).append(") > ?)");
        try {
            try (PreparedStatement statement = connection.prepareStatement("LockEngine.validateLocks 2", ((StringBuilder)sql).toString());){
                statement.setDouble(1, lockType);
                statement.setDouble(2, nodeId);
                statement.setDouble(3, recordId);
                statement.setDouble(4, 0.008333333333333333);
                statement.executeUpdate(connection.getSSContext());
            }
            connection.commit();
            return true;
        }
        catch (SQLException e) {
            Core.logger.error(null, e);
            try {
                connection.rollback();
            }
            catch (Throwable t) {
                Core.logger.error(null, t);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteLock(int lockType, double nodeId, double recordId, DatabaseConnection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("LockEngine.deleteLock", sqlDeleteLock);){
            statement.setDouble(1, lockType);
            statement.setDouble(2, nodeId);
            statement.setDouble(3, recordId);
            statement.executeUpdate(connection.getSSContext());
        }
        connection.commit();
    }

    private static boolean insertLockValidated(int lockType, double nodeId, double recordId, double userId, double sessionId, DatabaseConnection connection) throws SQLException {
        return LockEngine.insertLock(lockType, nodeId, recordId, userId, sessionId, connection) || LockEngine.validateLocks(connection, lockType, nodeId, recordId) && LockEngine.insertLock(lockType, nodeId, recordId, userId, sessionId, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean insertLock(int lockType, double nodeId, double recordId, double userId, double sessionId, DatabaseConnection connection) throws SQLException {
        DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
        String sql = "insert into " + MetadataNodeReader.mtdLocksTableName + " (ID, APP_ID, LOCK_TYPE, NODE_ID, RECORD_ID, USER_ID, SESSION_ID, CREATION_TIME) values (?, ?, ?, ?, ?, ?, ?, " + caps.currentDateTime() + ")";
        try (PreparedStatement statement = connection.prepareStatement("LockEngine.insertLock", sql);){
            statement.setDouble(1, Core.generateId());
            statement.setDouble(2, Core.getApplicationId());
            statement.setDouble(3, lockType);
            statement.setDouble(4, nodeId);
            statement.setDouble(5, recordId);
            statement.setDouble(6, userId);
            statement.setDouble(7, sessionId);
            try {
                statement.executeUpdate(connection.getSSContext());
                connection.commit();
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                Core.logger.error(null, e);
                try {
                    connection.rollback();
                }
                catch (Throwable t) {
                    Core.logger.error(null, t);
                }
                boolean bl = false;
                statement.close();
                return bl;
            }
        }
    }

    public static class Locker {
        private final double lockId;
        private final double applicationId;
        private final int locType;
        private final double nodeId;
        private final double recordId;
        private final double userId;
        private final double sessionId;
        private final long time;

        Locker(double lockId, double applicationId, int locType, double nodeId, double recordId, double userId, double sessionId, long time) {
            this.lockId = lockId;
            this.applicationId = applicationId;
            this.locType = locType;
            this.nodeId = nodeId;
            this.recordId = recordId;
            this.userId = userId;
            this.sessionId = sessionId;
            this.time = time;
        }

        Locker(double lockId, double applicationId, int locType, double nodeId, double recordId, double userId, double sessionId, Timestamp time) {
            this(lockId, applicationId, locType, nodeId, recordId, userId, sessionId, time != null ? time.getTime() : 0L);
        }

        public void throwNode(Node node) {
            this.throwNode(node, null);
        }

        public void throwNode(Node node, String message) {
            StringBuilder msg = new StringBuilder();
            msg.append("\u0423\u0437\u0435\u043b '").append(node.getName()).append("' \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d");
            if (this.userId != 0.0) {
                String name = MtdEngine.tryGetUserName(this.userId);
                if (name == null) {
                    name = "";
                }
                msg.append(" \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c ").append(name).append(" [").append(NumberConverter.doubleToString(this.userId)).append(']');
            }
            if (message != null) {
                msg.append("\r\n").append(message);
            }
            InformException ex = new InformException(msg.toString());
            if (this.sessionId != 0.0) {
                ex.detail("SessionID: " + NumberConverter.doubleToString(this.sessionId));
            }
            throw ex;
        }

        public String getReplicaError() {
            String text = "\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \"" + MtdEngine.tryGetNodeName(this.nodeId) + "\" [" + (long)this.nodeId + "] \u043f\u043e \u043a\u0430\u043d\u0430\u043b\u0443 \"" + MtdEngine.tryGetNodeName(this.recordId) + "\" [" + (long)this.recordId + "] \u0443\u0436\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f\n \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \"" + MtdEngine.tryGetUserName(this.userId) + "\" [" + (long)this.userId + "]";
            if (this.time != 0L) {
                text = text + " \u0432\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 " + DateTime.toString(DateTime.fromUnixTime(this.time));
            }
            return text;
        }

        public double getNodeId() {
            return this.nodeId;
        }

        public double getSessionId() {
            return this.sessionId;
        }

        public double getUserId() {
            return this.userId;
        }

        public String getUserName() {
            if (this.userId == 0.0) {
                return "";
            }
            String name = MtdEngine.tryGetUserName(this.userId);
            if (name == null) {
                return "";
            }
            return name;
        }
    }
}

