/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.NumberConverter;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.LogContext;
import inform.agent.db.DBLogin;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdCache;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.NodeRecordIntf;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.ConstantsNode;
import inform.agent.mtd.nodes.GroupNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.NodeHashTable;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.mtd.request.NodeStatus;
import inform.agent.net.Client;
import inform.common.Empty;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class AccountNode
extends BasicNode {
    public static final int TAG_ACCOUNT_ROOT_NODE = 1;
    public static final int TAG_ACCOUNT_START_NODE = 2;
    public static final int TAG_ACCOUNT_START_ACTION = 3;
    public static final int TAG_ACCOUNT_START_SCRIPT = 4;
    public static final int TAG_ACCOUNT_COUNSTANTS = 6;
    public static final int TAG_ACCOUNT_PROPS = 7;
    public static final int TAG_ACCOUNT_INHERITED_UI = 8;
    public static final int TAG_ACCOUNT_UI_SETTINGS = 9;
    public static final int TAG_ACCOUNT_DB_LOGINS = 10;
    public static final int TAG_ACCOUNT_SERVER_IPS = 11;
    public static final int TAG_ACCOUNT_WEB_START_NODE = 12;
    public static final int TAG_ACCOUNT_SAVE_PER_RECORD = 14;
    public static final int TAG_ACCOUNT_INHERITED_SAVE_PER_RECORD = 15;
    public static final int TAG_ACCOUNT_CAN_SETUP_USER = 16;
    public static final int TAG_ACCOUNT_INHERITED_CAN_SETUP_USER = 17;
    public static final int TAG_ACCOUNT_CAN_CREATE_ANY_NODES = 18;
    public static final int TAG_ACCOUNT_CAN_CREATE_NODE_TYPES = 19;
    public static final int TAG_ACCOUNT_INHERITED_CAN_CREATE_NODE_TYPES = 20;
    public static final int TAG_ACCOUNT_SIMPLE_POPUP = 21;
    public static final int TAG_ACCOUNT_INHERITED_SIMPLE_POPUP = 22;
    public static final int TAG_ACCOUNT_CAN_WRITE_PUBLIC_FILTERS = 23;
    public static final int TAG_ACCOUNT_INHERITED_CAN_WRITE_PUBLIC_FILTERS = 24;
    public static final int TAG_ACCOUNT_CAN_OPERATE_PEX_OBSOLETE = 25;
    public static final int TAG_ACCOUNT_INHERITED_CAN_OPERATE_PEX_OBSOLETE = 26;
    public static final int TAG_ACCOUNT_CAN_VIEW_DATA_HISTORY = 27;
    public static final int TAG_ACCOUNT_INHERITED_CAN_VIEW_DATA_HISTORY = 28;
    public static final int TAG_ACCOUNT_CAN_VIEW_METADATA_HISTORY = 29;
    public static final int TAG_ACCOUNT_INHERITED_CAN_VIEW_METADATA_HISTORY = 30;
    public static final int TAG_ACCOUNT_CAN_WRITE_PEX = 31;
    public static final int TAG_ACCOUNT_INHERITED_CAN_WRITE_PEX = 32;
    public static final int TAG_ACCOUNT_CAN_UPLOAD_PEX = 33;
    public static final int TAG_ACCOUNT_INHERITED_CAN_UPLOAD_PEX = 34;
    public static final int TAG_ACCOUNT_POSSIBLE_LOGIN_COUNT = 35;
    public static final int TAG_ACCOUNT_EDIT_NODE = 36;
    public static final int TAG_ACCOUNT_INHERITED_EDIT_NODE = 37;
    public static final int TAG_ACCOUNT_SERVICE_USER = 38;
    public static final int TAG_ACCOUNT_EXPLICIT_START_SCRIPT = 100;
    static final int TAG_UI_FAST_SAVE = 1;
    static final int TAG_UI_PROP_SETTING = 2;
    static final int TAG_UI_NODE_TYPES = 3;
    static final int TAG_UI_NODE_TYPES_ALL = 4;
    static final int TAG_UI_SIMPLE_POPUP = 5;
    public static final int DEF_CMD_NONE = -1;
    private static final AtomicInteger globalSecurityChangeNo = new AtomicInteger(0);
    private volatile int securityChangeNo;
    private double[] explicitGroups = Empty.doubleArray;
    private double[] parentGroupsCache;
    private double[] effectiveGroupsCache;
    private byte[] constants = null;
    private ArrayList<DBLogin> dbLogins = null;
    private int[] allowedServerIPs = null;
    private String[] allowedServerNames = null;
    private boolean allowAnyServerIP = true;
    private boolean inheritedServerIPs = true;
    protected boolean blocked = false;
    protected boolean activeDirectory = false;
    protected boolean inheritedStartup = true;
    protected double startupRootNodeId = 0.0;
    protected double startupStartNodeId = -1.0;
    protected int startupStartNodeAction = -1;
    protected double startupScriptId = -1.0;
    protected double webStartNodeId;
    private final UserInterface userInterface = new UserInterface();
    private boolean newUserInterface = false;
    private boolean obsolate = false;

    public AccountNode(NodeRecord record) {
        super(record);
    }

    public final boolean isBlocked() {
        return this.isBlockedImpl(null);
    }

    protected boolean isBlockedImpl(LogContext.Builder cause) {
        if (this.blocked && cause != null) {
            cause.append("blocked", true);
        }
        return this.blocked;
    }

    public boolean isAccountBlocked(LogContext.Builder cause) {
        AccountNode account = this;
        for (int i = 0; i < 256 && account != null; ++i) {
            if (account.isBlockedImpl(cause)) {
                cause.append("node", NumberConverter.doubleToString(account.getId()));
                return true;
            }
            account = MtdEngine.getAccountNode(account.getParentId());
        }
        return false;
    }

    public boolean isActiveDirectoryAuthorization() throws InformException {
        if (this.activeDirectory) {
            return true;
        }
        Node node = MtdEngine.getNode(this.getParentId());
        while (node != null && node.getParentId() != 0.0) {
            if (node instanceof GroupNode && ((AccountNode)node).activeDirectory) {
                return true;
            }
            node = MtdEngine.getNode(node.getParentId());
        }
        return false;
    }

    public boolean serverManaged() {
        return false;
    }

    public ArrayList<DBLogin> getDbLogins() {
        return this.dbLogins;
    }

    @Override
    public void getNodeInfo(Node.NodeInfoArg arg) throws InformException, IOException, SQLException, InterruptedException {
        super.getNodeInfo(arg);
        if ((arg.options & 0x100) != 0) {
            arg.out.putBool(52, this.isBlocked());
            return;
        }
        this.getAccountInfo(arg.out, false);
    }

    @Override
    public void afterCreateNew(Node.CreationArg arg) throws InformException {
        if (!arg.clone) {
            this.userInterface.setAllInherited(true);
            this.inheritedServerIPs = true;
            this.inheritedStartup = true;
        }
        this.setAttrModified();
        this.setContentModified();
        super.afterCreateNew(arg);
    }

    @Override
    public void getCreationChanges(NodeRecordIntf record) throws InformException {
        super.getCreationChanges(record);
        if (record instanceof MetadataNodeReader.NodeChanges) {
            ((MetadataNodeReader.NodeChanges)record).setContent(this.getModifiedContent());
        }
    }

    public void getAccountInfo(TaggedWriter out, boolean needHash) throws IOException, InformException {
        if (this.explicitGroups.length != 0) {
            out.putRaw(34, LittleEndian.doubleArrayToBinary(this.explicitGroups));
        }
        if (this.inheritedStartup) {
            out.putEmpty(35);
        }
        if (this.constants != null && this.constants.length != 0) {
            out.putRaw(37, this.constants);
        }
        UserInterface ui = new UserInterface(this.userInterface);
        this.findUserInterface(ui, ui.getInheritedBits());
        out.putBool(89, ui.inheritedSavePerRecord);
        out.putBool(88, ui.savePerRecord);
        out.putBool(91, ui.inheritedCanSetupUser);
        out.putBool(90, ui.canSetupUser);
        out.putBool(94, ui.inheritedCanCreateNodes);
        out.putBool(92, ui.canCreateAnyNodes);
        if (!ui.canCreateAnyNodes) {
            out.putIntArray(93, ui.canCreateNodeTypes);
        }
        out.putBool(96, ui.inheritedSimplePopup);
        out.putBool(95, ui.simplePopup);
        out.putBool(98, ui.inheritedCanWritePublicFilters);
        out.putBool(97, ui.canWritePublicFilters);
        out.putBool(107, ui.inheritedCanWritePex);
        out.putBool(106, ui.canWritePex);
        out.putBool(109, ui.inheritedCanUploadPex);
        out.putBool(108, ui.canUploadPex);
        out.putBool(103, ui.inheritedCanViewDataHistory);
        out.putBool(102, ui.canViewDataHistory);
        out.putBool(105, ui.inheritedCanViewMetadataHistory);
        out.putBool(104, ui.canViewMetadataHistory);
        out.putBool(112, ui.inheritedEditNode);
        out.putBool(111, ui.editNode);
        byte[] loggins = this.saveDbLogins();
        if (loggins != null && loggins.length != 0) {
            out.putRaw(45, loggins);
        }
        out.putBool(51, this.inheritedServerIPs);
        out.putBool(82, this.activeDirectory);
        byte[] ips = this.findAllowedServerIPs();
        if (ips != null && ips.length != 0) {
            out.putRaw(50, ips);
        }
        out.putBool(52, this.isBlocked());
    }

    protected void afterLoadTag(TaggedReader in) throws Throwable {
    }

    private void loadContent(byte[] content) throws Throwable {
        TaggedReader in = new TaggedReader(new ByteArrayInputStream(content), content.length);
        block42: while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    in.skip();
                    this.startupRootNodeId = in.getDouble(151);
                    continue block42;
                }
                case 2: {
                    in.skip();
                    this.startupStartNodeId = in.getDouble(151);
                    continue block42;
                }
                case 3: {
                    this.startupStartNodeAction = in.getInt();
                    continue block42;
                }
                case 4: {
                    in.skip();
                    this.startupScriptId = in.getDouble(151);
                    continue block42;
                }
                case 12: {
                    in.skip();
                    this.webStartNodeId = in.getDouble(151);
                    continue block42;
                }
                case 6: {
                    in.skip();
                    this.constants = in.getRaw(202);
                    continue block42;
                }
                case 8: {
                    if (this.newUserInterface) continue block42;
                    this.userInterface.setAllInherited(in.getBoolean());
                    continue block42;
                }
                case 9: {
                    if (this.newUserInterface) continue block42;
                    this.userInterface.setAllInherited(false);
                    TaggedReader stream = in.getStreamReader();
                    while (stream.next()) {
                        switch (stream.getCurrentTag()) {
                            case 1: {
                                this.userInterface.savePerRecord = stream.getBoolean();
                                break;
                            }
                            case 2: {
                                this.userInterface.canSetupUser = stream.getBoolean();
                                break;
                            }
                            case 4: {
                                this.userInterface.canCreateAnyNodes = stream.getBoolean();
                                break;
                            }
                            case 3: {
                                this.userInterface.canCreateAnyNodes = false;
                                this.userInterface.canCreateNodeTypes = LittleEndian.toIntArray(stream.getRaw());
                                break;
                            }
                            case 5: {
                                this.userInterface.simplePopup = stream.getBoolean();
                            }
                        }
                    }
                    continue block42;
                }
                case 14: {
                    this.userInterface.savePerRecord = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 15: {
                    this.userInterface.inheritedSavePerRecord = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 16: {
                    this.userInterface.canSetupUser = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 17: {
                    this.userInterface.inheritedCanSetupUser = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 18: {
                    this.userInterface.canCreateAnyNodes = true;
                    this.newUserInterface = true;
                    continue block42;
                }
                case 19: {
                    this.userInterface.canCreateAnyNodes = false;
                    this.userInterface.canCreateNodeTypes = LittleEndian.toIntArray(in.getRaw());
                    this.newUserInterface = true;
                    continue block42;
                }
                case 20: {
                    this.userInterface.inheritedCanCreateNodes = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 21: {
                    this.userInterface.simplePopup = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 22: {
                    this.userInterface.inheritedSimplePopup = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 23: {
                    this.userInterface.canWritePublicFilters = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 24: {
                    this.userInterface.inheritedCanWritePublicFilters = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 25: {
                    this.userInterface.canUploadPex = this.userInterface.canWritePex = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 26: {
                    this.userInterface.inheritedCanUploadPex = this.userInterface.inheritedCanWritePex = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 31: {
                    this.userInterface.canWritePex = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 32: {
                    this.userInterface.inheritedCanWritePex = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 33: {
                    this.userInterface.canUploadPex = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 34: {
                    this.userInterface.inheritedCanUploadPex = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 27: {
                    this.userInterface.canViewDataHistory = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 28: {
                    this.userInterface.inheritedCanViewDataHistory = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 29: {
                    this.userInterface.canViewMetadataHistory = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 30: {
                    this.userInterface.inheritedCanViewMetadataHistory = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 36: {
                    this.userInterface.editNode = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 37: {
                    this.userInterface.inheritedEditNode = in.getBoolean();
                    this.newUserInterface = true;
                    continue block42;
                }
                case 10: {
                    this.loadDBLogins(in.getStreamReader());
                    continue block42;
                }
                case 11: {
                    this.inheritedServerIPs = false;
                    this.loadServerIPs(in.getStreamReader());
                    continue block42;
                }
            }
            this.afterLoadTag(in);
        }
    }

    @Override
    protected void afterLoad() throws InformException {
        try {
            byte[] content = this.getContent();
            if (content == null || content.length == 0) {
                return;
            }
            this.loadContent(content);
        }
        catch (Throwable ex) {
            Core.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430 \u0443\u0437\u043b\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f/\u0433\u0440\u0443\u043f\u043f\u044b[" + NumberConverter.doubleToString(this.getId()) + "], \u0443\u0437\u0435\u043b \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d", ex);
            this.blocked = true;
        }
    }

    @Override
    public void beforeLoad() {
        this.newUserInterface = false;
    }

    protected void loadExplicitGroups(double[] value) {
        this.explicitGroups = value;
    }

    @Override
    protected void loadTag(MtdCache mtdCache, TaggedReader in) throws InformException, IOException, InterruptedException {
        switch (in.getCurrentTag()) {
            case 105: {
                this.explicitGroups = LittleEndian.toDoubleArray(in.getRaw());
                break;
            }
            case 104: {
                this.inheritedStartup = !in.getBooleanDef(true);
                break;
            }
            case 107: {
                in.skip();
                this.constants = in.getRaw(202);
                break;
            }
            case 111: {
                if (this.newUserInterface) break;
                this.userInterface.setAllInherited(in.getBoolean());
                break;
            }
            case 110: {
                if (this.newUserInterface) break;
                this.userInterface.setAllInherited(false);
                TaggedReader stream = in.getStreamReader();
                while (stream.next()) {
                    switch (stream.getCurrentTag()) {
                        case 1: {
                            this.userInterface.savePerRecord = stream.getBoolean();
                            break;
                        }
                        case 2: {
                            this.userInterface.canSetupUser = stream.getBoolean();
                            break;
                        }
                        case 4: {
                            this.userInterface.canCreateAnyNodes = stream.getBoolean();
                            break;
                        }
                        case 3: {
                            this.userInterface.canCreateAnyNodes = false;
                            this.userInterface.canCreateNodeTypes = LittleEndian.toIntArray(stream.getRaw());
                            break;
                        }
                        case 5: {
                            this.userInterface.simplePopup = stream.getBoolean();
                        }
                    }
                }
                break;
            }
            case 112: {
                this.loadDBLogins(in.getStreamReader());
                break;
            }
            case 114: {
                this.inheritedServerIPs = in.getBoolean();
                break;
            }
            case 113: {
                this.inheritedServerIPs = false;
                this.loadServerIPs(in.getStreamReader());
                break;
            }
            case 119: {
                this.activeDirectory = in.getBoolean();
                break;
            }
            case 115: {
                if (this.status == NodeStatus.COPIED) {
                    this.trySetLock(mtdCache, true);
                    break;
                }
                this.trySetLock(mtdCache, in.getBooleanDef(false));
                break;
            }
            default: {
                super.loadTag(null, in);
            }
        }
    }

    public void trySetLock(MtdCache mtdCache, boolean value) throws InterruptedException, InformException {
        this.blocked = value;
    }

    private void getActualConstants(TaggedWriter out, IntegerSet complete, boolean isInherited) throws IOException, InformException {
        Node parentNode;
        if (this.constants != null) {
            TaggedReader in = new TaggedReader(new ByteArrayInputStream(this.constants), this.constants.length);
            while (in.getNextTag() != 0) {
                int constId = in.getInt(19);
                if (constId < 0 || !complete.add(constId)) {
                    in.skip();
                    continue;
                }
                out.putInt32(19, constId);
                if (isInherited) {
                    out.putEmpty(20);
                }
                in.transferTag(out);
            }
        }
        if ((parentNode = MtdEngine.getNode(this.getParentId())) == null || !(parentNode instanceof AccountNode)) {
            return;
        }
        AccountNode parentAccount = (AccountNode)parentNode;
        parentAccount.getActualConstants(out, complete, true);
    }

    private byte[] getActualConstants(boolean isInherited) throws InformException {
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(result);
            IntegerSet complete = new IntegerSet();
            this.getActualConstants(out, complete, isInherited);
            ConstantsNode.getActualContstants(out, complete);
            out.flush();
            if (result.size() == 0) {
                return Empty.byteArray;
            }
            return result.toByteArray();
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
    }

    public byte[] getActualConstants() throws InformException {
        return this.getActualConstants(false);
    }

    public byte[] getInheritedActualConstants() throws InformException, IOException {
        Node parentNode = MtdEngine.getNode(this.getParentId());
        if (parentNode == null || !(parentNode instanceof AccountNode)) {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(result);
            IntegerSet complete = new IntegerSet();
            ConstantsNode.getActualContstants(out, complete);
            out.flush();
            if (result.size() == 0) {
                return Empty.byteArray;
            }
            return result.toByteArray();
        }
        AccountNode parentAccount = (AccountNode)parentNode;
        return parentAccount.getActualConstants(true);
    }

    private void loadServerIPs(TaggedReader in) throws IOException, TaggedReaderException {
        this.allowedServerIPs = null;
        this.allowedServerNames = null;
        int ipCount = 0;
        int nameCount = 0;
        this.allowAnyServerIP = false;
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.allowAnyServerIP = true;
                    break;
                }
                case 2: {
                    if (this.allowedServerIPs == null) {
                        this.allowedServerIPs = new int[4];
                    } else if (ipCount >= this.allowedServerIPs.length) {
                        this.allowedServerIPs = Arrays.copyOf(this.allowedServerIPs, this.allowedServerIPs.length + 4);
                    }
                    this.allowedServerIPs[ipCount++] = in.getInt();
                    break;
                }
                case 3: {
                    if (this.allowedServerNames == null) {
                        this.allowedServerNames = new String[4];
                    } else if (nameCount >= this.allowedServerNames.length) {
                        this.allowedServerNames = Arrays.copyOf(this.allowedServerNames, this.allowedServerNames.length + 4);
                    }
                    this.allowedServerNames[nameCount++] = in.getAnsi();
                }
            }
        }
        if (ipCount == 0 && nameCount == 0) {
            this.allowAnyServerIP = true;
        }
        if (ipCount == 0) {
            this.allowedServerIPs = null;
        } else if (ipCount != this.allowedServerIPs.length) {
            this.allowedServerIPs = Arrays.copyOf(this.allowedServerIPs, ipCount);
        }
        if (nameCount == 0) {
            this.allowedServerNames = null;
        } else if (nameCount != this.allowedServerNames.length) {
            this.allowedServerNames = Arrays.copyOf(this.allowedServerNames, nameCount);
        }
    }

    protected byte[] saveServerIPs() throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        if (this.allowAnyServerIP) {
            out.putEmpty(1);
        }
        if (this.allowedServerIPs != null) {
            for (int ip : this.allowedServerIPs) {
                out.putInt32(2, ip);
            }
        }
        if (this.allowedServerNames != null) {
            for (String ip : this.allowedServerNames) {
                out.putAnsi(3, ip);
            }
        }
        out.flush();
        return data.toByteArray();
    }

    private void loadDBLogins(TaggedReader in) throws IOException, TaggedReaderException {
        this.dbLogins = new ArrayList();
        DBLogin dbLogin = null;
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    dbLogin = new DBLogin();
                    break;
                }
                case 2: {
                    if (dbLogin != null && dbLogin.getDatabaseId() != 0.0) {
                        this.dbLogins.add(dbLogin);
                    }
                    dbLogin = null;
                }
            }
            if (dbLogin == null) continue;
            dbLogin.loadTag(in);
        }
    }

    protected byte[] saveDbLogins() throws IOException {
        if (this.dbLogins == null) {
            return null;
        }
        ByteArrayOutputStream loggins = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(loggins);
        for (DBLogin dbLogin : this.dbLogins) {
            dbLogin.save(out);
        }
        out.flush();
        return loggins.toByteArray();
    }

    private void findUserInterface(UserInterface ui, int bits) {
        Node node;
        AccountNode accountNode = this;
        while (bits != 0 && (node = MtdEngine.getNode(accountNode.getParentId())) != null && node.getId() != 0.0 && node instanceof AccountNode) {
            accountNode = (AccountNode)node;
            bits = ui.updateInheritedValues(accountNode.userInterface, bits);
        }
    }

    public UserInterface getActualUserInterface() {
        UserInterface ui = new UserInterface(this.userInterface);
        this.findUserInterface(ui, ui.getInheritedBits());
        return ui;
    }

    private byte[] findAllowedServerIPs() throws InformException, IOException {
        AccountNode accountNode = this;
        while (true) {
            if (!accountNode.inheritedServerIPs) {
                return accountNode.saveServerIPs();
            }
            Node node = MtdEngine.getNode(accountNode.getParentId());
            if (node == null || !(node instanceof AccountNode)) break;
            accountNode = (AccountNode)node;
        }
        return null;
    }

    public boolean acceptServerIP(InetAddress addr, String serverHostName) throws InformException {
        Node node;
        AccountNode accountNode = this;
        while (accountNode.inheritedServerIPs && (node = MtdEngine.getNode(accountNode.getParentId())) != null && node instanceof AccountNode) {
            accountNode = (AccountNode)node;
        }
        if (accountNode.inheritedServerIPs) {
            return true;
        }
        if (accountNode.allowAnyServerIP) {
            return true;
        }
        if (accountNode.allowedServerNames != null) {
            if (serverHostName != null && !serverHostName.isEmpty()) {
                for (String host : accountNode.allowedServerNames) {
                    if (!host.equalsIgnoreCase(serverHostName)) continue;
                    return true;
                }
            }
            for (String host : accountNode.allowedServerNames) {
                try {
                    InetAddress[] addresses;
                    for (InetAddress address : addresses = InetAddress.getAllByName(host)) {
                        if (!address.equals(addr)) continue;
                        return true;
                    }
                }
                catch (UnknownHostException ex) {
                    Core.logger.error("acceptServerIP", ex);
                }
            }
        }
        if (accountNode.allowedServerIPs == null) {
            return true;
        }
        for (int allowedIp : accountNode.allowedServerIPs) {
            if (allowedIp != addr.hashCode()) continue;
            return true;
        }
        return false;
    }

    public String checkStartupRootNodeAssigned() {
        AccountNode node = this;
        AccountNode accountNode = this;
        while (accountNode.inheritedStartup) {
            Node n = MtdEngine.getNode(accountNode.getParentId());
            if (!(n instanceof AccountNode)) {
                node = null;
                break;
            }
            node = accountNode = (AccountNode)n;
        }
        if (node == null || node.startupRootNodeId == 0.0) {
            StringBuilder msg = new StringBuilder();
            if (accountNode.getId() == this.getId()) {
                msg.append("\u0423 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f ").append(this.getName()).append(" [").append(NumberConverter.doubleToString(this.getId())).append("] \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0439 \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0443\u0437\u0435\u043b");
            } else {
                msg.append("\u0423 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f ").append(this.getName()).append(" [").append(NumberConverter.doubleToString(this.getId())).append("] \u043d\u0430\u0441\u043b\u0435\u0434\u0443\u0435\u0442\u0441\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0439 \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0443\u0437\u0435\u043b \u043e\u0442 \u0433\u0440\u0443\u043f\u043f\u044b-\u0448\u0430\u0431\u043b\u043e\u043d\u0430 ").append(accountNode.getName()).append(" [").append(NumberConverter.doubleToString(accountNode.getId())).append(']');
            }
            return msg.toString();
        }
        return null;
    }

    public boolean isInheritedStartup() {
        return this.inheritedStartup;
    }

    protected AccountNode findStartupAccount() {
        AccountNode accountNode = this;
        while (accountNode.inheritedStartup) {
            Node node = MtdEngine.getNode(accountNode.getParentId());
            if (!(node instanceof AccountNode)) {
                accountNode = null;
                break;
            }
            accountNode = (AccountNode)node;
        }
        return accountNode;
    }

    public StartupInfo findStartupInfo() {
        AccountNode accountNode = this.findStartupAccount();
        if (accountNode == null) {
            return null;
        }
        return new StartupInfo(accountNode);
    }

    public byte[] findStartup() throws InformException, IOException {
        double startupScript;
        AccountNode accountNode = this.findStartupAccount();
        double d = startupScript = accountNode == null ? 0.0 : accountNode.startupScriptId;
        if (startupScript == 0.0) {
            startupScript = MtdEngine.serverNode().descriptor().userStartupScript;
        }
        if (accountNode == null && startupScript == 0.0) {
            return Empty.byteArray;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        if (accountNode != null) {
            out.putEmpty(1);
            out.putDouble(151, accountNode.startupRootNodeId);
            out.putEmpty(2);
            out.putDouble(151, accountNode.startupStartNodeId);
            out.putInt32(3, accountNode.startupStartNodeAction);
            out.putEmpty(12);
            out.putDouble(151, accountNode.webStartNodeId);
            out.putDouble(100, accountNode.startupScriptId);
        }
        out.putEmpty(4);
        out.putDouble(151, startupScript);
        out.flush();
        return result.toByteArray();
    }

    public double getActualRootNodeId() throws InformException {
        AccountNode accountNode = this;
        while (accountNode.inheritedStartup) {
            Node node = MtdEngine.getNode(accountNode.getParentId());
            if (node == null) {
                return 0.0;
            }
            if (node instanceof AccountNode) {
                accountNode = (AccountNode)node;
                continue;
            }
            return 0.0;
        }
        return accountNode.startupRootNodeId;
    }

    public double[] explicitGroups() {
        return this.explicitGroups;
    }

    public double[] parentGroups() throws InformException {
        assert (this.status == null);
        double[] result = this.parentGroupsCache;
        int chNo = globalSecurityChangeNo.get();
        if (result == null || chNo != this.securityChangeNo) {
            NodeHashTable nht = MtdEngine.getMtdCache().getNodes();
            double[] tmp = new double[1024];
            int idx = 0;
            AccountNode node = this;
            do {
                if ((node = nht.getAccount(node.getParentId())) == null) continue;
                tmp[idx++] = node.getId();
            } while (node != null);
            this.parentGroupsCache = result = idx == 0 ? Empty.doubleArray : Arrays.copyOf(tmp, idx + 1);
            this.securityChangeNo = chNo;
        }
        return result;
    }

    private void gatherEffectiveGroups(DoubleSet out, NodeHashTable nodes, DoubleSet recursiveCheck) throws InformException {
        double[] result;
        AccountNode n;
        double[] result2;
        assert (this.status == null);
        int chNo = globalSecurityChangeNo.get();
        if (this.securityChangeNo == chNo && (result2 = this.effectiveGroupsCache) != null) {
            for (double g : result2) {
                out.add(g);
            }
            return;
        }
        if (!recursiveCheck.add(this.getId())) {
            Core.logger.error("recursive node [" + NumberConverter.doubleToString(this.getId()) + "] in gatherEffectiveGroups");
            return;
        }
        DoubleSet selfGroups = new DoubleSet();
        for (double g : this.explicitGroups) {
            n = nodes.getAccount(g);
            if (!(n instanceof GroupNode) || n.isBlocked() || n.isInTrashRecursive() || !selfGroups.add(g)) continue;
            n.gatherEffectiveGroups(selfGroups, nodes, recursiveCheck);
        }
        for (double g : this.parentGroups()) {
            n = nodes.getAccount(g);
            if (!(n instanceof GroupNode) || n.isBlocked() || n.isInTrashRecursive() || !selfGroups.add(g)) continue;
            n.gatherEffectiveGroups(selfGroups, nodes, recursiveCheck);
        }
        for (double g : result = selfGroups.toArray()) {
            out.add(g);
        }
        this.effectiveGroupsCache = result;
        this.securityChangeNo = chNo;
    }

    public double[] effectiveGroups() throws InformException {
        assert (this.status == null);
        double[] result = this.effectiveGroupsCache;
        int chNo = globalSecurityChangeNo.get();
        if (result == null || chNo != this.securityChangeNo) {
            DoubleSet tmp = new DoubleSet();
            DoubleSet recursiveCheck = new DoubleSet();
            this.gatherEffectiveGroups(tmp, MtdEngine.getMtdCache().getNodes(), recursiveCheck);
            this.effectiveGroupsCache = result = tmp.toArray();
            this.securityChangeNo = chNo;
        }
        return result;
    }

    protected boolean activeDirectory() {
        return this.activeDirectory;
    }

    protected boolean inheritedStartup() {
        return this.inheritedStartup;
    }

    protected double startupRootNodeId() {
        return this.startupRootNodeId;
    }

    protected double startupStartNodeId() {
        return this.startupStartNodeId;
    }

    protected int startupStartNodeAction() {
        return this.startupStartNodeAction;
    }

    protected double startupScriptId() {
        return this.startupScriptId;
    }

    protected byte[] constants() {
        return this.constants;
    }

    protected UserInterface userInterface() {
        return this.userInterface;
    }

    protected boolean inheritedServerIPs() {
        return this.inheritedServerIPs;
    }

    public static int globalSecurityChangeNo() {
        return globalSecurityChangeNo.get();
    }

    public static void invalidateSecurity() {
        globalSecurityChangeNo.incrementAndGet();
    }

    public double webStartNodeId() {
        AccountNode accountNode = this.findStartupAccount();
        return accountNode == null ? 0.0 : accountNode.webStartNodeId;
    }

    protected void storeContent(TaggedWriter out) throws IOException {
        out.putEmpty(150);
        if (!this.inheritedStartup) {
            out.putEmpty(1);
            out.putDouble(151, this.startupRootNodeId);
            out.putEmpty(2);
            out.putDouble(151, this.startupStartNodeId);
            out.putInt32(3, this.startupStartNodeAction);
            out.putEmpty(4);
            out.putDouble(151, this.startupScriptId);
            out.putEmpty(12);
            out.putDouble(151, this.webStartNodeId);
        }
        if (this.constants != null) {
            out.putEmpty(6);
            out.putRaw(202, this.constants);
        }
        out.putBool(15, this.userInterface.inheritedSavePerRecord);
        if (!this.userInterface.inheritedSavePerRecord) {
            out.putBool(14, this.userInterface.savePerRecord);
        }
        out.putBool(17, this.userInterface.inheritedCanSetupUser);
        if (!this.userInterface.inheritedCanSetupUser) {
            out.putBool(16, this.userInterface.canSetupUser);
        }
        out.putBool(20, this.userInterface.inheritedCanCreateNodes);
        if (!this.userInterface.inheritedCanCreateNodes) {
            if (this.userInterface.canCreateAnyNodes) {
                out.putEmpty(18);
            } else {
                out.putIntArray(19, this.userInterface.canCreateNodeTypes);
            }
        }
        out.putBool(22, this.userInterface.inheritedSimplePopup);
        if (!this.userInterface.inheritedSimplePopup) {
            out.putBool(21, this.userInterface.simplePopup);
        }
        out.putBool(24, this.userInterface.inheritedCanWritePublicFilters);
        if (!this.userInterface.inheritedCanWritePublicFilters) {
            out.putBool(23, this.userInterface.canWritePublicFilters);
        }
        out.putBool(32, this.userInterface.inheritedCanWritePex);
        if (!this.userInterface.inheritedCanWritePex) {
            out.putBool(31, this.userInterface.canWritePex);
        }
        out.putBool(34, this.userInterface.inheritedCanUploadPex);
        if (!this.userInterface.inheritedCanUploadPex) {
            out.putBool(33, this.userInterface.canUploadPex);
        }
        out.putBool(28, this.userInterface.inheritedCanViewDataHistory);
        if (!this.userInterface.inheritedCanViewDataHistory) {
            out.putBool(27, this.userInterface.canViewDataHistory);
        }
        out.putBool(30, this.userInterface.inheritedCanViewMetadataHistory);
        if (!this.userInterface.inheritedCanViewMetadataHistory) {
            out.putBool(29, this.userInterface.canViewMetadataHistory);
        }
        out.putBool(37, this.userInterface.inheritedEditNode);
        if (!this.userInterface.inheritedEditNode) {
            out.putBool(36, this.userInterface.editNode);
        }
        if (this.dbLogins != null) {
            out.putRaw(10, this.saveDbLogins());
        }
        if (!this.inheritedServerIPs) {
            out.putRaw(11, this.saveServerIPs());
        }
    }

    @Override
    public byte[] getModifiedContent() throws InformException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        try {
            this.storeContent(out);
            out.flush();
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
        return data.toByteArray();
    }

    @Override
    protected void replicationStoreAttributes(int mask, TaggedWriter out, Connector connector, Client client) throws InformException, IOException {
        super.replicationStoreAttributes(mask, out, connector, client);
        this.storeSpecificAttributes(out, true);
    }

    @Override
    protected double replicationStoreContent(TaggedWriter out, Connector connector, Client client) throws InformException, IOException {
        byte[] content = this.getModifiedContent();
        if (content != null && content.length != 0) {
            out.putRaw(14, content);
        }
        return 0.0;
    }

    public void storeSpecificAttributes(TaggedWriter out, boolean fullStore) throws InformException, IOException {
        if (this.explicitGroups.length != 0 || fullStore) {
            out.putRaw(105, LittleEndian.doubleArrayToBinary(this.explicitGroups));
        }
        out.putBool(104, !this.inheritedStartup);
        out.putBool(114, this.inheritedServerIPs);
        out.putBool(119, this.activeDirectory);
        out.putBool(115, this.blocked);
    }

    @Override
    public void storeAttributes(TaggedWriter out) throws InformException, IOException {
        super.storeAttributes(out);
        this.storeSpecificAttributes(out, false);
    }

    @Override
    public void setContent(byte[] buffer, String dslContent, Node.ModifyNodeArg arg) throws InformException, SQLException {
        assert (this.status != null);
        super.setContent(buffer, dslContent, arg);
        if (buffer != null && buffer.length != 0) {
            try {
                this.loadContent(buffer);
            }
            catch (Throwable ex) {
                throw InformException.wrap(ex);
            }
        }
    }

    @Override
    public void loadReplicationTag(int tag, Node.ModifyNodeArg arg, int mask) throws IOException, InformException, SQLException {
        assert (this.status != null);
        TaggedReader in = arg.in;
        switch (tag) {
            case 105: {
                this.loadModifyTag(34, arg);
                break;
            }
            case 104: {
                this.inheritedStartup = !in.getBoolean();
                this.setSignificantAttrModified(false);
                break;
            }
            case 114: {
                this.loadModifyTag(51, arg);
                break;
            }
            case 119: {
                this.loadModifyTag(82, arg);
                break;
            }
            case 115: {
                boolean newBlocked = in.getBooleanDef(false);
                this.checkCanSetLock(newBlocked, arg.userId);
                try {
                    this.trySetLock(MtdEngine.getMtdCache(), newBlocked);
                    break;
                }
                catch (InterruptedException ex) {
                    throw InformException.wrap(ex);
                }
            }
            default: {
                super.loadReplicationTag(tag, arg, mask);
            }
        }
    }

    @Override
    public void loadModifyTag(int tag, Node.ModifyNodeArg arg) throws IOException, InformException, SQLException {
        assert (this.status != null);
        TaggedReader in = arg.in;
        switch (tag) {
            case 34: {
                this.explicitGroups = LittleEndian.toDoubleArray(in.getRaw());
                this.setSignificantAttrModified(false);
                break;
            }
            case 35: {
                this.inheritedStartup = true;
                this.setSignificantAttrModified(false);
                break;
            }
            case 44: {
                if (this.newUserInterface) break;
                this.userInterface.setAllInherited(true);
                break;
            }
            case 39: {
                if (this.newUserInterface) break;
                this.userInterface.setAllInherited(false);
                TaggedReader stream = in.getStreamReader();
                while (stream.next()) {
                    switch (stream.getCurrentTag()) {
                        case 1: {
                            this.userInterface.savePerRecord = stream.getBoolean();
                            break;
                        }
                        case 2: {
                            this.userInterface.canSetupUser = stream.getBoolean();
                            break;
                        }
                        case 4: {
                            this.userInterface.canCreateAnyNodes = stream.getBoolean();
                            break;
                        }
                        case 3: {
                            this.userInterface.canCreateAnyNodes = false;
                            this.userInterface.canCreateNodeTypes = LittleEndian.toIntArray(stream.getRaw());
                            break;
                        }
                        case 5: {
                            this.userInterface.simplePopup = stream.getBoolean();
                        }
                    }
                }
                break;
            }
            case 37: {
                this.constants = in.getRaw();
                break;
            }
            case 45: {
                this.loadDBLogins(in.getStreamReader());
                break;
            }
            case 51: {
                this.inheritedServerIPs = in.getBoolean();
                this.setSignificantAttrModified(false);
                break;
            }
            case 52: {
                boolean newBlocked = in.getBooleanDef(false);
                this.checkCanSetLock(newBlocked, arg.userId);
                this.setLock(newBlocked);
                break;
            }
            case 50: {
                this.inheritedServerIPs = false;
                this.loadServerIPs(in.getStreamReader());
                break;
            }
            case 82: {
                UserNode adAccount;
                this.activeDirectory = in.getBooleanDef(false);
                if (!this.activeDirectory || (adAccount = MtdEngine.getAcitiveDirectoryUserNodes(this.getName())) == null || adAccount.getId() == this.getId()) break;
                throw new InformException("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439: \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c:\n" + this.toLogString() + "\n" + adAccount.toLogString());
            }
            case 83: {
                TaggedReader stream = in.getStreamReader();
                while (stream.getNextTag() != 0) {
                    switch (stream.getCurrentTag()) {
                        case 1: {
                            stream.skip();
                            this.startupRootNodeId = stream.getDouble(151);
                            break;
                        }
                        case 2: {
                            stream.skip();
                            this.startupStartNodeId = stream.getDouble(151);
                            break;
                        }
                        case 3: {
                            this.startupStartNodeAction = stream.getInt();
                            break;
                        }
                        case 4: {
                            stream.skip();
                            this.startupScriptId = stream.getDouble(151);
                            break;
                        }
                        case 12: {
                            stream.skip();
                            this.webStartNodeId = stream.getDouble(151);
                        }
                    }
                }
                this.inheritedStartup = false;
                break;
            }
            case 42: {
                break;
            }
            case 88: {
                this.userInterface.savePerRecord = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 89: {
                this.userInterface.inheritedSavePerRecord = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 90: {
                this.userInterface.canSetupUser = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 91: {
                this.userInterface.inheritedCanSetupUser = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 92: {
                this.userInterface.canCreateAnyNodes = true;
                this.newUserInterface = true;
                break;
            }
            case 93: {
                this.userInterface.canCreateAnyNodes = false;
                this.userInterface.canCreateNodeTypes = LittleEndian.toIntArray(in.getRaw());
                this.newUserInterface = true;
                break;
            }
            case 94: {
                this.userInterface.inheritedCanCreateNodes = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 95: {
                this.userInterface.simplePopup = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 96: {
                this.userInterface.inheritedSimplePopup = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 97: {
                this.userInterface.canWritePublicFilters = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 98: {
                this.userInterface.inheritedCanWritePublicFilters = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 99: {
                this.userInterface.canUploadPex = this.userInterface.canWritePex = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 100: {
                this.userInterface.inheritedCanUploadPex = this.userInterface.inheritedCanWritePex = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 106: {
                this.userInterface.canWritePex = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 107: {
                this.userInterface.inheritedCanWritePex = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 108: {
                this.userInterface.canUploadPex = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 109: {
                this.userInterface.inheritedCanUploadPex = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 102: {
                this.userInterface.canViewDataHistory = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 103: {
                this.userInterface.inheritedCanViewDataHistory = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 104: {
                this.userInterface.canViewMetadataHistory = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 105: {
                this.userInterface.inheritedCanViewMetadataHistory = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 111: {
                this.userInterface.editNode = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 112: {
                this.userInterface.inheritedEditNode = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 10: {
                this.loadDBLogins(in.getStreamReader());
                break;
            }
            case 11: {
                this.inheritedServerIPs = false;
                this.loadServerIPs(in.getStreamReader());
                break;
            }
            default: {
                super.loadModifyTag(tag, arg);
            }
        }
        this.setContentModified();
    }

    protected void checkCanSetLock(boolean newBlocked, double userId) throws InformException {
        AccountNode accountNode;
        if (newBlocked && (accountNode = MtdEngine.getAccountNode(userId)) != null) {
            for (double g : accountNode.parentGroups()) {
                if (g != this.getId()) continue;
                throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0430\u043c\u043e\u0433\u043e \u0441\u0435\u0431\u044f");
            }
        }
    }

    protected void setLock(boolean newBlocked) throws InformException {
        this.blocked = newBlocked;
    }

    @Override
    public AccountNode clone(double appId, NodeStatus status) throws InformException {
        AccountNode result = (AccountNode)super.clone(appId, status);
        result.parentGroupsCache = this.parentGroupsCache;
        result.effectiveGroupsCache = this.effectiveGroupsCache;
        return result;
    }

    public final boolean isDeleted() {
        return this.isDeletedImpl(null);
    }

    protected boolean isDeletedImpl(LogContext.Builder cause) {
        return false;
    }

    public static class UserInterface {
        public static final int SAVE_PER_RECORD = 1;
        public static final int CAN_SETUP_USER = 2;
        public static final int CAN_WRITE_PUBLIC_FILTERS = 4;
        public static final int SIMPLE_POPUP = 8;
        public static final int CAN_CREATE_NODES = 16;
        public static final int CAN_WRITE_PEX = 32;
        public static final int CAN_VIEW_DATA_HISTORY = 64;
        public static final int CAN_VIEW_METADATA_HISTORY = 128;
        public static final int CAN_UPLOAD_PEX = 256;
        public static final int EDIT_NODE = 512;
        public boolean savePerRecord;
        public boolean inheritedSavePerRecord;
        public boolean canSetupUser;
        public boolean inheritedCanSetupUser;
        public boolean canWritePublicFilters;
        public boolean inheritedCanWritePublicFilters;
        public boolean simplePopup;
        public boolean inheritedSimplePopup;
        public boolean canCreateAnyNodes;
        public int[] canCreateNodeTypes;
        public boolean inheritedCanCreateNodes;
        public boolean inheritedCanWritePex;
        public boolean canWritePex;
        public boolean inheritedCanUploadPex;
        public boolean canUploadPex;
        public boolean inheritedCanViewDataHistory;
        public boolean canViewDataHistory;
        public boolean inheritedCanViewMetadataHistory;
        public boolean canViewMetadataHistory;
        public boolean inheritedEditNode;
        public boolean editNode;

        public UserInterface() {
            this.setAllInherited(true);
        }

        public UserInterface(UserInterface ui) {
            this.savePerRecord = ui.savePerRecord;
            this.inheritedSavePerRecord = ui.inheritedSavePerRecord;
            this.canSetupUser = ui.canSetupUser;
            this.inheritedCanSetupUser = ui.inheritedCanSetupUser;
            this.canWritePublicFilters = ui.canWritePublicFilters;
            this.inheritedCanWritePublicFilters = ui.inheritedCanWritePublicFilters;
            this.simplePopup = ui.simplePopup;
            this.inheritedSimplePopup = ui.inheritedSimplePopup;
            this.canCreateAnyNodes = ui.canCreateAnyNodes;
            this.canCreateNodeTypes = ui.canCreateNodeTypes;
            this.inheritedCanCreateNodes = ui.inheritedCanCreateNodes;
            this.canWritePex = ui.canWritePex;
            this.inheritedCanWritePex = ui.inheritedCanWritePex;
            this.canUploadPex = ui.canUploadPex;
            this.inheritedCanUploadPex = ui.inheritedCanUploadPex;
            this.canViewDataHistory = ui.canViewDataHistory;
            this.inheritedCanViewDataHistory = ui.inheritedCanViewDataHistory;
            this.canViewMetadataHistory = ui.canViewMetadataHistory;
            this.inheritedCanViewMetadataHistory = ui.inheritedCanViewMetadataHistory;
            this.editNode = ui.editNode;
            this.inheritedEditNode = ui.inheritedEditNode;
        }

        public int getInheritedBits() {
            int bits = 0;
            if (this.inheritedSavePerRecord) {
                bits |= 1;
            }
            if (this.inheritedCanSetupUser) {
                bits |= 2;
            }
            if (this.inheritedCanWritePublicFilters) {
                bits |= 4;
            }
            if (this.inheritedSimplePopup) {
                bits |= 8;
            }
            if (this.inheritedCanCreateNodes) {
                bits |= 0x10;
            }
            if (this.inheritedCanViewDataHistory) {
                bits |= 0x40;
            }
            if (this.inheritedCanViewMetadataHistory) {
                bits |= 0x80;
            }
            if (this.inheritedCanWritePex) {
                bits |= 0x20;
            }
            if (this.inheritedCanUploadPex) {
                bits |= 0x100;
            }
            if (this.inheritedEditNode) {
                bits |= 0x200;
            }
            return bits;
        }

        public int updateInheritedValues(UserInterface ui, int bits) {
            if ((bits & 1) != 0 && !ui.inheritedSavePerRecord) {
                bits &= 0xFFFFFFFE;
                this.savePerRecord = ui.savePerRecord;
            }
            if ((bits & 2) != 0 && !ui.inheritedCanSetupUser) {
                bits &= 0xFFFFFFFD;
                this.canSetupUser = ui.canSetupUser;
            }
            if ((bits & 4) != 0 && !ui.inheritedCanWritePublicFilters) {
                bits &= 0xFFFFFFFB;
                this.canWritePublicFilters = ui.canWritePublicFilters;
            }
            if ((bits & 8) != 0 && !ui.inheritedSimplePopup) {
                bits &= 0xFFFFFFF7;
                this.simplePopup = ui.simplePopup;
            }
            if ((bits & 0x20) != 0 && !ui.inheritedCanWritePex) {
                bits &= 0xFFFFFFDF;
                this.canWritePex = ui.canWritePex;
            }
            if ((bits & 0x100) != 0 && !ui.inheritedCanUploadPex) {
                bits &= 0xFFFFFEFF;
                this.canUploadPex = ui.canUploadPex;
            }
            if ((bits & 0x40) != 0 && !ui.inheritedCanViewDataHistory) {
                bits &= 0xFFFFFFBF;
                this.canViewDataHistory = ui.canViewDataHistory;
            }
            if ((bits & 0x80) != 0 && !ui.inheritedCanViewMetadataHistory) {
                bits &= 0xFFFFFF7F;
                this.canViewMetadataHistory = ui.canViewMetadataHistory;
            }
            if ((bits & 0x200) != 0 && !ui.inheritedEditNode) {
                bits &= 0xFFFFFDFF;
                this.editNode = ui.editNode;
            }
            if ((bits & 0x10) != 0 && !ui.inheritedCanCreateNodes) {
                bits &= 0xFFFFFFEF;
                this.canCreateAnyNodes = ui.canCreateAnyNodes;
                this.canCreateNodeTypes = ui.canCreateNodeTypes == null ? ui.canCreateNodeTypes : Arrays.copyOf(ui.canCreateNodeTypes, ui.canCreateNodeTypes.length);
            }
            return bits;
        }

        public void setAllInherited(boolean value) {
            this.inheritedSavePerRecord = value;
            this.inheritedCanSetupUser = value;
            this.inheritedCanWritePublicFilters = value;
            this.inheritedSimplePopup = value;
            this.inheritedCanCreateNodes = value;
            this.inheritedCanWritePex = value;
            this.inheritedCanUploadPex = value;
            this.inheritedCanViewDataHistory = value;
            this.inheritedCanViewMetadataHistory = value;
            this.inheritedEditNode = value;
            this.savePerRecord = false;
            this.canSetupUser = true;
            this.simplePopup = false;
            this.canWritePublicFilters = false;
            this.canCreateAnyNodes = true;
            this.canWritePex = false;
            this.canUploadPex = false;
            this.canViewDataHistory = false;
            this.canViewMetadataHistory = false;
            this.editNode = true;
        }
    }

    public static class StartupInfo {
        public final double rootNode;
        public final double startNode;
        public final int startAction;
        public final double scriptNode;
        public final double webNode;

        StartupInfo(AccountNode node) {
            this.rootNode = node.startupRootNodeId;
            this.startNode = node.startupStartNodeId;
            this.startAction = node.startupStartNodeAction;
            this.scriptNode = node.startupScriptId;
            this.webNode = node.webStartNodeId;
        }
    }
}

