/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.Memory;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.Acl;
import inform.agent.mtd.AclEntry;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdCache;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.nodes.ContentCache;
import inform.agent.mtd.nodes.Correlations;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.request.NodeStatus;
import inform.agent.net.Client;
import inform.agent.net.Security;
import inform.common.Empty;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.BitSet;

public class BasicNode
extends Node {
    private Acl acl = null;
    private Acl childrenAcl = null;
    private double pinId;
    private byte nodeState;
    private ContentCache content = new ContentCache(this);
    private byte[] __modified_content = null;
    private String __modified_dslContent = null;
    private byte[] childrenTypes = null;
    private double[] childrenCache = null;

    public BasicNode(NodeRecord record) {
        super(record);
        this.setModificationContentTime(record.getModificationContentTime());
    }

    @Override
    public final boolean dropContentIfNeed(NodeRecord r) {
        if (r.getModificationContentTime() != this.content.modContentTime()) {
            this.content.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public void invalidateContent() {
        super.invalidateContent();
        this.content.invalidate();
    }

    public boolean isInheritedAcl() {
        return this.acl == null;
    }

    @Override
    public void getNodeInfo(Node.NodeInfoArg arg) throws InformException, IOException, SQLException, InterruptedException {
        super.getNodeInfo(arg);
        if (!this.isInTrash()) {
            if (arg.nodeTypeFilter == null) {
                if (this.hasChilldren(arg.connector)) {
                    arg.out.putEmpty(10);
                }
            } else {
                DoubleSet processedNodes = new DoubleSet();
                if (this.hasFilteredChildren(arg.connector, arg.nodeTypeFilter, processedNodes)) {
                    arg.out.putEmpty(10);
                }
            }
        }
        if (this.isInTrashRecursive()) {
            arg.out.putEmpty(66);
        }
        arg.out.putBool(20, this.acl == null);
        arg.out.putBool(65, this.childrenAcl == null);
        arg.out.putDouble(53, this.pinId);
        arg.out.putInt32(57, this.nodeState);
        arg.out.putRaw(63, this.childrenTypes);
    }

    public double getPinId() {
        return this.pinId;
    }

    @Override
    protected BasicNode getRefNode(int loops) throws InformException {
        return this;
    }

    @Override
    public BasicNode getRealNode(int loops) throws InformException {
        return this;
    }

    public NodeContent getNodeContent(double pinId, boolean currentPin) {
        if (currentPin) {
            pinId = this.getPinId();
        }
        ContentCache content = pinId == this.pinId ? this.content : new ContentCache(this);
        ContentCache.Entry entry = content.content(0.0);
        if (pinId == 0.0) {
            return new NodeContent(entry.modContentTime, entry);
        }
        return new NodeContent(entry.modContentTime, content.content(pinId));
    }

    public byte[] getContent() throws InformException {
        return this.getContent(this.getPinId());
    }

    public byte[] getContent(double pinId) throws InformException {
        return this.content.content(pinId).content();
    }

    public int getContentSize() throws InformException {
        assert (this.status == null);
        return this.content.size(this.getPinId()).size();
    }

    public void cacheContent(long time, byte[] content, String dslContent) {
        this.content.cacheContent(time, content, dslContent);
    }

    public double[] tryGetFreshCachedRefs(long modTime) throws IOException {
        return this.content.tryGetFreshRefs(modTime);
    }

    public double[] findAndCacheRefs(long modTime, byte[] content, String dslContent) throws IOException {
        return this.content.findAndCacheRefs(modTime, content, dslContent);
    }

    protected synchronized double[] getChildrenCache() {
        return this.childrenCache;
    }

    @Override
    public synchronized void setChildrenCache(double[] cache) {
        this.childrenCache = cache;
    }

    @Override
    public String getNewChildName(Connector connector, String name) throws InformException {
        double[] children = this.getChildren(connector);
        String[] names = new String[children.length];
        Object newName = name;
        int no = 0;
        boolean exists = true;
        block0: while (exists) {
            exists = false;
            for (int i = 0; i < children.length; ++i) {
                Node child;
                if (names[i] == null && (child = MtdEngine.getNode(children[i])) != null) {
                    names[i] = child.getName();
                }
                if (!((String)newName).equals(names[i])) continue;
                exists = true;
                newName = name + "(" + ++no + ")";
                continue block0;
            }
        }
        return newName;
    }

    @Override
    public synchronized void dropChildrenCache() {
        this.childrenCache = null;
    }

    @Override
    protected void loadTag(MtdCache mtdCache, TaggedReader in) throws InformException, IOException, InterruptedException {
        switch (in.getCurrentTag()) {
            case 2: {
                this.acl = new Acl();
                this.acl.load(in);
                break;
            }
            case 18: {
                if (in.getBoolean()) {
                    this.acl = null;
                    break;
                }
                if (this.acl != null) break;
                this.acl = new Acl();
                break;
            }
            case 37: {
                this.childrenAcl = new Acl();
                this.childrenAcl.load(in);
                break;
            }
            case 38: {
                if (in.getBoolean()) {
                    this.childrenAcl = null;
                    break;
                }
                if (this.childrenAcl != null) break;
                this.childrenAcl = new Acl();
                break;
            }
            case 34: {
                this.nodeState = in.getByte();
                break;
            }
            case 36: {
                this.childrenTypes = in.getRaw();
                break;
            }
            default: {
                super.loadTag(null, in);
            }
        }
    }

    @Override
    public void initNode(MtdCache cache) throws InterruptedException, InformException {
        super.initNode(cache);
        if (this.contentAttr != null) {
            if (!TaggedReader.containsTag(1, this.contentAttr) || this.contentAttr.length < 10) {
                this.contentAttr = null;
            } else {
                double time;
                TaggedReader reader = new TaggedReader(this.contentAttr);
                try {
                    time = reader.getDouble();
                }
                catch (IOException e) {
                    throw InformException.wrap(e);
                }
                if (DateTime.toUnixTime(time) != this.content.modContentTime()) {
                    this.contentAttr = null;
                }
            }
        }
    }

    @Override
    protected void afterLoad() throws InformException {
        super.afterLoad();
        if (this.getId() == 0.0 && this.acl == null) {
            this.acl = new Acl();
            this.acl.setAllUserFullControl();
        }
        this.pinId = MtdEngine.getPin(this.getId());
    }

    public double getPrecedingChildId(double nodeId, Connector connector) throws InformException {
        double[] children = this.getChildren(connector);
        double result = 0.0;
        for (double childId : children) {
            if (childId == nodeId) {
                return result;
            }
            result = childId;
        }
        return 0.0;
    }

    @Override
    public double[] getChildren(Connector connector) throws InformException {
        try {
            double[] children = this.getChildrenCache();
            if (children == null) {
                children = MetadataNodeReader.getNodeChildrenIds(null, connector.connection(), this.getId());
                this.setChildrenCache(children);
            }
            return children;
        }
        catch (SQLException ex) {
            throw InformException.wrap(ex);
        }
    }

    @Override
    protected boolean hasFilteredChildren(Connector connector, BitSet nodeTypeFilter, DoubleSet processedNodes) throws InformException, SQLException {
        if (!processedNodes.add(this.getId())) {
            return false;
        }
        double[] children = this.getChildren(connector);
        if (children.length == 0) {
            return false;
        }
        for (double childId : children) {
            Node child = MtdEngine.getNode(childId);
            if (child == null || !nodeTypeFilter.get(child.getType()) && !child.hasFilteredChildren(connector, nodeTypeFilter, processedNodes)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasFilteredChildren(Connector connector, BitSet nodeTypeFilter, int permissions, Security security, DoubleSet processedNodes) throws InformException, SQLException {
        if (!processedNodes.add(this.getId())) {
            return false;
        }
        double[] children = this.getChildren(connector);
        if (children.length == 0) {
            return false;
        }
        for (double childId : children) {
            Node child = MtdEngine.getNode(childId);
            if (child == null) continue;
            int accessMask = security.accessMask(child);
            if ((!nodeTypeFilter.get(child.getType()) || AccessMask.accessDenied(permissions, accessMask)) && !child.hasFilteredChildren(connector, nodeTypeFilter, permissions, security, processedNodes)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected double[] getFilteredChildren(Connector connector, BitSet nodeTypeFilter) throws InformException, SQLException {
        double[] children = this.getChildren(connector);
        if (children.length == 0) {
            return Empty.doubleArray;
        }
        double[] filtered = new double[32];
        int filteredCount = 0;
        DoubleSet processedNodes = new DoubleSet();
        for (double childId : children) {
            Node child = MtdEngine.getNode(childId);
            if (child == null || !nodeTypeFilter.get(child.getType()) && !child.hasFilteredChildren(connector, nodeTypeFilter, processedNodes)) continue;
            if (filteredCount >= filtered.length) {
                filtered = Arrays.copyOf(filtered, filtered.length + 32);
            }
            filtered[filteredCount++] = child.getId();
        }
        if (filteredCount == 0) {
            return Empty.doubleArray;
        }
        if (filteredCount == filtered.length) {
            return filtered;
        }
        return Arrays.copyOf(filtered, filteredCount);
    }

    @Override
    protected double[] getFilteredChildren(Connector connector, BitSet nodeTypeFilter, int permissions, Security security) throws InformException, SQLException {
        double[] children = this.getChildren(connector);
        if (children.length == 0) {
            return Empty.doubleArray;
        }
        double[] filtered = new double[32];
        int filteredCount = 0;
        DoubleSet processedNodes = new DoubleSet();
        for (double childId : children) {
            Node child = MtdEngine.getNode(childId);
            if (child == null) continue;
            int accessMask = security.accessMask(child);
            if ((!nodeTypeFilter.get(child.getType()) || AccessMask.accessDenied(permissions, accessMask)) && !child.hasFilteredChildren(connector, nodeTypeFilter, permissions, security, processedNodes)) continue;
            if (filteredCount >= filtered.length) {
                filtered = Arrays.copyOf(filtered, filtered.length + 32);
            }
            filtered[filteredCount++] = child.getId();
        }
        if (filteredCount == 0) {
            return Empty.doubleArray;
        }
        if (filteredCount == filtered.length) {
            return filtered;
        }
        return Arrays.copyOf(filtered, filteredCount);
    }

    @Override
    public void getAclContent(TaggedWriter out) throws InformException {
        try {
            byte[] inheritedAclContent;
            if (this.acl != null && !this.acl.isEmpty()) {
                out.putRaw(5, this.acl.getContent());
            }
            if ((inheritedAclContent = this.getInheritedAclContent()) != null && inheritedAclContent.length != 0) {
                out.putRaw(17, inheritedAclContent);
            }
            if (this.childrenAcl != null && !this.childrenAcl.isEmpty()) {
                out.putRaw(64, this.childrenAcl.getContent());
            }
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
    }

    private byte[] getInheritedAclContent() throws InformException, IOException {
        if (this.acl != null) {
            return null;
        }
        Node parent = MtdEngine.getNode(this.getParentId());
        while (parent != null) {
            if (parent instanceof BasicNode) {
                BasicNode node = (BasicNode)parent;
                if (node.childrenAcl != null) {
                    return node.childrenAcl.getContent();
                }
                if (node.acl != null) {
                    return node.acl.getContent();
                }
                if (parent.getId() == 0.0) break;
            }
            parent = MtdEngine.getNode(parent.getParentId());
        }
        return null;
    }

    public byte getNodeState() {
        return this.nodeState;
    }

    public Acl acl() {
        assert (this.status == null);
        return this.acl;
    }

    public Acl childrenAcl() {
        assert (this.status == null);
        return this.childrenAcl;
    }

    @Override
    public void storeAttributes(TaggedWriter out) throws InformException, IOException {
        super.storeAttributes(out);
        if (this.acl != null && !this.acl.isEmpty()) {
            out.putRaw(2, this.acl.getContent());
        }
        out.putBool(18, this.acl == null);
        if (this.childrenAcl != null && !this.childrenAcl.isEmpty()) {
            out.putRaw(37, this.childrenAcl.getContent());
        }
        out.putBool(38, this.childrenAcl == null);
        byte currentNodeState = this.getNodeState();
        if (currentNodeState != 0) {
            out.putInt08(34, currentNodeState);
        }
        out.putRaw(36, this.childrenTypes);
    }

    @Override
    protected void replicationStoreAttributes(int mask, TaggedWriter out, Connector connector, Client client) throws InformException, IOException {
        byte currentNodeState;
        super.replicationStoreAttributes(mask, out, connector, client);
        if (this.getDescription() != null && !this.getDescription().isEmpty()) {
            out.putString(9, this.getDescription());
        }
        out.putRaw(36, this.childrenTypes);
        if ((mask & 4) != 0) {
            if (this.acl != null && !this.acl.isEmpty()) {
                out.putRaw(2, this.acl.getContent());
            }
            out.putBool(18, this.acl == null);
            if (this.childrenAcl != null && !this.childrenAcl.isEmpty()) {
                out.putRaw(37, this.childrenAcl.getContent());
            }
            out.putBool(38, this.childrenAcl == null);
        }
        if ((mask & 0x100) != 0) {
            double[] children = this.getChildren(connector);
            out.putRaw(30, LittleEndian.doubleArrayToBinary(children));
        }
        if ((currentNodeState = this.getNodeState()) != 0) {
            out.putInt08(34, currentNodeState);
        }
    }

    @Override
    protected double replicationStoreContent(TaggedWriter out, Connector connector, Client client) throws InformException, IOException {
        double pinId = this.getPinId();
        NodeContent nodeContent = this.getNodeContent(pinId, false);
        if (nodeContent.dslContent != null) {
            if (!client.isClientLevel(4)) {
                throw new InformException("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043a\u043b\u0438\u0435\u043d\u0442 \u0441 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 5.2.1192 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0443\u0437\u043b\u043e\u0432 \u0441 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u043c\u0438 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f\u043c\u0438 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u043e\u0432");
            }
            out.putRaw(124, nodeContent.dslContent.getBytes(TaggedWriter.UTF8));
        } else if (!Memory.isVoid(nodeContent.content)) {
            out.putRaw(14, nodeContent.content);
        }
        return pinId;
    }

    @Override
    public void loadReplicationTag(int tag, Node.ModifyNodeArg arg, int mask) throws IOException, InformException, SQLException {
        assert (this.status != null);
        TaggedReader in = arg.in;
        switch (tag) {
            case 18: {
                if ((mask & 4) == 0) break;
                this.loadModifyTag(20, arg);
                break;
            }
            case 2: {
                if ((mask & 4) == 0) break;
                this.loadModifyTag(5, arg);
                break;
            }
            case 38: {
                if ((mask & 4) == 0) break;
                this.loadModifyTag(65, arg);
                break;
            }
            case 37: {
                if ((mask & 4) == 0) break;
                this.loadModifyTag(64, arg);
                break;
            }
            case 36: {
                this.childrenTypes = in.getRaw();
                this.setAttrModified();
                break;
            }
            case 34: {
                this.nodeState = in.getByte();
                this.setAttrModified();
                break;
            }
            default: {
                super.loadReplicationTag(tag, arg, mask);
            }
        }
    }

    public void Unpin() {
        assert (this.status != null);
        MtdEngine.setPin(this.getRefNodeId(), 0.0);
        if (this.pinId != 0.0) {
            this.pinId = 0.0;
            this.setSignificantAttrModified(false);
        }
    }

    @Override
    public void loadModifyTag(int tag, Node.ModifyNodeArg arg) throws IOException, InformException, SQLException {
        assert (this.status != null);
        TaggedReader in = arg.in;
        switch (tag) {
            case 20: {
                boolean inheritedAcl = in.getBoolean();
                if (inheritedAcl) {
                    this.acl = null;
                }
                this.setSignificantAttrModified(true);
                break;
            }
            case 5: {
                this.acl = new Acl();
                this.acl.load(in);
                this.setSignificantAttrModified(true);
                break;
            }
            case 65: {
                boolean inheritedAcl = in.getBoolean();
                if (inheritedAcl) {
                    this.childrenAcl = null;
                }
                this.setSignificantAttrModified(true);
                break;
            }
            case 64: {
                this.childrenAcl = new Acl();
                this.childrenAcl.load(in);
                this.setSignificantAttrModified(true);
                break;
            }
            case 24: {
                double[] children;
                for (double childId : children = this.getChildren(arg.connector)) {
                    Node child = arg.getNode(childId);
                    if (child == null) continue;
                    child.dropChildrenAcl(arg);
                }
                break;
            }
            case 53: {
                this.pinId = in.getDouble();
                MtdEngine.setPin(this.getRefNodeId(), this.pinId);
                this.setSignificantAttrModified(false);
                break;
            }
            case 57: {
                int state = in.getInt();
                if ((state & 0x200) != 0) {
                    this.nodeState = (byte)(this.nodeState | 1);
                } else if ((state & 0x400) != 0) {
                    this.nodeState = (byte)(this.nodeState & 0xFFFFFFFE);
                }
                this.nodeState = (byte)(this.nodeState | (state &= 0xFF) & 0xFFFFFFFE);
                this.setAttrModified();
                break;
            }
            case 63: {
                this.childrenTypes = in.getRaw();
                this.setAttrModified();
                break;
            }
            default: {
                super.loadModifyTag(tag, arg);
            }
        }
    }

    @Override
    protected void dropChildrenAcl(Node.ModifyNodeArg arg) throws InformException {
        double[] children;
        if (this.acl != null) {
            BasicNode node = arg.modifyNode(this);
            node.acl = null;
            node.setAttrModified();
        }
        for (double childId : children = this.getChildren(arg.connector)) {
            Node child = arg.getNode(childId);
            if (child == null) continue;
            child.dropChildrenAcl(arg);
        }
    }

    @Override
    public void redistributeAcl(AclEntry aclEntry, Node.ModifyNodeArg arg) throws InformException {
        double[] children;
        for (double childId : children = this.getChildren(arg.connector)) {
            BasicNode child = arg.getTranslatedNode(childId);
            if (child == null) continue;
            if (child.acl != null) {
                child = arg.modifyNode(child);
                child.acl.replace(aclEntry);
                child.setModificationAttributeTime(System.currentTimeMillis());
            }
            child.redistributeAcl(aclEntry, arg);
        }
    }

    public int getNewOrderNo(Connector connector) throws InformException {
        double[] children = this.getChildren(connector);
        if (children.length == 0) {
            return 0;
        }
        Node lastChild = MtdEngine.getNode(children[children.length - 1]);
        if (lastChild == null) {
            return children.length * 100;
        }
        return lastChild.getOrderNo() + 100;
    }

    public void moveNodeLast(Node child, Node.ModifyNodeArg arg) throws InformException {
        double[] children = this.getChildren(arg.connector);
        if (children.length < 2 || children[children.length - 1] == child.getId()) {
            return;
        }
        Node lastChild = arg.getNode(children[children.length - 1]);
        if (lastChild == null) {
            return;
        }
        int childOrder = lastChild.getOrderNo() + 100;
        child.setOrderNo(childOrder);
        arg.modifiedParents.add(this.getId());
    }

    void moveNodeAfter(Node child, double precedinId, Node.ModifyNodeArg arg) throws InformException {
        int childOrder;
        double[] children = this.getChildren(arg.connector);
        if (children.length < 2) {
            return;
        }
        if (precedinId == 0.0) {
            Node firstChild = arg.getNode(children[0]);
            childOrder = firstChild.getOrderNo() - 100;
        } else {
            int index = -1;
            for (int i = children.length - 1; i >= 0; --i) {
                if (children[i] != precedinId) continue;
                index = i;
                break;
            }
            if (index < 0) {
                return;
            }
            Node beforeChild = arg.getNode(children[index]);
            if (index == children.length - 1) {
                childOrder = beforeChild.getOrderNo() + 100;
            } else {
                double afterId = children[index + 1];
                double movingId = child.getId();
                if (afterId == movingId) {
                    return;
                }
                Node afterChild = arg.getNode(afterId);
                double beforeId = beforeChild.getId();
                int beforeOrder = beforeChild.getOrderNo();
                int afterOrder = afterChild.getOrderNo();
                childOrder = (afterOrder + beforeOrder) / 2;
                if (childOrder <= beforeOrder || afterOrder <= childOrder) {
                    childOrder = 0;
                    for (double childId : children) {
                        if (childId != movingId) {
                            Node node = arg.getNode(childId);
                            if (node != null) {
                                node = arg.modifyNode(node);
                                node.setOrderNo(childOrder);
                            }
                            if (childId == beforeId) {
                                beforeOrder = childOrder;
                            } else if (childId == afterId) {
                                afterOrder = childOrder;
                            }
                        }
                        childOrder += 100;
                    }
                    childOrder = (afterOrder + beforeOrder) / 2;
                }
            }
        }
        child.setOrderNo(childOrder);
        arg.modifiedParents.add(this.getId());
    }

    protected void replaceTagDependencies(TaggedReader tag, TaggedWriter out, Correlations dependencies) throws IOException, InformException {
        switch (tag.getCurrentTag()) {
            case 151: {
                double key = tag.getDouble();
                out.putDouble(151, dependencies.getCorrelation(key));
                break;
            }
            case 202: {
                TaggedReader stream = tag.getStreamReader();
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                TaggedWriter newStream = new TaggedWriter(data);
                while (stream.next()) {
                    this.replaceTagDependencies(stream, newStream, dependencies);
                }
                newStream.flush();
                out.putRaw(202, data);
                break;
            }
            default: {
                tag.transferTag(out);
            }
        }
    }

    @Override
    public byte[] replaceDependencies(Correlations dependencies, byte[] content) throws InformException {
        assert (this.status != null);
        if (!TaggedReader.containsTag(150, content)) {
            return content;
        }
        TaggedReader in = new TaggedReader(new ByteArrayInputStream(content), content.length);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        try {
            while (in.next()) {
                this.replaceTagDependencies(in, out, dependencies);
            }
            out.flush();
            return result.toByteArray();
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
    }

    @Override
    protected void setContentModified() {
        super.setContentModified();
        this.content.invalidate();
    }

    public void setContent(byte[] buffer, String dslContent, Node.ModifyNodeArg arg) throws InformException, SQLException {
        assert (this.status != null);
        super.setContentModified();
        this.setContentModificationUser(arg.userId);
        this.content.set(buffer, dslContent, arg.contentModificationTime);
        if (dslContent != null) {
            this.__modified_content = null;
            this.__modified_dslContent = dslContent;
        } else {
            this.__modified_content = buffer;
            this.__modified_dslContent = null;
        }
    }

    @Override
    public void applyChanges() {
        super.applyChanges();
        this.__modified_content = null;
        this.__modified_dslContent = null;
    }

    @Override
    public byte[] getModifiedContent() throws InformException {
        return this.__modified_content;
    }

    @Override
    public String getModifiedDslContent() {
        return this.__modified_dslContent;
    }

    @Override
    public boolean isModifiedDslContent() {
        return this.__modified_dslContent != null;
    }

    @Override
    public long getModificationContentTime() {
        return this.content.modContentTime();
    }

    @Override
    public void setModificationContentTime(long time) {
        this.content.modContentTime(time);
    }

    @Override
    public Node clone(double appId, NodeStatus status) throws InformException {
        BasicNode result = (BasicNode)super.clone(appId, status);
        result.content = this.content.copy();
        return result;
    }

    @Override
    public byte[] createContentAttr() {
        try {
            if (!this.needCreateContentAttr()) {
                return this.contentAttr;
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(stream);
            out.putDouble(1, DateTime.fromUnixTime(this.content.modContentTime()));
            if (!this.writeContentAttr(out)) {
                this.contentAttr = null;
            } else {
                out.flush();
                this.contentAttr = stream.toByteArray();
                if (this.contentAttr != null && this.contentAttr.length <= 10) {
                    this.contentAttr = null;
                }
            }
            return this.contentAttr;
        }
        catch (InformException | IOException ex) {
            Core.logger.error(null, ex);
            return super.createContentAttr();
        }
    }

    protected boolean writeContentAttr(TaggedWriter out) throws InformException, IOException {
        return false;
    }

    @Override
    public void changeParent(double newParentId, Node.ModifyNodeArg arg) throws InformException, SQLException {
        if (this.getId() == 0.0) {
            throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438/\u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0443\u0437\u0435\u043b");
        }
        super.changeParent(newParentId, arg);
    }

    public class NodeContent {
        public final byte[] content;
        public final String dslContent;
        public final long lastContentTime;

        public NodeContent(long lastContentTime, ContentCache.Entry entry) {
            this.content = entry.content();
            this.dslContent = entry.dslContent();
            this.lastContentTime = lastContentTime;
        }
    }
}

