/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.Cache;
import inform.adt.IO;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.db.BlobDataReader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.types.BlobValueId;
import inform.agent.db.types.DataType;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.web.Session;
import inform.agent.web.WebServerSideHost;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.server.Request;

public class ExtFilesNode
extends BasicNode {
    private static final Cache<Double, Container> GlobalCache = new Cache();

    public ExtFilesNode(NodeRecord record) {
        super(record);
    }

    private Container getContainer() throws IOException {
        TaggedReader reader = new TaggedReader(this.getContent());
        Container c = null;
        if (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 150: {
                    c = new Container(reader);
                    break;
                }
                case 2: {
                    c = new Container(reader.getStreamReader());
                    break;
                }
                case 3: {
                    c = new Container(new TaggedReader(new InflaterInputStream(reader.getStream(), new Inflater(true))));
                }
            }
        }
        return c;
    }

    public static byte[] getFileContentFromCache(ExtFilesNode node, String path) throws IOException {
        Entry e;
        byte[] content = null;
        Container c = GlobalCache.get(node.getId());
        if (c != null && (e = c.find(path)) != null && e instanceof File) {
            content = ((File)e).getContent();
        }
        if (content == null && (c = node.getContainer()) != null) {
            GlobalCache.put(node.getId(), c);
            e = c.find(path);
            if (e != null && e instanceof File) {
                content = ((File)e).getContent();
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileContent(ExtFilesNode node, String path) throws IOException {
        byte[] content = null;
        Cache<Double, Container> cache = GlobalCache;
        synchronized (cache) {
            content = ExtFilesNode.getFileContentFromCache(node, path.toString());
            if (content == null) {
                throw new InformException(String.format("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0435\u043d\u0442 \u0444\u0430\u0439\u043b\u0430 [node: %.0f; path: %s]", node.getId(), path));
            }
        }
        return content;
    }

    private static byte[] getFileContentFromCacheRel(ExtFilesNode node, String path) throws IOException {
        String s;
        int index;
        Entry e;
        int SEPARATOR = 92;
        byte[] content = null;
        Container c = GlobalCache.get(node.getId());
        if (c != null) {
            if (c.executable == null || c.executable.isEmpty()) {
                throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b [node: %.0f]", node.getId()));
            }
            e = null;
            if (!path.isEmpty()) {
                index = c.executable.lastIndexOf(92);
                if (index > 0) {
                    s = c.executable.subSequence(0, index).toString();
                    e = c.find(s + "/" + path);
                }
            } else {
                e = c.find(c.executable);
            }
            if (e != null && e instanceof File) {
                content = ((File)e).getContent();
            }
        }
        if (content == null && (c = node.getContainer()) != null) {
            GlobalCache.put(node.getId(), c);
            if (c.executable == null || c.executable.isEmpty()) {
                throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b [node: %.0f]", node.getId()));
            }
            e = null;
            if (!path.isEmpty()) {
                index = c.executable.lastIndexOf(92);
                if (index > 0) {
                    s = c.executable.subSequence(0, index).toString();
                    e = c.find(s + "/" + path);
                }
            } else {
                e = c.find(c.executable);
            }
            if (e != null && e instanceof File) {
                content = ((File)e).getContent();
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileContentRel(ExtFilesNode node, String path) throws IOException {
        byte[] content = null;
        Cache<Double, Container> cache = GlobalCache;
        synchronized (cache) {
            content = ExtFilesNode.getFileContentFromCacheRel(node, path.toString());
            if (content == null) {
                throw new InformException(String.format("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0435\u043d\u0442 \u0444\u0430\u0439\u043b\u0430 [node: %.0f; path: %s]", node.getId(), path));
            }
        }
        return content;
    }

    private static int readFullyIfPossible(InputStream in, byte[] buffer, int length) throws IOException {
        int off;
        int l;
        for (off = 0; off < length && (l = in.read(buffer, off, length - off)) >= 0; off += l) {
        }
        return off;
    }

    private static byte[] getFileContentFromCacheRelBlob(String tid, String path) throws IOException {
        byte[] content = null;
        double tableId = Double.parseDouble(tid);
        Container c = GlobalCache.get(tableId);
        if (c != null) {
            if (c.executable == null || c.executable.isEmpty()) {
                throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b [tableId: %.0f]", tableId));
            }
            Entry e = null;
            e = !path.isEmpty() ? c.find(path) : c.find(c.executable);
            if (e != null && e instanceof File) {
                content = ((File)e).getContent();
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileContentRelBlob(String tid, String path) throws IOException {
        byte[] content = null;
        Cache<Double, Container> cache = GlobalCache;
        synchronized (cache) {
            content = ExtFilesNode.getFileContentFromCacheRelBlob(tid, path);
            if (content == null) {
                throw new InformException(String.format("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0435\u043d\u0442 \u0444\u0430\u0439\u043b\u0430 [tableId: %s; path: %s]", tid, path));
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getFileContentFromBlob(String tid, String rid, String fid, HttpServletResponse resp, HttpServletRequest req, Session session) throws IOException {
        block32: {
            BlobDataReader blobData;
            resp.setStatus(200);
            byte[] content = null;
            double nodeId = 0.0;
            double tableId = Double.parseDouble(tid);
            int fieldId = Integer.parseInt(fid);
            double rowId = Double.parseDouble(rid);
            BlobValueId blobId = new BlobValueId(tableId, fieldId, rowId);
            Session.User user = session.user();
            WebServerSideHost host = new WebServerSideHost(nodeId, user, (AbstractConnection)((Request)req).getConnection());
            try {
                blobData = new BlobDataReader(-1, host);
            }
            catch (InterruptedException e) {
                throw InformException.wrap(e);
            }
            RuntimeException exception = null;
            try {
                TableDescriptor tableDescriptor = TableDescriptor.get(tableId);
                InputStream in = blobData.readData(null, tableDescriptor.getDbId(), blobId);
                if (in != null) {
                    try {
                        byte[] buffer = new byte[1024];
                        int l = ExtFilesNode.readFullyIfPossible(in, buffer, buffer.length);
                        FieldDescriptor field = tableDescriptor.getExistingFieldDescriptor(blobId.getFieldId());
                        if (field.getType() == DataType.FILE || !TaggedReader.containsTag(2, buffer) && !TaggedReader.containsTag(3, buffer)) {
                            ServletOutputStream out = resp.getOutputStream();
                            out.write(buffer, 0, l);
                            IO.transfer(in, (OutputStream)out);
                            return;
                        }
                        in = new SequenceInputStream(new ByteArrayInputStream(buffer, 0, l), in);
                        TaggedReader reader = new TaggedReader(in);
                        Container c = null;
                        if (reader.next()) {
                            switch (reader.getCurrentTag()) {
                                case 150: {
                                    c = new Container(reader);
                                    break;
                                }
                                case 2: {
                                    c = new Container(reader.getStreamReader());
                                    break;
                                }
                                case 3: {
                                    c = new Container(new TaggedReader(new InflaterInputStream(reader.getStream(), new Inflater(true))));
                                }
                            }
                        }
                        if (c != null) {
                            if (c.executable == null || c.executable.isEmpty()) {
                                throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b [tableId: %.0f]", tableId));
                            }
                            Entry e = c.find(c.executable);
                            if (e != null && e instanceof File) {
                                content = ((File)e).getContent();
                            }
                            if (content != null) {
                                ServletOutputStream out = resp.getOutputStream();
                                out.write(content);
                            }
                            GlobalCache.remove(tableId);
                            GlobalCache.put(tableId, c);
                        }
                        break block32;
                    }
                    finally {
                        in.close();
                    }
                }
                throw new InformException("\u0417\u0430\u043f\u0438\u0441\u044c " + NumberConverter.doubleToString(rowId) + " \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 " + NumberConverter.doubleToString(tableId) + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
            }
            catch (SQLException e) {
                Core.logger.error(null, e);
                exception = InformException.wrap(e);
            }
            finally {
                block33: {
                    try {
                        blobData.release();
                    }
                    catch (SQLException e) {
                        Core.logger.error(null, e);
                        if (exception == null) break block33;
                        InformException.detail(exception, e.toString());
                    }
                }
                if (exception == null) break block32;
                throw exception;
            }
        }
    }

    public static class Container
    extends Folder {
        private static final int TAG_EXEC_FILE = 1;
        private static final int TAG_FILE_ACTION = 2;
        private static final int TAG_EXTERNAL_FILES_OLD = 4;
        private static final int TAG_OWNER_EXFILE = 5;
        private static final int TAG_EXTERNAL_FILES = 7;
        private static final int TAG_ROOT_TEXT = 1;
        private static final int TAG_ROOT_ID_OLD = 2;
        private static final int TAG_ROOT_ID = 3;
        private static final int TAG_ROOT_DATA_STREAM = 4;
        private String executable;
        private String action = "open";

        public Container() {
            super(null);
        }

        public Container(TaggedReader reader) throws IOException, TaggedReaderException {
            super(null);
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 1: {
                        this.executable = reader.getAnsi();
                        break;
                    }
                    case 2: {
                        this.action = reader.getAnsi();
                        break;
                    }
                    case 4: 
                    case 7: {
                        if (reader.getCurrentTag() == 4 && reader.getNextTag() != 202) break;
                        TaggedReader rdr = reader.getStreamReader();
                        block13: while (rdr.next()) {
                            switch (rdr.getCurrentTag()) {
                                case 2: 
                                case 4: {
                                    if (rdr.getCurrentTag() == 2 && rdr.getNextTag() != 202) continue block13;
                                    TaggedReader r = rdr.getStreamReader();
                                    while (r.next()) {
                                        switch (r.getCurrentTag()) {
                                            case 2: {
                                                File file = new File(this, r);
                                                this.entries.put(file.name.toLowerCase(), file);
                                                break;
                                            }
                                            case 1: {
                                                Folder f = new Folder(this, r);
                                                this.entries.put(f.name.toLowerCase(), f);
                                            }
                                        }
                                    }
                                    return;
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }

        private Entry find(String path) {
            String[] sp = path.replaceAll("\\\\", "/").split("/");
            Entry f = this;
            for (String p : sp) {
                if (p.isEmpty()) continue;
                if (!(f instanceof Folder)) {
                    throw new InformException("\"" + f.path() + "\" \u044d\u0442\u043e \u043d\u0435 \u043a\u0430\u0442\u0430\u043b\u043e\u0433");
                }
                Entry o = ((Folder)f).entries.get(p.toLowerCase());
                if (o == null) {
                    throw new InformException("\u0424\u0430\u0439\u043b \"" + f.path() + "/" + p + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
                if (!(o instanceof Entry)) {
                    throw new InformException("\"" + f.path() + "/" + p + "\" \u044d\u0442\u043e \u043d\u0435 \u0438\u043d\u043e\u0434");
                }
                f = o;
            }
            return f;
        }
    }

    private static class Folder
    extends Entry {
        private static final int TAG_BEGIN = 1;
        private static final int TAG_END = 6;
        protected final Map<String, Entry> entries = new HashMap<String, Entry>();

        public Folder(Entry parent) {
            super(parent);
        }

        public Folder(Entry parent, TaggedReader reader) throws IOException {
            this(parent);
            this.name = reader.getAnsi(1);
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 1: {
                        Folder f = new Folder(this, reader);
                        this.entries.put(f.name.toLowerCase(), f);
                        break;
                    }
                    case 2: {
                        File file = new File(this, reader);
                        this.entries.put(file.name.toLowerCase(), file);
                        break;
                    }
                    case 6: {
                        return;
                    }
                }
            }
        }
    }

    private static class File
    extends Entry {
        private static final int TAG_BEGIN = 2;
        private static final int TAG_CONTENT_OLD = 3;
        private static final int TAG_END = 5;
        private static final int TAG_CONTENT = 7;
        private byte[] content;

        public File(Entry parent) {
            super(parent);
        }

        public File(Entry parent, TaggedReader reader) throws IOException, TaggedReaderException {
            this(parent);
            this.name = reader.getAnsi(2);
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 3: 
                    case 7: {
                        if (reader.getCurrentTag() == 3 && reader.getNextTag() != 202) break;
                        this.content = reader.getRaw();
                        break;
                    }
                    case 5: {
                        return;
                    }
                }
            }
        }

        public byte[] getContent() {
            return this.content;
        }
    }

    public static class Entry {
        private final Entry parent;
        protected String name;

        public Entry(Entry parent) {
            this.parent = parent;
        }

        public String getName() {
            return this.name;
        }

        protected boolean path(StringBuilder out) {
            if (this.parent != null && this.parent.path(out)) {
                out.append('/');
            }
            if (this.name != null) {
                out.append(this.name);
            }
            return this.name != null;
        }

        public String path() {
            StringBuilder result = new StringBuilder();
            this.path(result);
            return result.toString();
        }
    }
}

