/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.nodes.BasicNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class FindNode
extends BasicNode {
    private Descriptor descriptor;

    public FindNode(NodeRecord record) {
        super(record);
    }

    public Descriptor getDescriptor() throws InformException {
        if (this.descriptor == null) {
            this.descriptor = new Descriptor(this.getContent());
        }
        return this.descriptor;
    }

    public static class Descriptor {
        public static final int KIND_STANDARD = 0;
        public static final int KIND_ADVANCED = 1;
        public static final int KIND_STORED_PROCEDURE = 2;
        private static final int TAG_FS_ROOT_TABLE = 1;
        private static final int TAG_FS_FIND_KIND = 15;
        private int kind = 0;
        private double rootTableId;
        private byte[] inputParams;

        public Descriptor(byte[] content) throws InformException {
            TaggedReader reader = new TaggedReader(new ByteArrayInputStream(content), content.length);
            try {
                int pLeft = 3;
                while (pLeft > 0 && reader.next()) {
                    switch (reader.getCurrentTag()) {
                        case 1: {
                            reader.skip();
                            this.rootTableId = reader.getDouble(151);
                            --pLeft;
                            break;
                        }
                        case 15: {
                            this.kind = reader.getInt();
                            --pLeft;
                            break;
                        }
                        case 153: {
                            this.inputParams = reader.getSubStreamData();
                            --pLeft;
                        }
                    }
                }
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
        }

        public int getKind() {
            return this.kind;
        }

        public double getRootTableId() {
            return this.rootTableId;
        }

        public byte[] getInputParams() {
            return this.inputParams;
        }
    }
}

