/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.Statement;
import inform.agent.db.types.SqlDataType;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class SqlScriptNode
extends BasicNode {
    private static final int TAG_SQLSCRIPT_LAUNCH = 4;
    private Descriptor descriptor;

    public SqlScriptNode(NodeRecord record) {
        super(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(byte[] buffer, String dslContent, Node.ModifyNodeArg arg) throws InformException, SQLException {
        TaggedReader reader = new TaggedReader(new ByteArrayInputStream(buffer), buffer.length);
        boolean launch = false;
        try {
            while (reader.getNextTag() != 0) {
                if (reader.getCurrentTag() != 4) continue;
                launch = true;
                break;
            }
        }
        catch (IOException e) {
            throw InformException.wrap(e);
        }
        if (launch) {
            try {
                this.descriptor = new Descriptor(buffer);
                DatabaseDescriptor db = DatabaseDescriptor.getDatabase(this.descriptor.databaseId);
                try (DatabaseConnection connection = db.connect(arg.ssHost, "SqlScriptNode::setContent");){
                    try (Statement statement = connection.createStatement();){
                        statement.execute(null, this.descriptor.sql);
                    }
                    connection.commit();
                }
            }
            catch (SQLException e) {
                throw InformException.wrap(e);
            }
        }
        super.setContent(buffer, dslContent, arg);
    }

    public Descriptor getDescriptor() throws InformException {
        if (this.descriptor == null) {
            byte[] bytes = this.getContent();
            this.descriptor = new Descriptor(bytes, bytes.length);
        }
        return this.descriptor;
    }

    public static class Descriptor {
        private static final int TAG_SQLSCRIPT_CODE = 1;
        private static final int TAG_SQLSCRIPT_DATABASE = 3;
        private static final int TAG_SQLSCRIPT_LAUNCH_UNCHECKED = 5;
        private static final int TAG_SQLSCRIPT_PARAMS = 6;
        private static final int TAG_SQLSCRIPT_EXPLAIN = 7;
        private static final int TAG_SQLSCRIPT_TRACE = 8;
        private static final int TAG_SQLSCRIPT_ANALYZE = 9;
        private static final int TAG_SQLSCRIPT_PRE_SQL = 10;
        private double databaseId;
        private String sql;
        private boolean checkWarnings = true;
        private boolean explain = false;
        private boolean trace = false;
        private boolean analyze = false;
        private String preSql;
        private final Collection<Parameter> parameters = new ArrayList<Parameter>();

        public Descriptor(byte[] buffer, int length) throws InformException {
            TaggedReader reader = new TaggedReader(new ByteArrayInputStream(buffer, 0, length), length);
            try {
                while (reader.getNextTag() != 0) {
                    switch (reader.getCurrentTag()) {
                        case 1: {
                            this.sql = reader.getAnsi();
                            break;
                        }
                        case 3: {
                            reader.skip();
                            this.databaseId = reader.getDouble(151);
                            break;
                        }
                        case 5: {
                            this.checkWarnings = false;
                            break;
                        }
                        case 6: {
                            TaggedReader pr = reader.getStreamReader();
                            while (pr.next()) {
                                Object value;
                                SqlDataType type = SqlDataType.get(pr.getCurrentTag());
                                if (type == null) {
                                    throw new InformException("Unsupported parameter type (" + pr.getCurrentTag() + ")");
                                }
                                if (pr.getCurrentTagSize() == 0) {
                                    value = null;
                                } else {
                                    switch (type) {
                                        case INTEGER: {
                                            value = pr.getInt();
                                            break;
                                        }
                                        case DOUBLE: 
                                        case DATE_TIME: {
                                            value = pr.getDouble();
                                            break;
                                        }
                                        case STRING: {
                                            value = pr.getString();
                                            break;
                                        }
                                        case BOOLEAN: {
                                            value = pr.getBoolean();
                                            break;
                                        }
                                        default: {
                                            throw new InformException("Unsupported parameter type (" + pr.getCurrentTag() + ")");
                                        }
                                    }
                                }
                                this.parameters.add(new Parameter(type, value));
                            }
                            break;
                        }
                        case 7: {
                            this.explain = true;
                            break;
                        }
                        case 9: {
                            this.analyze = true;
                            break;
                        }
                        case 8: {
                            this.trace = true;
                            break;
                        }
                        case 10: {
                            this.preSql = reader.getAnsi();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
        }

        public Descriptor(byte[] content) throws InformException {
            this(content, content.length);
        }

        public double getDatabaseId() {
            return this.databaseId;
        }

        public String getSql() {
            return this.sql;
        }

        public String getPreSql() {
            return this.preSql;
        }

        public boolean getTrace() {
            return this.trace;
        }

        public boolean isCheckWarnings() {
            return this.checkWarnings;
        }

        public Collection<Parameter> parameters() {
            return this.parameters;
        }

        public boolean explain() {
            return this.explain;
        }

        public boolean analyze() {
            return this.analyze;
        }

        public static class Parameter {
            public final SqlDataType type;
            public final Object value;

            public Parameter(SqlDataType type, Object value) {
                this.type = type;
                this.value = value;
            }
        }
    }
}

